###########################################################################
# ALGLIB 3.16.0 (source code generated 2019-12-19)
# Copyright (c) Sergey Bochkanov (ALGLIB project).
# 
# >>> SOURCE LICENSE >>>
# This software is a non-commercial edition of  ALGLIB  package,  which  is
# licensed under ALGLIB Personal and Academic Use License Agreement (PAULA).
# 
# See paula-v1.0.pdf file in the archive  root  for  full  text  of  license
# agreement.
# >>> END OF LICENSE >>>

##########################################################################

import ctypes

import ctypes
import sys
import os

if ctypes.sizeof(ctypes.c_void_p)==4:
    c_ptrint_t = ctypes.c_int32
else:
    c_ptrint_t = ctypes.c_int64

DT_BOOL = 1
DT_INT = 2
DT_REAL = 3
DT_COMPLEX = 4

SIZE_BOOL = 1
SIZE_INT = ctypes.sizeof(ctypes.c_void_p)
SIZE_REAL = 8
SIZE_COMPLEX = 16

OWN_CALLER = 1
OWN_AE = 2

X_ASSERTION_FAILED = 5

X_SET     = 1 # data are copied into x-vector/matrix; previous contents of x-structure is freed
X_CREATE  = 2 # x-vector/matrix is created, its previous contents is ignored
X_REWRITE = 3 # data are copied into x-structure; size of Python structure must be equal to the x-structure size

class x_complex(ctypes.Structure):
    _fields_ = [("x", ctypes.c_double), ("y", ctypes.c_double)]

class x_multiptr(ctypes.Union):
    _fields_ = [("p_ptr",       ctypes.c_void_p),
                ("p_char",      ctypes.c_char_p),
                ("p_bool",      ctypes.POINTER(ctypes.c_int8)),
                ("p_int",       ctypes.POINTER(c_ptrint_t)),
                ("p_real",      ctypes.POINTER(ctypes.c_double)),
                ("p_complex",   ctypes.POINTER(x_complex)),
                ("longval",     ctypes.c_uint64)]

class x_int(ctypes.Union):
    _fields_ = [("val",         c_ptrint_t),
                ("longval",     ctypes.c_uint64)]

class x_string(ctypes.Structure):
    _fields_ = [("owner",       ctypes.c_uint64),
                ("last_action", ctypes.c_uint64),
                ("ptr",         x_multiptr)]

class x_vector(ctypes.Structure):
    _pack_   = 8
    _fields_ = [("cnt",         ctypes.c_uint64),
                ("datatype",    ctypes.c_uint64),
                ("owner",       ctypes.c_uint64),
                ("last_action", ctypes.c_uint64),
                ("ptr",         x_multiptr)]

class x_matrix(ctypes.Structure):
    _pack_   = 8
    _fields_ = [("rows",        ctypes.c_uint64),
                ("cols",        ctypes.c_uint64),
                ("stride",      ctypes.c_uint64),
                ("datatype",    ctypes.c_uint64),
                ("owner",       ctypes.c_uint64),
                ("last_action", ctypes.c_uint64),
                ("ptr",         x_multiptr)]

#
# Load ALGLIB shared library
#
_so_candidates = []
curdir = os.path.dirname(__file__)
if curdir=="":
    curdir = "."
if sys.platform=="win32" or sys.platform=="cygwin":
    _shared_lib_name = "alglib316_"+str(ctypes.sizeof(ctypes.c_void_p)*8)+"free"+".dll"
    _so_candidates.append(os.path.join(curdir,_shared_lib_name))
    _so_candidates.append(os.path.join(sys.prefix,_shared_lib_name))
else:
    _shared_lib_name = "alglib316_"+str(ctypes.sizeof(ctypes.c_void_p)*8)+"free"+".so"
    _so_candidates.append(os.path.join(curdir,_shared_lib_name))
    _so_candidates.append(os.path.join(sys.prefix,_shared_lib_name))
    _so_candidates.append(os.path.join(os.sep+"usr","local",_shared_lib_name))
for _candidate in _so_candidates:
    if os.path.isfile(_candidate):
        _lib_alglib = ctypes.cdll.LoadLibrary(_candidate)
        break
if _lib_alglib is None:
    raise RuntimeError("ALGLIB: unable to load shared library")

_lib_alglib.x_activate_core.argtypes = []
_lib_alglib.x_activate_core.restype = None
_lib_alglib.x_activate_core()

_lib_alglib.x_malloc.argtypes = [ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.x_malloc.restype = ctypes.c_int32
_lib_alglib.x_free.argtypes = [ctypes.c_void_p]
_lib_alglib.x_free.restype = ctypes.c_int32
_lib_alglib.x_setnworkers.argtypes = [ctypes.c_uint64]
_lib_alglib.x_setnworkers.restype = ctypes.c_uint8
_lib_alglib.x_set_dbg_flag.argtypes = [ctypes.c_int64, ctypes.c_int64]
_lib_alglib.x_set_dbg_flag.restype = None
_lib_alglib.x_alloc_counter.argtypes = []
_lib_alglib.x_alloc_counter.restype = ctypes.c_int64
_lib_alglib.x_is_symmetric_e_.argtypes = [ctypes.c_void_p]
_lib_alglib.x_is_symmetric_e_.restype = ctypes.c_uint8
_lib_alglib.x_is_hermitian_e_.argtypes = [ctypes.c_void_p]
_lib_alglib.x_is_hermitian_e_.restype = ctypes.c_uint8
_lib_alglib.x_force_symmetric_e_.argtypes = [ctypes.c_void_p]
_lib_alglib.x_force_symmetric_e_.restype = ctypes.c_uint8
_lib_alglib.x_force_hermitian_e_.argtypes = [ctypes.c_void_p]
_lib_alglib.x_force_hermitian_e_.restype = ctypes.c_uint8

def x_malloc(cnt):
    __cnt = ctypes.c_uint64(cnt)
    if __cnt.value!=cnt:
        raise RuntimeError("malloc() argument is too large!")
    __result = ctypes.c_void_p(0)
    if _lib_alglib.x_malloc(ctypes.byref(__result), __cnt)!=0:
        raise RuntimeError("Error while calling x_malloc()")
    return __result.value

def x_free(ptr):
    __ptr = ctypes.c_void_p(ptr)
    _lib_alglib.x_free(__ptr)
    return

def xsign(val):
    if val<0.0:
        return -1.0
    if val>0.0:
        return +1.0
    return 0.0

def setnworkers(nworkers):
    __nworkers = ctypes.c_uint64(nworkers)
    _lib_alglib.x_setnworkers(__nworkers)
    return
    
def setglobalthreadingserial():
    _lib_alglib.x_set_dbg_flag(1001, 1)
    return
    
def setglobalthreadingparallel():
    _lib_alglib.x_set_dbg_flag(1001, 2)
    return

def x_alloc_counter():
    return _lib_alglib.x_alloc_counter()

def x_is_symmetric(x):
    return _lib_alglib.x_is_symmetric_e_(ctypes.byref(x))

def x_force_symmetric(x):
    return _lib_alglib.x_force_symmetric_e_(ctypes.byref(x))

def x_is_hermitian(x):
    return _lib_alglib.x_is_hermitian_e_(ctypes.byref(x))

def x_force_hermitian(x):
    return _lib_alglib.x_force_hermitian_e_(ctypes.byref(x))

def x_vector_clear(x):
    if x.owner==OWN_AE:
        x_free(x.ptr.p_ptr)
    x.cnt = 0
    x.ptr.p_ptr = 0
    return

def x_matrix_clear(x):
    if x.owner==OWN_AE:
        x_free(x.ptr.p_ptr)
    x.cols = 0
    x.rows = 0
    x.ptr.p_ptr = 0
    return

#
# safe vector length:
# * returns list length.
# * throws ValueError if 'v' is not list (it uses
#   'msg' parameter to generate error message
#
def safe_len(msg,v):
    if type(v)!=list:
        raise ValueError(msg)
    return len(v)

#
# safe matrix size
# * returns number of columns
# * throws ValueError if 'v' is not rectangular matrix 
#   (list of lists of same size)
#   it uses 'msg' parameter to generate error message
#
def safe_cols(msg,v):
    if type(v)!=list:
        raise ValueError(msg)
    if len(v)==0:
        return 0
    if type(v[0])!=list:
        raise ValueError(msg)
    cols = len(v[0])
    for x in v:
        if type(x)!=list:
            raise ValueError(msg)
        if len(x)!=cols:
            raise ValueError(msg)
    return cols

#
# safe matrix size
# * returns number of rows
# * throws ValueError if 'v' is not rectangular matrix 
#   (list of lists of same size)
#   it uses 'msg' parameter to generate error message
#
def safe_rows(msg,v):
    if type(v)!=list:
        raise ValueError(msg)
    if len(v)==0:
        return 0
    if type(v[0])!=list:
        raise ValueError(msg)
    cols = len(v[0])
    for x in v:
        if type(x)!=list:
            raise ValueError(msg)
        if len(x)!=cols:
            raise ValueError(msg)
    return len(v)

def create_real_vector(cnt):
    if cnt<=0:
        return []
    return [0]*cnt

def create_real_matrix(rows, cols):
    if rows<=0 or cols<=0:
        return [[]]
    matrix = []
    row = 0
    while row<rows:
        matrix += [[0]*cols]
        row += 1
    return matrix

def is_bool(v):
    try:
        tmp = bool(v)
    except:
        return False
    return True

def is_int(v):
    try:
        tmp = int(v)
    except:
        return False
    return True

def is_real(v):
    try:
        tmp = float(v)
    except:
        return False
    return True

def is_complex(v):
    try:
        tmp = complex(v)
    except:
        return False
    return True

def is_bool_vector(v):
    if type(v)!=list:
        return False
    for x in v:
        try:
            tmp = bool(x)
        except:
            return False
    return True

def is_bool_matrix(v):
    if type(v)!=list:
        return False
    if len(v)==0:
        return True
    if type(v[0])!=list:
        return False
    rows = len(v)
    cols = len(v[0])
    for x in v:
        if type(x)!=list:
            return False
        if len(x)!=cols:
            return False
        for y in x:
            try:
                tmp = bool(y)
            except:
                return False
    return True

def is_int_vector(v):
    if type(v)!=list:
        return False
    for x in v:
        try:
            tmp = int(x)
        except:
            return False
    return True

def is_int_matrix(v):
    if type(v)!=list:
        return False
    if len(v)==0:
        return True
    if type(v[0])!=list:
        return False
    rows = len(v)
    cols = len(v[0])
    for x in v:
        if type(x)!=list:
            return False
        if len(x)!=cols:
            return False
        for y in x:
            try:
                tmp = int(y)
            except:
                return False
    return True

def is_real_vector(v):
    if type(v)!=list:
        return False
    for x in v:
        try:
            tmp = float(x)
        except:
            return False
    return True

def is_real_matrix(v):
    if type(v)!=list:
        return False
    if len(v)==0:
        return True
    if type(v[0])!=list:
        return False
    rows = len(v)
    cols = len(v[0])
    for x in v:
        if type(x)!=list:
            return False
        if len(x)!=cols:
            return False
        for y in x:
            try:
                tmp = float(y)
            except:
                return False
    return True

def is_complex_vector(v):
    if type(v)!=list:
        return False
    for x in v:
        try:
            tmp = complex(x)
        except:
            return False
    return True

def is_complex_matrix(v):
    if type(v)!=list:
        return False
    if len(v)==0:
        return True
    if type(v[0])!=list:
        return False
    rows = len(v)
    cols = len(v[0])
    for x in v:
        if type(x)!=list:
            return False
        if len(x)!=cols:
            return False
        for y in x:
            try:
                tmp = complex(y)
            except:
                return False
    return True

#
# conversion from list to x-vector:
#
# x     x-vector. 
# v     list
# dt    datatype
# mode  one of the modes:
#       * X_CREATE -  x is assumed to be uninitialized
#       * X_SET -     x is assumed to be initialized; old contents is freed
#       * X_REWRITE - x is assumed to have same size as v, exception is thrown otherwise
#                     it is rewritten without reallocation of memory;
#
def x_from_list(x, v, dt, mode):
    #
    # check types
    #
    if dt==DT_BOOL:
        if not is_bool_vector(v):
            raise ValueError("can't cast to bool_vector")
        elemsize = SIZE_BOOL
    if dt==DT_INT:
        if not is_int_vector(v):
            raise ValueError("can't cast to int_vector")
        elemsize = SIZE_INT
    if dt==DT_REAL:
        if not is_real_vector(v):
            raise ValueError("can't cast to real_vector")
        elemsize = SIZE_REAL
    if dt==DT_COMPLEX:
        if not is_complex_vector(v):
            raise ValueError("can't cast to complex_vector")
        elemsize = SIZE_COMPLEX
    
    #
    # allocation
    #
    if mode==X_CREATE:
        x.datatype = dt
        x.cnt = len(v)
        x.owner = OWN_AE
        x.ptr.p_ptr = x_malloc(elemsize*x.cnt)
        x.last_action = 1
    if mode==X_SET:
        if x.owner==OWN_AE:
            x_free(x.ptr.p_ptr)
        x.datatype = dt
        x.cnt = len(v)
        x.owner = OWN_AE
        x.ptr.p_ptr = x_malloc(elemsize*x.cnt)
        x.last_action = 3
    if mode==X_REWRITE:
        if x.datatype!=dt:
            raise RuntimeError("Trying to rewrite vector - types don't match")
        if len(v)!=x.cnt:
            raise RuntimeError("Trying to rewrite vector - sizes don't match")
        x.last_action = 2
    
    #
    # copy
    #
    if dt==DT_BOOL:
        cnt = x.cnt
        i = 0
        while i<cnt:
            x.ptr.p_bool[i] =   bool(v[i])
            i += 1
    if dt==DT_INT:
        cnt = x.cnt
        i = 0
        while i<cnt:
            x.ptr.p_int[i] =    int(v[i])
            i += 1
    if dt==DT_REAL:
        cnt = x.cnt
        i = 0
        while i<cnt:
            x.ptr.p_real[i] = float(v[i])
            i += 1
    if dt==DT_COMPLEX:
        cnt = x.cnt
        i = 0
        while i<cnt:
            tmp = complex(v[i])
            x.ptr.p_complex[i].x = tmp.real
            x.ptr.p_complex[i].y = tmp.imag
            i += 1
    
    return


#
# conversion from list of lists to x-matrix:
#
# x     x-matrix.
# v     list
# dt    datatype
# mode  one of the modes:
#       * X_CREATE -  x is assumed to be uninitialized
#       * X_SET -     x is assumed to be initialized; old contents is freed
#       * X_REWRITE - x is assumed to have same size as v, exception is thrown otherwise
#                     it is rewritten without reallocation of memory;
#
def x_from_listlist(x, v, dt, mode):
    #
    # check types
    #
    if dt==DT_BOOL:
        if not is_bool_matrix(v):
            raise ValueError("can't cast to bool_matrix")
        elemsize = SIZE_BOOL
    if dt==DT_INT:
        if not is_int_matrix(v):
            raise ValueError("can't cast to int_matrix")
        elemsize = SIZE_INT
    if dt==DT_REAL:
        if not is_real_matrix(v):
            raise ValueError("can't cast to real_matrix")
        elemsize = SIZE_REAL
    if dt==DT_COMPLEX:
        if not is_complex_matrix(v):
            raise ValueError("can't cast to complex_matrix")
        elemsize = SIZE_COMPLEX
    
    #
    # determine size
    #
    rows = len(v)
    if rows>0:
        cols = len(v[0])
    else:
        cols = 0
    if cols==0:
        rows = 0
    
    #
    # allocation
    #
    if mode==X_CREATE:
        x.datatype = dt
        x.cols = cols
        x.rows = rows
        x.stride = cols
        x.owner = OWN_AE
        x.ptr.p_ptr = x_malloc(elemsize*x.stride*x.rows)
        x.last_action = 1
    if mode==X_SET:
        if x.owner==OWN_AE:
            x_free(x.ptr.p_ptr)
        x.cols = cols
        x.rows = rows
        x.stride =cols
        x.owner = OWN_AE
        x.ptr.p_ptr = x_malloc(elemsize*x.stride*x.rows)
        x.last_action = 3
    if mode==X_REWRITE:
        if x.datatype!=dt:
            raise RuntimeError("Trying to rewrite matrix - types don't match")
        if rows!=x.rows or cols!=x.cols:
            raise RuntimeError("Trying to rewrite vector - sizes don't match")
        x.last_action = 2
    
    #
    # copy
    #
    offs = 0
    endoffs = x.stride-x.cols
    for p in v:
        for q in p:
            if dt==DT_BOOL:
                x.ptr.p_bool[offs] = bool(q)
            if dt==DT_INT:
                x.ptr.p_int[offs]  = int(q)
            if dt==DT_REAL:
                x.ptr.p_real[offs] = float(q)
            if dt==DT_COMPLEX:
                tmp = complex(q)
                x.ptr.p_complex[offs].x = tmp.real
                x.ptr.p_complex[offs].y = tmp.imag
            offs = offs+1
        offs = offs+endoffs
    return


#
# conversion from x-vector to Python vector
#
# Function takes only one parameter - x, x-vector,
# which is NOT freed after use.
#
def list_from_x(x):
    if x.cnt==0:
        return []
    r = [0]*x.cnt
    i = 0
    if x.datatype==DT_BOOL:
        while i<x.cnt:
            r[i] = bool(x.ptr.p_bool[i])
            i += 1
    if x.datatype==DT_INT:
        while i<x.cnt:
            r[i] = x.ptr.p_int[i]
            i += 1
    if x.datatype==DT_REAL:
        while i<x.cnt:
            r[i] = x.ptr.p_real[i]
            i += 1
    if x.datatype==DT_COMPLEX:
        while i<x.cnt:
            r[i] = complex(x.ptr.p_complex[i].x, x.ptr.p_complex[i].y)
            i += 1
    return r


#
# conversion from x-matrix to Python matrix
#
# Function takes only one parameter - x, x-matrix,
# which is NOT freed after use.
#
def listlist_from_x(x):
    if x.cols==0 or x.rows==0:
        return [[]]
    r = create_real_matrix(x.rows, x.cols)
    offs = 0
    endoffs = x.stride-x.cols
    m = x.rows
    n = x.cols
    dt = x.datatype
    i = 0
    while i<m:
        j = 0
        while j<n:
            if dt==DT_BOOL:
                r[i][j] = bool(x.ptr.p_bool[offs])
            if dt==DT_INT:
                r[i][j] = x.ptr.p_int[offs]
            if dt==DT_REAL:
                r[i][j] = x.ptr.p_real[offs]
            if dt==DT_COMPLEX:
                r[i][j] = complex(x.ptr.p_complex[offs].x, x.ptr.p_complex[offs].y)
            offs += 1
            j += 1
        offs += endoffs
        i += 1
    return r



#
# this function copies x-vector to previously allocated list 
# which should be large enough to store x-vector.
#
# invalid access to list is generated if list is too small.
# x-vector is not freed after use.
#
def copy_x_to_list(x,r):
    if x.cnt==0:
        return
    i = 0
    if x.datatype==DT_BOOL:
        while i<x.cnt:
            r[i] = bool(x.ptr.p_bool[i])
            i += 1
    if x.datatype==DT_INT:
        while i<x.cnt:
            r[i] = x.ptr.p_int[i]
            i += 1
    if x.datatype==DT_REAL:
        while i<x.cnt:
            r[i] = x.ptr.p_real[i]
            i += 1
    if x.datatype==DT_COMPLEX:
        while i<x.cnt:
            r[i] = complex(x.ptr.p_complex[i].x, x.ptr.p_complex[i].y)
            i += 1
    return

_lib_alglib.x_obj_free_kdtreerequestbuffer.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_kdtreerequestbuffer.restype = None


class kdtreerequestbuffer(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_kdtreerequestbuffer(self.ptr)
_lib_alglib.x_obj_free_kdtree.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_kdtree.restype = None


class kdtree(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_kdtree(self.ptr)
_lib_alglib.alglib_kdtreeserialize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.alglib_kdtreeserialize.restype = ctypes.c_int32

def kdtreeserialize(obj):
    error_msg = ctypes.c_char_p(0)
    _s_out = ctypes.c_char_p(0)
    retval = _lib_alglib.alglib_kdtreeserialize(ctypes.byref(error_msg), ctypes.byref(obj.ptr), ctypes.byref(_s_out))
    if retval!=0:
        if retval==X_ASSERTION_FAILED:
            raise RuntimeError(error_msg.value)
        else:
            raise RuntimeError("Error while calling 'kdtreeserialize'")
    s_out = _s_out.value
    _lib_alglib.x_free(_s_out)
    return s_out

_lib_alglib.alglib_kdtreeunserialize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.alglib_kdtreeunserialize.restype = ctypes.c_int32

def kdtreeunserialize(s_in):
    error_msg = ctypes.c_char_p(0)
    _s_in = ctypes.c_char_p(s_in)
    _obj = ctypes.c_void_p(0)
    retval = _lib_alglib.alglib_kdtreeunserialize(ctypes.byref(error_msg), ctypes.byref(_s_in), ctypes.byref(_obj), )
    if retval!=0:
        if retval==X_ASSERTION_FAILED:
            raise RuntimeError(error_msg.value)
        else:
            raise RuntimeError("Error while calling 'kdtreeserialize'")
    return kdtree(_obj)

_lib_alglib.alglib_xv2_kdtreebuild.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreebuild.restype = ctypes.c_int32
def kdtreebuild(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        xy,n,nx,ny,normtype = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        xy,nx,ny,normtype = functionargs
        n = safe_rows("'kdtreebuild': incorrect parameters",xy)
    else:
        raise RuntimeError("Error while calling 'kdtreebuild': function must have 4 or 5 parameters")
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __nx = x_int()
    __nx.val = int(nx)
    if __nx.val!=nx:
        raise ValueError("Error while converting 'nx' parameter to 'x_int'")
    __ny = x_int()
    __ny.val = int(ny)
    if __ny.val!=ny:
        raise ValueError("Error while converting 'ny' parameter to 'x_int'")
    __normtype = x_int()
    __normtype.val = int(normtype)
    if __normtype.val!=normtype:
        raise ValueError("Error while converting 'normtype' parameter to 'x_int'")
    __kdt = ctypes.c_void_p(0)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreebuild(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__n), ctypes.byref(__nx), ctypes.byref(__ny), ctypes.byref(__normtype), ctypes.byref(__kdt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreebuild'")
        __r__kdt = kdtree(__kdt)
        return __r__kdt
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_kdtreebuildtagged.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreebuildtagged.restype = ctypes.c_int32
def kdtreebuildtagged(*functionargs):
    if len(functionargs)==6:
        __friendly_form = False
        xy,tags,n,nx,ny,normtype = functionargs
    elif len(functionargs)==5:
        __friendly_form = True
        xy,tags,nx,ny,normtype = functionargs
        if safe_rows("'kdtreebuildtagged': incorrect parameters",xy)!=safe_len("'kdtreebuildtagged': incorrect parameters",tags):
            raise RuntimeError("Error while calling 'kdtreebuildtagged': looks like one of arguments has wrong size")
        n = safe_rows("'kdtreebuildtagged': incorrect parameters",xy)
    else:
        raise RuntimeError("Error while calling 'kdtreebuildtagged': function must have 5 or 6 parameters")
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(tags):
        raise ValueError("'tags' parameter can't be cast to int_vector")
    __tags = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __nx = x_int()
    __nx.val = int(nx)
    if __nx.val!=nx:
        raise ValueError("Error while converting 'nx' parameter to 'x_int'")
    __ny = x_int()
    __ny.val = int(ny)
    if __ny.val!=ny:
        raise ValueError("Error while converting 'ny' parameter to 'x_int'")
    __normtype = x_int()
    __normtype.val = int(normtype)
    if __normtype.val!=normtype:
        raise ValueError("Error while converting 'normtype' parameter to 'x_int'")
    __kdt = ctypes.c_void_p(0)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__tags, tags, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreebuildtagged(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__tags), ctypes.byref(__n), ctypes.byref(__nx), ctypes.byref(__ny), ctypes.byref(__normtype), ctypes.byref(__kdt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreebuildtagged'")
        __r__kdt = kdtree(__kdt)
        return __r__kdt
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__tags)


_lib_alglib.alglib_xv2_kdtreecreaterequestbuffer.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreecreaterequestbuffer.restype = ctypes.c_int32
def kdtreecreaterequestbuffer(kdt):
    pass
    __kdt = kdt.ptr
    __buf = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreecreaterequestbuffer(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__buf), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreecreaterequestbuffer'")
        __r__buf = kdtreerequestbuffer(__buf)
        return __r__buf
    finally:
        pass


_lib_alglib.alglib_xv2_kdtreequeryknn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryknn.restype = ctypes.c_int32
def kdtreequeryknn(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        kdt,x,k,selfmatch = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        kdt,x,k = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreequeryknn': function must have 3 or 4 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryknn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__x), ctypes.byref(__k), ctypes.byref(__selfmatch), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryknn'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreetsqueryknn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryknn.restype = ctypes.c_int32
def kdtreetsqueryknn(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        kdt,buf,x,k,selfmatch = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        kdt,buf,x,k = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreetsqueryknn': function must have 4 or 5 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryknn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__x), ctypes.byref(__k), ctypes.byref(__selfmatch), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryknn'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreequeryrnn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryrnn.restype = ctypes.c_int32
def kdtreequeryrnn(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        kdt,x,r,selfmatch = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        kdt,x,r = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreequeryrnn': function must have 3 or 4 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __r = ctypes.c_double(r)
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryrnn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__x), ctypes.byref(__r), ctypes.byref(__selfmatch), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryrnn'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreequeryrnnu.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryrnnu.restype = ctypes.c_int32
def kdtreequeryrnnu(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        kdt,x,r,selfmatch = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        kdt,x,r = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreequeryrnnu': function must have 3 or 4 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __r = ctypes.c_double(r)
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryrnnu(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__x), ctypes.byref(__r), ctypes.byref(__selfmatch), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryrnnu'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreetsqueryrnn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryrnn.restype = ctypes.c_int32
def kdtreetsqueryrnn(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        kdt,buf,x,r,selfmatch = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        kdt,buf,x,r = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreetsqueryrnn': function must have 4 or 5 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __r = ctypes.c_double(r)
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryrnn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__x), ctypes.byref(__r), ctypes.byref(__selfmatch), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryrnn'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreetsqueryrnnu.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryrnnu.restype = ctypes.c_int32
def kdtreetsqueryrnnu(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        kdt,buf,x,r,selfmatch = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        kdt,buf,x,r = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreetsqueryrnnu': function must have 4 or 5 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __r = ctypes.c_double(r)
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryrnnu(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__x), ctypes.byref(__r), ctypes.byref(__selfmatch), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryrnnu'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreequeryaknn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryaknn.restype = ctypes.c_int32
def kdtreequeryaknn(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        kdt,x,k,selfmatch,eps = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        kdt,x,k,eps = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreequeryaknn': function must have 4 or 5 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    __eps = ctypes.c_double(eps)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryaknn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__x), ctypes.byref(__k), ctypes.byref(__selfmatch), ctypes.byref(__eps), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryaknn'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreetsqueryaknn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryaknn.restype = ctypes.c_int32
def kdtreetsqueryaknn(*functionargs):
    if len(functionargs)==6:
        __friendly_form = False
        kdt,buf,x,k,selfmatch,eps = functionargs
    elif len(functionargs)==5:
        __friendly_form = True
        kdt,buf,x,k,eps = functionargs
        selfmatch = True
    else:
        raise RuntimeError("Error while calling 'kdtreetsqueryaknn': function must have 5 or 6 parameters")
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __selfmatch = ctypes.c_uint64(selfmatch)
    if __selfmatch.value!=0:
        __selfmatch = ctypes.c_uint64(1)
    __eps = ctypes.c_double(eps)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryaknn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__x), ctypes.byref(__k), ctypes.byref(__selfmatch), ctypes.byref(__eps), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryaknn'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_kdtreequerybox.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequerybox.restype = ctypes.c_int32
def kdtreequerybox(kdt, boxmin, boxmax):
    pass
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    if not is_real_vector(boxmin):
        raise ValueError("'boxmin' parameter can't be cast to real_vector")
    __boxmin = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(boxmax):
        raise ValueError("'boxmax' parameter can't be cast to real_vector")
    __boxmax = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__boxmin, boxmin, DT_REAL, X_CREATE)
        x_from_list(__boxmax, boxmax, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequerybox(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__boxmin), ctypes.byref(__boxmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequerybox'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__boxmin)
        x_vector_clear(__boxmax)


_lib_alglib.alglib_xv2_kdtreetsquerybox.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsquerybox.restype = ctypes.c_int32
def kdtreetsquerybox(kdt, buf, boxmin, boxmax):
    pass
    __result = x_int()
    __result.val = 0
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_vector(boxmin):
        raise ValueError("'boxmin' parameter can't be cast to real_vector")
    __boxmin = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(boxmax):
        raise ValueError("'boxmax' parameter can't be cast to real_vector")
    __boxmax = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__boxmin, boxmin, DT_REAL, X_CREATE)
        x_from_list(__boxmax, boxmax, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsquerybox(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__boxmin), ctypes.byref(__boxmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsquerybox'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__boxmin)
        x_vector_clear(__boxmax)


_lib_alglib.alglib_xv2_kdtreequeryresultsx.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultsx.restype = ctypes.c_int32
def kdtreequeryresultsx(kdt, x):
    pass
    __kdt = kdt.ptr
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultsx(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultsx'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_kdtreequeryresultsxy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultsxy.restype = ctypes.c_int32
def kdtreequeryresultsxy(kdt, xy):
    pass
    __kdt = kdt.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultsxy(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__xy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultsxy'")
        __r__xy = listlist_from_x(__xy)
        return __r__xy
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_kdtreequeryresultstags.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultstags.restype = ctypes.c_int32
def kdtreequeryresultstags(kdt, tags):
    pass
    __kdt = kdt.ptr
    if not is_int_vector(tags):
        raise ValueError("'tags' parameter can't be cast to int_vector")
    __tags = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__tags, tags, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultstags(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__tags), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultstags'")
        __r__tags = list_from_x(__tags)
        return __r__tags
    finally:
        x_vector_clear(__tags)


_lib_alglib.alglib_xv2_kdtreequeryresultsdistances.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultsdistances.restype = ctypes.c_int32
def kdtreequeryresultsdistances(kdt, r):
    pass
    __kdt = kdt.ptr
    if not is_real_vector(r):
        raise ValueError("'r' parameter can't be cast to real_vector")
    __r = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__r, r, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultsdistances(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__r), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultsdistances'")
        __r__r = list_from_x(__r)
        return __r__r
    finally:
        x_vector_clear(__r)


_lib_alglib.alglib_xv2_kdtreetsqueryresultsx.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryresultsx.restype = ctypes.c_int32
def kdtreetsqueryresultsx(kdt, buf, x):
    pass
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryresultsx(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryresultsx'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_kdtreetsqueryresultsxy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryresultsxy.restype = ctypes.c_int32
def kdtreetsqueryresultsxy(kdt, buf, xy):
    pass
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryresultsxy(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__xy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryresultsxy'")
        __r__xy = listlist_from_x(__xy)
        return __r__xy
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_kdtreetsqueryresultstags.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryresultstags.restype = ctypes.c_int32
def kdtreetsqueryresultstags(kdt, buf, tags):
    pass
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_int_vector(tags):
        raise ValueError("'tags' parameter can't be cast to int_vector")
    __tags = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__tags, tags, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryresultstags(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__tags), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryresultstags'")
        __r__tags = list_from_x(__tags)
        return __r__tags
    finally:
        x_vector_clear(__tags)


_lib_alglib.alglib_xv2_kdtreetsqueryresultsdistances.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreetsqueryresultsdistances.restype = ctypes.c_int32
def kdtreetsqueryresultsdistances(kdt, buf, r):
    pass
    __kdt = kdt.ptr
    __buf = buf.ptr
    if not is_real_vector(r):
        raise ValueError("'r' parameter can't be cast to real_vector")
    __r = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__r, r, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreetsqueryresultsdistances(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__buf), ctypes.byref(__r), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreetsqueryresultsdistances'")
        __r__r = list_from_x(__r)
        return __r__r
    finally:
        x_vector_clear(__r)


_lib_alglib.alglib_xv2_kdtreequeryresultsxi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultsxi.restype = ctypes.c_int32
def kdtreequeryresultsxi(kdt):
    pass
    __kdt = kdt.ptr
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultsxi(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultsxi'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_kdtreequeryresultsxyi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultsxyi.restype = ctypes.c_int32
def kdtreequeryresultsxyi(kdt):
    pass
    __kdt = kdt.ptr
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultsxyi(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__xy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultsxyi'")
        __r__xy = listlist_from_x(__xy)
        return __r__xy
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_kdtreequeryresultstagsi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultstagsi.restype = ctypes.c_int32
def kdtreequeryresultstagsi(kdt):
    pass
    __kdt = kdt.ptr
    __tags = x_vector(cnt=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultstagsi(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__tags), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultstagsi'")
        __r__tags = list_from_x(__tags)
        return __r__tags
    finally:
        x_vector_clear(__tags)


_lib_alglib.alglib_xv2_kdtreequeryresultsdistancesi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_kdtreequeryresultsdistancesi.restype = ctypes.c_int32
def kdtreequeryresultsdistancesi(kdt):
    pass
    __kdt = kdt.ptr
    __r = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_kdtreequeryresultsdistancesi(ctypes.byref(_error_msg), ctypes.byref(__kdt), ctypes.byref(__r), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'kdtreequeryresultsdistancesi'")
        __r__r = list_from_x(__r)
        return __r__r
    finally:
        x_vector_clear(__r)


_lib_alglib.x_obj_free_hqrndstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_hqrndstate.restype = None


class hqrndstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_hqrndstate(self.ptr)
_lib_alglib.alglib_xv2_hqrndrandomize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndrandomize.restype = ctypes.c_int32
def hqrndrandomize():
    pass
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndrandomize(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndrandomize'")
        __r__state = hqrndstate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_hqrndseed.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndseed.restype = ctypes.c_int32
def hqrndseed(s1, s2):
    pass
    __s1 = x_int()
    __s1.val = int(s1)
    if __s1.val!=s1:
        raise ValueError("Error while converting 's1' parameter to 'x_int'")
    __s2 = x_int()
    __s2.val = int(s2)
    if __s2.val!=s2:
        raise ValueError("Error while converting 's2' parameter to 'x_int'")
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndseed(ctypes.byref(_error_msg), ctypes.byref(__s1), ctypes.byref(__s2), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndseed'")
        __r__state = hqrndstate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_hqrnduniformr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrnduniformr.restype = ctypes.c_int32
def hqrnduniformr(state):
    pass
    __result = ctypes.c_double(0)
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrnduniformr(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrnduniformr'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_hqrnduniformi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrnduniformi.restype = ctypes.c_int32
def hqrnduniformi(state, n):
    pass
    __result = x_int()
    __result.val = 0
    __state = state.ptr
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrnduniformi(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrnduniformi'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_hqrndnormal.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndnormal.restype = ctypes.c_int32
def hqrndnormal(state):
    pass
    __result = ctypes.c_double(0)
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndnormal(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndnormal'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_hqrndunit2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndunit2.restype = ctypes.c_int32
def hqrndunit2(state):
    pass
    __state = state.ptr
    __x = ctypes.c_double(0)
    __y = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndunit2(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndunit2'")
        __r__x = __x.value
        __r__y = __y.value
        return (__r__x, __r__y)
    finally:
        pass


_lib_alglib.alglib_xv2_hqrndnormal2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndnormal2.restype = ctypes.c_int32
def hqrndnormal2(state):
    pass
    __state = state.ptr
    __x1 = ctypes.c_double(0)
    __x2 = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndnormal2(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x1), ctypes.byref(__x2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndnormal2'")
        __r__x1 = __x1.value
        __r__x2 = __x2.value
        return (__r__x1, __r__x2)
    finally:
        pass


_lib_alglib.alglib_xv2_hqrndexponential.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndexponential.restype = ctypes.c_int32
def hqrndexponential(state, lambdav):
    pass
    __result = ctypes.c_double(0)
    __state = state.ptr
    __lambdav = ctypes.c_double(lambdav)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndexponential(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), ctypes.byref(__lambdav), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndexponential'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_hqrnddiscrete.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrnddiscrete.restype = ctypes.c_int32
def hqrnddiscrete(state, x, n):
    pass
    __result = ctypes.c_double(0)
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrnddiscrete(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrnddiscrete'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_hqrndcontinuous.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hqrndcontinuous.restype = ctypes.c_int32
def hqrndcontinuous(state, x, n):
    pass
    __result = ctypes.c_double(0)
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hqrndcontinuous(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hqrndcontinuous'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)




class x_xdebugrecord1(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("i", x_int),
        ("c", x_complex),
        ("a", x_vector)
        ]




class xdebugrecord1(object):
    def __init__(self):
        self.i = 0
        self.c = 0
        self.a = []


def x_xdebugrecord1_zero_fields(x):
    x.i.val = 0
    x.c.x = 0
    x.c.y = 0
    x.a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    return




def x_xdebugrecord1_clear(x):
    x_vector_clear(x.a)
    x_xdebugrecord1_zero_fields(x)
    return




def x_from_xdebugrecord1(x,v):
    x.i.val = int(v.i)
    tmp = complex(v.c)
    x.c.x = tmp.real
    x.c.y = tmp.imag
    x_from_list(x.a, v.a, DT_REAL, X_CREATE)
    return




def xdebugrecord1_from_x(x):
    r = xdebugrecord1()
    r.i = x.i.val
    r.c = complex(x.c.x,x.c.y)
    r.a = list_from_x(x.a)
    return r


_lib_alglib.alglib_xv2_xdebuginitrecord1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebuginitrecord1.restype = ctypes.c_int32
def xdebuginitrecord1():
    pass
    __rec1 = x_xdebugrecord1()
    x_xdebugrecord1_zero_fields(__rec1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebuginitrecord1(ctypes.byref(_error_msg), ctypes.byref(__rec1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebuginitrecord1'")
        __r__rec1 = xdebugrecord1_from_x(__rec1)
        return __r__rec1
    finally:
        x_xdebugrecord1_clear(__rec1)


_lib_alglib.alglib_xv2_xdebugb1count.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb1count.restype = ctypes.c_int32
def xdebugb1count(a):
    pass
    __result = x_int()
    __result.val = 0
    if not is_bool_vector(a):
        raise ValueError("'a' parameter can't be cast to bool_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb1count(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb1count'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugb1not.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb1not.restype = ctypes.c_int32
def xdebugb1not(a):
    pass
    if not is_bool_vector(a):
        raise ValueError("'a' parameter can't be cast to bool_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb1not(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb1not'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugb1appendcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb1appendcopy.restype = ctypes.c_int32
def xdebugb1appendcopy(a):
    pass
    if not is_bool_vector(a):
        raise ValueError("'a' parameter can't be cast to bool_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb1appendcopy(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb1appendcopy'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugb1outeven.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb1outeven.restype = ctypes.c_int32
def xdebugb1outeven(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_vector(cnt=0,datatype=DT_BOOL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb1outeven(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb1outeven'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugi1sum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi1sum.restype = ctypes.c_int32
def xdebugi1sum(a):
    pass
    __result = x_int()
    __result.val = 0
    if not is_int_vector(a):
        raise ValueError("'a' parameter can't be cast to int_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi1sum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi1sum'")
        __r__result = __result.val
        return __r__result
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugi1neg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi1neg.restype = ctypes.c_int32
def xdebugi1neg(a):
    pass
    if not is_int_vector(a):
        raise ValueError("'a' parameter can't be cast to int_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi1neg(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi1neg'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugi1appendcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi1appendcopy.restype = ctypes.c_int32
def xdebugi1appendcopy(a):
    pass
    if not is_int_vector(a):
        raise ValueError("'a' parameter can't be cast to int_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi1appendcopy(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi1appendcopy'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugi1outeven.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi1outeven.restype = ctypes.c_int32
def xdebugi1outeven(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_vector(cnt=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi1outeven(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi1outeven'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugr1sum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr1sum.restype = ctypes.c_int32
def xdebugr1sum(a):
    pass
    __result = ctypes.c_double(0)
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr1sum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr1sum'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugr1neg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr1neg.restype = ctypes.c_int32
def xdebugr1neg(a):
    pass
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr1neg(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr1neg'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugr1appendcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr1appendcopy.restype = ctypes.c_int32
def xdebugr1appendcopy(a):
    pass
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr1appendcopy(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr1appendcopy'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugr1outeven.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr1outeven.restype = ctypes.c_int32
def xdebugr1outeven(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr1outeven(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr1outeven'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugc1sum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc1sum.restype = ctypes.c_int32
def xdebugc1sum(a):
    pass
    __result = x_complex(x=0,y=0)
    if not is_complex_vector(a):
        raise ValueError("'a' parameter can't be cast to complex_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc1sum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc1sum'")
        __r__result = complex(__result.x,__result.y)
        return __r__result
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugc1neg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc1neg.restype = ctypes.c_int32
def xdebugc1neg(a):
    pass
    if not is_complex_vector(a):
        raise ValueError("'a' parameter can't be cast to complex_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc1neg(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc1neg'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugc1appendcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc1appendcopy.restype = ctypes.c_int32
def xdebugc1appendcopy(a):
    pass
    if not is_complex_vector(a):
        raise ValueError("'a' parameter can't be cast to complex_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc1appendcopy(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc1appendcopy'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugc1outeven.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc1outeven.restype = ctypes.c_int32
def xdebugc1outeven(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc1outeven(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc1outeven'")
        __r__a = list_from_x(__a)
        return __r__a
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_xdebugb2count.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb2count.restype = ctypes.c_int32
def xdebugb2count(a):
    pass
    __result = x_int()
    __result.val = 0
    if not is_bool_matrix(a):
        raise ValueError("'a' parameter can't be cast to bool_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb2count(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb2count'")
        __r__result = __result.val
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugb2not.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb2not.restype = ctypes.c_int32
def xdebugb2not(a):
    pass
    if not is_bool_matrix(a):
        raise ValueError("'a' parameter can't be cast to bool_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb2not(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb2not'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugb2transpose.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb2transpose.restype = ctypes.c_int32
def xdebugb2transpose(a):
    pass
    if not is_bool_matrix(a):
        raise ValueError("'a' parameter can't be cast to bool_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb2transpose(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb2transpose'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugb2outsin.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugb2outsin.restype = ctypes.c_int32
def xdebugb2outsin(m, n):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_BOOL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugb2outsin(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugb2outsin'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugi2sum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi2sum.restype = ctypes.c_int32
def xdebugi2sum(a):
    pass
    __result = x_int()
    __result.val = 0
    if not is_int_matrix(a):
        raise ValueError("'a' parameter can't be cast to int_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi2sum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi2sum'")
        __r__result = __result.val
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugi2neg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi2neg.restype = ctypes.c_int32
def xdebugi2neg(a):
    pass
    if not is_int_matrix(a):
        raise ValueError("'a' parameter can't be cast to int_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi2neg(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi2neg'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugi2transpose.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi2transpose.restype = ctypes.c_int32
def xdebugi2transpose(a):
    pass
    if not is_int_matrix(a):
        raise ValueError("'a' parameter can't be cast to int_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi2transpose(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi2transpose'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugi2outsin.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugi2outsin.restype = ctypes.c_int32
def xdebugi2outsin(m, n):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugi2outsin(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugi2outsin'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugr2sum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr2sum.restype = ctypes.c_int32
def xdebugr2sum(a):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr2sum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr2sum'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugr2neg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr2neg.restype = ctypes.c_int32
def xdebugr2neg(a):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr2neg(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr2neg'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugr2transpose.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr2transpose.restype = ctypes.c_int32
def xdebugr2transpose(a):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr2transpose(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr2transpose'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugr2outsin.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugr2outsin.restype = ctypes.c_int32
def xdebugr2outsin(m, n):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugr2outsin(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugr2outsin'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugc2sum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc2sum.restype = ctypes.c_int32
def xdebugc2sum(a):
    pass
    __result = x_complex(x=0,y=0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc2sum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc2sum'")
        __r__result = complex(__result.x,__result.y)
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugc2neg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc2neg.restype = ctypes.c_int32
def xdebugc2neg(a):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc2neg(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc2neg'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugc2transpose.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc2transpose.restype = ctypes.c_int32
def xdebugc2transpose(a):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc2transpose(ctypes.byref(_error_msg), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc2transpose'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugc2outsincos.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugc2outsincos.restype = ctypes.c_int32
def xdebugc2outsincos(m, n):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugc2outsincos(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugc2outsincos'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_xdebugmaskedbiasedproductsum.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_xdebugmaskedbiasedproductsum.restype = ctypes.c_int32
def xdebugmaskedbiasedproductsum(m, n, a, b, c):
    pass
    __result = ctypes.c_double(0)
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_bool_matrix(c):
        raise ValueError("'c' parameter can't be cast to bool_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        x_from_listlist(__c, c, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_xdebugmaskedbiasedproductsum(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__b), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'xdebugmaskedbiasedproductsum'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_matrix_clear(__c)


_lib_alglib.x_obj_free_odesolverstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_odesolverstate.restype = None
_lib_alglib.x_odesolverstate_get_needdy.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_odesolverstate_get_needdy.restype = None
_lib_alglib.x_odesolverstate_set_needdy.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_odesolverstate_set_needdy.restype = None
_lib_alglib.x_odesolverstate_get_y.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_odesolverstate_get_y.restype = None
_lib_alglib.x_odesolverstate_get_dy.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_odesolverstate_get_dy.restype = None
_lib_alglib.x_odesolverstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_odesolverstate_get_x.restype = None
_lib_alglib.x_odesolverstate_set_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_odesolverstate_set_x.restype = None


class odesolverstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_odesolverstate(self.ptr)


class x_odesolverreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("nfev", x_int),
        ("terminationtype", x_int)
        ]




class odesolverreport(object):
    def __init__(self):
        self.nfev = 0
        self.terminationtype = 0


def x_odesolverreport_zero_fields(x):
    x.nfev.val = 0
    x.terminationtype.val = 0
    return




def x_odesolverreport_clear(x):
    x_odesolverreport_zero_fields(x)
    return




def x_from_odesolverreport(x,v):
    x.nfev.val = int(v.nfev)
    x.terminationtype.val = int(v.terminationtype)
    return




def odesolverreport_from_x(x):
    r = odesolverreport()
    r.nfev = x.nfev.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_odesolverrkck.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_odesolverrkck.restype = ctypes.c_int32
def odesolverrkck(*functionargs):
    if len(functionargs)==6:
        __friendly_form = False
        y,n,x,m,eps,h = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        y,x,eps,h = functionargs
        n = safe_len("'odesolverrkck': incorrect parameters",y)
        m = safe_len("'odesolverrkck': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'odesolverrkck': function must have 4 or 6 parameters")
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __eps = ctypes.c_double(eps)
    __h = ctypes.c_double(h)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__y, y, DT_REAL, X_CREATE)
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_odesolverrkck(ctypes.byref(_error_msg), ctypes.byref(__y), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__m), ctypes.byref(__eps), ctypes.byref(__h), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'odesolverrkck'")
        __r__state = odesolverstate(__state)
        return __r__state
    finally:
        x_vector_clear(__y)
        x_vector_clear(__x)




def odesolversolve(state, dy, param = None):
    # initialize temporaries
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_flag = ctypes.c_uint8()
    
    # initialize reverse communication variables
    _xc_y = x_vector()
    _lib_alglib.x_odesolverstate_get_y(state.ptr, ctypes.byref(_xc_y))
    _py_y = create_real_vector(_xc_y.cnt)
    _xc_x = ctypes.c_double()
    _xc_dy = x_vector()
    _lib_alglib.x_odesolverstate_get_dy(state.ptr, ctypes.byref(_xc_dy))
    _py_dy = create_real_vector(_xc_dy.cnt)
    
    # algorithm iterations
    while True:
        retval = _lib_alglib.alglib_xv2_odesolveriteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'odesolveriteration'")
        if not _xc_result:
            break
        _lib_alglib.x_odesolverstate_get_needdy(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_y, _py_y)
            _lib_alglib.x_odesolverstate_get_x(state.ptr, ctypes.byref(_xc_x))
            dy(_py_y, _xc_x.value, _py_dy, param)
            x_from_list(_xc_dy, _py_dy, DT_REAL, X_REWRITE)
            continue
        raise RuntimeError("ALGLIB: unexpected error in 'odesolversolve'")
    return


_lib_alglib.alglib_xv2_odesolverresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_odesolverresults.restype = ctypes.c_int32
def odesolverresults(state):
    pass
    __state = state.ptr
    __m = x_int()
    __m.val = 0
    __xtbl = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ytbl = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_odesolverreport()
    x_odesolverreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_odesolverresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__m), ctypes.byref(__xtbl), ctypes.byref(__ytbl), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'odesolverresults'")
        __r__m = __m.val
        __r__xtbl = list_from_x(__xtbl)
        __r__ytbl = listlist_from_x(__ytbl)
        __r__rep = odesolverreport_from_x(__rep)
        return (__r__m, __r__xtbl, __r__ytbl, __r__rep)
    finally:
        x_vector_clear(__xtbl)
        x_matrix_clear(__ytbl)
        x_odesolverreport_clear(__rep)


_lib_alglib.x_obj_free_sparsematrix.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_sparsematrix.restype = None


class sparsematrix(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_sparsematrix(self.ptr)
_lib_alglib.x_obj_free_sparsebuffers.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_sparsebuffers.restype = None


class sparsebuffers(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_sparsebuffers(self.ptr)
_lib_alglib.alglib_xv2_sparsecreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreate.restype = ctypes.c_int32
def sparsecreate(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        m,n,k = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        m,n = functionargs
        k = 0
    else:
        raise RuntimeError("Error while calling 'sparsecreate': function must have 2 or 3 parameters")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreate(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreate'")
        __r__s = sparsematrix(__s)
        return __r__s
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecreatebuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatebuf.restype = ctypes.c_int32
def sparsecreatebuf(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        m,n,k,s = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        m,n,s = functionargs
        k = 0
    else:
        raise RuntimeError("Error while calling 'sparsecreatebuf': function must have 3 or 4 parameters")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatebuf(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatebuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecreatecrs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatecrs.restype = ctypes.c_int32
def sparsecreatecrs(m, n, ner):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_int_vector(ner):
        raise ValueError("'ner' parameter can't be cast to int_vector")
    __ner = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __s = ctypes.c_void_p(0)
    try:
        x_from_list(__ner, ner, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatecrs(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__ner), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatecrs'")
        __r__s = sparsematrix(__s)
        return __r__s
    finally:
        x_vector_clear(__ner)


_lib_alglib.alglib_xv2_sparsecreatecrsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatecrsbuf.restype = ctypes.c_int32
def sparsecreatecrsbuf(m, n, ner, s):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_int_vector(ner):
        raise ValueError("'ner' parameter can't be cast to int_vector")
    __ner = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __s = s.ptr
    try:
        x_from_list(__ner, ner, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatecrsbuf(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__ner), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatecrsbuf'")
        return
    finally:
        x_vector_clear(__ner)


_lib_alglib.alglib_xv2_sparsecreatesks.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatesks.restype = ctypes.c_int32
def sparsecreatesks(m, n, d, u):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_int_vector(d):
        raise ValueError("'d' parameter can't be cast to int_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(u):
        raise ValueError("'u' parameter can't be cast to int_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __s = ctypes.c_void_p(0)
    try:
        x_from_list(__d, d, DT_INT, X_CREATE)
        x_from_list(__u, u, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatesks(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__d), ctypes.byref(__u), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatesks'")
        __r__s = sparsematrix(__s)
        return __r__s
    finally:
        x_vector_clear(__d)
        x_vector_clear(__u)


_lib_alglib.alglib_xv2_sparsecreatesksbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatesksbuf.restype = ctypes.c_int32
def sparsecreatesksbuf(m, n, d, u, s):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_int_vector(d):
        raise ValueError("'d' parameter can't be cast to int_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(u):
        raise ValueError("'u' parameter can't be cast to int_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __s = s.ptr
    try:
        x_from_list(__d, d, DT_INT, X_CREATE)
        x_from_list(__u, u, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatesksbuf(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__d), ctypes.byref(__u), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatesksbuf'")
        return
    finally:
        x_vector_clear(__d)
        x_vector_clear(__u)


_lib_alglib.alglib_xv2_sparsecreatesksband.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatesksband.restype = ctypes.c_int32
def sparsecreatesksband(m, n, bw):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __bw = x_int()
    __bw.val = int(bw)
    if __bw.val!=bw:
        raise ValueError("Error while converting 'bw' parameter to 'x_int'")
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatesksband(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__bw), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatesksband'")
        __r__s = sparsematrix(__s)
        return __r__s
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecreatesksbandbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecreatesksbandbuf.restype = ctypes.c_int32
def sparsecreatesksbandbuf(m, n, bw, s):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __bw = x_int()
    __bw.val = int(bw)
    if __bw.val!=bw:
        raise ValueError("Error while converting 'bw' parameter to 'x_int'")
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecreatesksbandbuf(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__bw), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecreatesksbandbuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopy.restype = ctypes.c_int32
def sparsecopy(s0):
    pass
    __s0 = s0.ptr
    __s1 = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopy(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopy'")
        __r__s1 = sparsematrix(__s1)
        return __r__s1
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopybuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopybuf.restype = ctypes.c_int32
def sparsecopybuf(s0, s1):
    pass
    __s0 = s0.ptr
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopybuf(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopybuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseswap.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseswap.restype = ctypes.c_int32
def sparseswap(s0, s1):
    pass
    __s0 = s0.ptr
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseswap(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseswap'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseadd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseadd.restype = ctypes.c_int32
def sparseadd(s, i, j, v):
    pass
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __j = x_int()
    __j.val = int(j)
    if __j.val!=j:
        raise ValueError("Error while converting 'j' parameter to 'x_int'")
    __v = ctypes.c_double(v)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseadd(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__i), ctypes.byref(__j), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseadd'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseset.restype = ctypes.c_int32
def sparseset(s, i, j, v):
    pass
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __j = x_int()
    __j.val = int(j)
    if __j.val!=j:
        raise ValueError("Error while converting 'j' parameter to 'x_int'")
    __v = ctypes.c_double(v)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseset(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__i), ctypes.byref(__j), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseset'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseget.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseget.restype = ctypes.c_int32
def sparseget(s, i, j):
    pass
    __result = ctypes.c_double(0)
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __j = x_int()
    __j.val = int(j)
    if __j.val!=j:
        raise ValueError("Error while converting 'j' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseget(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), ctypes.byref(__i), ctypes.byref(__j), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseget'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetdiagonal.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetdiagonal.restype = ctypes.c_int32
def sparsegetdiagonal(s, i):
    pass
    __result = ctypes.c_double(0)
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetdiagonal(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), ctypes.byref(__i), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetdiagonal'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsemv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsemv.restype = ctypes.c_int32
def sparsemv(s, x, y):
    pass
    __s = s.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsemv(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsemv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_sparsemtv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsemtv.restype = ctypes.c_int32
def sparsemtv(s, x, y):
    pass
    __s = s.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsemtv(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsemtv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_sparsegemv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegemv.restype = ctypes.c_int32
def sparsegemv(s, alpha, ops, x, ix, beta, y, iy):
    pass
    __s = s.ptr
    __alpha = ctypes.c_double(alpha)
    __ops = x_int()
    __ops.val = int(ops)
    if __ops.val!=ops:
        raise ValueError("Error while converting 'ops' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iy = x_int()
    __iy.val = int(iy)
    if __iy.val!=iy:
        raise ValueError("Error while converting 'iy' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegemv(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__alpha), ctypes.byref(__ops), ctypes.byref(__x), ctypes.byref(__ix), ctypes.byref(__beta), ctypes.byref(__y), ctypes.byref(__iy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegemv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_sparsemv2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsemv2.restype = ctypes.c_int32
def sparsemv2(s, x, y0, y1):
    pass
    __s = s.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y0):
        raise ValueError("'y0' parameter can't be cast to real_vector")
    __y0 = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y1):
        raise ValueError("'y1' parameter can't be cast to real_vector")
    __y1 = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y0, y0, DT_REAL, X_CREATE)
        x_from_list(__y1, y1, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsemv2(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__x), ctypes.byref(__y0), ctypes.byref(__y1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsemv2'")
        __r__y0 = list_from_x(__y0)
        __r__y1 = list_from_x(__y1)
        return (__r__y0, __r__y1)
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y0)
        x_vector_clear(__y1)


_lib_alglib.alglib_xv2_sparsesmv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsesmv.restype = ctypes.c_int32
def sparsesmv(s, isupper, x, y):
    pass
    __s = s.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsesmv(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__isupper), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsesmv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_sparsevsmv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsevsmv.restype = ctypes.c_int32
def sparsevsmv(s, isupper, x):
    pass
    __result = ctypes.c_double(0)
    __s = s.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsevsmv(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), ctypes.byref(__isupper), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsevsmv'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_sparsemm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsemm.restype = ctypes.c_int32
def sparsemm(s, a, k, b):
    pass
    __s = s.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsemm(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__a), ctypes.byref(__k), ctypes.byref(__b), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsemm'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_sparsemtm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsemtm.restype = ctypes.c_int32
def sparsemtm(s, a, k, b):
    pass
    __s = s.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsemtm(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__a), ctypes.byref(__k), ctypes.byref(__b), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsemtm'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_sparsemm2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsemm2.restype = ctypes.c_int32
def sparsemm2(s, a, k, b0, b1):
    pass
    __s = s.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    if not is_real_matrix(b0):
        raise ValueError("'b0' parameter can't be cast to real_matrix")
    __b0 = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(b1):
        raise ValueError("'b1' parameter can't be cast to real_matrix")
    __b1 = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b0, b0, DT_REAL, X_CREATE)
        x_from_listlist(__b1, b1, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsemm2(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__a), ctypes.byref(__k), ctypes.byref(__b0), ctypes.byref(__b1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsemm2'")
        __r__b0 = listlist_from_x(__b0)
        __r__b1 = listlist_from_x(__b1)
        return (__r__b0, __r__b1)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b0)
        x_matrix_clear(__b1)


_lib_alglib.alglib_xv2_sparsesmm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsesmm.restype = ctypes.c_int32
def sparsesmm(s, isupper, a, k, b):
    pass
    __s = s.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsesmm(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__isupper), ctypes.byref(__a), ctypes.byref(__k), ctypes.byref(__b), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsesmm'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_sparsetrmv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsetrmv.restype = ctypes.c_int32
def sparsetrmv(s, isupper, isunit, optype, x, y):
    pass
    __s = s.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsetrmv(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsetrmv'")
        __r__x = list_from_x(__x)
        __r__y = list_from_x(__y)
        return (__r__x, __r__y)
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_sparsetrsv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsetrsv.restype = ctypes.c_int32
def sparsetrsv(s, isupper, isunit, optype, x):
    pass
    __s = s.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsetrsv(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsetrsv'")
        __r__x = list_from_x(__x)
        return __r__x
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_sparseresizematrix.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseresizematrix.restype = ctypes.c_int32
def sparseresizematrix(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseresizematrix(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseresizematrix'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseenumerate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseenumerate.restype = ctypes.c_int32
def sparseenumerate(s, t0, t1):
    pass
    __result = ctypes.c_uint64(0)
    __s = s.ptr
    __t0 = x_int()
    __t0.val = int(t0)
    if __t0.val!=t0:
        raise ValueError("Error while converting 't0' parameter to 'x_int'")
    __t1 = x_int()
    __t1.val = int(t1)
    if __t1.val!=t1:
        raise ValueError("Error while converting 't1' parameter to 'x_int'")
    __i = x_int()
    __i.val = 0
    __j = x_int()
    __j.val = 0
    __v = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseenumerate(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), ctypes.byref(__t0), ctypes.byref(__t1), ctypes.byref(__i), ctypes.byref(__j), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseenumerate'")
        __r__result = __result.value!=0
        __r__t0 = __t0.val
        __r__t1 = __t1.val
        __r__i = __i.val
        __r__j = __j.val
        __r__v = __v.value
        return (__r__result, __r__t0, __r__t1, __r__i, __r__j, __r__v)
    finally:
        pass


_lib_alglib.alglib_xv2_sparserewriteexisting.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparserewriteexisting.restype = ctypes.c_int32
def sparserewriteexisting(s, i, j, v):
    pass
    __result = ctypes.c_uint64(0)
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __j = x_int()
    __j.val = int(j)
    if __j.val!=j:
        raise ValueError("Error while converting 'j' parameter to 'x_int'")
    __v = ctypes.c_double(v)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparserewriteexisting(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), ctypes.byref(__i), ctypes.byref(__j), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparserewriteexisting'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetrow.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetrow.restype = ctypes.c_int32
def sparsegetrow(s, i, irow):
    pass
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    if not is_real_vector(irow):
        raise ValueError("'irow' parameter can't be cast to real_vector")
    __irow = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__irow, irow, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetrow(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__i), ctypes.byref(__irow), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetrow'")
        __r__irow = list_from_x(__irow)
        return __r__irow
    finally:
        x_vector_clear(__irow)


_lib_alglib.alglib_xv2_sparsegetcompressedrow.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetcompressedrow.restype = ctypes.c_int32
def sparsegetcompressedrow(s, i, colidx, vals):
    pass
    __s = s.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    if not is_int_vector(colidx):
        raise ValueError("'colidx' parameter can't be cast to int_vector")
    __colidx = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(vals):
        raise ValueError("'vals' parameter can't be cast to real_vector")
    __vals = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nzcnt = x_int()
    __nzcnt.val = 0
    try:
        x_from_list(__colidx, colidx, DT_INT, X_CREATE)
        x_from_list(__vals, vals, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetcompressedrow(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__i), ctypes.byref(__colidx), ctypes.byref(__vals), ctypes.byref(__nzcnt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetcompressedrow'")
        __r__colidx = list_from_x(__colidx)
        __r__vals = list_from_x(__vals)
        __r__nzcnt = __nzcnt.val
        return (__r__colidx, __r__vals, __r__nzcnt)
    finally:
        x_vector_clear(__colidx)
        x_vector_clear(__vals)


_lib_alglib.alglib_xv2_sparsetransposesks.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsetransposesks.restype = ctypes.c_int32
def sparsetransposesks(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsetransposesks(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsetransposesks'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsetransposecrs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsetransposecrs.restype = ctypes.c_int32
def sparsetransposecrs(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsetransposecrs(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsetransposecrs'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytransposecrs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytransposecrs.restype = ctypes.c_int32
def sparsecopytransposecrs(s0):
    pass
    __s0 = s0.ptr
    __s1 = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytransposecrs(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytransposecrs'")
        __r__s1 = sparsematrix(__s1)
        return __r__s1
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytransposecrsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytransposecrsbuf.restype = ctypes.c_int32
def sparsecopytransposecrsbuf(s0, s1):
    pass
    __s0 = s0.ptr
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytransposecrsbuf(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytransposecrsbuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseconvertto.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseconvertto.restype = ctypes.c_int32
def sparseconvertto(s0, fmt):
    pass
    __s0 = s0.ptr
    __fmt = x_int()
    __fmt.val = int(fmt)
    if __fmt.val!=fmt:
        raise ValueError("Error while converting 'fmt' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseconvertto(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__fmt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseconvertto'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytobuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytobuf.restype = ctypes.c_int32
def sparsecopytobuf(s0, fmt, s1):
    pass
    __s0 = s0.ptr
    __fmt = x_int()
    __fmt.val = int(fmt)
    if __fmt.val!=fmt:
        raise ValueError("Error while converting 'fmt' parameter to 'x_int'")
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytobuf(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__fmt), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytobuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseconverttohash.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseconverttohash.restype = ctypes.c_int32
def sparseconverttohash(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseconverttohash(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseconverttohash'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytohash.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytohash.restype = ctypes.c_int32
def sparsecopytohash(s0):
    pass
    __s0 = s0.ptr
    __s1 = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytohash(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytohash'")
        __r__s1 = sparsematrix(__s1)
        return __r__s1
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytohashbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytohashbuf.restype = ctypes.c_int32
def sparsecopytohashbuf(s0, s1):
    pass
    __s0 = s0.ptr
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytohashbuf(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytohashbuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseconverttocrs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseconverttocrs.restype = ctypes.c_int32
def sparseconverttocrs(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseconverttocrs(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseconverttocrs'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytocrs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytocrs.restype = ctypes.c_int32
def sparsecopytocrs(s0):
    pass
    __s0 = s0.ptr
    __s1 = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytocrs(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytocrs'")
        __r__s1 = sparsematrix(__s1)
        return __r__s1
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytocrsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytocrsbuf.restype = ctypes.c_int32
def sparsecopytocrsbuf(s0, s1):
    pass
    __s0 = s0.ptr
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytocrsbuf(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytocrsbuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparseconverttosks.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseconverttosks.restype = ctypes.c_int32
def sparseconverttosks(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseconverttosks(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseconverttosks'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytosks.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytosks.restype = ctypes.c_int32
def sparsecopytosks(s0):
    pass
    __s0 = s0.ptr
    __s1 = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytosks(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytosks'")
        __r__s1 = sparsematrix(__s1)
        return __r__s1
    finally:
        pass


_lib_alglib.alglib_xv2_sparsecopytosksbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecopytosksbuf.restype = ctypes.c_int32
def sparsecopytosksbuf(s0, s1):
    pass
    __s0 = s0.ptr
    __s1 = s1.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecopytosksbuf(ctypes.byref(_error_msg), ctypes.byref(__s0), ctypes.byref(__s1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecopytosksbuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetmatrixtype.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetmatrixtype.restype = ctypes.c_int32
def sparsegetmatrixtype(s):
    pass
    __result = x_int()
    __result.val = 0
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetmatrixtype(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetmatrixtype'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparseishash.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseishash.restype = ctypes.c_int32
def sparseishash(s):
    pass
    __result = ctypes.c_uint64(0)
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseishash(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseishash'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparseiscrs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseiscrs.restype = ctypes.c_int32
def sparseiscrs(s):
    pass
    __result = ctypes.c_uint64(0)
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseiscrs(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseiscrs'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparseissks.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparseissks.restype = ctypes.c_int32
def sparseissks(s):
    pass
    __result = ctypes.c_uint64(0)
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparseissks(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparseissks'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsefree.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsefree.restype = ctypes.c_int32
def sparsefree():
    pass
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsefree(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsefree'")
        __r__s = sparsematrix(__s)
        return __r__s
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetnrows.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetnrows.restype = ctypes.c_int32
def sparsegetnrows(s):
    pass
    __result = x_int()
    __result.val = 0
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetnrows(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetnrows'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetncols.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetncols.restype = ctypes.c_int32
def sparsegetncols(s):
    pass
    __result = x_int()
    __result.val = 0
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetncols(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetncols'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetuppercount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetuppercount.restype = ctypes.c_int32
def sparsegetuppercount(s):
    pass
    __result = x_int()
    __result.val = 0
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetuppercount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetuppercount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_sparsegetlowercount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsegetlowercount.restype = ctypes.c_int32
def sparsegetlowercount(s):
    pass
    __result = x_int()
    __result.val = 0
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsegetlowercount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsegetlowercount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_cmatrixtranspose.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixtranspose.restype = ctypes.c_int32
def cmatrixtranspose(m, n, a, ia, ja, b, ib, jb):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixtranspose(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixtranspose'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rmatrixtranspose.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixtranspose.restype = ctypes.c_int32
def rmatrixtranspose(m, n, a, ia, ja, b, ib, jb):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixtranspose(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixtranspose'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rmatrixenforcesymmetricity.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixenforcesymmetricity.restype = ctypes.c_int32
def rmatrixenforcesymmetricity(a, n, isupper):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixenforcesymmetricity(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixenforcesymmetricity'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixcopy.restype = ctypes.c_int32
def cmatrixcopy(m, n, a, ia, ja, b, ib, jb):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixcopy(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixcopy'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rvectorcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rvectorcopy.restype = ctypes.c_int32
def rvectorcopy(n, a, ia, b, ib):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rvectorcopy(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__b), ctypes.byref(__ib), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rvectorcopy'")
        __r__b = list_from_x(__b)
        return __r__b
    finally:
        x_vector_clear(__a)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_rmatrixcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixcopy.restype = ctypes.c_int32
def rmatrixcopy(m, n, a, ia, ja, b, ib, jb):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixcopy(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixcopy'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rmatrixgencopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixgencopy.restype = ctypes.c_int32
def rmatrixgencopy(m, n, alpha, a, ia, ja, beta, b, ib, jb):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixgencopy(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__beta), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixgencopy'")
        __r__b = listlist_from_x(__b)
        return __r__b
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rmatrixger.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixger.restype = ctypes.c_int32
def rmatrixger(m, n, a, ia, ja, alpha, u, iu, v, iv):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_real_vector(u):
        raise ValueError("'u' parameter can't be cast to real_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iu = x_int()
    __iu.val = int(iu)
    if __iu.val!=iu:
        raise ValueError("Error while converting 'iu' parameter to 'x_int'")
    if not is_real_vector(v):
        raise ValueError("'v' parameter can't be cast to real_vector")
    __v = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iv = x_int()
    __iv.val = int(iv)
    if __iv.val!=iv:
        raise ValueError("Error while converting 'iv' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__u, u, DT_REAL, X_CREATE)
        x_from_list(__v, v, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixger(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__alpha), ctypes.byref(__u), ctypes.byref(__iu), ctypes.byref(__v), ctypes.byref(__iv), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixger'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__u)
        x_vector_clear(__v)


_lib_alglib.alglib_xv2_cmatrixrank1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrank1.restype = ctypes.c_int32
def cmatrixrank1(m, n, a, ia, ja, u, iu, v, iv):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    if not is_complex_vector(u):
        raise ValueError("'u' parameter can't be cast to complex_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iu = x_int()
    __iu.val = int(iu)
    if __iu.val!=iu:
        raise ValueError("Error while converting 'iu' parameter to 'x_int'")
    if not is_complex_vector(v):
        raise ValueError("'v' parameter can't be cast to complex_vector")
    __v = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iv = x_int()
    __iv.val = int(iv)
    if __iv.val!=iv:
        raise ValueError("Error while converting 'iv' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__u, u, DT_COMPLEX, X_CREATE)
        x_from_list(__v, v, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrank1(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__u), ctypes.byref(__iu), ctypes.byref(__v), ctypes.byref(__iv), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrank1'")
        __r__a = listlist_from_x(__a)
        __r__u = list_from_x(__u)
        __r__v = list_from_x(__v)
        return (__r__a, __r__u, __r__v)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__u)
        x_vector_clear(__v)


_lib_alglib.alglib_xv2_rmatrixrank1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrank1.restype = ctypes.c_int32
def rmatrixrank1(m, n, a, ia, ja, u, iu, v, iv):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    if not is_real_vector(u):
        raise ValueError("'u' parameter can't be cast to real_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iu = x_int()
    __iu.val = int(iu)
    if __iu.val!=iu:
        raise ValueError("Error while converting 'iu' parameter to 'x_int'")
    if not is_real_vector(v):
        raise ValueError("'v' parameter can't be cast to real_vector")
    __v = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iv = x_int()
    __iv.val = int(iv)
    if __iv.val!=iv:
        raise ValueError("Error while converting 'iv' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__u, u, DT_REAL, X_CREATE)
        x_from_list(__v, v, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrank1(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__u), ctypes.byref(__iu), ctypes.byref(__v), ctypes.byref(__iv), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrank1'")
        __r__a = listlist_from_x(__a)
        __r__u = list_from_x(__u)
        __r__v = list_from_x(__v)
        return (__r__a, __r__u, __r__v)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__u)
        x_vector_clear(__v)


_lib_alglib.alglib_xv2_rmatrixgemv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixgemv.restype = ctypes.c_int32
def rmatrixgemv(m, n, alpha, a, ia, ja, opa, x, ix, beta, y, iy):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __opa = x_int()
    __opa.val = int(opa)
    if __opa.val!=opa:
        raise ValueError("Error while converting 'opa' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iy = x_int()
    __iy.val = int(iy)
    if __iy.val!=iy:
        raise ValueError("Error while converting 'iy' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixgemv(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__opa), ctypes.byref(__x), ctypes.byref(__ix), ctypes.byref(__beta), ctypes.byref(__y), ctypes.byref(__iy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixgemv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_cmatrixmv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixmv.restype = ctypes.c_int32
def cmatrixmv(m, n, a, ia, ja, opa, x, ix, y, iy):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __opa = x_int()
    __opa.val = int(opa)
    if __opa.val!=opa:
        raise ValueError("Error while converting 'opa' parameter to 'x_int'")
    if not is_complex_vector(x):
        raise ValueError("'x' parameter can't be cast to complex_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    if not is_complex_vector(y):
        raise ValueError("'y' parameter can't be cast to complex_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iy = x_int()
    __iy.val = int(iy)
    if __iy.val!=iy:
        raise ValueError("Error while converting 'iy' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__x, x, DT_COMPLEX, X_CREATE)
        x_from_list(__y, y, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixmv(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__opa), ctypes.byref(__x), ctypes.byref(__ix), ctypes.byref(__y), ctypes.byref(__iy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixmv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_rmatrixmv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixmv.restype = ctypes.c_int32
def rmatrixmv(m, n, a, ia, ja, opa, x, ix, y, iy):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __opa = x_int()
    __opa.val = int(opa)
    if __opa.val!=opa:
        raise ValueError("Error while converting 'opa' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iy = x_int()
    __iy.val = int(iy)
    if __iy.val!=iy:
        raise ValueError("Error while converting 'iy' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixmv(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__opa), ctypes.byref(__x), ctypes.byref(__ix), ctypes.byref(__y), ctypes.byref(__iy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixmv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_rmatrixsymv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsymv.restype = ctypes.c_int32
def rmatrixsymv(n, alpha, a, ia, ja, isupper, x, ix, beta, y, iy):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __iy = x_int()
    __iy.val = int(iy)
    if __iy.val!=iy:
        raise ValueError("Error while converting 'iy' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsymv(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__isupper), ctypes.byref(__x), ctypes.byref(__ix), ctypes.byref(__beta), ctypes.byref(__y), ctypes.byref(__iy), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsymv'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_rmatrixsyvmv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsyvmv.restype = ctypes.c_int32
def rmatrixsyvmv(n, a, ia, ja, isupper, x, ix, tmp):
    pass
    __result = ctypes.c_double(0)
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    if not is_real_vector(tmp):
        raise ValueError("'tmp' parameter can't be cast to real_vector")
    __tmp = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__tmp, tmp, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsyvmv(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__isupper), ctypes.byref(__x), ctypes.byref(__ix), ctypes.byref(__tmp), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsyvmv'")
        __r__result = __result.value
        __r__tmp = list_from_x(__tmp)
        return (__r__result, __r__tmp)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__x)
        x_vector_clear(__tmp)


_lib_alglib.alglib_xv2_rmatrixtrsv.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixtrsv.restype = ctypes.c_int32
def rmatrixtrsv(n, a, ia, ja, isupper, isunit, optype, x, ix):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ix = x_int()
    __ix.val = int(ix)
    if __ix.val!=ix:
        raise ValueError("Error while converting 'ix' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixtrsv(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), ctypes.byref(__ix), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixtrsv'")
        __r__x = list_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_cmatrixrighttrsm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrighttrsm.restype = ctypes.c_int32
def cmatrixrighttrsm(m, n, a, i1, j1, isupper, isunit, optype, x, i2, j2):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __j1 = x_int()
    __j1.val = int(j1)
    if __j1.val!=j1:
        raise ValueError("Error while converting 'j1' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_complex_matrix(x):
        raise ValueError("'x' parameter can't be cast to complex_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    __j2 = x_int()
    __j2.val = int(j2)
    if __j2.val!=j2:
        raise ValueError("Error while converting 'j2' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__x, x, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrighttrsm(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__i1), ctypes.byref(__j1), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), ctypes.byref(__i2), ctypes.byref(__j2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrighttrsm'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_cmatrixlefttrsm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlefttrsm.restype = ctypes.c_int32
def cmatrixlefttrsm(m, n, a, i1, j1, isupper, isunit, optype, x, i2, j2):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __j1 = x_int()
    __j1.val = int(j1)
    if __j1.val!=j1:
        raise ValueError("Error while converting 'j1' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_complex_matrix(x):
        raise ValueError("'x' parameter can't be cast to complex_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    __j2 = x_int()
    __j2.val = int(j2)
    if __j2.val!=j2:
        raise ValueError("Error while converting 'j2' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__x, x, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlefttrsm(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__i1), ctypes.byref(__j1), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), ctypes.byref(__i2), ctypes.byref(__j2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlefttrsm'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_rmatrixrighttrsm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrighttrsm.restype = ctypes.c_int32
def rmatrixrighttrsm(m, n, a, i1, j1, isupper, isunit, optype, x, i2, j2):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __j1 = x_int()
    __j1.val = int(j1)
    if __j1.val!=j1:
        raise ValueError("Error while converting 'j1' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    __j2 = x_int()
    __j2.val = int(j2)
    if __j2.val!=j2:
        raise ValueError("Error while converting 'j2' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrighttrsm(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__i1), ctypes.byref(__j1), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), ctypes.byref(__i2), ctypes.byref(__j2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrighttrsm'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_rmatrixlefttrsm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlefttrsm.restype = ctypes.c_int32
def rmatrixlefttrsm(m, n, a, i1, j1, isupper, isunit, optype, x, i2, j2):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __j1 = x_int()
    __j1.val = int(j1)
    if __j1.val!=j1:
        raise ValueError("Error while converting 'j1' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __optype = x_int()
    __optype.val = int(optype)
    if __optype.val!=optype:
        raise ValueError("Error while converting 'optype' parameter to 'x_int'")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    __j2 = x_int()
    __j2.val = int(j2)
    if __j2.val!=j2:
        raise ValueError("Error while converting 'j2' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlefttrsm(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__a), ctypes.byref(__i1), ctypes.byref(__j1), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__optype), ctypes.byref(__x), ctypes.byref(__i2), ctypes.byref(__j2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlefttrsm'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_cmatrixherk.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixherk.restype = ctypes.c_int32
def cmatrixherk(n, k, alpha, a, ia, ja, optypea, beta, c, ic, jc, isupper):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __optypea = x_int()
    __optypea.val = int(optypea)
    if __optypea.val!=optypea:
        raise ValueError("Error while converting 'optypea' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_complex_matrix(c):
        raise ValueError("'c' parameter can't be cast to complex_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ic = x_int()
    __ic.val = int(ic)
    if __ic.val!=ic:
        raise ValueError("Error while converting 'ic' parameter to 'x_int'")
    __jc = x_int()
    __jc.val = int(jc)
    if __jc.val!=jc:
        raise ValueError("Error while converting 'jc' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__c, c, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixherk(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__optypea), ctypes.byref(__beta), ctypes.byref(__c), ctypes.byref(__ic), ctypes.byref(__jc), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixherk'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_rmatrixsyrk.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsyrk.restype = ctypes.c_int32
def rmatrixsyrk(n, k, alpha, a, ia, ja, optypea, beta, c, ic, jc, isupper):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __optypea = x_int()
    __optypea.val = int(optypea)
    if __optypea.val!=optypea:
        raise ValueError("Error while converting 'optypea' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ic = x_int()
    __ic.val = int(ic)
    if __ic.val!=ic:
        raise ValueError("Error while converting 'ic' parameter to 'x_int'")
    __jc = x_int()
    __jc.val = int(jc)
    if __jc.val!=jc:
        raise ValueError("Error while converting 'jc' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsyrk(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__optypea), ctypes.byref(__beta), ctypes.byref(__c), ctypes.byref(__ic), ctypes.byref(__jc), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsyrk'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_cmatrixgemm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixgemm.restype = ctypes.c_int32
def cmatrixgemm(m, n, k, alpha, a, ia, ja, optypea, b, ib, jb, optypeb, beta, c, ic, jc):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __tmp__val = complex(alpha)
    __alpha = x_complex(x=__tmp__val.real, y=__tmp__val.imag)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __optypea = x_int()
    __optypea.val = int(optypea)
    if __optypea.val!=optypea:
        raise ValueError("Error while converting 'optypea' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    __optypeb = x_int()
    __optypeb.val = int(optypeb)
    if __optypeb.val!=optypeb:
        raise ValueError("Error while converting 'optypeb' parameter to 'x_int'")
    __tmp__val = complex(beta)
    __beta = x_complex(x=__tmp__val.real, y=__tmp__val.imag)
    if not is_complex_matrix(c):
        raise ValueError("'c' parameter can't be cast to complex_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ic = x_int()
    __ic.val = int(ic)
    if __ic.val!=ic:
        raise ValueError("Error while converting 'ic' parameter to 'x_int'")
    __jc = x_int()
    __jc.val = int(jc)
    if __jc.val!=jc:
        raise ValueError("Error while converting 'jc' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        x_from_listlist(__c, c, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixgemm(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__optypea), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), ctypes.byref(__optypeb), ctypes.byref(__beta), ctypes.byref(__c), ctypes.byref(__ic), ctypes.byref(__jc), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixgemm'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_rmatrixgemm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixgemm.restype = ctypes.c_int32
def rmatrixgemm(m, n, k, alpha, a, ia, ja, optypea, b, ib, jb, optypeb, beta, c, ic, jc):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __optypea = x_int()
    __optypea.val = int(optypea)
    if __optypea.val!=optypea:
        raise ValueError("Error while converting 'optypea' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ib = x_int()
    __ib.val = int(ib)
    if __ib.val!=ib:
        raise ValueError("Error while converting 'ib' parameter to 'x_int'")
    __jb = x_int()
    __jb.val = int(jb)
    if __jb.val!=jb:
        raise ValueError("Error while converting 'jb' parameter to 'x_int'")
    __optypeb = x_int()
    __optypeb.val = int(optypeb)
    if __optypeb.val!=optypeb:
        raise ValueError("Error while converting 'optypeb' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ic = x_int()
    __ic.val = int(ic)
    if __ic.val!=ic:
        raise ValueError("Error while converting 'ic' parameter to 'x_int'")
    __jc = x_int()
    __jc.val = int(jc)
    if __jc.val!=jc:
        raise ValueError("Error while converting 'jc' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixgemm(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__optypea), ctypes.byref(__b), ctypes.byref(__ib), ctypes.byref(__jb), ctypes.byref(__optypeb), ctypes.byref(__beta), ctypes.byref(__c), ctypes.byref(__ic), ctypes.byref(__jc), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixgemm'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_cmatrixsyrk.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixsyrk.restype = ctypes.c_int32
def cmatrixsyrk(n, k, alpha, a, ia, ja, optypea, beta, c, ic, jc, isupper):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ia = x_int()
    __ia.val = int(ia)
    if __ia.val!=ia:
        raise ValueError("Error while converting 'ia' parameter to 'x_int'")
    __ja = x_int()
    __ja.val = int(ja)
    if __ja.val!=ja:
        raise ValueError("Error while converting 'ja' parameter to 'x_int'")
    __optypea = x_int()
    __optypea.val = int(optypea)
    if __optypea.val!=optypea:
        raise ValueError("Error while converting 'optypea' parameter to 'x_int'")
    __beta = ctypes.c_double(beta)
    if not is_complex_matrix(c):
        raise ValueError("'c' parameter can't be cast to complex_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ic = x_int()
    __ic.val = int(ic)
    if __ic.val!=ic:
        raise ValueError("Error while converting 'ic' parameter to 'x_int'")
    __jc = x_int()
    __jc.val = int(jc)
    if __jc.val!=jc:
        raise ValueError("Error while converting 'jc' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__c, c, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixsyrk(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__alpha), ctypes.byref(__a), ctypes.byref(__ia), ctypes.byref(__ja), ctypes.byref(__optypea), ctypes.byref(__beta), ctypes.byref(__c), ctypes.byref(__ic), ctypes.byref(__jc), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixsyrk'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_rmatrixrndorthogonal.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrndorthogonal.restype = ctypes.c_int32
def rmatrixrndorthogonal(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrndorthogonal(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrndorthogonal'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixrndcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrndcond.restype = ctypes.c_int32
def rmatrixrndcond(n, c):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __c = ctypes.c_double(c)
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrndcond(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__c), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrndcond'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixrndorthogonal.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrndorthogonal.restype = ctypes.c_int32
def cmatrixrndorthogonal(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrndorthogonal(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrndorthogonal'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixrndcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrndcond.restype = ctypes.c_int32
def cmatrixrndcond(n, c):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __c = ctypes.c_double(c)
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrndcond(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__c), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrndcond'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_smatrixrndcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixrndcond.restype = ctypes.c_int32
def smatrixrndcond(n, c):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __c = ctypes.c_double(c)
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixrndcond(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__c), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixrndcond'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_spdmatrixrndcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixrndcond.restype = ctypes.c_int32
def spdmatrixrndcond(n, c):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __c = ctypes.c_double(c)
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixrndcond(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__c), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixrndcond'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_hmatrixrndcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixrndcond.restype = ctypes.c_int32
def hmatrixrndcond(n, c):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __c = ctypes.c_double(c)
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixrndcond(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__c), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixrndcond'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_hpdmatrixrndcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixrndcond.restype = ctypes.c_int32
def hpdmatrixrndcond(n, c):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __c = ctypes.c_double(c)
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixrndcond(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__c), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixrndcond'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixrndorthogonalfromtheright.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrndorthogonalfromtheright.restype = ctypes.c_int32
def rmatrixrndorthogonalfromtheright(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrndorthogonalfromtheright(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrndorthogonalfromtheright'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixrndorthogonalfromtheleft.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrndorthogonalfromtheleft.restype = ctypes.c_int32
def rmatrixrndorthogonalfromtheleft(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrndorthogonalfromtheleft(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrndorthogonalfromtheleft'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixrndorthogonalfromtheright.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrndorthogonalfromtheright.restype = ctypes.c_int32
def cmatrixrndorthogonalfromtheright(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrndorthogonalfromtheright(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrndorthogonalfromtheright'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixrndorthogonalfromtheleft.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrndorthogonalfromtheleft.restype = ctypes.c_int32
def cmatrixrndorthogonalfromtheleft(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrndorthogonalfromtheleft(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrndorthogonalfromtheleft'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_smatrixrndmultiply.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixrndmultiply.restype = ctypes.c_int32
def smatrixrndmultiply(a, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixrndmultiply(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixrndmultiply'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_hmatrixrndmultiply.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixrndmultiply.restype = ctypes.c_int32
def hmatrixrndmultiply(a, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixrndmultiply(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixrndmultiply'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixlu.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlu.restype = ctypes.c_int32
def rmatrixlu(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __pivots = x_vector(cnt=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlu(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__pivots), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlu'")
        __r__a = listlist_from_x(__a)
        __r__pivots = list_from_x(__pivots)
        return (__r__a, __r__pivots)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__pivots)


_lib_alglib.alglib_xv2_cmatrixlu.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlu.restype = ctypes.c_int32
def cmatrixlu(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __pivots = x_vector(cnt=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlu(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__pivots), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlu'")
        __r__a = listlist_from_x(__a)
        __r__pivots = list_from_x(__pivots)
        return (__r__a, __r__pivots)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__pivots)


_lib_alglib.alglib_xv2_hpdmatrixcholesky.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholesky.restype = ctypes.c_int32
def hpdmatrixcholesky(a, n, isupper):
    pass
    __result = ctypes.c_uint64(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholesky(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholesky'")
        __r__result = __result.value!=0
        __r__a = listlist_from_x(__a)
        return (__r__result, __r__a)
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_spdmatrixcholesky.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholesky.restype = ctypes.c_int32
def spdmatrixcholesky(a, n, isupper):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholesky(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholesky'")
        __r__result = __result.value!=0
        __r__a = listlist_from_x(__a)
        return (__r__result, __r__a)
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_spdmatrixcholeskyupdateadd1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskyupdateadd1.restype = ctypes.c_int32
def spdmatrixcholeskyupdateadd1(a, n, isupper, u):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(u):
        raise ValueError("'u' parameter can't be cast to real_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__u, u, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskyupdateadd1(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__u), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskyupdateadd1'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__u)


_lib_alglib.alglib_xv2_spdmatrixcholeskyupdatefix.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskyupdatefix.restype = ctypes.c_int32
def spdmatrixcholeskyupdatefix(a, n, isupper, fix):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_bool_vector(fix):
        raise ValueError("'fix' parameter can't be cast to bool_vector")
    __fix = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__fix, fix, DT_BOOL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskyupdatefix(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__fix), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskyupdatefix'")
        __r__a = listlist_from_x(__a)
        return __r__a
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__fix)


_lib_alglib.alglib_xv2_spdmatrixcholeskyupdateadd1buf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskyupdateadd1buf.restype = ctypes.c_int32
def spdmatrixcholeskyupdateadd1buf(a, n, isupper, u, bufr):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(u):
        raise ValueError("'u' parameter can't be cast to real_vector")
    __u = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bufr):
        raise ValueError("'bufr' parameter can't be cast to real_vector")
    __bufr = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__u, u, DT_REAL, X_CREATE)
        x_from_list(__bufr, bufr, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskyupdateadd1buf(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__u), ctypes.byref(__bufr), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskyupdateadd1buf'")
        __r__a = listlist_from_x(__a)
        __r__bufr = list_from_x(__bufr)
        return (__r__a, __r__bufr)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__u)
        x_vector_clear(__bufr)


_lib_alglib.alglib_xv2_spdmatrixcholeskyupdatefixbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskyupdatefixbuf.restype = ctypes.c_int32
def spdmatrixcholeskyupdatefixbuf(a, n, isupper, fix, bufr):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_bool_vector(fix):
        raise ValueError("'fix' parameter can't be cast to bool_vector")
    __fix = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bufr):
        raise ValueError("'bufr' parameter can't be cast to real_vector")
    __bufr = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__fix, fix, DT_BOOL, X_CREATE)
        x_from_list(__bufr, bufr, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskyupdatefixbuf(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__fix), ctypes.byref(__bufr), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskyupdatefixbuf'")
        __r__a = listlist_from_x(__a)
        __r__bufr = list_from_x(__bufr)
        return (__r__a, __r__bufr)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__fix)
        x_vector_clear(__bufr)


_lib_alglib.alglib_xv2_sparselu.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparselu.restype = ctypes.c_int32
def sparselu(a, pivottype):
    pass
    __result = ctypes.c_uint64(0)
    __a = a.ptr
    __pivottype = x_int()
    __pivottype.val = int(pivottype)
    if __pivottype.val!=pivottype:
        raise ValueError("Error while converting 'pivottype' parameter to 'x_int'")
    __p = x_vector(cnt=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __q = x_vector(cnt=0,datatype=DT_INT,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparselu(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__pivottype), ctypes.byref(__p), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparselu'")
        __r__result = __result.value!=0
        __r__p = list_from_x(__p)
        __r__q = list_from_x(__q)
        return (__r__result, __r__p, __r__q)
    finally:
        x_vector_clear(__p)
        x_vector_clear(__q)


_lib_alglib.alglib_xv2_sparsecholeskyskyline.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sparsecholeskyskyline.restype = ctypes.c_int32
def sparsecholeskyskyline(a, n, isupper):
    pass
    __result = ctypes.c_uint64(0)
    __a = a.ptr
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sparsecholeskyskyline(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sparsecholeskyskyline'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_rmatrixrcond1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrcond1.restype = ctypes.c_int32
def rmatrixrcond1(a, n):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrcond1(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrcond1'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixrcondinf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixrcondinf.restype = ctypes.c_int32
def rmatrixrcondinf(a, n):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixrcondinf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixrcondinf'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_spdmatrixrcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixrcond.restype = ctypes.c_int32
def spdmatrixrcond(a, n, isupper):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixrcond(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixrcond'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixtrrcond1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixtrrcond1.restype = ctypes.c_int32
def rmatrixtrrcond1(a, n, isupper, isunit):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixtrrcond1(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isunit), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixtrrcond1'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixtrrcondinf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixtrrcondinf.restype = ctypes.c_int32
def rmatrixtrrcondinf(a, n, isupper, isunit):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixtrrcondinf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isunit), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixtrrcondinf'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_hpdmatrixrcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixrcond.restype = ctypes.c_int32
def hpdmatrixrcond(a, n, isupper):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixrcond(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixrcond'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixrcond1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrcond1.restype = ctypes.c_int32
def cmatrixrcond1(a, n):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrcond1(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrcond1'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixrcondinf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixrcondinf.restype = ctypes.c_int32
def cmatrixrcondinf(a, n):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixrcondinf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixrcondinf'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_rmatrixlurcond1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlurcond1.restype = ctypes.c_int32
def rmatrixlurcond1(lua, n):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlurcond1(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lua), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlurcond1'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__lua)


_lib_alglib.alglib_xv2_rmatrixlurcondinf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlurcondinf.restype = ctypes.c_int32
def rmatrixlurcondinf(lua, n):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlurcondinf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lua), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlurcondinf'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__lua)


_lib_alglib.alglib_xv2_spdmatrixcholeskyrcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskyrcond.restype = ctypes.c_int32
def spdmatrixcholeskyrcond(a, n, isupper):
    pass
    __result = ctypes.c_double(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskyrcond(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskyrcond'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_hpdmatrixcholeskyrcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholeskyrcond.restype = ctypes.c_int32
def hpdmatrixcholeskyrcond(a, n, isupper):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholeskyrcond(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholeskyrcond'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixlurcond1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlurcond1.restype = ctypes.c_int32
def cmatrixlurcond1(lua, n):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlurcond1(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lua), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlurcond1'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__lua)


_lib_alglib.alglib_xv2_cmatrixlurcondinf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlurcondinf.restype = ctypes.c_int32
def cmatrixlurcondinf(lua, n):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlurcondinf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lua), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlurcondinf'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__lua)


_lib_alglib.alglib_xv2_cmatrixtrrcond1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixtrrcond1.restype = ctypes.c_int32
def cmatrixtrrcond1(a, n, isupper, isunit):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixtrrcond1(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isunit), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixtrrcond1'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_cmatrixtrrcondinf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixtrrcondinf.restype = ctypes.c_int32
def cmatrixtrrcondinf(a, n, isupper, isunit):
    pass
    __result = ctypes.c_double(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixtrrcondinf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isunit), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixtrrcondinf'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__a)




class x_matinvreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("r1", ctypes.c_double),
        ("rinf", ctypes.c_double)
        ]




class matinvreport(object):
    def __init__(self):
        self.r1 = 0
        self.rinf = 0


def x_matinvreport_zero_fields(x):
    x.r1 = 0
    x.rinf = 0
    return




def x_matinvreport_clear(x):
    x_matinvreport_zero_fields(x)
    return




def x_from_matinvreport(x,v):
    x.r1 = float(v.r1)
    x.rinf = float(v.rinf)
    return




def matinvreport_from_x(x):
    r = matinvreport()
    r.r1 = x.r1
    r.rinf = x.rinf
    return r


_lib_alglib.alglib_xv2_rmatrixluinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixluinverse.restype = ctypes.c_int32
def rmatrixluinverse(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        a,pivots,n = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        a,pivots = functionargs
        if safe_cols("'rmatrixluinverse': incorrect parameters",a)!=safe_rows("'rmatrixluinverse': incorrect parameters",a) or safe_cols("'rmatrixluinverse': incorrect parameters",a)!=safe_len("'rmatrixluinverse': incorrect parameters",pivots):
            raise RuntimeError("Error while calling 'rmatrixluinverse': looks like one of arguments has wrong size")
        n = safe_cols("'rmatrixluinverse': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'rmatrixluinverse': function must have 2 or 3 parameters")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(pivots):
        raise ValueError("'pivots' parameter can't be cast to int_vector")
    __pivots = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__pivots, pivots, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixluinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__pivots), ctypes.byref(__n), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixluinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__pivots)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_rmatrixinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixinverse.restype = ctypes.c_int32
def rmatrixinverse(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        a,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        a, = functionargs
        if safe_cols("'rmatrixinverse': incorrect parameters",a)!=safe_rows("'rmatrixinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'rmatrixinverse': looks like one of arguments has wrong size")
        n = safe_cols("'rmatrixinverse': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'rmatrixinverse': function must have 1 or 2 parameters")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_cmatrixluinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixluinverse.restype = ctypes.c_int32
def cmatrixluinverse(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        a,pivots,n = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        a,pivots = functionargs
        if safe_cols("'cmatrixluinverse': incorrect parameters",a)!=safe_rows("'cmatrixluinverse': incorrect parameters",a) or safe_cols("'cmatrixluinverse': incorrect parameters",a)!=safe_len("'cmatrixluinverse': incorrect parameters",pivots):
            raise RuntimeError("Error while calling 'cmatrixluinverse': looks like one of arguments has wrong size")
        n = safe_cols("'cmatrixluinverse': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'cmatrixluinverse': function must have 2 or 3 parameters")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(pivots):
        raise ValueError("'pivots' parameter can't be cast to int_vector")
    __pivots = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__pivots, pivots, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixluinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__pivots), ctypes.byref(__n), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixluinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__pivots)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_cmatrixinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixinverse.restype = ctypes.c_int32
def cmatrixinverse(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        a,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        a, = functionargs
        if safe_cols("'cmatrixinverse': incorrect parameters",a)!=safe_rows("'cmatrixinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'cmatrixinverse': looks like one of arguments has wrong size")
        n = safe_cols("'cmatrixinverse': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'cmatrixinverse': function must have 1 or 2 parameters")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_spdmatrixcholeskyinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskyinverse.restype = ctypes.c_int32
def spdmatrixcholeskyinverse(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        a,n,isupper = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        a, = functionargs
        if safe_cols("'spdmatrixcholeskyinverse': incorrect parameters",a)!=safe_rows("'spdmatrixcholeskyinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'spdmatrixcholeskyinverse': looks like one of arguments has wrong size")
        n = safe_cols("'spdmatrixcholeskyinverse': incorrect parameters",a)
        isupper = False
    else:
        raise RuntimeError("Error while calling 'spdmatrixcholeskyinverse': function must have 1 or 3 parameters")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskyinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskyinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_spdmatrixinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixinverse.restype = ctypes.c_int32
def spdmatrixinverse(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        a,n,isupper = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        a, = functionargs
        if safe_cols("'spdmatrixinverse': incorrect parameters",a)!=safe_rows("'spdmatrixinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'spdmatrixinverse': looks like one of arguments has wrong size")
        n = safe_cols("'spdmatrixinverse': incorrect parameters",a)
        isupper = False
    else:
        raise RuntimeError("Error while calling 'spdmatrixinverse': function must have 1 or 3 parameters")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to symmetric")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        if __friendly_form:
            if not x_is_symmetric(__a):
                raise ValueError("'a' parameter is not symmetric matrix")
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixinverse'")
        if __friendly_form:
            if not x_force_symmetric(__a):
                raise RuntimeError("Internal error while forcing symmetricity of 'a' parameter")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_hpdmatrixcholeskyinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholeskyinverse.restype = ctypes.c_int32
def hpdmatrixcholeskyinverse(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        a,n,isupper = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        a, = functionargs
        if safe_cols("'hpdmatrixcholeskyinverse': incorrect parameters",a)!=safe_rows("'hpdmatrixcholeskyinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'hpdmatrixcholeskyinverse': looks like one of arguments has wrong size")
        n = safe_cols("'hpdmatrixcholeskyinverse': incorrect parameters",a)
        isupper = False
    else:
        raise RuntimeError("Error while calling 'hpdmatrixcholeskyinverse': function must have 1 or 3 parameters")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholeskyinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholeskyinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_hpdmatrixinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixinverse.restype = ctypes.c_int32
def hpdmatrixinverse(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        a,n,isupper = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        a, = functionargs
        if safe_cols("'hpdmatrixinverse': incorrect parameters",a)!=safe_rows("'hpdmatrixinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'hpdmatrixinverse': looks like one of arguments has wrong size")
        n = safe_cols("'hpdmatrixinverse': incorrect parameters",a)
        isupper = False
    else:
        raise RuntimeError("Error while calling 'hpdmatrixinverse': function must have 1 or 3 parameters")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to hermitian")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        if __friendly_form:
            if not x_is_hermitian(__a):
                raise ValueError("'a' parameter is not Hermitian matrix")
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixinverse'")
        if __friendly_form:
            if not x_force_hermitian(__a):
                raise RuntimeError("Internal error while forcing Hermitian properties of 'a' parameter")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_rmatrixtrinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixtrinverse.restype = ctypes.c_int32
def rmatrixtrinverse(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        a,n,isupper,isunit = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        a,isupper = functionargs
        if safe_cols("'rmatrixtrinverse': incorrect parameters",a)!=safe_rows("'rmatrixtrinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'rmatrixtrinverse': looks like one of arguments has wrong size")
        n = safe_cols("'rmatrixtrinverse': incorrect parameters",a)
        isunit = False
    else:
        raise RuntimeError("Error while calling 'rmatrixtrinverse': function must have 2 or 4 parameters")
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixtrinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixtrinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_cmatrixtrinverse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixtrinverse.restype = ctypes.c_int32
def cmatrixtrinverse(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        a,n,isupper,isunit = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        a,isupper = functionargs
        if safe_cols("'cmatrixtrinverse': incorrect parameters",a)!=safe_rows("'cmatrixtrinverse': incorrect parameters",a):
            raise RuntimeError("Error while calling 'cmatrixtrinverse': looks like one of arguments has wrong size")
        n = safe_cols("'cmatrixtrinverse': incorrect parameters",a)
        isunit = False
    else:
        raise RuntimeError("Error while calling 'cmatrixtrinverse': function must have 2 or 4 parameters")
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isunit = ctypes.c_uint64(isunit)
    if __isunit.value!=0:
        __isunit = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_matinvreport()
    x_matinvreport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixtrinverse(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isunit), ctypes.byref(__info), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixtrinverse'")
        __r__a = listlist_from_x(__a)
        __r__info = __info.val
        __r__rep = matinvreport_from_x(__rep)
        return (__r__a, __r__info, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_matinvreport_clear(__rep)


_lib_alglib.alglib_xv2_rmatrixqr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixqr.restype = ctypes.c_int32
def rmatrixqr(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __tau = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixqr(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixqr'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        return (__r__a, __r__tau)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)


_lib_alglib.alglib_xv2_rmatrixlq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlq.restype = ctypes.c_int32
def rmatrixlq(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __tau = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlq'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        return (__r__a, __r__tau)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)


_lib_alglib.alglib_xv2_cmatrixqr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixqr.restype = ctypes.c_int32
def cmatrixqr(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __tau = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixqr(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixqr'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        return (__r__a, __r__tau)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)


_lib_alglib.alglib_xv2_cmatrixlq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlq.restype = ctypes.c_int32
def cmatrixlq(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __tau = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlq'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        return (__r__a, __r__tau)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)


_lib_alglib.alglib_xv2_rmatrixqrunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixqrunpackq.restype = ctypes.c_int32
def rmatrixqrunpackq(a, m, n, tau, qcolumns):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(tau):
        raise ValueError("'tau' parameter can't be cast to real_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __qcolumns = x_int()
    __qcolumns.val = int(qcolumns)
    if __qcolumns.val!=qcolumns:
        raise ValueError("Error while converting 'qcolumns' parameter to 'x_int'")
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__tau, tau, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixqrunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), ctypes.byref(__qcolumns), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixqrunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_rmatrixqrunpackr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixqrunpackr.restype = ctypes.c_int32
def rmatrixqrunpackr(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __r = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixqrunpackr(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__r), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixqrunpackr'")
        __r__r = listlist_from_x(__r)
        return __r__r
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__r)


_lib_alglib.alglib_xv2_rmatrixlqunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlqunpackq.restype = ctypes.c_int32
def rmatrixlqunpackq(a, m, n, tau, qrows):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(tau):
        raise ValueError("'tau' parameter can't be cast to real_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __qrows = x_int()
    __qrows.val = int(qrows)
    if __qrows.val!=qrows:
        raise ValueError("Error while converting 'qrows' parameter to 'x_int'")
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__tau, tau, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlqunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), ctypes.byref(__qrows), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlqunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_rmatrixlqunpackl.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlqunpackl.restype = ctypes.c_int32
def rmatrixlqunpackl(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __l = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlqunpackl(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__l), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlqunpackl'")
        __r__l = listlist_from_x(__l)
        return __r__l
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__l)


_lib_alglib.alglib_xv2_cmatrixqrunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixqrunpackq.restype = ctypes.c_int32
def cmatrixqrunpackq(a, m, n, tau, qcolumns):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(tau):
        raise ValueError("'tau' parameter can't be cast to complex_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __qcolumns = x_int()
    __qcolumns.val = int(qcolumns)
    if __qcolumns.val!=qcolumns:
        raise ValueError("Error while converting 'qcolumns' parameter to 'x_int'")
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__tau, tau, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixqrunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), ctypes.byref(__qcolumns), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixqrunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_cmatrixqrunpackr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixqrunpackr.restype = ctypes.c_int32
def cmatrixqrunpackr(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __r = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixqrunpackr(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__r), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixqrunpackr'")
        __r__r = listlist_from_x(__r)
        return __r__r
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__r)


_lib_alglib.alglib_xv2_cmatrixlqunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlqunpackq.restype = ctypes.c_int32
def cmatrixlqunpackq(a, m, n, tau, qrows):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(tau):
        raise ValueError("'tau' parameter can't be cast to complex_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __qrows = x_int()
    __qrows.val = int(qrows)
    if __qrows.val!=qrows:
        raise ValueError("Error while converting 'qrows' parameter to 'x_int'")
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__tau, tau, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlqunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tau), ctypes.byref(__qrows), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlqunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_cmatrixlqunpackl.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlqunpackl.restype = ctypes.c_int32
def cmatrixlqunpackl(a, m, n):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __l = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlqunpackl(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__l), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlqunpackl'")
        __r__l = listlist_from_x(__l)
        return __r__l
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__l)


_lib_alglib.alglib_xv2_rmatrixbd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbd.restype = ctypes.c_int32
def rmatrixbd(a, m, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __tauq = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __taup = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbd(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tauq), ctypes.byref(__taup), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbd'")
        __r__a = listlist_from_x(__a)
        __r__tauq = list_from_x(__tauq)
        __r__taup = list_from_x(__taup)
        return (__r__a, __r__tauq, __r__taup)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tauq)
        x_vector_clear(__taup)


_lib_alglib.alglib_xv2_rmatrixbdunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbdunpackq.restype = ctypes.c_int32
def rmatrixbdunpackq(qp, m, n, tauq, qcolumns):
    pass
    if not is_real_matrix(qp):
        raise ValueError("'qp' parameter can't be cast to real_matrix")
    __qp = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(tauq):
        raise ValueError("'tauq' parameter can't be cast to real_vector")
    __tauq = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __qcolumns = x_int()
    __qcolumns.val = int(qcolumns)
    if __qcolumns.val!=qcolumns:
        raise ValueError("Error while converting 'qcolumns' parameter to 'x_int'")
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__qp, qp, DT_REAL, X_CREATE)
        x_from_list(__tauq, tauq, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbdunpackq(ctypes.byref(_error_msg), ctypes.byref(__qp), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tauq), ctypes.byref(__qcolumns), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbdunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__qp)
        x_vector_clear(__tauq)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_rmatrixbdmultiplybyq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbdmultiplybyq.restype = ctypes.c_int32
def rmatrixbdmultiplybyq(qp, m, n, tauq, z, zrows, zcolumns, fromtheright, dotranspose):
    pass
    if not is_real_matrix(qp):
        raise ValueError("'qp' parameter can't be cast to real_matrix")
    __qp = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(tauq):
        raise ValueError("'tauq' parameter can't be cast to real_vector")
    __tauq = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(z):
        raise ValueError("'z' parameter can't be cast to real_matrix")
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __zrows = x_int()
    __zrows.val = int(zrows)
    if __zrows.val!=zrows:
        raise ValueError("Error while converting 'zrows' parameter to 'x_int'")
    __zcolumns = x_int()
    __zcolumns.val = int(zcolumns)
    if __zcolumns.val!=zcolumns:
        raise ValueError("Error while converting 'zcolumns' parameter to 'x_int'")
    __fromtheright = ctypes.c_uint64(fromtheright)
    if __fromtheright.value!=0:
        __fromtheright = ctypes.c_uint64(1)
    __dotranspose = ctypes.c_uint64(dotranspose)
    if __dotranspose.value!=0:
        __dotranspose = ctypes.c_uint64(1)
    try:
        x_from_listlist(__qp, qp, DT_REAL, X_CREATE)
        x_from_list(__tauq, tauq, DT_REAL, X_CREATE)
        x_from_listlist(__z, z, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbdmultiplybyq(ctypes.byref(_error_msg), ctypes.byref(__qp), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__tauq), ctypes.byref(__z), ctypes.byref(__zrows), ctypes.byref(__zcolumns), ctypes.byref(__fromtheright), ctypes.byref(__dotranspose), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbdmultiplybyq'")
        __r__z = listlist_from_x(__z)
        return __r__z
    finally:
        x_matrix_clear(__qp)
        x_vector_clear(__tauq)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_rmatrixbdunpackpt.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbdunpackpt.restype = ctypes.c_int32
def rmatrixbdunpackpt(qp, m, n, taup, ptrows):
    pass
    if not is_real_matrix(qp):
        raise ValueError("'qp' parameter can't be cast to real_matrix")
    __qp = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(taup):
        raise ValueError("'taup' parameter can't be cast to real_vector")
    __taup = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ptrows = x_int()
    __ptrows.val = int(ptrows)
    if __ptrows.val!=ptrows:
        raise ValueError("Error while converting 'ptrows' parameter to 'x_int'")
    __pt = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__qp, qp, DT_REAL, X_CREATE)
        x_from_list(__taup, taup, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbdunpackpt(ctypes.byref(_error_msg), ctypes.byref(__qp), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__taup), ctypes.byref(__ptrows), ctypes.byref(__pt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbdunpackpt'")
        __r__pt = listlist_from_x(__pt)
        return __r__pt
    finally:
        x_matrix_clear(__qp)
        x_vector_clear(__taup)
        x_matrix_clear(__pt)


_lib_alglib.alglib_xv2_rmatrixbdmultiplybyp.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbdmultiplybyp.restype = ctypes.c_int32
def rmatrixbdmultiplybyp(qp, m, n, taup, z, zrows, zcolumns, fromtheright, dotranspose):
    pass
    if not is_real_matrix(qp):
        raise ValueError("'qp' parameter can't be cast to real_matrix")
    __qp = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(taup):
        raise ValueError("'taup' parameter can't be cast to real_vector")
    __taup = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(z):
        raise ValueError("'z' parameter can't be cast to real_matrix")
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __zrows = x_int()
    __zrows.val = int(zrows)
    if __zrows.val!=zrows:
        raise ValueError("Error while converting 'zrows' parameter to 'x_int'")
    __zcolumns = x_int()
    __zcolumns.val = int(zcolumns)
    if __zcolumns.val!=zcolumns:
        raise ValueError("Error while converting 'zcolumns' parameter to 'x_int'")
    __fromtheright = ctypes.c_uint64(fromtheright)
    if __fromtheright.value!=0:
        __fromtheright = ctypes.c_uint64(1)
    __dotranspose = ctypes.c_uint64(dotranspose)
    if __dotranspose.value!=0:
        __dotranspose = ctypes.c_uint64(1)
    try:
        x_from_listlist(__qp, qp, DT_REAL, X_CREATE)
        x_from_list(__taup, taup, DT_REAL, X_CREATE)
        x_from_listlist(__z, z, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbdmultiplybyp(ctypes.byref(_error_msg), ctypes.byref(__qp), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__taup), ctypes.byref(__z), ctypes.byref(__zrows), ctypes.byref(__zcolumns), ctypes.byref(__fromtheright), ctypes.byref(__dotranspose), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbdmultiplybyp'")
        __r__z = listlist_from_x(__z)
        return __r__z
    finally:
        x_matrix_clear(__qp)
        x_vector_clear(__taup)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_rmatrixbdunpackdiagonals.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbdunpackdiagonals.restype = ctypes.c_int32
def rmatrixbdunpackdiagonals(b, m, n):
    pass
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(0)
    __d = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __e = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbdunpackdiagonals(ctypes.byref(_error_msg), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__d), ctypes.byref(__e), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbdunpackdiagonals'")
        __r__isupper = __isupper.value!=0
        __r__d = list_from_x(__d)
        __r__e = list_from_x(__e)
        return (__r__isupper, __r__d, __r__e)
    finally:
        x_matrix_clear(__b)
        x_vector_clear(__d)
        x_vector_clear(__e)


_lib_alglib.alglib_xv2_rmatrixhessenberg.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixhessenberg.restype = ctypes.c_int32
def rmatrixhessenberg(a, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __tau = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixhessenberg(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__tau), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixhessenberg'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        return (__r__a, __r__tau)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)


_lib_alglib.alglib_xv2_rmatrixhessenbergunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixhessenbergunpackq.restype = ctypes.c_int32
def rmatrixhessenbergunpackq(a, n, tau):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(tau):
        raise ValueError("'tau' parameter can't be cast to real_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__tau, tau, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixhessenbergunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__tau), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixhessenbergunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_rmatrixhessenbergunpackh.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixhessenbergunpackh.restype = ctypes.c_int32
def rmatrixhessenbergunpackh(a, n):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __h = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixhessenbergunpackh(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__h), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixhessenbergunpackh'")
        __r__h = listlist_from_x(__h)
        return __r__h
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__h)


_lib_alglib.alglib_xv2_smatrixtd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixtd.restype = ctypes.c_int32
def smatrixtd(a, n, isupper):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __tau = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __d = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __e = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixtd(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__tau), ctypes.byref(__d), ctypes.byref(__e), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixtd'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        __r__d = list_from_x(__d)
        __r__e = list_from_x(__e)
        return (__r__a, __r__tau, __r__d, __r__e)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_vector_clear(__d)
        x_vector_clear(__e)


_lib_alglib.alglib_xv2_smatrixtdunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixtdunpackq.restype = ctypes.c_int32
def smatrixtdunpackq(a, n, isupper, tau):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(tau):
        raise ValueError("'tau' parameter can't be cast to real_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__tau, tau, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixtdunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__tau), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixtdunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)


_lib_alglib.alglib_xv2_hmatrixtd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixtd.restype = ctypes.c_int32
def hmatrixtd(a, n, isupper):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __tau = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __d = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __e = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixtd(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__tau), ctypes.byref(__d), ctypes.byref(__e), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixtd'")
        __r__a = listlist_from_x(__a)
        __r__tau = list_from_x(__tau)
        __r__d = list_from_x(__d)
        __r__e = list_from_x(__e)
        return (__r__a, __r__tau, __r__d, __r__e)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_vector_clear(__d)
        x_vector_clear(__e)


_lib_alglib.alglib_xv2_hmatrixtdunpackq.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixtdunpackq.restype = ctypes.c_int32
def hmatrixtdunpackq(a, n, isupper, tau):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_vector(tau):
        raise ValueError("'tau' parameter can't be cast to complex_vector")
    __tau = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __q = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__tau, tau, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixtdunpackq(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__tau), ctypes.byref(__q), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixtdunpackq'")
        __r__q = listlist_from_x(__q)
        return __r__q
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__tau)
        x_matrix_clear(__q)




class x_optguardreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("nonc0suspected", ctypes.c_uint64),
        ("nonc0test0positive", ctypes.c_uint64),
        ("nonc0fidx", x_int),
        ("nonc0lipschitzc", ctypes.c_double),
        ("nonc1suspected", ctypes.c_uint64),
        ("nonc1test0positive", ctypes.c_uint64),
        ("nonc1test1positive", ctypes.c_uint64),
        ("nonc1fidx", x_int),
        ("nonc1lipschitzc", ctypes.c_double),
        ("badgradsuspected", ctypes.c_uint64),
        ("badgradfidx", x_int),
        ("badgradvidx", x_int),
        ("badgradxbase", x_vector),
        ("badgraduser", x_matrix),
        ("badgradnum", x_matrix)
        ]




class optguardreport(object):
    def __init__(self):
        self.nonc0suspected = False
        self.nonc0test0positive = False
        self.nonc0fidx = 0
        self.nonc0lipschitzc = 0
        self.nonc1suspected = False
        self.nonc1test0positive = False
        self.nonc1test1positive = False
        self.nonc1fidx = 0
        self.nonc1lipschitzc = 0
        self.badgradsuspected = False
        self.badgradfidx = 0
        self.badgradvidx = 0
        self.badgradxbase = []
        self.badgraduser = [[]]
        self.badgradnum = [[]]


def x_optguardreport_zero_fields(x):
    x.nonc0suspected = 0
    x.nonc0test0positive = 0
    x.nonc0fidx.val = 0
    x.nonc0lipschitzc = 0
    x.nonc1suspected = 0
    x.nonc1test0positive = 0
    x.nonc1test1positive = 0
    x.nonc1fidx.val = 0
    x.nonc1lipschitzc = 0
    x.badgradsuspected = 0
    x.badgradfidx.val = 0
    x.badgradvidx.val = 0
    x.badgradxbase = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.badgraduser = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.badgradnum = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    return




def x_optguardreport_clear(x):
    x_vector_clear(x.badgradxbase)
    x_matrix_clear(x.badgraduser)
    x_matrix_clear(x.badgradnum)
    x_optguardreport_zero_fields(x)
    return




def x_from_optguardreport(x,v):
    x.nonc0suspected = int(v.nonc0suspected)
    x.nonc0test0positive = int(v.nonc0test0positive)
    x.nonc0fidx.val = int(v.nonc0fidx)
    x.nonc0lipschitzc = float(v.nonc0lipschitzc)
    x.nonc1suspected = int(v.nonc1suspected)
    x.nonc1test0positive = int(v.nonc1test0positive)
    x.nonc1test1positive = int(v.nonc1test1positive)
    x.nonc1fidx.val = int(v.nonc1fidx)
    x.nonc1lipschitzc = float(v.nonc1lipschitzc)
    x.badgradsuspected = int(v.badgradsuspected)
    x.badgradfidx.val = int(v.badgradfidx)
    x.badgradvidx.val = int(v.badgradvidx)
    x_from_list(x.badgradxbase, v.badgradxbase, DT_REAL, X_CREATE)
    x_from_listlist(x.badgraduser, v.badgraduser, DT_REAL, X_CREATE)
    x_from_listlist(x.badgradnum, v.badgradnum, DT_REAL, X_CREATE)
    return




def optguardreport_from_x(x):
    r = optguardreport()
    r.nonc0suspected = x.nonc0suspected
    r.nonc0test0positive = x.nonc0test0positive
    r.nonc0fidx = x.nonc0fidx.val
    r.nonc0lipschitzc = x.nonc0lipschitzc
    r.nonc1suspected = x.nonc1suspected
    r.nonc1test0positive = x.nonc1test0positive
    r.nonc1test1positive = x.nonc1test1positive
    r.nonc1fidx = x.nonc1fidx.val
    r.nonc1lipschitzc = x.nonc1lipschitzc
    r.badgradsuspected = x.badgradsuspected
    r.badgradfidx = x.badgradfidx.val
    r.badgradvidx = x.badgradvidx.val
    r.badgradxbase = list_from_x(x.badgradxbase)
    r.badgraduser = listlist_from_x(x.badgraduser)
    r.badgradnum = listlist_from_x(x.badgradnum)
    return r




class x_optguardnonc0report(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("positive", ctypes.c_uint64),
        ("fidx", x_int),
        ("x0", x_vector),
        ("d", x_vector),
        ("n", x_int),
        ("stp", x_vector),
        ("f", x_vector),
        ("cnt", x_int),
        ("stpidxa", x_int),
        ("stpidxb", x_int)
        ]




class optguardnonc0report(object):
    def __init__(self):
        self.positive = False
        self.fidx = 0
        self.x0 = []
        self.d = []
        self.n = 0
        self.stp = []
        self.f = []
        self.cnt = 0
        self.stpidxa = 0
        self.stpidxb = 0


def x_optguardnonc0report_zero_fields(x):
    x.positive = 0
    x.fidx.val = 0
    x.x0 = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.n.val = 0
    x.stp = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.f = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.cnt.val = 0
    x.stpidxa.val = 0
    x.stpidxb.val = 0
    return




def x_optguardnonc0report_clear(x):
    x_vector_clear(x.x0)
    x_vector_clear(x.d)
    x_vector_clear(x.stp)
    x_vector_clear(x.f)
    x_optguardnonc0report_zero_fields(x)
    return




def x_from_optguardnonc0report(x,v):
    x.positive = int(v.positive)
    x.fidx.val = int(v.fidx)
    x_from_list(x.x0, v.x0, DT_REAL, X_CREATE)
    x_from_list(x.d, v.d, DT_REAL, X_CREATE)
    x.n.val = int(v.n)
    x_from_list(x.stp, v.stp, DT_REAL, X_CREATE)
    x_from_list(x.f, v.f, DT_REAL, X_CREATE)
    x.cnt.val = int(v.cnt)
    x.stpidxa.val = int(v.stpidxa)
    x.stpidxb.val = int(v.stpidxb)
    return




def optguardnonc0report_from_x(x):
    r = optguardnonc0report()
    r.positive = x.positive
    r.fidx = x.fidx.val
    r.x0 = list_from_x(x.x0)
    r.d = list_from_x(x.d)
    r.n = x.n.val
    r.stp = list_from_x(x.stp)
    r.f = list_from_x(x.f)
    r.cnt = x.cnt.val
    r.stpidxa = x.stpidxa.val
    r.stpidxb = x.stpidxb.val
    return r




class x_optguardnonc1test0report(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("positive", ctypes.c_uint64),
        ("fidx", x_int),
        ("x0", x_vector),
        ("d", x_vector),
        ("n", x_int),
        ("stp", x_vector),
        ("f", x_vector),
        ("cnt", x_int),
        ("stpidxa", x_int),
        ("stpidxb", x_int)
        ]




class optguardnonc1test0report(object):
    def __init__(self):
        self.positive = False
        self.fidx = 0
        self.x0 = []
        self.d = []
        self.n = 0
        self.stp = []
        self.f = []
        self.cnt = 0
        self.stpidxa = 0
        self.stpidxb = 0


def x_optguardnonc1test0report_zero_fields(x):
    x.positive = 0
    x.fidx.val = 0
    x.x0 = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.n.val = 0
    x.stp = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.f = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.cnt.val = 0
    x.stpidxa.val = 0
    x.stpidxb.val = 0
    return




def x_optguardnonc1test0report_clear(x):
    x_vector_clear(x.x0)
    x_vector_clear(x.d)
    x_vector_clear(x.stp)
    x_vector_clear(x.f)
    x_optguardnonc1test0report_zero_fields(x)
    return




def x_from_optguardnonc1test0report(x,v):
    x.positive = int(v.positive)
    x.fidx.val = int(v.fidx)
    x_from_list(x.x0, v.x0, DT_REAL, X_CREATE)
    x_from_list(x.d, v.d, DT_REAL, X_CREATE)
    x.n.val = int(v.n)
    x_from_list(x.stp, v.stp, DT_REAL, X_CREATE)
    x_from_list(x.f, v.f, DT_REAL, X_CREATE)
    x.cnt.val = int(v.cnt)
    x.stpidxa.val = int(v.stpidxa)
    x.stpidxb.val = int(v.stpidxb)
    return




def optguardnonc1test0report_from_x(x):
    r = optguardnonc1test0report()
    r.positive = x.positive
    r.fidx = x.fidx.val
    r.x0 = list_from_x(x.x0)
    r.d = list_from_x(x.d)
    r.n = x.n.val
    r.stp = list_from_x(x.stp)
    r.f = list_from_x(x.f)
    r.cnt = x.cnt.val
    r.stpidxa = x.stpidxa.val
    r.stpidxb = x.stpidxb.val
    return r




class x_optguardnonc1test1report(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("positive", ctypes.c_uint64),
        ("fidx", x_int),
        ("vidx", x_int),
        ("x0", x_vector),
        ("d", x_vector),
        ("n", x_int),
        ("stp", x_vector),
        ("g", x_vector),
        ("cnt", x_int),
        ("stpidxa", x_int),
        ("stpidxb", x_int)
        ]




class optguardnonc1test1report(object):
    def __init__(self):
        self.positive = False
        self.fidx = 0
        self.vidx = 0
        self.x0 = []
        self.d = []
        self.n = 0
        self.stp = []
        self.g = []
        self.cnt = 0
        self.stpidxa = 0
        self.stpidxb = 0


def x_optguardnonc1test1report_zero_fields(x):
    x.positive = 0
    x.fidx.val = 0
    x.vidx.val = 0
    x.x0 = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.n.val = 0
    x.stp = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.g = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.cnt.val = 0
    x.stpidxa.val = 0
    x.stpidxb.val = 0
    return




def x_optguardnonc1test1report_clear(x):
    x_vector_clear(x.x0)
    x_vector_clear(x.d)
    x_vector_clear(x.stp)
    x_vector_clear(x.g)
    x_optguardnonc1test1report_zero_fields(x)
    return




def x_from_optguardnonc1test1report(x,v):
    x.positive = int(v.positive)
    x.fidx.val = int(v.fidx)
    x.vidx.val = int(v.vidx)
    x_from_list(x.x0, v.x0, DT_REAL, X_CREATE)
    x_from_list(x.d, v.d, DT_REAL, X_CREATE)
    x.n.val = int(v.n)
    x_from_list(x.stp, v.stp, DT_REAL, X_CREATE)
    x_from_list(x.g, v.g, DT_REAL, X_CREATE)
    x.cnt.val = int(v.cnt)
    x.stpidxa.val = int(v.stpidxa)
    x.stpidxb.val = int(v.stpidxb)
    return




def optguardnonc1test1report_from_x(x):
    r = optguardnonc1test1report()
    r.positive = x.positive
    r.fidx = x.fidx.val
    r.vidx = x.vidx.val
    r.x0 = list_from_x(x.x0)
    r.d = list_from_x(x.d)
    r.n = x.n.val
    r.stp = list_from_x(x.stp)
    r.g = list_from_x(x.g)
    r.cnt = x.cnt.val
    r.stpidxa = x.stpidxa.val
    r.stpidxb = x.stpidxb.val
    return r


_lib_alglib.alglib_xv2_rmatrixbdsvd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixbdsvd.restype = ctypes.c_int32
def rmatrixbdsvd(d, e, n, isupper, isfractionalaccuracyrequired, u, nru, c, ncc, vt, ncvt):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(e):
        raise ValueError("'e' parameter can't be cast to real_vector")
    __e = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __isfractionalaccuracyrequired = ctypes.c_uint64(isfractionalaccuracyrequired)
    if __isfractionalaccuracyrequired.value!=0:
        __isfractionalaccuracyrequired = ctypes.c_uint64(1)
    if not is_real_matrix(u):
        raise ValueError("'u' parameter can't be cast to real_matrix")
    __u = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nru = x_int()
    __nru.val = int(nru)
    if __nru.val!=nru:
        raise ValueError("Error while converting 'nru' parameter to 'x_int'")
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ncc = x_int()
    __ncc.val = int(ncc)
    if __ncc.val!=ncc:
        raise ValueError("Error while converting 'ncc' parameter to 'x_int'")
    if not is_real_matrix(vt):
        raise ValueError("'vt' parameter can't be cast to real_matrix")
    __vt = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ncvt = x_int()
    __ncvt.val = int(ncvt)
    if __ncvt.val!=ncvt:
        raise ValueError("Error while converting 'ncvt' parameter to 'x_int'")
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        x_from_list(__e, e, DT_REAL, X_CREATE)
        x_from_listlist(__u, u, DT_REAL, X_CREATE)
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        x_from_listlist(__vt, vt, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixbdsvd(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__d), ctypes.byref(__e), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__isfractionalaccuracyrequired), ctypes.byref(__u), ctypes.byref(__nru), ctypes.byref(__c), ctypes.byref(__ncc), ctypes.byref(__vt), ctypes.byref(__ncvt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixbdsvd'")
        __r__result = __result.value!=0
        __r__d = list_from_x(__d)
        __r__u = listlist_from_x(__u)
        __r__c = listlist_from_x(__c)
        __r__vt = listlist_from_x(__vt)
        return (__r__result, __r__d, __r__u, __r__c, __r__vt)
    finally:
        x_vector_clear(__d)
        x_vector_clear(__e)
        x_matrix_clear(__u)
        x_matrix_clear(__c)
        x_matrix_clear(__vt)


_lib_alglib.alglib_xv2_rmatrixsvd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsvd.restype = ctypes.c_int32
def rmatrixsvd(a, m, n, uneeded, vtneeded, additionalmemory):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __uneeded = x_int()
    __uneeded.val = int(uneeded)
    if __uneeded.val!=uneeded:
        raise ValueError("Error while converting 'uneeded' parameter to 'x_int'")
    __vtneeded = x_int()
    __vtneeded.val = int(vtneeded)
    if __vtneeded.val!=vtneeded:
        raise ValueError("Error while converting 'vtneeded' parameter to 'x_int'")
    __additionalmemory = x_int()
    __additionalmemory.val = int(additionalmemory)
    if __additionalmemory.val!=additionalmemory:
        raise ValueError("Error while converting 'additionalmemory' parameter to 'x_int'")
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __u = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __vt = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsvd(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__uneeded), ctypes.byref(__vtneeded), ctypes.byref(__additionalmemory), ctypes.byref(__w), ctypes.byref(__u), ctypes.byref(__vt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsvd'")
        __r__result = __result.value!=0
        __r__w = list_from_x(__w)
        __r__u = listlist_from_x(__u)
        __r__vt = listlist_from_x(__vt)
        return (__r__result, __r__w, __r__u, __r__vt)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__w)
        x_matrix_clear(__u)
        x_matrix_clear(__vt)




class x_densesolverreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("r1", ctypes.c_double),
        ("rinf", ctypes.c_double)
        ]




class densesolverreport(object):
    def __init__(self):
        self.r1 = 0
        self.rinf = 0


def x_densesolverreport_zero_fields(x):
    x.r1 = 0
    x.rinf = 0
    return




def x_densesolverreport_clear(x):
    x_densesolverreport_zero_fields(x)
    return




def x_from_densesolverreport(x,v):
    x.r1 = float(v.r1)
    x.rinf = float(v.rinf)
    return




def densesolverreport_from_x(x):
    r = densesolverreport()
    r.r1 = x.r1
    r.rinf = x.rinf
    return r




class x_densesolverlsreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("r2", ctypes.c_double),
        ("cx", x_matrix),
        ("n", x_int),
        ("k", x_int)
        ]




class densesolverlsreport(object):
    def __init__(self):
        self.r2 = 0
        self.cx = [[]]
        self.n = 0
        self.k = 0


def x_densesolverlsreport_zero_fields(x):
    x.r2 = 0
    x.cx = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.n.val = 0
    x.k.val = 0
    return




def x_densesolverlsreport_clear(x):
    x_matrix_clear(x.cx)
    x_densesolverlsreport_zero_fields(x)
    return




def x_from_densesolverlsreport(x,v):
    x.r2 = float(v.r2)
    x_from_listlist(x.cx, v.cx, DT_REAL, X_CREATE)
    x.n.val = int(v.n)
    x.k.val = int(v.k)
    return




def densesolverlsreport_from_x(x):
    r = densesolverlsreport()
    r.r2 = x.r2
    r.cx = listlist_from_x(x.cx)
    r.n = x.n.val
    r.k = x.k.val
    return r


_lib_alglib.alglib_xv2_rmatrixsolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsolve.restype = ctypes.c_int32
def rmatrixsolve(a, n, b):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsolve(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_rmatrixsolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsolvefast.restype = ctypes.c_int32
def rmatrixsolvefast(a, n, b):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsolvefast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_rmatrixsolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsolvem.restype = ctypes.c_int32
def rmatrixsolvem(a, n, b, m, rfs):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __rfs = ctypes.c_uint64(rfs)
    if __rfs.value!=0:
        __rfs = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsolvem(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__rfs), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_rmatrixsolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsolvemfast.restype = ctypes.c_int32
def rmatrixsolvemfast(a, n, b, m):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsolvemfast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rmatrixlusolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlusolve.restype = ctypes.c_int32
def rmatrixlusolve(lua, p, n, b):
    pass
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlusolve(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlusolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_rmatrixlusolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlusolvefast.restype = ctypes.c_int32
def rmatrixlusolvefast(lua, p, n, b):
    pass
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlusolvefast(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlusolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_rmatrixlusolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlusolvem.restype = ctypes.c_int32
def rmatrixlusolvem(lua, p, n, b, m):
    pass
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlusolvem(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlusolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_rmatrixlusolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixlusolvemfast.restype = ctypes.c_int32
def rmatrixlusolvemfast(lua, p, n, b, m):
    pass
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixlusolvemfast(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixlusolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_rmatrixmixedsolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixmixedsolve.restype = ctypes.c_int32
def rmatrixmixedsolve(a, lua, p, n, b):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixmixedsolve(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixmixedsolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_rmatrixmixedsolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixmixedsolvem.restype = ctypes.c_int32
def rmatrixmixedsolvem(a, lua, p, n, b, m):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to real_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__lua, lua, DT_REAL, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixmixedsolvem(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixmixedsolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_cmatrixsolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixsolvem.restype = ctypes.c_int32
def cmatrixsolvem(a, n, b, m, rfs):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __rfs = ctypes.c_uint64(rfs)
    if __rfs.value!=0:
        __rfs = ctypes.c_uint64(1)
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixsolvem(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__rfs), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixsolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_cmatrixsolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixsolvemfast.restype = ctypes.c_int32
def cmatrixsolvemfast(a, n, b, m):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixsolvemfast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixsolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_cmatrixsolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixsolve.restype = ctypes.c_int32
def cmatrixsolve(a, n, b):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixsolve(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixsolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_cmatrixsolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixsolvefast.restype = ctypes.c_int32
def cmatrixsolvefast(a, n, b):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixsolvefast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixsolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_cmatrixlusolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlusolvem.restype = ctypes.c_int32
def cmatrixlusolvem(lua, p, n, b, m):
    pass
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlusolvem(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlusolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_cmatrixlusolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlusolvemfast.restype = ctypes.c_int32
def cmatrixlusolvemfast(lua, p, n, b, m):
    pass
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlusolvemfast(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlusolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_cmatrixlusolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlusolve.restype = ctypes.c_int32
def cmatrixlusolve(lua, p, n, b):
    pass
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlusolve(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlusolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_cmatrixlusolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixlusolvefast.restype = ctypes.c_int32
def cmatrixlusolvefast(lua, p, n, b):
    pass
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixlusolvefast(ctypes.byref(_error_msg), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixlusolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_cmatrixmixedsolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixmixedsolvem.restype = ctypes.c_int32
def cmatrixmixedsolvem(a, lua, p, n, b, m):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixmixedsolvem(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixmixedsolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_cmatrixmixedsolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cmatrixmixedsolve.restype = ctypes.c_int32
def cmatrixmixedsolve(a, lua, p, n, b):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_complex_matrix(lua):
        raise ValueError("'lua' parameter can't be cast to complex_matrix")
    __lua = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(p):
        raise ValueError("'p' parameter can't be cast to int_vector")
    __p = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__lua, lua, DT_COMPLEX, X_CREATE)
        x_from_list(__p, p, DT_INT, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cmatrixmixedsolve(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__lua), ctypes.byref(__p), ctypes.byref(__n), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cmatrixmixedsolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__lua)
        x_vector_clear(__p)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_spdmatrixsolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixsolvem.restype = ctypes.c_int32
def spdmatrixsolvem(a, n, isupper, b, m):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixsolvem(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixsolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_spdmatrixsolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixsolvemfast.restype = ctypes.c_int32
def spdmatrixsolvemfast(a, n, isupper, b, m):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixsolvemfast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixsolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_spdmatrixsolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixsolve.restype = ctypes.c_int32
def spdmatrixsolve(a, n, isupper, b):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixsolve(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixsolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_spdmatrixsolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixsolvefast.restype = ctypes.c_int32
def spdmatrixsolvefast(a, n, isupper, b):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixsolvefast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixsolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_spdmatrixcholeskysolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskysolvem.restype = ctypes.c_int32
def spdmatrixcholeskysolvem(cha, n, isupper, b, m):
    pass
    if not is_real_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to real_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__cha, cha, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskysolvem(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskysolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__cha)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_spdmatrixcholeskysolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskysolvemfast.restype = ctypes.c_int32
def spdmatrixcholeskysolvemfast(cha, n, isupper, b, m):
    pass
    if not is_real_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to real_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_matrix(b):
        raise ValueError("'b' parameter can't be cast to real_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__cha, cha, DT_REAL, X_CREATE)
        x_from_listlist(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskysolvemfast(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskysolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__cha)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_spdmatrixcholeskysolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskysolve.restype = ctypes.c_int32
def spdmatrixcholeskysolve(cha, n, isupper, b):
    pass
    if not is_real_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to real_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__cha, cha, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskysolve(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskysolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__cha)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_spdmatrixcholeskysolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spdmatrixcholeskysolvefast.restype = ctypes.c_int32
def spdmatrixcholeskysolvefast(cha, n, isupper, b):
    pass
    if not is_real_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to real_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__cha, cha, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spdmatrixcholeskysolvefast(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spdmatrixcholeskysolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__cha)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_hpdmatrixsolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixsolvem.restype = ctypes.c_int32
def hpdmatrixsolvem(a, n, isupper, b, m):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixsolvem(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixsolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_hpdmatrixsolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixsolvemfast.restype = ctypes.c_int32
def hpdmatrixsolvemfast(a, n, isupper, b, m):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixsolvemfast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixsolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_hpdmatrixsolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixsolve.restype = ctypes.c_int32
def hpdmatrixsolve(a, n, isupper, b):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixsolve(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixsolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_hpdmatrixsolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixsolvefast.restype = ctypes.c_int32
def hpdmatrixsolvefast(a, n, isupper, b):
    pass
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixsolvefast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixsolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_hpdmatrixcholeskysolvem.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholeskysolvem.restype = ctypes.c_int32
def hpdmatrixcholeskysolvem(cha, n, isupper, b, m):
    pass
    if not is_complex_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to complex_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__cha, cha, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholeskysolvem(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholeskysolvem'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = listlist_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__cha)
        x_matrix_clear(__b)
        x_densesolverreport_clear(__rep)
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_hpdmatrixcholeskysolvemfast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholeskysolvemfast.restype = ctypes.c_int32
def hpdmatrixcholeskysolvemfast(cha, n, isupper, b, m):
    pass
    if not is_complex_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to complex_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_matrix(b):
        raise ValueError("'b' parameter can't be cast to complex_matrix")
    __b = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__cha, cha, DT_COMPLEX, X_CREATE)
        x_from_listlist(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholeskysolvemfast(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholeskysolvemfast'")
        __r__b = listlist_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__cha)
        x_matrix_clear(__b)


_lib_alglib.alglib_xv2_hpdmatrixcholeskysolve.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholeskysolve.restype = ctypes.c_int32
def hpdmatrixcholeskysolve(cha, n, isupper, b):
    pass
    if not is_complex_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to complex_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverreport()
    x_densesolverreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__cha, cha, DT_COMPLEX, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholeskysolve(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholeskysolve'")
        __r__info = __info.val
        __r__rep = densesolverreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__cha)
        x_vector_clear(__b)
        x_densesolverreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_hpdmatrixcholeskysolvefast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hpdmatrixcholeskysolvefast.restype = ctypes.c_int32
def hpdmatrixcholeskysolvefast(cha, n, isupper, b):
    pass
    if not is_complex_matrix(cha):
        raise ValueError("'cha' parameter can't be cast to complex_matrix")
    __cha = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    if not is_complex_vector(b):
        raise ValueError("'b' parameter can't be cast to complex_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __info = x_int()
    __info.val = 0
    try:
        x_from_listlist(__cha, cha, DT_COMPLEX, X_CREATE)
        x_from_list(__b, b, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hpdmatrixcholeskysolvefast(ctypes.byref(_error_msg), ctypes.byref(__cha), ctypes.byref(__n), ctypes.byref(__isupper), ctypes.byref(__b), ctypes.byref(__info), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hpdmatrixcholeskysolvefast'")
        __r__b = list_from_x(__b)
        __r__info = __info.val
        return (__r__b, __r__info)
    finally:
        x_matrix_clear(__cha)
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_rmatrixsolvels.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixsolvels.restype = ctypes.c_int32
def rmatrixsolvels(a, nrows, ncols, b, threshold):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nrows = x_int()
    __nrows.val = int(nrows)
    if __nrows.val!=nrows:
        raise ValueError("Error while converting 'nrows' parameter to 'x_int'")
    __ncols = x_int()
    __ncols.val = int(ncols)
    if __ncols.val!=ncols:
        raise ValueError("Error while converting 'ncols' parameter to 'x_int'")
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __threshold = ctypes.c_double(threshold)
    __info = x_int()
    __info.val = 0
    __rep = x_densesolverlsreport()
    x_densesolverlsreport_zero_fields(__rep)
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixsolvels(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__nrows), ctypes.byref(__ncols), ctypes.byref(__b), ctypes.byref(__threshold), ctypes.byref(__info), ctypes.byref(__rep), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixsolvels'")
        __r__info = __info.val
        __r__rep = densesolverlsreport_from_x(__rep)
        __r__x = list_from_x(__x)
        return (__r__info, __r__rep, __r__x)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__b)
        x_densesolverlsreport_clear(__rep)
        x_vector_clear(__x)


_lib_alglib.x_obj_free_minlbfgsstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minlbfgsstate.restype = None
_lib_alglib.x_minlbfgsstate_get_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_get_needf.restype = None
_lib_alglib.x_minlbfgsstate_set_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_set_needf.restype = None
_lib_alglib.x_minlbfgsstate_get_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_get_needfg.restype = None
_lib_alglib.x_minlbfgsstate_set_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_set_needfg.restype = None
_lib_alglib.x_minlbfgsstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_get_xupdated.restype = None
_lib_alglib.x_minlbfgsstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_set_xupdated.restype = None
_lib_alglib.x_minlbfgsstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_get_f.restype = None
_lib_alglib.x_minlbfgsstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_set_f.restype = None
_lib_alglib.x_minlbfgsstate_get_g.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_get_g.restype = None
_lib_alglib.x_minlbfgsstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlbfgsstate_get_x.restype = None


class minlbfgsstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minlbfgsstate(self.ptr)


class x_minlbfgsreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("terminationtype", x_int)
        ]




class minlbfgsreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.terminationtype = 0


def x_minlbfgsreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.terminationtype.val = 0
    return




def x_minlbfgsreport_clear(x):
    x_minlbfgsreport_zero_fields(x)
    return




def x_from_minlbfgsreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.terminationtype.val = int(v.terminationtype)
    return




def minlbfgsreport_from_x(x):
    r = minlbfgsreport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_minlbfgscreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgscreate.restype = ctypes.c_int32
def minlbfgscreate(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,m,x = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        m,x = functionargs
        n = safe_len("'minlbfgscreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlbfgscreate': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgscreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgscreate'")
        __r__state = minlbfgsstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlbfgscreatef.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgscreatef.restype = ctypes.c_int32
def minlbfgscreatef(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        n,m,x,diffstep = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        m,x,diffstep = functionargs
        n = safe_len("'minlbfgscreatef': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlbfgscreatef': function must have 3 or 4 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgscreatef(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgscreatef'")
        __r__state = minlbfgsstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlbfgssetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetcond.restype = ctypes.c_int32
def minlbfgssetcond(state, epsg, epsf, epsx, maxits):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgssetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetxrep.restype = ctypes.c_int32
def minlbfgssetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgssetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetstpmax.restype = ctypes.c_int32
def minlbfgssetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetstpmax'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgssetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetscale.restype = ctypes.c_int32
def minlbfgssetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minlbfgssetprecdefault.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetprecdefault.restype = ctypes.c_int32
def minlbfgssetprecdefault(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetprecdefault(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetprecdefault'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgssetpreccholesky.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetpreccholesky.restype = ctypes.c_int32
def minlbfgssetpreccholesky(state, p, isupper):
    pass
    __state = state.ptr
    if not is_real_matrix(p):
        raise ValueError("'p' parameter can't be cast to real_matrix")
    __p = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__p, p, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetpreccholesky(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__p), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetpreccholesky'")
        return
    finally:
        x_matrix_clear(__p)


_lib_alglib.alglib_xv2_minlbfgssetprecdiag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetprecdiag.restype = ctypes.c_int32
def minlbfgssetprecdiag(state, d):
    pass
    __state = state.ptr
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetprecdiag(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__d), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetprecdiag'")
        return
    finally:
        x_vector_clear(__d)


_lib_alglib.alglib_xv2_minlbfgssetprecscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetprecscale.restype = ctypes.c_int32
def minlbfgssetprecscale(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetprecscale(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetprecscale'")
        return
    finally:
        pass




def minlbfgsoptimize_f(state, func, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlbfgsstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    while True:
        retval = _lib_alglib.alglib_xv2_minlbfgsiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlbfgsstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_minlbfgsstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_minlbfgsstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlbfgsstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlbfgsoptimize' (some derivatives were not provided?)")
    return


def minlbfgsoptimize_g(state, grad, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlbfgsstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_minlbfgsstate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minlbfgsiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlbfgsstate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_minlbfgsstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlbfgsstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlbfgsstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlbfgsoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minlbfgsoptguardgradient.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsoptguardgradient.restype = ctypes.c_int32
def minlbfgsoptguardgradient(state, teststep):
    pass
    __state = state.ptr
    __teststep = ctypes.c_double(teststep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsoptguardgradient(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__teststep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsoptguardgradient'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgsoptguardsmoothness.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsoptguardsmoothness.restype = ctypes.c_int32
def minlbfgsoptguardsmoothness(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        state,level = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        state, = functionargs
        level = 1
    else:
        raise RuntimeError("Error while calling 'minlbfgsoptguardsmoothness': function must have 1 or 2 parameters")
    __state = state.ptr
    __level = x_int()
    __level.val = int(level)
    if __level.val!=level:
        raise ValueError("Error while converting 'level' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsoptguardsmoothness(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__level), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsoptguardsmoothness'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgsoptguardresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsoptguardresults.restype = ctypes.c_int32
def minlbfgsoptguardresults(state):
    pass
    __state = state.ptr
    __rep = x_optguardreport()
    x_optguardreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsoptguardresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsoptguardresults'")
        __r__rep = optguardreport_from_x(__rep)
        return __r__rep
    finally:
        x_optguardreport_clear(__rep)


_lib_alglib.alglib_xv2_minlbfgsoptguardnonc1test0results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsoptguardnonc1test0results.restype = ctypes.c_int32
def minlbfgsoptguardnonc1test0results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsoptguardnonc1test0results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsoptguardnonc1test0results'")
        __r__strrep = optguardnonc1test0report_from_x(__strrep)
        __r__lngrep = optguardnonc1test0report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test0report_clear(__strrep)
        x_optguardnonc1test0report_clear(__lngrep)


_lib_alglib.alglib_xv2_minlbfgsoptguardnonc1test1results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsoptguardnonc1test1results.restype = ctypes.c_int32
def minlbfgsoptguardnonc1test1results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsoptguardnonc1test1results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsoptguardnonc1test1results'")
        __r__strrep = optguardnonc1test1report_from_x(__strrep)
        __r__lngrep = optguardnonc1test1report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test1report_clear(__strrep)
        x_optguardnonc1test1report_clear(__lngrep)


_lib_alglib.alglib_xv2_minlbfgsresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsresults.restype = ctypes.c_int32
def minlbfgsresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minlbfgsreport()
    x_minlbfgsreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsresults'")
        __r__x = list_from_x(__x)
        __r__rep = minlbfgsreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minlbfgsreport_clear(__rep)


_lib_alglib.alglib_xv2_minlbfgsresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsresultsbuf.restype = ctypes.c_int32
def minlbfgsresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minlbfgsreport()
    x_minlbfgsreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minlbfgsreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minlbfgsreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minlbfgsreport_clear(__rep)


_lib_alglib.alglib_xv2_minlbfgsrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsrestartfrom.restype = ctypes.c_int32
def minlbfgsrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlbfgsrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgsrequesttermination.restype = ctypes.c_int32
def minlbfgsrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgsrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgsrequesttermination'")
        return
    finally:
        pass


_lib_alglib.x_obj_free_normestimatorstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_normestimatorstate.restype = None


class normestimatorstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_normestimatorstate(self.ptr)
_lib_alglib.alglib_xv2_normestimatorcreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normestimatorcreate.restype = ctypes.c_int32
def normestimatorcreate(m, n, nstart, nits):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __nstart = x_int()
    __nstart.val = int(nstart)
    if __nstart.val!=nstart:
        raise ValueError("Error while converting 'nstart' parameter to 'x_int'")
    __nits = x_int()
    __nits.val = int(nits)
    if __nits.val!=nits:
        raise ValueError("Error while converting 'nits' parameter to 'x_int'")
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normestimatorcreate(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__nstart), ctypes.byref(__nits), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normestimatorcreate'")
        __r__state = normestimatorstate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_normestimatorsetseed.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normestimatorsetseed.restype = ctypes.c_int32
def normestimatorsetseed(state, seedval):
    pass
    __state = state.ptr
    __seedval = x_int()
    __seedval.val = int(seedval)
    if __seedval.val!=seedval:
        raise ValueError("Error while converting 'seedval' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normestimatorsetseed(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__seedval), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normestimatorsetseed'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_normestimatorestimatesparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normestimatorestimatesparse.restype = ctypes.c_int32
def normestimatorestimatesparse(state, a):
    pass
    __state = state.ptr
    __a = a.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normestimatorestimatesparse(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normestimatorestimatesparse'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_normestimatorresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normestimatorresults.restype = ctypes.c_int32
def normestimatorresults(state):
    pass
    __state = state.ptr
    __nrm = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normestimatorresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__nrm), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normestimatorresults'")
        __r__nrm = __nrm.value
        return __r__nrm
    finally:
        pass


_lib_alglib.x_obj_free_linlsqrstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_linlsqrstate.restype = None


class linlsqrstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_linlsqrstate(self.ptr)


class x_linlsqrreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nmv", x_int),
        ("terminationtype", x_int)
        ]




class linlsqrreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nmv = 0
        self.terminationtype = 0


def x_linlsqrreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nmv.val = 0
    x.terminationtype.val = 0
    return




def x_linlsqrreport_clear(x):
    x_linlsqrreport_zero_fields(x)
    return




def x_from_linlsqrreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nmv.val = int(v.nmv)
    x.terminationtype.val = int(v.terminationtype)
    return




def linlsqrreport_from_x(x):
    r = linlsqrreport()
    r.iterationscount = x.iterationscount.val
    r.nmv = x.nmv.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_linlsqrcreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrcreate.restype = ctypes.c_int32
def linlsqrcreate(m, n):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrcreate(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrcreate'")
        __r__state = linlsqrstate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrcreatebuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrcreatebuf.restype = ctypes.c_int32
def linlsqrcreatebuf(m, n, state):
    pass
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrcreatebuf(ctypes.byref(_error_msg), ctypes.byref(__m), ctypes.byref(__n), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrcreatebuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrsetprecunit.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrsetprecunit.restype = ctypes.c_int32
def linlsqrsetprecunit(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrsetprecunit(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrsetprecunit'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrsetprecdiag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrsetprecdiag.restype = ctypes.c_int32
def linlsqrsetprecdiag(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrsetprecdiag(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrsetprecdiag'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrsetlambdai.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrsetlambdai.restype = ctypes.c_int32
def linlsqrsetlambdai(state, lambdai):
    pass
    __state = state.ptr
    __lambdai = ctypes.c_double(lambdai)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrsetlambdai(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__lambdai), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrsetlambdai'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrsolvesparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrsolvesparse.restype = ctypes.c_int32
def linlsqrsolvesparse(state, a, b):
    pass
    __state = state.ptr
    __a = a.ptr
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrsolvesparse(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__b), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrsolvesparse'")
        return
    finally:
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_linlsqrsetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrsetcond.restype = ctypes.c_int32
def linlsqrsetcond(state, epsa, epsb, maxits):
    pass
    __state = state.ptr
    __epsa = ctypes.c_double(epsa)
    __epsb = ctypes.c_double(epsb)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrsetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsa), ctypes.byref(__epsb), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrsetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrresults.restype = ctypes.c_int32
def linlsqrresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_linlsqrreport()
    x_linlsqrreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrresults'")
        __r__x = list_from_x(__x)
        __r__rep = linlsqrreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_linlsqrreport_clear(__rep)


_lib_alglib.alglib_xv2_linlsqrsetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrsetxrep.restype = ctypes.c_int32
def linlsqrsetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrsetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrsetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrpeekiterationscount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrpeekiterationscount.restype = ctypes.c_int32
def linlsqrpeekiterationscount(s):
    pass
    __result = x_int()
    __result.val = 0
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrpeekiterationscount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrpeekiterationscount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_linlsqrrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_linlsqrrequesttermination.restype = ctypes.c_int32
def linlsqrrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_linlsqrrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'linlsqrrequesttermination'")
        return
    finally:
        pass


_lib_alglib.x_obj_free_minbleicstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minbleicstate.restype = None
_lib_alglib.x_minbleicstate_get_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_get_needf.restype = None
_lib_alglib.x_minbleicstate_set_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_set_needf.restype = None
_lib_alglib.x_minbleicstate_get_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_get_needfg.restype = None
_lib_alglib.x_minbleicstate_set_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_set_needfg.restype = None
_lib_alglib.x_minbleicstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_get_xupdated.restype = None
_lib_alglib.x_minbleicstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_set_xupdated.restype = None
_lib_alglib.x_minbleicstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_get_f.restype = None
_lib_alglib.x_minbleicstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_set_f.restype = None
_lib_alglib.x_minbleicstate_get_g.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_get_g.restype = None
_lib_alglib.x_minbleicstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbleicstate_get_x.restype = None


class minbleicstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minbleicstate(self.ptr)


class x_minbleicreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("varidx", x_int),
        ("terminationtype", x_int),
        ("debugeqerr", ctypes.c_double),
        ("debugfs", ctypes.c_double),
        ("debugff", ctypes.c_double),
        ("debugdx", ctypes.c_double),
        ("debugfeasqpits", x_int),
        ("debugfeasgpaits", x_int),
        ("inneriterationscount", x_int),
        ("outeriterationscount", x_int)
        ]




class minbleicreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.varidx = 0
        self.terminationtype = 0
        self.debugeqerr = 0
        self.debugfs = 0
        self.debugff = 0
        self.debugdx = 0
        self.debugfeasqpits = 0
        self.debugfeasgpaits = 0
        self.inneriterationscount = 0
        self.outeriterationscount = 0


def x_minbleicreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.varidx.val = 0
    x.terminationtype.val = 0
    x.debugeqerr = 0
    x.debugfs = 0
    x.debugff = 0
    x.debugdx = 0
    x.debugfeasqpits.val = 0
    x.debugfeasgpaits.val = 0
    x.inneriterationscount.val = 0
    x.outeriterationscount.val = 0
    return




def x_minbleicreport_clear(x):
    x_minbleicreport_zero_fields(x)
    return




def x_from_minbleicreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.varidx.val = int(v.varidx)
    x.terminationtype.val = int(v.terminationtype)
    x.debugeqerr = float(v.debugeqerr)
    x.debugfs = float(v.debugfs)
    x.debugff = float(v.debugff)
    x.debugdx = float(v.debugdx)
    x.debugfeasqpits.val = int(v.debugfeasqpits)
    x.debugfeasgpaits.val = int(v.debugfeasgpaits)
    x.inneriterationscount.val = int(v.inneriterationscount)
    x.outeriterationscount.val = int(v.outeriterationscount)
    return




def minbleicreport_from_x(x):
    r = minbleicreport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.varidx = x.varidx.val
    r.terminationtype = x.terminationtype.val
    r.debugeqerr = x.debugeqerr
    r.debugfs = x.debugfs
    r.debugff = x.debugff
    r.debugdx = x.debugdx
    r.debugfeasqpits = x.debugfeasqpits.val
    r.debugfeasgpaits = x.debugfeasgpaits.val
    r.inneriterationscount = x.inneriterationscount.val
    r.outeriterationscount = x.outeriterationscount.val
    return r


_lib_alglib.alglib_xv2_minbleiccreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleiccreate.restype = ctypes.c_int32
def minbleiccreate(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        n,x = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'minbleiccreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minbleiccreate': function must have 1 or 2 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleiccreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleiccreate'")
        __r__state = minbleicstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minbleiccreatef.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleiccreatef.restype = ctypes.c_int32
def minbleiccreatef(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,x,diffstep = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,diffstep = functionargs
        n = safe_len("'minbleiccreatef': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minbleiccreatef': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleiccreatef(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleiccreatef'")
        __r__state = minbleicstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minbleicsetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetbc.restype = ctypes.c_int32
def minbleicsetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minbleicsetlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetlc.restype = ctypes.c_int32
def minbleicsetlc(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        state,c,ct,k = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        state,c,ct = functionargs
        if safe_rows("'minbleicsetlc': incorrect parameters",c)!=safe_len("'minbleicsetlc': incorrect parameters",ct):
            raise RuntimeError("Error while calling 'minbleicsetlc': looks like one of arguments has wrong size")
        k = safe_rows("'minbleicsetlc': incorrect parameters",c)
    else:
        raise RuntimeError("Error while calling 'minbleicsetlc': function must have 3 or 4 parameters")
    __state = state.ptr
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetlc'")
        return
    finally:
        x_matrix_clear(__c)
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minbleicsetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetcond.restype = ctypes.c_int32
def minbleicsetcond(state, epsg, epsf, epsx, maxits):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetscale.restype = ctypes.c_int32
def minbleicsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minbleicsetprecdefault.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetprecdefault.restype = ctypes.c_int32
def minbleicsetprecdefault(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetprecdefault(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetprecdefault'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicsetprecdiag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetprecdiag.restype = ctypes.c_int32
def minbleicsetprecdiag(state, d):
    pass
    __state = state.ptr
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetprecdiag(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__d), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetprecdiag'")
        return
    finally:
        x_vector_clear(__d)


_lib_alglib.alglib_xv2_minbleicsetprecscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetprecscale.restype = ctypes.c_int32
def minbleicsetprecscale(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetprecscale(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetprecscale'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicsetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetxrep.restype = ctypes.c_int32
def minbleicsetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicsetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetstpmax.restype = ctypes.c_int32
def minbleicsetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetstpmax'")
        return
    finally:
        pass




def minbleicoptimize_f(state, func, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minbleicstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    while True:
        retval = _lib_alglib.alglib_xv2_minbleiciteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleiciteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minbleicstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_minbleicstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_minbleicstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minbleicstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minbleicoptimize' (some derivatives were not provided?)")
    return


def minbleicoptimize_g(state, grad, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minbleicstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_minbleicstate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minbleiciteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleiciteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minbleicstate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_minbleicstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minbleicstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minbleicstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minbleicoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minbleicoptguardgradient.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicoptguardgradient.restype = ctypes.c_int32
def minbleicoptguardgradient(state, teststep):
    pass
    __state = state.ptr
    __teststep = ctypes.c_double(teststep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicoptguardgradient(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__teststep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicoptguardgradient'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicoptguardsmoothness.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicoptguardsmoothness.restype = ctypes.c_int32
def minbleicoptguardsmoothness(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        state,level = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        state, = functionargs
        level = 1
    else:
        raise RuntimeError("Error while calling 'minbleicoptguardsmoothness': function must have 1 or 2 parameters")
    __state = state.ptr
    __level = x_int()
    __level.val = int(level)
    if __level.val!=level:
        raise ValueError("Error while converting 'level' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicoptguardsmoothness(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__level), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicoptguardsmoothness'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicoptguardresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicoptguardresults.restype = ctypes.c_int32
def minbleicoptguardresults(state):
    pass
    __state = state.ptr
    __rep = x_optguardreport()
    x_optguardreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicoptguardresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicoptguardresults'")
        __r__rep = optguardreport_from_x(__rep)
        return __r__rep
    finally:
        x_optguardreport_clear(__rep)


_lib_alglib.alglib_xv2_minbleicoptguardnonc1test0results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicoptguardnonc1test0results.restype = ctypes.c_int32
def minbleicoptguardnonc1test0results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicoptguardnonc1test0results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicoptguardnonc1test0results'")
        __r__strrep = optguardnonc1test0report_from_x(__strrep)
        __r__lngrep = optguardnonc1test0report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test0report_clear(__strrep)
        x_optguardnonc1test0report_clear(__lngrep)


_lib_alglib.alglib_xv2_minbleicoptguardnonc1test1results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicoptguardnonc1test1results.restype = ctypes.c_int32
def minbleicoptguardnonc1test1results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicoptguardnonc1test1results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicoptguardnonc1test1results'")
        __r__strrep = optguardnonc1test1report_from_x(__strrep)
        __r__lngrep = optguardnonc1test1report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test1report_clear(__strrep)
        x_optguardnonc1test1report_clear(__lngrep)


_lib_alglib.alglib_xv2_minbleicresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicresults.restype = ctypes.c_int32
def minbleicresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minbleicreport()
    x_minbleicreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicresults'")
        __r__x = list_from_x(__x)
        __r__rep = minbleicreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minbleicreport_clear(__rep)


_lib_alglib.alglib_xv2_minbleicresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicresultsbuf.restype = ctypes.c_int32
def minbleicresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minbleicreport()
    x_minbleicreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minbleicreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minbleicreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minbleicreport_clear(__rep)


_lib_alglib.alglib_xv2_minbleicrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicrestartfrom.restype = ctypes.c_int32
def minbleicrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minbleicrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicrequesttermination.restype = ctypes.c_int32
def minbleicrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicrequesttermination'")
        return
    finally:
        pass


_lib_alglib.x_obj_free_minqpstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minqpstate.restype = None


class minqpstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minqpstate(self.ptr)


class x_minqpreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("inneriterationscount", x_int),
        ("outeriterationscount", x_int),
        ("nmv", x_int),
        ("ncholesky", x_int),
        ("terminationtype", x_int),
        ("lagbc", x_vector),
        ("laglc", x_vector)
        ]




class minqpreport(object):
    def __init__(self):
        self.inneriterationscount = 0
        self.outeriterationscount = 0
        self.nmv = 0
        self.ncholesky = 0
        self.terminationtype = 0
        self.lagbc = []
        self.laglc = []


def x_minqpreport_zero_fields(x):
    x.inneriterationscount.val = 0
    x.outeriterationscount.val = 0
    x.nmv.val = 0
    x.ncholesky.val = 0
    x.terminationtype.val = 0
    x.lagbc = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.laglc = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    return




def x_minqpreport_clear(x):
    x_vector_clear(x.lagbc)
    x_vector_clear(x.laglc)
    x_minqpreport_zero_fields(x)
    return




def x_from_minqpreport(x,v):
    x.inneriterationscount.val = int(v.inneriterationscount)
    x.outeriterationscount.val = int(v.outeriterationscount)
    x.nmv.val = int(v.nmv)
    x.ncholesky.val = int(v.ncholesky)
    x.terminationtype.val = int(v.terminationtype)
    x_from_list(x.lagbc, v.lagbc, DT_REAL, X_CREATE)
    x_from_list(x.laglc, v.laglc, DT_REAL, X_CREATE)
    return




def minqpreport_from_x(x):
    r = minqpreport()
    r.inneriterationscount = x.inneriterationscount.val
    r.outeriterationscount = x.outeriterationscount.val
    r.nmv = x.nmv.val
    r.ncholesky = x.ncholesky.val
    r.terminationtype = x.terminationtype.val
    r.lagbc = list_from_x(x.lagbc)
    r.laglc = list_from_x(x.laglc)
    return r


_lib_alglib.alglib_xv2_minqpcreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpcreate.restype = ctypes.c_int32
def minqpcreate(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpcreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpcreate'")
        __r__state = minqpstate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetlinearterm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlinearterm.restype = ctypes.c_int32
def minqpsetlinearterm(state, b):
    pass
    __state = state.ptr
    if not is_real_vector(b):
        raise ValueError("'b' parameter can't be cast to real_vector")
    __b = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__b, b, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlinearterm(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__b), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlinearterm'")
        return
    finally:
        x_vector_clear(__b)


_lib_alglib.alglib_xv2_minqpsetquadraticterm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetquadraticterm.restype = ctypes.c_int32
def minqpsetquadraticterm(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        state,a,isupper = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        state,a = functionargs
        isupper = False
    else:
        raise RuntimeError("Error while calling 'minqpsetquadraticterm': function must have 2 or 3 parameters")
    __state = state.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to symmetric")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        if __friendly_form:
            if not x_is_symmetric(__a):
                raise ValueError("'a' parameter is not symmetric matrix")
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetquadraticterm(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetquadraticterm'")
        return
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_minqpsetquadratictermsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetquadratictermsparse.restype = ctypes.c_int32
def minqpsetquadratictermsparse(state, a, isupper):
    pass
    __state = state.ptr
    __a = a.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetquadratictermsparse(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetquadratictermsparse'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetstartingpoint.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetstartingpoint.restype = ctypes.c_int32
def minqpsetstartingpoint(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetstartingpoint(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetstartingpoint'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minqpsetorigin.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetorigin.restype = ctypes.c_int32
def minqpsetorigin(state, xorigin):
    pass
    __state = state.ptr
    if not is_real_vector(xorigin):
        raise ValueError("'xorigin' parameter can't be cast to real_vector")
    __xorigin = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__xorigin, xorigin, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetorigin(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__xorigin), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetorigin'")
        return
    finally:
        x_vector_clear(__xorigin)


_lib_alglib.alglib_xv2_minqpsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetscale.restype = ctypes.c_int32
def minqpsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minqpsetscaleautodiag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetscaleautodiag.restype = ctypes.c_int32
def minqpsetscaleautodiag(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetscaleautodiag(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetscaleautodiag'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetalgobleic.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetalgobleic.restype = ctypes.c_int32
def minqpsetalgobleic(state, epsg, epsf, epsx, maxits):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetalgobleic(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetalgobleic'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetalgodenseaul.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetalgodenseaul.restype = ctypes.c_int32
def minqpsetalgodenseaul(state, epsx, rho, itscnt):
    pass
    __state = state.ptr
    __epsx = ctypes.c_double(epsx)
    __rho = ctypes.c_double(rho)
    __itscnt = x_int()
    __itscnt.val = int(itscnt)
    if __itscnt.val!=itscnt:
        raise ValueError("Error while converting 'itscnt' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetalgodenseaul(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsx), ctypes.byref(__rho), ctypes.byref(__itscnt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetalgodenseaul'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetalgodenseipm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetalgodenseipm.restype = ctypes.c_int32
def minqpsetalgodenseipm(state, eps):
    pass
    __state = state.ptr
    __eps = ctypes.c_double(eps)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetalgodenseipm(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__eps), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetalgodenseipm'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetalgosparseipm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetalgosparseipm.restype = ctypes.c_int32
def minqpsetalgosparseipm(state, eps):
    pass
    __state = state.ptr
    __eps = ctypes.c_double(eps)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetalgosparseipm(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__eps), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetalgosparseipm'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetalgoquickqp.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetalgoquickqp.restype = ctypes.c_int32
def minqpsetalgoquickqp(state, epsg, epsf, epsx, maxouterits, usenewton):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxouterits = x_int()
    __maxouterits.val = int(maxouterits)
    if __maxouterits.val!=maxouterits:
        raise ValueError("Error while converting 'maxouterits' parameter to 'x_int'")
    __usenewton = ctypes.c_uint64(usenewton)
    if __usenewton.value!=0:
        __usenewton = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetalgoquickqp(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxouterits), ctypes.byref(__usenewton), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetalgoquickqp'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetbc.restype = ctypes.c_int32
def minqpsetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minqpsetbcall.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetbcall.restype = ctypes.c_int32
def minqpsetbcall(state, bndl, bndu):
    pass
    __state = state.ptr
    __bndl = ctypes.c_double(bndl)
    __bndu = ctypes.c_double(bndu)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetbcall(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetbcall'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetbci.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetbci.restype = ctypes.c_int32
def minqpsetbci(state, i, bndl, bndu):
    pass
    __state = state.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __bndl = ctypes.c_double(bndl)
    __bndu = ctypes.c_double(bndu)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetbci(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__i), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetbci'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpsetlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlc.restype = ctypes.c_int32
def minqpsetlc(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        state,c,ct,k = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        state,c,ct = functionargs
        if safe_rows("'minqpsetlc': incorrect parameters",c)!=safe_len("'minqpsetlc': incorrect parameters",ct):
            raise RuntimeError("Error while calling 'minqpsetlc': looks like one of arguments has wrong size")
        k = safe_rows("'minqpsetlc': incorrect parameters",c)
    else:
        raise RuntimeError("Error while calling 'minqpsetlc': function must have 3 or 4 parameters")
    __state = state.ptr
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlc'")
        return
    finally:
        x_matrix_clear(__c)
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minqpsetlcsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlcsparse.restype = ctypes.c_int32
def minqpsetlcsparse(state, c, ct, k):
    pass
    __state = state.ptr
    __c = c.ptr
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlcsparse(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlcsparse'")
        return
    finally:
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minqpsetlcmixed.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlcmixed.restype = ctypes.c_int32
def minqpsetlcmixed(state, sparsec, sparsect, sparsek, densec, densect, densek):
    pass
    __state = state.ptr
    __sparsec = sparsec.ptr
    if not is_int_vector(sparsect):
        raise ValueError("'sparsect' parameter can't be cast to int_vector")
    __sparsect = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __sparsek = x_int()
    __sparsek.val = int(sparsek)
    if __sparsek.val!=sparsek:
        raise ValueError("Error while converting 'sparsek' parameter to 'x_int'")
    if not is_real_matrix(densec):
        raise ValueError("'densec' parameter can't be cast to real_matrix")
    __densec = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(densect):
        raise ValueError("'densect' parameter can't be cast to int_vector")
    __densect = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __densek = x_int()
    __densek.val = int(densek)
    if __densek.val!=densek:
        raise ValueError("Error while converting 'densek' parameter to 'x_int'")
    try:
        x_from_list(__sparsect, sparsect, DT_INT, X_CREATE)
        x_from_listlist(__densec, densec, DT_REAL, X_CREATE)
        x_from_list(__densect, densect, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlcmixed(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__sparsec), ctypes.byref(__sparsect), ctypes.byref(__sparsek), ctypes.byref(__densec), ctypes.byref(__densect), ctypes.byref(__densek), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlcmixed'")
        return
    finally:
        x_vector_clear(__sparsect)
        x_matrix_clear(__densec)
        x_vector_clear(__densect)


_lib_alglib.alglib_xv2_minqpsetlcmixedlegacy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlcmixedlegacy.restype = ctypes.c_int32
def minqpsetlcmixedlegacy(state, densec, densect, densek, sparsec, sparsect, sparsek):
    pass
    __state = state.ptr
    if not is_real_matrix(densec):
        raise ValueError("'densec' parameter can't be cast to real_matrix")
    __densec = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(densect):
        raise ValueError("'densect' parameter can't be cast to int_vector")
    __densect = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __densek = x_int()
    __densek.val = int(densek)
    if __densek.val!=densek:
        raise ValueError("Error while converting 'densek' parameter to 'x_int'")
    __sparsec = sparsec.ptr
    if not is_int_vector(sparsect):
        raise ValueError("'sparsect' parameter can't be cast to int_vector")
    __sparsect = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __sparsek = x_int()
    __sparsek.val = int(sparsek)
    if __sparsek.val!=sparsek:
        raise ValueError("Error while converting 'sparsek' parameter to 'x_int'")
    try:
        x_from_listlist(__densec, densec, DT_REAL, X_CREATE)
        x_from_list(__densect, densect, DT_INT, X_CREATE)
        x_from_list(__sparsect, sparsect, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlcmixedlegacy(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__densec), ctypes.byref(__densect), ctypes.byref(__densek), ctypes.byref(__sparsec), ctypes.byref(__sparsect), ctypes.byref(__sparsek), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlcmixedlegacy'")
        return
    finally:
        x_matrix_clear(__densec)
        x_vector_clear(__densect)
        x_vector_clear(__sparsect)


_lib_alglib.alglib_xv2_minqpsetlc2dense.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlc2dense.restype = ctypes.c_int32
def minqpsetlc2dense(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        state,a,al,au,k = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        state,a,al,au = functionargs
        if safe_rows("'minqpsetlc2dense': incorrect parameters",a)!=safe_len("'minqpsetlc2dense': incorrect parameters",al) or safe_rows("'minqpsetlc2dense': incorrect parameters",a)!=safe_len("'minqpsetlc2dense': incorrect parameters",au):
            raise RuntimeError("Error while calling 'minqpsetlc2dense': looks like one of arguments has wrong size")
        k = safe_rows("'minqpsetlc2dense': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'minqpsetlc2dense': function must have 4 or 5 parameters")
    __state = state.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(al):
        raise ValueError("'al' parameter can't be cast to real_vector")
    __al = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(au):
        raise ValueError("'au' parameter can't be cast to real_vector")
    __au = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__al, al, DT_REAL, X_CREATE)
        x_from_list(__au, au, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlc2dense(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__al), ctypes.byref(__au), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlc2dense'")
        return
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__al)
        x_vector_clear(__au)


_lib_alglib.alglib_xv2_minqpsetlc2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlc2.restype = ctypes.c_int32
def minqpsetlc2(state, a, al, au, k):
    pass
    __state = state.ptr
    __a = a.ptr
    if not is_real_vector(al):
        raise ValueError("'al' parameter can't be cast to real_vector")
    __al = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(au):
        raise ValueError("'au' parameter can't be cast to real_vector")
    __au = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_list(__al, al, DT_REAL, X_CREATE)
        x_from_list(__au, au, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlc2(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__al), ctypes.byref(__au), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlc2'")
        return
    finally:
        x_vector_clear(__al)
        x_vector_clear(__au)


_lib_alglib.alglib_xv2_minqpsetlc2mixed.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpsetlc2mixed.restype = ctypes.c_int32
def minqpsetlc2mixed(state, sparsea, ksparse, densea, kdense, al, au):
    pass
    __state = state.ptr
    __sparsea = sparsea.ptr
    __ksparse = x_int()
    __ksparse.val = int(ksparse)
    if __ksparse.val!=ksparse:
        raise ValueError("Error while converting 'ksparse' parameter to 'x_int'")
    if not is_real_matrix(densea):
        raise ValueError("'densea' parameter can't be cast to real_matrix")
    __densea = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __kdense = x_int()
    __kdense.val = int(kdense)
    if __kdense.val!=kdense:
        raise ValueError("Error while converting 'kdense' parameter to 'x_int'")
    if not is_real_vector(al):
        raise ValueError("'al' parameter can't be cast to real_vector")
    __al = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(au):
        raise ValueError("'au' parameter can't be cast to real_vector")
    __au = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__densea, densea, DT_REAL, X_CREATE)
        x_from_list(__al, al, DT_REAL, X_CREATE)
        x_from_list(__au, au, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpsetlc2mixed(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__sparsea), ctypes.byref(__ksparse), ctypes.byref(__densea), ctypes.byref(__kdense), ctypes.byref(__al), ctypes.byref(__au), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpsetlc2mixed'")
        return
    finally:
        x_matrix_clear(__densea)
        x_vector_clear(__al)
        x_vector_clear(__au)


_lib_alglib.alglib_xv2_minqpaddlc2dense.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpaddlc2dense.restype = ctypes.c_int32
def minqpaddlc2dense(state, a, al, au):
    pass
    __state = state.ptr
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __al = ctypes.c_double(al)
    __au = ctypes.c_double(au)
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpaddlc2dense(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__al), ctypes.byref(__au), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpaddlc2dense'")
        return
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_minqpaddlc2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpaddlc2.restype = ctypes.c_int32
def minqpaddlc2(state, idxa, vala, nnz, al, au):
    pass
    __state = state.ptr
    if not is_int_vector(idxa):
        raise ValueError("'idxa' parameter can't be cast to int_vector")
    __idxa = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(vala):
        raise ValueError("'vala' parameter can't be cast to real_vector")
    __vala = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nnz = x_int()
    __nnz.val = int(nnz)
    if __nnz.val!=nnz:
        raise ValueError("Error while converting 'nnz' parameter to 'x_int'")
    __al = ctypes.c_double(al)
    __au = ctypes.c_double(au)
    try:
        x_from_list(__idxa, idxa, DT_INT, X_CREATE)
        x_from_list(__vala, vala, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpaddlc2(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__idxa), ctypes.byref(__vala), ctypes.byref(__nnz), ctypes.byref(__al), ctypes.byref(__au), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpaddlc2'")
        return
    finally:
        x_vector_clear(__idxa)
        x_vector_clear(__vala)


_lib_alglib.alglib_xv2_minqpoptimize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpoptimize.restype = ctypes.c_int32
def minqpoptimize(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpoptimize(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpoptimize'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minqpresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpresults.restype = ctypes.c_int32
def minqpresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minqpreport()
    x_minqpreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpresults'")
        __r__x = list_from_x(__x)
        __r__rep = minqpreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minqpreport_clear(__rep)


_lib_alglib.alglib_xv2_minqpresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minqpresultsbuf.restype = ctypes.c_int32
def minqpresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minqpreport()
    x_minqpreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minqpreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minqpresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minqpresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minqpreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minqpreport_clear(__rep)


_lib_alglib.x_obj_free_minlpstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minlpstate.restype = None


class minlpstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minlpstate(self.ptr)


class x_minlpreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("f", ctypes.c_double),
        ("y", x_vector),
        ("stats", x_vector),
        ("primalerror", ctypes.c_double),
        ("dualerror", ctypes.c_double),
        ("iterationscount", x_int),
        ("terminationtype", x_int)
        ]




class minlpreport(object):
    def __init__(self):
        self.f = 0
        self.y = []
        self.stats = []
        self.primalerror = 0
        self.dualerror = 0
        self.iterationscount = 0
        self.terminationtype = 0


def x_minlpreport_zero_fields(x):
    x.f = 0
    x.y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.stats = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.primalerror = 0
    x.dualerror = 0
    x.iterationscount.val = 0
    x.terminationtype.val = 0
    return




def x_minlpreport_clear(x):
    x_vector_clear(x.y)
    x_vector_clear(x.stats)
    x_minlpreport_zero_fields(x)
    return




def x_from_minlpreport(x,v):
    x.f = float(v.f)
    x_from_list(x.y, v.y, DT_REAL, X_CREATE)
    x_from_list(x.stats, v.stats, DT_INT, X_CREATE)
    x.primalerror = float(v.primalerror)
    x.dualerror = float(v.dualerror)
    x.iterationscount.val = int(v.iterationscount)
    x.terminationtype.val = int(v.terminationtype)
    return




def minlpreport_from_x(x):
    r = minlpreport()
    r.f = x.f
    r.y = list_from_x(x.y)
    r.stats = list_from_x(x.stats)
    r.primalerror = x.primalerror
    r.dualerror = x.dualerror
    r.iterationscount = x.iterationscount.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_minlpcreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpcreate.restype = ctypes.c_int32
def minlpcreate(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpcreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpcreate'")
        __r__state = minlpstate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_minlpsetcost.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetcost.restype = ctypes.c_int32
def minlpsetcost(state, c):
    pass
    __state = state.ptr
    if not is_real_vector(c):
        raise ValueError("'c' parameter can't be cast to real_vector")
    __c = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__c, c, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetcost(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetcost'")
        return
    finally:
        x_vector_clear(__c)


_lib_alglib.alglib_xv2_minlpsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetscale.restype = ctypes.c_int32
def minlpsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minlpsetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetbc.restype = ctypes.c_int32
def minlpsetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minlpsetbcall.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetbcall.restype = ctypes.c_int32
def minlpsetbcall(state, bndl, bndu):
    pass
    __state = state.ptr
    __bndl = ctypes.c_double(bndl)
    __bndu = ctypes.c_double(bndu)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetbcall(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetbcall'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlpsetbci.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetbci.restype = ctypes.c_int32
def minlpsetbci(state, i, bndl, bndu):
    pass
    __state = state.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __bndl = ctypes.c_double(bndl)
    __bndu = ctypes.c_double(bndu)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetbci(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__i), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetbci'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlpsetlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetlc.restype = ctypes.c_int32
def minlpsetlc(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        state,a,ct,k = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        state,a,ct = functionargs
        if safe_rows("'minlpsetlc': incorrect parameters",a)!=safe_len("'minlpsetlc': incorrect parameters",ct):
            raise RuntimeError("Error while calling 'minlpsetlc': looks like one of arguments has wrong size")
        k = safe_rows("'minlpsetlc': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'minlpsetlc': function must have 3 or 4 parameters")
    __state = state.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetlc'")
        return
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minlpsetlc2dense.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetlc2dense.restype = ctypes.c_int32
def minlpsetlc2dense(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        state,a,al,au,k = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        state,a,al,au = functionargs
        if safe_rows("'minlpsetlc2dense': incorrect parameters",a)!=safe_len("'minlpsetlc2dense': incorrect parameters",al) or safe_rows("'minlpsetlc2dense': incorrect parameters",a)!=safe_len("'minlpsetlc2dense': incorrect parameters",au):
            raise RuntimeError("Error while calling 'minlpsetlc2dense': looks like one of arguments has wrong size")
        k = safe_rows("'minlpsetlc2dense': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'minlpsetlc2dense': function must have 4 or 5 parameters")
    __state = state.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(al):
        raise ValueError("'al' parameter can't be cast to real_vector")
    __al = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(au):
        raise ValueError("'au' parameter can't be cast to real_vector")
    __au = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        x_from_list(__al, al, DT_REAL, X_CREATE)
        x_from_list(__au, au, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetlc2dense(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__al), ctypes.byref(__au), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetlc2dense'")
        return
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__al)
        x_vector_clear(__au)


_lib_alglib.alglib_xv2_minlpsetlc2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpsetlc2.restype = ctypes.c_int32
def minlpsetlc2(state, a, al, au, k):
    pass
    __state = state.ptr
    __a = a.ptr
    if not is_real_vector(al):
        raise ValueError("'al' parameter can't be cast to real_vector")
    __al = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(au):
        raise ValueError("'au' parameter can't be cast to real_vector")
    __au = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_list(__al, al, DT_REAL, X_CREATE)
        x_from_list(__au, au, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpsetlc2(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__al), ctypes.byref(__au), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpsetlc2'")
        return
    finally:
        x_vector_clear(__al)
        x_vector_clear(__au)


_lib_alglib.alglib_xv2_minlpaddlc2dense.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpaddlc2dense.restype = ctypes.c_int32
def minlpaddlc2dense(state, a, al, au):
    pass
    __state = state.ptr
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __al = ctypes.c_double(al)
    __au = ctypes.c_double(au)
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpaddlc2dense(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__al), ctypes.byref(__au), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpaddlc2dense'")
        return
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_minlpaddlc2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpaddlc2.restype = ctypes.c_int32
def minlpaddlc2(state, idxa, vala, nnz, al, au):
    pass
    __state = state.ptr
    if not is_int_vector(idxa):
        raise ValueError("'idxa' parameter can't be cast to int_vector")
    __idxa = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(vala):
        raise ValueError("'vala' parameter can't be cast to real_vector")
    __vala = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nnz = x_int()
    __nnz.val = int(nnz)
    if __nnz.val!=nnz:
        raise ValueError("Error while converting 'nnz' parameter to 'x_int'")
    __al = ctypes.c_double(al)
    __au = ctypes.c_double(au)
    try:
        x_from_list(__idxa, idxa, DT_INT, X_CREATE)
        x_from_list(__vala, vala, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpaddlc2(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__idxa), ctypes.byref(__vala), ctypes.byref(__nnz), ctypes.byref(__al), ctypes.byref(__au), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpaddlc2'")
        return
    finally:
        x_vector_clear(__idxa)
        x_vector_clear(__vala)


_lib_alglib.alglib_xv2_minlpoptimize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpoptimize.restype = ctypes.c_int32
def minlpoptimize(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpoptimize(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpoptimize'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlpresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpresults.restype = ctypes.c_int32
def minlpresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minlpreport()
    x_minlpreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpresults'")
        __r__x = list_from_x(__x)
        __r__rep = minlpreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minlpreport_clear(__rep)


_lib_alglib.alglib_xv2_minlpresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlpresultsbuf.restype = ctypes.c_int32
def minlpresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minlpreport()
    x_minlpreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minlpreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlpresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlpresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minlpreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minlpreport_clear(__rep)


_lib_alglib.x_obj_free_minnlcstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minnlcstate.restype = None
_lib_alglib.x_minnlcstate_get_needfi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_needfi.restype = None
_lib_alglib.x_minnlcstate_set_needfi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_set_needfi.restype = None
_lib_alglib.x_minnlcstate_get_needfij.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_needfij.restype = None
_lib_alglib.x_minnlcstate_set_needfij.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_set_needfij.restype = None
_lib_alglib.x_minnlcstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_xupdated.restype = None
_lib_alglib.x_minnlcstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_set_xupdated.restype = None
_lib_alglib.x_minnlcstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_f.restype = None
_lib_alglib.x_minnlcstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_set_f.restype = None
_lib_alglib.x_minnlcstate_get_fi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_fi.restype = None
_lib_alglib.x_minnlcstate_get_j.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_j.restype = None
_lib_alglib.x_minnlcstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnlcstate_get_x.restype = None


class minnlcstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minnlcstate(self.ptr)


class x_minnlcreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("terminationtype", x_int),
        ("bcerr", ctypes.c_double),
        ("bcidx", x_int),
        ("lcerr", ctypes.c_double),
        ("lcidx", x_int),
        ("nlcerr", ctypes.c_double),
        ("nlcidx", x_int),
        ("dbgphase0its", x_int)
        ]




class minnlcreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.terminationtype = 0
        self.bcerr = 0
        self.bcidx = 0
        self.lcerr = 0
        self.lcidx = 0
        self.nlcerr = 0
        self.nlcidx = 0
        self.dbgphase0its = 0


def x_minnlcreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.terminationtype.val = 0
    x.bcerr = 0
    x.bcidx.val = 0
    x.lcerr = 0
    x.lcidx.val = 0
    x.nlcerr = 0
    x.nlcidx.val = 0
    x.dbgphase0its.val = 0
    return




def x_minnlcreport_clear(x):
    x_minnlcreport_zero_fields(x)
    return




def x_from_minnlcreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.terminationtype.val = int(v.terminationtype)
    x.bcerr = float(v.bcerr)
    x.bcidx.val = int(v.bcidx)
    x.lcerr = float(v.lcerr)
    x.lcidx.val = int(v.lcidx)
    x.nlcerr = float(v.nlcerr)
    x.nlcidx.val = int(v.nlcidx)
    x.dbgphase0its.val = int(v.dbgphase0its)
    return




def minnlcreport_from_x(x):
    r = minnlcreport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.terminationtype = x.terminationtype.val
    r.bcerr = x.bcerr
    r.bcidx = x.bcidx.val
    r.lcerr = x.lcerr
    r.lcidx = x.lcidx.val
    r.nlcerr = x.nlcerr
    r.nlcidx = x.nlcidx.val
    r.dbgphase0its = x.dbgphase0its.val
    return r


_lib_alglib.alglib_xv2_minnlccreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlccreate.restype = ctypes.c_int32
def minnlccreate(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        n,x = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'minnlccreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minnlccreate': function must have 1 or 2 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlccreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlccreate'")
        __r__state = minnlcstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minnlccreatef.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlccreatef.restype = ctypes.c_int32
def minnlccreatef(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,x,diffstep = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,diffstep = functionargs
        n = safe_len("'minnlccreatef': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minnlccreatef': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlccreatef(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlccreatef'")
        __r__state = minnlcstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minnlcsetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetbc.restype = ctypes.c_int32
def minnlcsetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minnlcsetlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetlc.restype = ctypes.c_int32
def minnlcsetlc(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        state,c,ct,k = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        state,c,ct = functionargs
        if safe_rows("'minnlcsetlc': incorrect parameters",c)!=safe_len("'minnlcsetlc': incorrect parameters",ct):
            raise RuntimeError("Error while calling 'minnlcsetlc': looks like one of arguments has wrong size")
        k = safe_rows("'minnlcsetlc': incorrect parameters",c)
    else:
        raise RuntimeError("Error while calling 'minnlcsetlc': function must have 3 or 4 parameters")
    __state = state.ptr
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetlc'")
        return
    finally:
        x_matrix_clear(__c)
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minnlcsetnlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetnlc.restype = ctypes.c_int32
def minnlcsetnlc(state, nlec, nlic):
    pass
    __state = state.ptr
    __nlec = x_int()
    __nlec.val = int(nlec)
    if __nlec.val!=nlec:
        raise ValueError("Error while converting 'nlec' parameter to 'x_int'")
    __nlic = x_int()
    __nlic.val = int(nlic)
    if __nlic.val!=nlic:
        raise ValueError("Error while converting 'nlic' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetnlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__nlec), ctypes.byref(__nlic), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetnlc'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetcond.restype = ctypes.c_int32
def minnlcsetcond(state, epsx, maxits):
    pass
    __state = state.ptr
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetscale.restype = ctypes.c_int32
def minnlcsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minnlcsetprecinexact.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetprecinexact.restype = ctypes.c_int32
def minnlcsetprecinexact(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetprecinexact(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetprecinexact'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetprecexactlowrank.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetprecexactlowrank.restype = ctypes.c_int32
def minnlcsetprecexactlowrank(state, updatefreq):
    pass
    __state = state.ptr
    __updatefreq = x_int()
    __updatefreq.val = int(updatefreq)
    if __updatefreq.val!=updatefreq:
        raise ValueError("Error while converting 'updatefreq' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetprecexactlowrank(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__updatefreq), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetprecexactlowrank'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetprecexactrobust.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetprecexactrobust.restype = ctypes.c_int32
def minnlcsetprecexactrobust(state, updatefreq):
    pass
    __state = state.ptr
    __updatefreq = x_int()
    __updatefreq.val = int(updatefreq)
    if __updatefreq.val!=updatefreq:
        raise ValueError("Error while converting 'updatefreq' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetprecexactrobust(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__updatefreq), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetprecexactrobust'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetprecnone.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetprecnone.restype = ctypes.c_int32
def minnlcsetprecnone(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetprecnone(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetprecnone'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetstpmax.restype = ctypes.c_int32
def minnlcsetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetstpmax'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetalgoaul.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetalgoaul.restype = ctypes.c_int32
def minnlcsetalgoaul(state, rho, itscnt):
    pass
    __state = state.ptr
    __rho = ctypes.c_double(rho)
    __itscnt = x_int()
    __itscnt.val = int(itscnt)
    if __itscnt.val!=itscnt:
        raise ValueError("Error while converting 'itscnt' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetalgoaul(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rho), ctypes.byref(__itscnt), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetalgoaul'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetalgoslp.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetalgoslp.restype = ctypes.c_int32
def minnlcsetalgoslp(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetalgoslp(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetalgoslp'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetalgosqp.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetalgosqp.restype = ctypes.c_int32
def minnlcsetalgosqp(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetalgosqp(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetalgosqp'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcsetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcsetxrep.restype = ctypes.c_int32
def minnlcsetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcsetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcsetxrep'")
        return
    finally:
        pass




def minnlcoptimize_v(state, fvec, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minnlcstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_fi  = x_vector()
    _lib_alglib.x_minnlcstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minnlciteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlciteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minnlcstate_get_needfi(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            fvec(_py_x, _py_fi, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minnlcstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minnlcstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minnlcoptimize' (some derivatives were not provided?)")
    return


def minnlcoptimize_j(state, jac, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minnlcstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_fi  = x_vector()
    _lib_alglib.x_minnlcstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    _xc_j  = x_matrix()
    _lib_alglib.x_minnlcstate_get_j(state.ptr, ctypes.byref(_xc_j))
    _py_j = create_real_matrix(_xc_j.rows,_xc_j.cols)
    while True:
        retval = _lib_alglib.alglib_xv2_minnlciteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlciteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minnlcstate_get_needfij(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            jac(_py_x, _py_fi, _py_j, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            x_from_listlist(_xc_j, _py_j, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minnlcstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minnlcstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minnlcoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minnlcoptguardgradient.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcoptguardgradient.restype = ctypes.c_int32
def minnlcoptguardgradient(state, teststep):
    pass
    __state = state.ptr
    __teststep = ctypes.c_double(teststep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcoptguardgradient(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__teststep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcoptguardgradient'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcoptguardsmoothness.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcoptguardsmoothness.restype = ctypes.c_int32
def minnlcoptguardsmoothness(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        state,level = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        state, = functionargs
        level = 1
    else:
        raise RuntimeError("Error while calling 'minnlcoptguardsmoothness': function must have 1 or 2 parameters")
    __state = state.ptr
    __level = x_int()
    __level.val = int(level)
    if __level.val!=level:
        raise ValueError("Error while converting 'level' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcoptguardsmoothness(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__level), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcoptguardsmoothness'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcoptguardresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcoptguardresults.restype = ctypes.c_int32
def minnlcoptguardresults(state):
    pass
    __state = state.ptr
    __rep = x_optguardreport()
    x_optguardreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcoptguardresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcoptguardresults'")
        __r__rep = optguardreport_from_x(__rep)
        return __r__rep
    finally:
        x_optguardreport_clear(__rep)


_lib_alglib.alglib_xv2_minnlcoptguardnonc1test0results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcoptguardnonc1test0results.restype = ctypes.c_int32
def minnlcoptguardnonc1test0results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcoptguardnonc1test0results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcoptguardnonc1test0results'")
        __r__strrep = optguardnonc1test0report_from_x(__strrep)
        __r__lngrep = optguardnonc1test0report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test0report_clear(__strrep)
        x_optguardnonc1test0report_clear(__lngrep)


_lib_alglib.alglib_xv2_minnlcoptguardnonc1test1results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcoptguardnonc1test1results.restype = ctypes.c_int32
def minnlcoptguardnonc1test1results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcoptguardnonc1test1results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcoptguardnonc1test1results'")
        __r__strrep = optguardnonc1test1report_from_x(__strrep)
        __r__lngrep = optguardnonc1test1report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test1report_clear(__strrep)
        x_optguardnonc1test1report_clear(__lngrep)


_lib_alglib.alglib_xv2_minnlcresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcresults.restype = ctypes.c_int32
def minnlcresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minnlcreport()
    x_minnlcreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcresults'")
        __r__x = list_from_x(__x)
        __r__rep = minnlcreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minnlcreport_clear(__rep)


_lib_alglib.alglib_xv2_minnlcresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcresultsbuf.restype = ctypes.c_int32
def minnlcresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minnlcreport()
    x_minnlcreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minnlcreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minnlcreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minnlcreport_clear(__rep)


_lib_alglib.alglib_xv2_minnlcrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcrequesttermination.restype = ctypes.c_int32
def minnlcrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcrequesttermination'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnlcrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnlcrestartfrom.restype = ctypes.c_int32
def minnlcrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnlcrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnlcrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.x_obj_free_minbcstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minbcstate.restype = None
_lib_alglib.x_minbcstate_get_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_get_needf.restype = None
_lib_alglib.x_minbcstate_set_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_set_needf.restype = None
_lib_alglib.x_minbcstate_get_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_get_needfg.restype = None
_lib_alglib.x_minbcstate_set_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_set_needfg.restype = None
_lib_alglib.x_minbcstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_get_xupdated.restype = None
_lib_alglib.x_minbcstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_set_xupdated.restype = None
_lib_alglib.x_minbcstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_get_f.restype = None
_lib_alglib.x_minbcstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_set_f.restype = None
_lib_alglib.x_minbcstate_get_g.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_get_g.restype = None
_lib_alglib.x_minbcstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minbcstate_get_x.restype = None


class minbcstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minbcstate(self.ptr)


class x_minbcreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("varidx", x_int),
        ("terminationtype", x_int)
        ]




class minbcreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.varidx = 0
        self.terminationtype = 0


def x_minbcreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.varidx.val = 0
    x.terminationtype.val = 0
    return




def x_minbcreport_clear(x):
    x_minbcreport_zero_fields(x)
    return




def x_from_minbcreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.varidx.val = int(v.varidx)
    x.terminationtype.val = int(v.terminationtype)
    return




def minbcreport_from_x(x):
    r = minbcreport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.varidx = x.varidx.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_minbccreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbccreate.restype = ctypes.c_int32
def minbccreate(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        n,x = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'minbccreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minbccreate': function must have 1 or 2 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbccreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbccreate'")
        __r__state = minbcstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minbccreatef.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbccreatef.restype = ctypes.c_int32
def minbccreatef(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,x,diffstep = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,diffstep = functionargs
        n = safe_len("'minbccreatef': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minbccreatef': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbccreatef(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbccreatef'")
        __r__state = minbcstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minbcsetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetbc.restype = ctypes.c_int32
def minbcsetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minbcsetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetcond.restype = ctypes.c_int32
def minbcsetcond(state, epsg, epsf, epsx, maxits):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbcsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetscale.restype = ctypes.c_int32
def minbcsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minbcsetprecdefault.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetprecdefault.restype = ctypes.c_int32
def minbcsetprecdefault(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetprecdefault(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetprecdefault'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbcsetprecdiag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetprecdiag.restype = ctypes.c_int32
def minbcsetprecdiag(state, d):
    pass
    __state = state.ptr
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetprecdiag(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__d), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetprecdiag'")
        return
    finally:
        x_vector_clear(__d)


_lib_alglib.alglib_xv2_minbcsetprecscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetprecscale.restype = ctypes.c_int32
def minbcsetprecscale(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetprecscale(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetprecscale'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbcsetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetxrep.restype = ctypes.c_int32
def minbcsetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbcsetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcsetstpmax.restype = ctypes.c_int32
def minbcsetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcsetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcsetstpmax'")
        return
    finally:
        pass




def minbcoptimize_f(state, func, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minbcstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    while True:
        retval = _lib_alglib.alglib_xv2_minbciteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbciteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minbcstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_minbcstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_minbcstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minbcstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minbcoptimize' (some derivatives were not provided?)")
    return


def minbcoptimize_g(state, grad, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minbcstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_minbcstate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minbciteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbciteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minbcstate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_minbcstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minbcstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minbcstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minbcoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minbcoptguardgradient.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcoptguardgradient.restype = ctypes.c_int32
def minbcoptguardgradient(state, teststep):
    pass
    __state = state.ptr
    __teststep = ctypes.c_double(teststep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcoptguardgradient(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__teststep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcoptguardgradient'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbcoptguardsmoothness.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcoptguardsmoothness.restype = ctypes.c_int32
def minbcoptguardsmoothness(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        state,level = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        state, = functionargs
        level = 1
    else:
        raise RuntimeError("Error while calling 'minbcoptguardsmoothness': function must have 1 or 2 parameters")
    __state = state.ptr
    __level = x_int()
    __level.val = int(level)
    if __level.val!=level:
        raise ValueError("Error while converting 'level' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcoptguardsmoothness(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__level), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcoptguardsmoothness'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbcoptguardresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcoptguardresults.restype = ctypes.c_int32
def minbcoptguardresults(state):
    pass
    __state = state.ptr
    __rep = x_optguardreport()
    x_optguardreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcoptguardresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcoptguardresults'")
        __r__rep = optguardreport_from_x(__rep)
        return __r__rep
    finally:
        x_optguardreport_clear(__rep)


_lib_alglib.alglib_xv2_minbcoptguardnonc1test0results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcoptguardnonc1test0results.restype = ctypes.c_int32
def minbcoptguardnonc1test0results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcoptguardnonc1test0results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcoptguardnonc1test0results'")
        __r__strrep = optguardnonc1test0report_from_x(__strrep)
        __r__lngrep = optguardnonc1test0report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test0report_clear(__strrep)
        x_optguardnonc1test0report_clear(__lngrep)


_lib_alglib.alglib_xv2_minbcoptguardnonc1test1results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcoptguardnonc1test1results.restype = ctypes.c_int32
def minbcoptguardnonc1test1results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcoptguardnonc1test1results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcoptguardnonc1test1results'")
        __r__strrep = optguardnonc1test1report_from_x(__strrep)
        __r__lngrep = optguardnonc1test1report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test1report_clear(__strrep)
        x_optguardnonc1test1report_clear(__lngrep)


_lib_alglib.alglib_xv2_minbcresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcresults.restype = ctypes.c_int32
def minbcresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minbcreport()
    x_minbcreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcresults'")
        __r__x = list_from_x(__x)
        __r__rep = minbcreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minbcreport_clear(__rep)


_lib_alglib.alglib_xv2_minbcresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcresultsbuf.restype = ctypes.c_int32
def minbcresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minbcreport()
    x_minbcreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minbcreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minbcreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minbcreport_clear(__rep)


_lib_alglib.alglib_xv2_minbcrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcrestartfrom.restype = ctypes.c_int32
def minbcrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minbcrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbcrequesttermination.restype = ctypes.c_int32
def minbcrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbcrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbcrequesttermination'")
        return
    finally:
        pass


_lib_alglib.x_obj_free_minnsstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minnsstate.restype = None
_lib_alglib.x_minnsstate_get_needfi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_needfi.restype = None
_lib_alglib.x_minnsstate_set_needfi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_set_needfi.restype = None
_lib_alglib.x_minnsstate_get_needfij.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_needfij.restype = None
_lib_alglib.x_minnsstate_set_needfij.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_set_needfij.restype = None
_lib_alglib.x_minnsstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_xupdated.restype = None
_lib_alglib.x_minnsstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_set_xupdated.restype = None
_lib_alglib.x_minnsstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_f.restype = None
_lib_alglib.x_minnsstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_set_f.restype = None
_lib_alglib.x_minnsstate_get_fi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_fi.restype = None
_lib_alglib.x_minnsstate_get_j.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_j.restype = None
_lib_alglib.x_minnsstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minnsstate_get_x.restype = None


class minnsstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minnsstate(self.ptr)


class x_minnsreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("cerr", ctypes.c_double),
        ("lcerr", ctypes.c_double),
        ("nlcerr", ctypes.c_double),
        ("terminationtype", x_int),
        ("varidx", x_int),
        ("funcidx", x_int)
        ]




class minnsreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.cerr = 0
        self.lcerr = 0
        self.nlcerr = 0
        self.terminationtype = 0
        self.varidx = 0
        self.funcidx = 0


def x_minnsreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.cerr = 0
    x.lcerr = 0
    x.nlcerr = 0
    x.terminationtype.val = 0
    x.varidx.val = 0
    x.funcidx.val = 0
    return




def x_minnsreport_clear(x):
    x_minnsreport_zero_fields(x)
    return




def x_from_minnsreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.cerr = float(v.cerr)
    x.lcerr = float(v.lcerr)
    x.nlcerr = float(v.nlcerr)
    x.terminationtype.val = int(v.terminationtype)
    x.varidx.val = int(v.varidx)
    x.funcidx.val = int(v.funcidx)
    return




def minnsreport_from_x(x):
    r = minnsreport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.cerr = x.cerr
    r.lcerr = x.lcerr
    r.nlcerr = x.nlcerr
    r.terminationtype = x.terminationtype.val
    r.varidx = x.varidx.val
    r.funcidx = x.funcidx.val
    return r


_lib_alglib.alglib_xv2_minnscreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnscreate.restype = ctypes.c_int32
def minnscreate(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        n,x = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'minnscreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minnscreate': function must have 1 or 2 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnscreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnscreate'")
        __r__state = minnsstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minnscreatef.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnscreatef.restype = ctypes.c_int32
def minnscreatef(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,x,diffstep = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,diffstep = functionargs
        n = safe_len("'minnscreatef': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minnscreatef': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnscreatef(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnscreatef'")
        __r__state = minnsstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minnssetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetbc.restype = ctypes.c_int32
def minnssetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minnssetlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetlc.restype = ctypes.c_int32
def minnssetlc(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        state,c,ct,k = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        state,c,ct = functionargs
        if safe_rows("'minnssetlc': incorrect parameters",c)!=safe_len("'minnssetlc': incorrect parameters",ct):
            raise RuntimeError("Error while calling 'minnssetlc': looks like one of arguments has wrong size")
        k = safe_rows("'minnssetlc': incorrect parameters",c)
    else:
        raise RuntimeError("Error while calling 'minnssetlc': function must have 3 or 4 parameters")
    __state = state.ptr
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetlc'")
        return
    finally:
        x_matrix_clear(__c)
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minnssetnlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetnlc.restype = ctypes.c_int32
def minnssetnlc(state, nlec, nlic):
    pass
    __state = state.ptr
    __nlec = x_int()
    __nlec.val = int(nlec)
    if __nlec.val!=nlec:
        raise ValueError("Error while converting 'nlec' parameter to 'x_int'")
    __nlic = x_int()
    __nlic.val = int(nlic)
    if __nlic.val!=nlic:
        raise ValueError("Error while converting 'nlic' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetnlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__nlec), ctypes.byref(__nlic), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetnlc'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnssetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetcond.restype = ctypes.c_int32
def minnssetcond(state, epsx, maxits):
    pass
    __state = state.ptr
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnssetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetscale.restype = ctypes.c_int32
def minnssetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minnssetalgoags.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetalgoags.restype = ctypes.c_int32
def minnssetalgoags(state, radius, penalty):
    pass
    __state = state.ptr
    __radius = ctypes.c_double(radius)
    __penalty = ctypes.c_double(penalty)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetalgoags(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__radius), ctypes.byref(__penalty), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetalgoags'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnssetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnssetxrep.restype = ctypes.c_int32
def minnssetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnssetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnssetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minnsrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnsrequesttermination.restype = ctypes.c_int32
def minnsrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnsrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnsrequesttermination'")
        return
    finally:
        pass




def minnsoptimize_v(state, fvec, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minnsstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_fi  = x_vector()
    _lib_alglib.x_minnsstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minnsiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnsiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minnsstate_get_needfi(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            fvec(_py_x, _py_fi, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minnsstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minnsstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minnsoptimize' (some derivatives were not provided?)")
    return


def minnsoptimize_j(state, jac, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minnsstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_fi  = x_vector()
    _lib_alglib.x_minnsstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    _xc_j  = x_matrix()
    _lib_alglib.x_minnsstate_get_j(state.ptr, ctypes.byref(_xc_j))
    _py_j = create_real_matrix(_xc_j.rows,_xc_j.cols)
    while True:
        retval = _lib_alglib.alglib_xv2_minnsiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnsiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minnsstate_get_needfij(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            jac(_py_x, _py_fi, _py_j, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            x_from_listlist(_xc_j, _py_j, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minnsstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minnsstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minnsoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minnsresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnsresults.restype = ctypes.c_int32
def minnsresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minnsreport()
    x_minnsreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnsresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnsresults'")
        __r__x = list_from_x(__x)
        __r__rep = minnsreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minnsreport_clear(__rep)


_lib_alglib.alglib_xv2_minnsresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnsresultsbuf.restype = ctypes.c_int32
def minnsresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minnsreport()
    x_minnsreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minnsreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnsresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnsresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minnsreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minnsreport_clear(__rep)


_lib_alglib.alglib_xv2_minnsrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minnsrestartfrom.restype = ctypes.c_int32
def minnsrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minnsrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minnsrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.x_obj_free_minasastate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minasastate.restype = None
_lib_alglib.x_minasastate_get_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_get_needfg.restype = None
_lib_alglib.x_minasastate_set_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_set_needfg.restype = None
_lib_alglib.x_minasastate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_get_xupdated.restype = None
_lib_alglib.x_minasastate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_set_xupdated.restype = None
_lib_alglib.x_minasastate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_get_f.restype = None
_lib_alglib.x_minasastate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_set_f.restype = None
_lib_alglib.x_minasastate_get_g.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_get_g.restype = None
_lib_alglib.x_minasastate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minasastate_get_x.restype = None


class minasastate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minasastate(self.ptr)


class x_minasareport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("terminationtype", x_int),
        ("activeconstraints", x_int)
        ]




class minasareport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.terminationtype = 0
        self.activeconstraints = 0


def x_minasareport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.terminationtype.val = 0
    x.activeconstraints.val = 0
    return




def x_minasareport_clear(x):
    x_minasareport_zero_fields(x)
    return




def x_from_minasareport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.terminationtype.val = int(v.terminationtype)
    x.activeconstraints.val = int(v.activeconstraints)
    return




def minasareport_from_x(x):
    r = minasareport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.terminationtype = x.terminationtype.val
    r.activeconstraints = x.activeconstraints.val
    return r


_lib_alglib.alglib_xv2_minlbfgssetdefaultpreconditioner.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetdefaultpreconditioner.restype = ctypes.c_int32
def minlbfgssetdefaultpreconditioner(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetdefaultpreconditioner(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetdefaultpreconditioner'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlbfgssetcholeskypreconditioner.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlbfgssetcholeskypreconditioner.restype = ctypes.c_int32
def minlbfgssetcholeskypreconditioner(state, p, isupper):
    pass
    __state = state.ptr
    if not is_real_matrix(p):
        raise ValueError("'p' parameter can't be cast to real_matrix")
    __p = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    try:
        x_from_listlist(__p, p, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlbfgssetcholeskypreconditioner(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__p), ctypes.byref(__isupper), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlbfgssetcholeskypreconditioner'")
        return
    finally:
        x_matrix_clear(__p)


_lib_alglib.alglib_xv2_minbleicsetbarrierwidth.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetbarrierwidth.restype = ctypes.c_int32
def minbleicsetbarrierwidth(state, mu):
    pass
    __state = state.ptr
    __mu = ctypes.c_double(mu)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetbarrierwidth(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__mu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetbarrierwidth'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minbleicsetbarrierdecay.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minbleicsetbarrierdecay.restype = ctypes.c_int32
def minbleicsetbarrierdecay(state, mudecay):
    pass
    __state = state.ptr
    __mudecay = ctypes.c_double(mudecay)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minbleicsetbarrierdecay(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__mudecay), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minbleicsetbarrierdecay'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minasacreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasacreate.restype = ctypes.c_int32
def minasacreate(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        n,x,bndl,bndu = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        x,bndl,bndu = functionargs
        if safe_len("'minasacreate': incorrect parameters",x)!=safe_len("'minasacreate': incorrect parameters",bndl) or safe_len("'minasacreate': incorrect parameters",x)!=safe_len("'minasacreate': incorrect parameters",bndu):
            raise RuntimeError("Error while calling 'minasacreate': looks like one of arguments has wrong size")
        n = safe_len("'minasacreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minasacreate': function must have 3 or 4 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasacreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__bndl), ctypes.byref(__bndu), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasacreate'")
        __r__state = minasastate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minasasetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasasetcond.restype = ctypes.c_int32
def minasasetcond(state, epsg, epsf, epsx, maxits):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasasetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasasetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minasasetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasasetxrep.restype = ctypes.c_int32
def minasasetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasasetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasasetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minasasetalgorithm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasasetalgorithm.restype = ctypes.c_int32
def minasasetalgorithm(state, algotype):
    pass
    __state = state.ptr
    __algotype = x_int()
    __algotype.val = int(algotype)
    if __algotype.val!=algotype:
        raise ValueError("Error while converting 'algotype' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasasetalgorithm(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__algotype), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasasetalgorithm'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minasasetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasasetstpmax.restype = ctypes.c_int32
def minasasetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasasetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasasetstpmax'")
        return
    finally:
        pass




def minasaoptimize_g(state, grad, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minasastate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_minasastate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minasaiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasaiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minasastate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_minasastate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minasastate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minasastate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minasaoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minasaresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasaresults.restype = ctypes.c_int32
def minasaresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minasareport()
    x_minasareport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasaresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasaresults'")
        __r__x = list_from_x(__x)
        __r__rep = minasareport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minasareport_clear(__rep)


_lib_alglib.alglib_xv2_minasaresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasaresultsbuf.restype = ctypes.c_int32
def minasaresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minasareport()
    x_minasareport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minasareport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasaresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasaresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minasareport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minasareport_clear(__rep)


_lib_alglib.alglib_xv2_minasarestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minasarestartfrom.restype = ctypes.c_int32
def minasarestartfrom(state, x, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minasarestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minasarestartfrom'")
        return
    finally:
        x_vector_clear(__x)
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.x_obj_free_mincgstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_mincgstate.restype = None
_lib_alglib.x_mincgstate_get_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_get_needf.restype = None
_lib_alglib.x_mincgstate_set_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_set_needf.restype = None
_lib_alglib.x_mincgstate_get_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_get_needfg.restype = None
_lib_alglib.x_mincgstate_set_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_set_needfg.restype = None
_lib_alglib.x_mincgstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_get_xupdated.restype = None
_lib_alglib.x_mincgstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_set_xupdated.restype = None
_lib_alglib.x_mincgstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_get_f.restype = None
_lib_alglib.x_mincgstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_set_f.restype = None
_lib_alglib.x_mincgstate_get_g.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_get_g.restype = None
_lib_alglib.x_mincgstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_mincgstate_get_x.restype = None


class mincgstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_mincgstate(self.ptr)


class x_mincgreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("nfev", x_int),
        ("terminationtype", x_int)
        ]




class mincgreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.nfev = 0
        self.terminationtype = 0


def x_mincgreport_zero_fields(x):
    x.iterationscount.val = 0
    x.nfev.val = 0
    x.terminationtype.val = 0
    return




def x_mincgreport_clear(x):
    x_mincgreport_zero_fields(x)
    return




def x_from_mincgreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.nfev.val = int(v.nfev)
    x.terminationtype.val = int(v.terminationtype)
    return




def mincgreport_from_x(x):
    r = mincgreport()
    r.iterationscount = x.iterationscount.val
    r.nfev = x.nfev.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_mincgcreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgcreate.restype = ctypes.c_int32
def mincgcreate(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        n,x = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'mincgcreate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'mincgcreate': function must have 1 or 2 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgcreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgcreate'")
        __r__state = mincgstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_mincgcreatef.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgcreatef.restype = ctypes.c_int32
def mincgcreatef(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,x,diffstep = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,diffstep = functionargs
        n = safe_len("'mincgcreatef': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'mincgcreatef': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgcreatef(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgcreatef'")
        __r__state = mincgstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_mincgsetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetcond.restype = ctypes.c_int32
def mincgsetcond(state, epsg, epsf, epsx, maxits):
    pass
    __state = state.ptr
    __epsg = ctypes.c_double(epsg)
    __epsf = ctypes.c_double(epsf)
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsg), ctypes.byref(__epsf), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetscale.restype = ctypes.c_int32
def mincgsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_mincgsetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetxrep.restype = ctypes.c_int32
def mincgsetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgsetcgtype.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetcgtype.restype = ctypes.c_int32
def mincgsetcgtype(state, cgtype):
    pass
    __state = state.ptr
    __cgtype = x_int()
    __cgtype.val = int(cgtype)
    if __cgtype.val!=cgtype:
        raise ValueError("Error while converting 'cgtype' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetcgtype(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__cgtype), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetcgtype'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgsetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetstpmax.restype = ctypes.c_int32
def mincgsetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetstpmax'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgsuggeststep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsuggeststep.restype = ctypes.c_int32
def mincgsuggeststep(state, stp):
    pass
    __state = state.ptr
    __stp = ctypes.c_double(stp)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsuggeststep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stp), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsuggeststep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgsetprecdefault.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetprecdefault.restype = ctypes.c_int32
def mincgsetprecdefault(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetprecdefault(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetprecdefault'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgsetprecdiag.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetprecdiag.restype = ctypes.c_int32
def mincgsetprecdiag(state, d):
    pass
    __state = state.ptr
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetprecdiag(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__d), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetprecdiag'")
        return
    finally:
        x_vector_clear(__d)


_lib_alglib.alglib_xv2_mincgsetprecscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgsetprecscale.restype = ctypes.c_int32
def mincgsetprecscale(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgsetprecscale(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgsetprecscale'")
        return
    finally:
        pass




def mincgoptimize_f(state, func, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_mincgstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    while True:
        retval = _lib_alglib.alglib_xv2_mincgiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_mincgstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_mincgstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_mincgstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_mincgstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'mincgoptimize' (some derivatives were not provided?)")
    return


def mincgoptimize_g(state, grad, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_mincgstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_mincgstate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_mincgiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_mincgstate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_mincgstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_mincgstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_mincgstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'mincgoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_mincgoptguardgradient.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgoptguardgradient.restype = ctypes.c_int32
def mincgoptguardgradient(state, teststep):
    pass
    __state = state.ptr
    __teststep = ctypes.c_double(teststep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgoptguardgradient(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__teststep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgoptguardgradient'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgoptguardsmoothness.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgoptguardsmoothness.restype = ctypes.c_int32
def mincgoptguardsmoothness(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        state,level = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        state, = functionargs
        level = 1
    else:
        raise RuntimeError("Error while calling 'mincgoptguardsmoothness': function must have 1 or 2 parameters")
    __state = state.ptr
    __level = x_int()
    __level.val = int(level)
    if __level.val!=level:
        raise ValueError("Error while converting 'level' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgoptguardsmoothness(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__level), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgoptguardsmoothness'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mincgoptguardresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgoptguardresults.restype = ctypes.c_int32
def mincgoptguardresults(state):
    pass
    __state = state.ptr
    __rep = x_optguardreport()
    x_optguardreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgoptguardresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgoptguardresults'")
        __r__rep = optguardreport_from_x(__rep)
        return __r__rep
    finally:
        x_optguardreport_clear(__rep)


_lib_alglib.alglib_xv2_mincgoptguardnonc1test0results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgoptguardnonc1test0results.restype = ctypes.c_int32
def mincgoptguardnonc1test0results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test0report()
    x_optguardnonc1test0report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgoptguardnonc1test0results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgoptguardnonc1test0results'")
        __r__strrep = optguardnonc1test0report_from_x(__strrep)
        __r__lngrep = optguardnonc1test0report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test0report_clear(__strrep)
        x_optguardnonc1test0report_clear(__lngrep)


_lib_alglib.alglib_xv2_mincgoptguardnonc1test1results.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgoptguardnonc1test1results.restype = ctypes.c_int32
def mincgoptguardnonc1test1results(state):
    pass
    __state = state.ptr
    __strrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__strrep)
    __lngrep = x_optguardnonc1test1report()
    x_optguardnonc1test1report_zero_fields(__lngrep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgoptguardnonc1test1results(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__strrep), ctypes.byref(__lngrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgoptguardnonc1test1results'")
        __r__strrep = optguardnonc1test1report_from_x(__strrep)
        __r__lngrep = optguardnonc1test1report_from_x(__lngrep)
        return (__r__strrep, __r__lngrep)
    finally:
        x_optguardnonc1test1report_clear(__strrep)
        x_optguardnonc1test1report_clear(__lngrep)


_lib_alglib.alglib_xv2_mincgresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgresults.restype = ctypes.c_int32
def mincgresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_mincgreport()
    x_mincgreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgresults'")
        __r__x = list_from_x(__x)
        __r__rep = mincgreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_mincgreport_clear(__rep)


_lib_alglib.alglib_xv2_mincgresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgresultsbuf.restype = ctypes.c_int32
def mincgresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_mincgreport()
    x_mincgreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_mincgreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = mincgreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_mincgreport_clear(__rep)


_lib_alglib.alglib_xv2_mincgrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgrestartfrom.restype = ctypes.c_int32
def mincgrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_mincgrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mincgrequesttermination.restype = ctypes.c_int32
def mincgrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mincgrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mincgrequesttermination'")
        return
    finally:
        pass


_lib_alglib.x_obj_free_minlmstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_minlmstate.restype = None
_lib_alglib.x_minlmstate_get_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_needf.restype = None
_lib_alglib.x_minlmstate_set_needf.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_needf.restype = None
_lib_alglib.x_minlmstate_get_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_needfg.restype = None
_lib_alglib.x_minlmstate_set_needfg.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_needfg.restype = None
_lib_alglib.x_minlmstate_get_needfgh.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_needfgh.restype = None
_lib_alglib.x_minlmstate_set_needfgh.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_needfgh.restype = None
_lib_alglib.x_minlmstate_get_needfi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_needfi.restype = None
_lib_alglib.x_minlmstate_set_needfi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_needfi.restype = None
_lib_alglib.x_minlmstate_get_needfij.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_needfij.restype = None
_lib_alglib.x_minlmstate_set_needfij.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_needfij.restype = None
_lib_alglib.x_minlmstate_get_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_xupdated.restype = None
_lib_alglib.x_minlmstate_set_xupdated.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_xupdated.restype = None
_lib_alglib.x_minlmstate_get_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_f.restype = None
_lib_alglib.x_minlmstate_set_f.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_set_f.restype = None
_lib_alglib.x_minlmstate_get_fi.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_fi.restype = None
_lib_alglib.x_minlmstate_get_g.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_g.restype = None
_lib_alglib.x_minlmstate_get_h.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_h.restype = None
_lib_alglib.x_minlmstate_get_j.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_j.restype = None
_lib_alglib.x_minlmstate_get_x.argtypes = [ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.x_minlmstate_get_x.restype = None


class minlmstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_minlmstate(self.ptr)


class x_minlmreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int),
        ("terminationtype", x_int),
        ("nfunc", x_int),
        ("njac", x_int),
        ("ngrad", x_int),
        ("nhess", x_int),
        ("ncholesky", x_int)
        ]




class minlmreport(object):
    def __init__(self):
        self.iterationscount = 0
        self.terminationtype = 0
        self.nfunc = 0
        self.njac = 0
        self.ngrad = 0
        self.nhess = 0
        self.ncholesky = 0


def x_minlmreport_zero_fields(x):
    x.iterationscount.val = 0
    x.terminationtype.val = 0
    x.nfunc.val = 0
    x.njac.val = 0
    x.ngrad.val = 0
    x.nhess.val = 0
    x.ncholesky.val = 0
    return




def x_minlmreport_clear(x):
    x_minlmreport_zero_fields(x)
    return




def x_from_minlmreport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    x.terminationtype.val = int(v.terminationtype)
    x.nfunc.val = int(v.nfunc)
    x.njac.val = int(v.njac)
    x.ngrad.val = int(v.ngrad)
    x.nhess.val = int(v.nhess)
    x.ncholesky.val = int(v.ncholesky)
    return




def minlmreport_from_x(x):
    r = minlmreport()
    r.iterationscount = x.iterationscount.val
    r.terminationtype = x.terminationtype.val
    r.nfunc = x.nfunc.val
    r.njac = x.njac.val
    r.ngrad = x.ngrad.val
    r.nhess = x.nhess.val
    r.ncholesky = x.ncholesky.val
    return r


_lib_alglib.alglib_xv2_minlmcreatevj.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmcreatevj.restype = ctypes.c_int32
def minlmcreatevj(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,m,x = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        m,x = functionargs
        n = safe_len("'minlmcreatevj': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlmcreatevj': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmcreatevj(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmcreatevj'")
        __r__state = minlmstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlmcreatev.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmcreatev.restype = ctypes.c_int32
def minlmcreatev(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        n,m,x,diffstep = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        m,x,diffstep = functionargs
        n = safe_len("'minlmcreatev': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlmcreatev': function must have 3 or 4 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __diffstep = ctypes.c_double(diffstep)
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmcreatev(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__diffstep), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmcreatev'")
        __r__state = minlmstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlmcreatefgh.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmcreatefgh.restype = ctypes.c_int32
def minlmcreatefgh(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        n,x = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'minlmcreatefgh': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlmcreatefgh': function must have 1 or 2 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmcreatefgh(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmcreatefgh'")
        __r__state = minlmstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlmsetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetcond.restype = ctypes.c_int32
def minlmsetcond(state, epsx, maxits):
    pass
    __state = state.ptr
    __epsx = ctypes.c_double(epsx)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__epsx), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlmsetxrep.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetxrep.restype = ctypes.c_int32
def minlmsetxrep(state, needxrep):
    pass
    __state = state.ptr
    __needxrep = ctypes.c_uint64(needxrep)
    if __needxrep.value!=0:
        __needxrep = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetxrep(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__needxrep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetxrep'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlmsetstpmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetstpmax.restype = ctypes.c_int32
def minlmsetstpmax(state, stpmax):
    pass
    __state = state.ptr
    __stpmax = ctypes.c_double(stpmax)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetstpmax(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__stpmax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetstpmax'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlmsetscale.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetscale.restype = ctypes.c_int32
def minlmsetscale(state, s):
    pass
    __state = state.ptr
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetscale(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetscale'")
        return
    finally:
        x_vector_clear(__s)


_lib_alglib.alglib_xv2_minlmsetbc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetbc.restype = ctypes.c_int32
def minlmsetbc(state, bndl, bndu):
    pass
    __state = state.ptr
    if not is_real_vector(bndl):
        raise ValueError("'bndl' parameter can't be cast to real_vector")
    __bndl = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bndu):
        raise ValueError("'bndu' parameter can't be cast to real_vector")
    __bndu = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__bndl, bndl, DT_REAL, X_CREATE)
        x_from_list(__bndu, bndu, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetbc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__bndl), ctypes.byref(__bndu), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetbc'")
        return
    finally:
        x_vector_clear(__bndl)
        x_vector_clear(__bndu)


_lib_alglib.alglib_xv2_minlmsetlc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetlc.restype = ctypes.c_int32
def minlmsetlc(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        state,c,ct,k = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        state,c,ct = functionargs
        if safe_rows("'minlmsetlc': incorrect parameters",c)!=safe_len("'minlmsetlc': incorrect parameters",ct):
            raise RuntimeError("Error while calling 'minlmsetlc': looks like one of arguments has wrong size")
        k = safe_rows("'minlmsetlc': incorrect parameters",c)
    else:
        raise RuntimeError("Error while calling 'minlmsetlc': function must have 3 or 4 parameters")
    __state = state.ptr
    if not is_real_matrix(c):
        raise ValueError("'c' parameter can't be cast to real_matrix")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(ct):
        raise ValueError("'ct' parameter can't be cast to int_vector")
    __ct = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_listlist(__c, c, DT_REAL, X_CREATE)
        x_from_list(__ct, ct, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetlc(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__c), ctypes.byref(__ct), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetlc'")
        return
    finally:
        x_matrix_clear(__c)
        x_vector_clear(__ct)


_lib_alglib.alglib_xv2_minlmsetacctype.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmsetacctype.restype = ctypes.c_int32
def minlmsetacctype(state, acctype):
    pass
    __state = state.ptr
    __acctype = x_int()
    __acctype.val = int(acctype)
    if __acctype.val!=acctype:
        raise ValueError("Error while converting 'acctype' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmsetacctype(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__acctype), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmsetacctype'")
        return
    finally:
        pass




def minlmoptimize_v(state, fvec, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlmstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_fi  = x_vector()
    _lib_alglib.x_minlmstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    while True:
        retval = _lib_alglib.alglib_xv2_minlmiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlmstate_get_needfi(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            fvec(_py_x, _py_fi, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlmstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)")
    return


def minlmoptimize_vj(state, fvec, jac, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlmstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_fi  = x_vector()
    _lib_alglib.x_minlmstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    _xc_j  = x_matrix()
    _lib_alglib.x_minlmstate_get_j(state.ptr, ctypes.byref(_xc_j))
    _py_j = create_real_matrix(_xc_j.rows,_xc_j.cols)
    while True:
        retval = _lib_alglib.alglib_xv2_minlmiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlmstate_get_needfi(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            fvec(_py_x, _py_fi, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_needfij(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            jac(_py_x, _py_fi, _py_j, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            x_from_listlist(_xc_j, _py_j, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlmstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)")
    return


def minlmoptimize_fgh(state, func, grad, hess, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlmstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_minlmstate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    _xc_h  = x_matrix()
    _lib_alglib.x_minlmstate_get_h(state.ptr, ctypes.byref(_xc_h))
    _py_h = create_real_matrix(_xc_h.rows,_xc_h.cols)
    while True:
        retval = _lib_alglib.alglib_xv2_minlmiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlmstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_minlmstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_minlmstate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_minlmstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_needfgh(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = hess(_py_x, _py_g, _py_h, param)
            _lib_alglib.x_minlmstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            x_from_listlist(_xc_h, _py_h, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlmstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)")
    return


def minlmoptimize_fj(state, func, jac, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlmstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_fi  = x_vector()
    _lib_alglib.x_minlmstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    _xc_j  = x_matrix()
    _lib_alglib.x_minlmstate_get_j(state.ptr, ctypes.byref(_xc_j))
    _py_j = create_real_matrix(_xc_j.rows,_xc_j.cols)
    while True:
        retval = _lib_alglib.alglib_xv2_minlmiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlmstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_minlmstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_minlmstate_get_needfij(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            jac(_py_x, _py_fi, _py_j, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            x_from_listlist(_xc_j, _py_j, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlmstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)")
    return


def minlmoptimize_fgj(state, func, grad, jac, rep = None, param = None):
    _xc_result = ctypes.c_uint8(0)
    _xc_msg = ctypes.c_char_p()
    _xc_x  = x_vector()
    _lib_alglib.x_minlmstate_get_x(state.ptr, ctypes.byref(_xc_x))
    _py_x = create_real_vector(_xc_x.cnt)
    _xc_flag = ctypes.c_uint8()
    _xc_f = ctypes.c_double()
    _xc_g  = x_vector()
    _lib_alglib.x_minlmstate_get_g(state.ptr, ctypes.byref(_xc_g))
    _py_g = create_real_vector(_xc_g.cnt)
    _xc_fi  = x_vector()
    _lib_alglib.x_minlmstate_get_fi(state.ptr, ctypes.byref(_xc_fi))
    _py_fi = create_real_vector(_xc_fi.cnt)
    _xc_j  = x_matrix()
    _lib_alglib.x_minlmstate_get_j(state.ptr, ctypes.byref(_xc_j))
    _py_j = create_real_matrix(_xc_j.rows,_xc_j.cols)
    while True:
        retval = _lib_alglib.alglib_xv2_minlmiteration(ctypes.byref(_xc_msg), ctypes.byref(_xc_result), ctypes.byref(state.ptr), 0)
        if retval!=0:
            if retval==X_ASSERTION_FAILED:
                raise RuntimeError(_xc_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmiteration'")
        if not _xc_result:
            break
        _lib_alglib.x_minlmstate_get_needf(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = func(_py_x, param)
            _lib_alglib.x_minlmstate_set_f(state.ptr, ctypes.byref(_xc_f))
            continue
        _lib_alglib.x_minlmstate_get_needfg(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            _xc_f.value = grad(_py_x, _py_g, param)
            _lib_alglib.x_minlmstate_set_f(state.ptr, ctypes.byref(_xc_f))
            x_from_list(_xc_g, _py_g, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_needfij(state.ptr, ctypes.byref(_xc_flag))
        if  _xc_flag.value!=0:
            copy_x_to_list(_xc_x, _py_x)

            jac(_py_x, _py_fi, _py_j, param)
            x_from_list(_xc_fi, _py_fi, DT_REAL, X_REWRITE)
            x_from_listlist(_xc_j, _py_j, DT_REAL, X_REWRITE)
            continue
        _lib_alglib.x_minlmstate_get_xupdated(state.ptr, ctypes.byref(_xc_flag))
        if _xc_flag.value!=0 :
            if not (rep is None):
                copy_x_to_list(_xc_x, _py_x)
                _lib_alglib.x_minlmstate_get_f(state.ptr, ctypes.byref(_xc_f))
                rep(_py_x, _xc_f.value, param)
            continue
        raise RuntimeError("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)")
    return


_lib_alglib.alglib_xv2_minlmoptguardgradient.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmoptguardgradient.restype = ctypes.c_int32
def minlmoptguardgradient(state, teststep):
    pass
    __state = state.ptr
    __teststep = ctypes.c_double(teststep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmoptguardgradient(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__teststep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmoptguardgradient'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlmoptguardresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmoptguardresults.restype = ctypes.c_int32
def minlmoptguardresults(state):
    pass
    __state = state.ptr
    __rep = x_optguardreport()
    x_optguardreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmoptguardresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmoptguardresults'")
        __r__rep = optguardreport_from_x(__rep)
        return __r__rep
    finally:
        x_optguardreport_clear(__rep)


_lib_alglib.alglib_xv2_minlmresults.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmresults.restype = ctypes.c_int32
def minlmresults(state):
    pass
    __state = state.ptr
    __x = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minlmreport()
    x_minlmreport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmresults(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmresults'")
        __r__x = list_from_x(__x)
        __r__rep = minlmreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minlmreport_clear(__rep)


_lib_alglib.alglib_xv2_minlmresultsbuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmresultsbuf.restype = ctypes.c_int32
def minlmresultsbuf(state, x, rep):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_minlmreport()
    x_minlmreport_zero_fields(__rep)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_minlmreport(__rep, rep)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmresultsbuf(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmresultsbuf'")
        __r__x = list_from_x(__x)
        __r__rep = minlmreport_from_x(__rep)
        return (__r__x, __r__rep)
    finally:
        x_vector_clear(__x)
        x_minlmreport_clear(__rep)


_lib_alglib.alglib_xv2_minlmrestartfrom.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmrestartfrom.restype = ctypes.c_int32
def minlmrestartfrom(state, x):
    pass
    __state = state.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmrestartfrom(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmrestartfrom'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlmrequesttermination.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmrequesttermination.restype = ctypes.c_int32
def minlmrequesttermination(state):
    pass
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmrequesttermination(ctypes.byref(_error_msg), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmrequesttermination'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_minlmcreatevgj.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmcreatevgj.restype = ctypes.c_int32
def minlmcreatevgj(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,m,x = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        m,x = functionargs
        n = safe_len("'minlmcreatevgj': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlmcreatevgj': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmcreatevgj(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmcreatevgj'")
        __r__state = minlmstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlmcreatefgj.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmcreatefgj.restype = ctypes.c_int32
def minlmcreatefgj(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,m,x = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        m,x = functionargs
        n = safe_len("'minlmcreatefgj': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlmcreatefgj': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmcreatefgj(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmcreatefgj'")
        __r__state = minlmstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_minlmcreatefj.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_minlmcreatefj.restype = ctypes.c_int32
def minlmcreatefj(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        n,m,x = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        m,x = functionargs
        n = safe_len("'minlmcreatefj': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'minlmcreatefj': function must have 2 or 3 parameters")
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __state = ctypes.c_void_p(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_minlmcreatefj(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__x), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'minlmcreatefj'")
        __r__state = minlmstate(__state)
        return __r__state
    finally:
        x_vector_clear(__x)


_lib_alglib.x_obj_free_eigsubspacestate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_eigsubspacestate.restype = None


class eigsubspacestate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_eigsubspacestate(self.ptr)


class x_eigsubspacereport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("iterationscount", x_int)
        ]




class eigsubspacereport(object):
    def __init__(self):
        self.iterationscount = 0


def x_eigsubspacereport_zero_fields(x):
    x.iterationscount.val = 0
    return




def x_eigsubspacereport_clear(x):
    x_eigsubspacereport_zero_fields(x)
    return




def x_from_eigsubspacereport(x,v):
    x.iterationscount.val = int(v.iterationscount)
    return




def eigsubspacereport_from_x(x):
    r = eigsubspacereport()
    r.iterationscount = x.iterationscount.val
    return r


_lib_alglib.alglib_xv2_eigsubspacecreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspacecreate.restype = ctypes.c_int32
def eigsubspacecreate(n, k):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __state = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspacecreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspacecreate'")
        __r__state = eigsubspacestate(__state)
        return __r__state
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspacecreatebuf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspacecreatebuf.restype = ctypes.c_int32
def eigsubspacecreatebuf(n, k, state):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspacecreatebuf(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__k), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspacecreatebuf'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspacesetcond.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspacesetcond.restype = ctypes.c_int32
def eigsubspacesetcond(state, eps, maxits):
    pass
    __state = state.ptr
    __eps = ctypes.c_double(eps)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspacesetcond(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__eps), ctypes.byref(__maxits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspacesetcond'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspacesetwarmstart.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspacesetwarmstart.restype = ctypes.c_int32
def eigsubspacesetwarmstart(state, usewarmstart):
    pass
    __state = state.ptr
    __usewarmstart = ctypes.c_uint64(usewarmstart)
    if __usewarmstart.value!=0:
        __usewarmstart = ctypes.c_uint64(1)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspacesetwarmstart(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__usewarmstart), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspacesetwarmstart'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspaceoocstart.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspaceoocstart.restype = ctypes.c_int32
def eigsubspaceoocstart(state, mtype):
    pass
    __state = state.ptr
    __mtype = x_int()
    __mtype.val = int(mtype)
    if __mtype.val!=mtype:
        raise ValueError("Error while converting 'mtype' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspaceoocstart(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__mtype), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspaceoocstart'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspaceooccontinue.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspaceooccontinue.restype = ctypes.c_int32
def eigsubspaceooccontinue(state):
    pass
    __result = ctypes.c_uint64(0)
    __state = state.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspaceooccontinue(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__state), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspaceooccontinue'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspaceoocgetrequestinfo.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspaceoocgetrequestinfo.restype = ctypes.c_int32
def eigsubspaceoocgetrequestinfo(state):
    pass
    __state = state.ptr
    __requesttype = x_int()
    __requesttype.val = 0
    __requestsize = x_int()
    __requestsize.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspaceoocgetrequestinfo(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__requesttype), ctypes.byref(__requestsize), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspaceoocgetrequestinfo'")
        __r__requesttype = __requesttype.val
        __r__requestsize = __requestsize.val
        return (__r__requesttype, __r__requestsize)
    finally:
        pass


_lib_alglib.alglib_xv2_eigsubspaceoocgetrequestdata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspaceoocgetrequestdata.restype = ctypes.c_int32
def eigsubspaceoocgetrequestdata(state, x):
    pass
    __state = state.ptr
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspaceoocgetrequestdata(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspaceoocgetrequestdata'")
        __r__x = listlist_from_x(__x)
        return __r__x
    finally:
        x_matrix_clear(__x)


_lib_alglib.alglib_xv2_eigsubspaceoocsendresult.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspaceoocsendresult.restype = ctypes.c_int32
def eigsubspaceoocsendresult(state, ax):
    pass
    __state = state.ptr
    if not is_real_matrix(ax):
        raise ValueError("'ax' parameter can't be cast to real_matrix")
    __ax = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__ax, ax, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspaceoocsendresult(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__ax), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspaceoocsendresult'")
        return
    finally:
        x_matrix_clear(__ax)


_lib_alglib.alglib_xv2_eigsubspaceoocstop.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspaceoocstop.restype = ctypes.c_int32
def eigsubspaceoocstop(state):
    pass
    __state = state.ptr
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_eigsubspacereport()
    x_eigsubspacereport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspaceoocstop(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__w), ctypes.byref(__z), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspaceoocstop'")
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        __r__rep = eigsubspacereport_from_x(__rep)
        return (__r__w, __r__z, __r__rep)
    finally:
        x_vector_clear(__w)
        x_matrix_clear(__z)
        x_eigsubspacereport_clear(__rep)


_lib_alglib.alglib_xv2_eigsubspacesolvedenses.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspacesolvedenses.restype = ctypes.c_int32
def eigsubspacesolvedenses(state, a, isupper):
    pass
    __state = state.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_eigsubspacereport()
    x_eigsubspacereport_zero_fields(__rep)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspacesolvedenses(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__isupper), ctypes.byref(__w), ctypes.byref(__z), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspacesolvedenses'")
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        __r__rep = eigsubspacereport_from_x(__rep)
        return (__r__w, __r__z, __r__rep)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__w)
        x_matrix_clear(__z)
        x_eigsubspacereport_clear(__rep)


_lib_alglib.alglib_xv2_eigsubspacesolvesparses.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_eigsubspacesolvesparses.restype = ctypes.c_int32
def eigsubspacesolvesparses(state, a, isupper):
    pass
    __state = state.ptr
    __a = a.ptr
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __rep = x_eigsubspacereport()
    x_eigsubspacereport_zero_fields(__rep)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_eigsubspacesolvesparses(ctypes.byref(_error_msg), ctypes.byref(__state), ctypes.byref(__a), ctypes.byref(__isupper), ctypes.byref(__w), ctypes.byref(__z), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'eigsubspacesolvesparses'")
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        __r__rep = eigsubspacereport_from_x(__rep)
        return (__r__w, __r__z, __r__rep)
    finally:
        x_vector_clear(__w)
        x_matrix_clear(__z)
        x_eigsubspacereport_clear(__rep)


_lib_alglib.alglib_xv2_smatrixevd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixevd.restype = ctypes.c_int32
def smatrixevd(a, n, zneeded, isupper):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __d = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixevd(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__isupper), ctypes.byref(__d), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixevd'")
        __r__result = __result.value!=0
        __r__d = list_from_x(__d)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__d, __r__z)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__d)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_smatrixevdr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixevdr.restype = ctypes.c_int32
def smatrixevdr(a, n, zneeded, isupper, b1, b2):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __b1 = ctypes.c_double(b1)
    __b2 = ctypes.c_double(b2)
    __m = x_int()
    __m.val = 0
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixevdr(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__isupper), ctypes.byref(__b1), ctypes.byref(__b2), ctypes.byref(__m), ctypes.byref(__w), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixevdr'")
        __r__result = __result.value!=0
        __r__m = __m.val
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__m, __r__w, __r__z)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__w)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_smatrixevdi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixevdi.restype = ctypes.c_int32
def smatrixevdi(a, n, zneeded, isupper, i1, i2):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixevdi(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__isupper), ctypes.byref(__i1), ctypes.byref(__i2), ctypes.byref(__w), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixevdi'")
        __r__result = __result.value!=0
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__w, __r__z)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__w)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_hmatrixevd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixevd.restype = ctypes.c_int32
def hmatrixevd(a, n, zneeded, isupper):
    pass
    __result = ctypes.c_uint64(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __d = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixevd(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__isupper), ctypes.byref(__d), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixevd'")
        __r__result = __result.value!=0
        __r__d = list_from_x(__d)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__d, __r__z)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__d)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_hmatrixevdr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixevdr.restype = ctypes.c_int32
def hmatrixevdr(a, n, zneeded, isupper, b1, b2):
    pass
    __result = ctypes.c_uint64(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __b1 = ctypes.c_double(b1)
    __b2 = ctypes.c_double(b2)
    __m = x_int()
    __m.val = 0
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixevdr(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__isupper), ctypes.byref(__b1), ctypes.byref(__b2), ctypes.byref(__m), ctypes.byref(__w), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixevdr'")
        __r__result = __result.value!=0
        __r__m = __m.val
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__m, __r__w, __r__z)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__w)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_hmatrixevdi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_hmatrixevdi.restype = ctypes.c_int32
def hmatrixevdi(a, n, zneeded, isupper, i1, i2):
    pass
    __result = ctypes.c_uint64(0)
    if not is_complex_matrix(a):
        raise ValueError("'a' parameter can't be cast to complex_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __isupper = ctypes.c_uint64(isupper)
    if __isupper.value!=0:
        __isupper = ctypes.c_uint64(1)
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=DT_COMPLEX,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_COMPLEX, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_hmatrixevdi(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__isupper), ctypes.byref(__i1), ctypes.byref(__i2), ctypes.byref(__w), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'hmatrixevdi'")
        __r__result = __result.value!=0
        __r__w = list_from_x(__w)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__w, __r__z)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__w)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_smatrixtdevd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixtdevd.restype = ctypes.c_int32
def smatrixtdevd(d, e, n, zneeded, z):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(e):
        raise ValueError("'e' parameter can't be cast to real_vector")
    __e = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    if not is_real_matrix(z):
        raise ValueError("'z' parameter can't be cast to real_matrix")
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        x_from_list(__e, e, DT_REAL, X_CREATE)
        x_from_listlist(__z, z, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixtdevd(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__d), ctypes.byref(__e), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixtdevd'")
        __r__result = __result.value!=0
        __r__d = list_from_x(__d)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__d, __r__z)
    finally:
        x_vector_clear(__d)
        x_vector_clear(__e)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_smatrixtdevdr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixtdevdr.restype = ctypes.c_int32
def smatrixtdevdr(d, e, n, zneeded, a, b, z):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(e):
        raise ValueError("'e' parameter can't be cast to real_vector")
    __e = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __a = ctypes.c_double(a)
    __b = ctypes.c_double(b)
    __m = x_int()
    __m.val = 0
    if not is_real_matrix(z):
        raise ValueError("'z' parameter can't be cast to real_matrix")
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        x_from_list(__e, e, DT_REAL, X_CREATE)
        x_from_listlist(__z, z, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixtdevdr(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__d), ctypes.byref(__e), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__a), ctypes.byref(__b), ctypes.byref(__m), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixtdevdr'")
        __r__result = __result.value!=0
        __r__d = list_from_x(__d)
        __r__m = __m.val
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__d, __r__m, __r__z)
    finally:
        x_vector_clear(__d)
        x_vector_clear(__e)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_smatrixtdevdi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_smatrixtdevdi.restype = ctypes.c_int32
def smatrixtdevdi(d, e, n, zneeded, i1, i2, z):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_vector(d):
        raise ValueError("'d' parameter can't be cast to real_vector")
    __d = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(e):
        raise ValueError("'e' parameter can't be cast to real_vector")
    __e = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __zneeded = x_int()
    __zneeded.val = int(zneeded)
    if __zneeded.val!=zneeded:
        raise ValueError("Error while converting 'zneeded' parameter to 'x_int'")
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __i2 = x_int()
    __i2.val = int(i2)
    if __i2.val!=i2:
        raise ValueError("Error while converting 'i2' parameter to 'x_int'")
    if not is_real_matrix(z):
        raise ValueError("'z' parameter can't be cast to real_matrix")
    __z = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__d, d, DT_REAL, X_CREATE)
        x_from_list(__e, e, DT_REAL, X_CREATE)
        x_from_listlist(__z, z, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_smatrixtdevdi(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__d), ctypes.byref(__e), ctypes.byref(__n), ctypes.byref(__zneeded), ctypes.byref(__i1), ctypes.byref(__i2), ctypes.byref(__z), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'smatrixtdevdi'")
        __r__result = __result.value!=0
        __r__d = list_from_x(__d)
        __r__z = listlist_from_x(__z)
        return (__r__result, __r__d, __r__z)
    finally:
        x_vector_clear(__d)
        x_vector_clear(__e)
        x_matrix_clear(__z)


_lib_alglib.alglib_xv2_rmatrixevd.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rmatrixevd.restype = ctypes.c_int32
def rmatrixevd(a, n, vneeded):
    pass
    __result = ctypes.c_uint64(0)
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __vneeded = x_int()
    __vneeded.val = int(vneeded)
    if __vneeded.val!=vneeded:
        raise ValueError("Error while converting 'vneeded' parameter to 'x_int'")
    __wr = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __wi = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __vl = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __vr = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rmatrixevd(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__n), ctypes.byref(__vneeded), ctypes.byref(__wr), ctypes.byref(__wi), ctypes.byref(__vl), ctypes.byref(__vr), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rmatrixevd'")
        __r__result = __result.value!=0
        __r__wr = list_from_x(__wr)
        __r__wi = list_from_x(__wi)
        __r__vl = listlist_from_x(__vl)
        __r__vr = listlist_from_x(__vr)
        return (__r__result, __r__wr, __r__wi, __r__vl, __r__vr)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__wr)
        x_vector_clear(__wi)
        x_matrix_clear(__vl)
        x_matrix_clear(__vr)


_lib_alglib.alglib_xv2_samplemoments.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_samplemoments.restype = ctypes.c_int32
def samplemoments(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'samplemoments': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'samplemoments': function must have 1 or 2 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __mean = ctypes.c_double(0)
    __variance = ctypes.c_double(0)
    __skewness = ctypes.c_double(0)
    __kurtosis = ctypes.c_double(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_samplemoments(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__mean), ctypes.byref(__variance), ctypes.byref(__skewness), ctypes.byref(__kurtosis), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'samplemoments'")
        __r__mean = __mean.value
        __r__variance = __variance.value
        __r__skewness = __skewness.value
        __r__kurtosis = __kurtosis.value
        return (__r__mean, __r__variance, __r__skewness, __r__kurtosis)
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_samplemean.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_samplemean.restype = ctypes.c_int32
def samplemean(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'samplemean': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'samplemean': function must have 1 or 2 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_samplemean(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'samplemean'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_samplevariance.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_samplevariance.restype = ctypes.c_int32
def samplevariance(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'samplevariance': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'samplevariance': function must have 1 or 2 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_samplevariance(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'samplevariance'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_sampleskewness.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sampleskewness.restype = ctypes.c_int32
def sampleskewness(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'sampleskewness': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'sampleskewness': function must have 1 or 2 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sampleskewness(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sampleskewness'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_samplekurtosis.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_samplekurtosis.restype = ctypes.c_int32
def samplekurtosis(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'samplekurtosis': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'samplekurtosis': function must have 1 or 2 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_samplekurtosis(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'samplekurtosis'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_sampleadev.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_sampleadev.restype = ctypes.c_int32
def sampleadev(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'sampleadev': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'sampleadev': function must have 1 or 2 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __adev = ctypes.c_double(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_sampleadev(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__adev), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'sampleadev'")
        __r__adev = __adev.value
        return __r__adev
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_samplemedian.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_samplemedian.restype = ctypes.c_int32
def samplemedian(*functionargs):
    if len(functionargs)==2:
        __friendly_form = False
        x,n = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_len("'samplemedian': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'samplemedian': function must have 1 or 2 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __median = ctypes.c_double(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_samplemedian(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__median), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'samplemedian'")
        __r__median = __median.value
        return __r__median
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_samplepercentile.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_samplepercentile.restype = ctypes.c_int32
def samplepercentile(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,p = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,p = functionargs
        n = safe_len("'samplepercentile': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'samplepercentile': function must have 2 or 3 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __p = ctypes.c_double(p)
    __v = ctypes.c_double(0)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_samplepercentile(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__p), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'samplepercentile'")
        __r__v = __v.value
        return __r__v
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_cov2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_cov2.restype = ctypes.c_int32
def cov2(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,y,n = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,y = functionargs
        if safe_len("'cov2': incorrect parameters",x)!=safe_len("'cov2': incorrect parameters",y):
            raise RuntimeError("Error while calling 'cov2': looks like one of arguments has wrong size")
        n = safe_len("'cov2': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'cov2': function must have 2 or 3 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_cov2(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'cov2'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_pearsoncorr2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pearsoncorr2.restype = ctypes.c_int32
def pearsoncorr2(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,y,n = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,y = functionargs
        if safe_len("'pearsoncorr2': incorrect parameters",x)!=safe_len("'pearsoncorr2': incorrect parameters",y):
            raise RuntimeError("Error while calling 'pearsoncorr2': looks like one of arguments has wrong size")
        n = safe_len("'pearsoncorr2': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'pearsoncorr2': function must have 2 or 3 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pearsoncorr2(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pearsoncorr2'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_spearmancorr2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spearmancorr2.restype = ctypes.c_int32
def spearmancorr2(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,y,n = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,y = functionargs
        if safe_len("'spearmancorr2': incorrect parameters",x)!=safe_len("'spearmancorr2': incorrect parameters",y):
            raise RuntimeError("Error while calling 'spearmancorr2': looks like one of arguments has wrong size")
        n = safe_len("'spearmancorr2': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'spearmancorr2': function must have 2 or 3 parameters")
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spearmancorr2(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spearmancorr2'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_covm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_covm.restype = ctypes.c_int32
def covm(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,m = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_rows("'covm': incorrect parameters",x)
        m = safe_cols("'covm': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'covm': function must have 1 or 3 parameters")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_covm(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'covm'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__x)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_pearsoncorrm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pearsoncorrm.restype = ctypes.c_int32
def pearsoncorrm(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,m = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_rows("'pearsoncorrm': incorrect parameters",x)
        m = safe_cols("'pearsoncorrm': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'pearsoncorrm': function must have 1 or 3 parameters")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pearsoncorrm(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pearsoncorrm'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__x)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_spearmancorrm.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spearmancorrm.restype = ctypes.c_int32
def spearmancorrm(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,m = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        x, = functionargs
        n = safe_rows("'spearmancorrm': incorrect parameters",x)
        m = safe_cols("'spearmancorrm': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'spearmancorrm': function must have 1 or 3 parameters")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spearmancorrm(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__m), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spearmancorrm'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__x)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_covm2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_covm2.restype = ctypes.c_int32
def covm2(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        x,y,n,m1,m2 = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,y = functionargs
        if safe_rows("'covm2': incorrect parameters",x)!=safe_rows("'covm2': incorrect parameters",y):
            raise RuntimeError("Error while calling 'covm2': looks like one of arguments has wrong size")
        n = safe_rows("'covm2': incorrect parameters",x)
        m1 = safe_cols("'covm2': incorrect parameters",x)
        m2 = safe_cols("'covm2': incorrect parameters",y)
    else:
        raise RuntimeError("Error while calling 'covm2': function must have 2 or 5 parameters")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(y):
        raise ValueError("'y' parameter can't be cast to real_matrix")
    __y = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m1 = x_int()
    __m1.val = int(m1)
    if __m1.val!=m1:
        raise ValueError("Error while converting 'm1' parameter to 'x_int'")
    __m2 = x_int()
    __m2.val = int(m2)
    if __m2.val!=m2:
        raise ValueError("Error while converting 'm2' parameter to 'x_int'")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        x_from_listlist(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_covm2(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), ctypes.byref(__m1), ctypes.byref(__m2), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'covm2'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__x)
        x_matrix_clear(__y)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_pearsoncorrm2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pearsoncorrm2.restype = ctypes.c_int32
def pearsoncorrm2(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        x,y,n,m1,m2 = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,y = functionargs
        if safe_rows("'pearsoncorrm2': incorrect parameters",x)!=safe_rows("'pearsoncorrm2': incorrect parameters",y):
            raise RuntimeError("Error while calling 'pearsoncorrm2': looks like one of arguments has wrong size")
        n = safe_rows("'pearsoncorrm2': incorrect parameters",x)
        m1 = safe_cols("'pearsoncorrm2': incorrect parameters",x)
        m2 = safe_cols("'pearsoncorrm2': incorrect parameters",y)
    else:
        raise RuntimeError("Error while calling 'pearsoncorrm2': function must have 2 or 5 parameters")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(y):
        raise ValueError("'y' parameter can't be cast to real_matrix")
    __y = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m1 = x_int()
    __m1.val = int(m1)
    if __m1.val!=m1:
        raise ValueError("Error while converting 'm1' parameter to 'x_int'")
    __m2 = x_int()
    __m2.val = int(m2)
    if __m2.val!=m2:
        raise ValueError("Error while converting 'm2' parameter to 'x_int'")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        x_from_listlist(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pearsoncorrm2(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), ctypes.byref(__m1), ctypes.byref(__m2), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pearsoncorrm2'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__x)
        x_matrix_clear(__y)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_spearmancorrm2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spearmancorrm2.restype = ctypes.c_int32
def spearmancorrm2(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        x,y,n,m1,m2 = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,y = functionargs
        if safe_rows("'spearmancorrm2': incorrect parameters",x)!=safe_rows("'spearmancorrm2': incorrect parameters",y):
            raise RuntimeError("Error while calling 'spearmancorrm2': looks like one of arguments has wrong size")
        n = safe_rows("'spearmancorrm2': incorrect parameters",x)
        m1 = safe_cols("'spearmancorrm2': incorrect parameters",x)
        m2 = safe_cols("'spearmancorrm2': incorrect parameters",y)
    else:
        raise RuntimeError("Error while calling 'spearmancorrm2': function must have 2 or 5 parameters")
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(y):
        raise ValueError("'y' parameter can't be cast to real_matrix")
    __y = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __m1 = x_int()
    __m1.val = int(m1)
    if __m1.val!=m1:
        raise ValueError("Error while converting 'm1' parameter to 'x_int'")
    __m2 = x_int()
    __m2.val = int(m2)
    if __m2.val!=m2:
        raise ValueError("Error while converting 'm2' parameter to 'x_int'")
    __c = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        x_from_listlist(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spearmancorrm2(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), ctypes.byref(__m1), ctypes.byref(__m2), ctypes.byref(__c), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spearmancorrm2'")
        __r__c = listlist_from_x(__c)
        return __r__c
    finally:
        x_matrix_clear(__x)
        x_matrix_clear(__y)
        x_matrix_clear(__c)


_lib_alglib.alglib_xv2_rankdata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rankdata.restype = ctypes.c_int32
def rankdata(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        xy,npoints,nfeatures = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        xy, = functionargs
        npoints = safe_rows("'rankdata': incorrect parameters",xy)
        nfeatures = safe_cols("'rankdata': incorrect parameters",xy)
    else:
        raise RuntimeError("Error while calling 'rankdata': function must have 1 or 3 parameters")
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nfeatures = x_int()
    __nfeatures.val = int(nfeatures)
    if __nfeatures.val!=nfeatures:
        raise ValueError("Error while converting 'nfeatures' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rankdata(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nfeatures), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rankdata'")
        __r__xy = listlist_from_x(__xy)
        return __r__xy
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_rankdatacentered.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_rankdatacentered.restype = ctypes.c_int32
def rankdatacentered(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        xy,npoints,nfeatures = functionargs
    elif len(functionargs)==1:
        __friendly_form = True
        xy, = functionargs
        npoints = safe_rows("'rankdatacentered': incorrect parameters",xy)
        nfeatures = safe_cols("'rankdatacentered': incorrect parameters",xy)
    else:
        raise RuntimeError("Error while calling 'rankdatacentered': function must have 1 or 3 parameters")
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nfeatures = x_int()
    __nfeatures.val = int(nfeatures)
    if __nfeatures.val!=nfeatures:
        raise ValueError("Error while converting 'nfeatures' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_rankdatacentered(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nfeatures), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'rankdatacentered'")
        __r__xy = listlist_from_x(__xy)
        return __r__xy
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_pearsoncorrelation.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pearsoncorrelation.restype = ctypes.c_int32
def pearsoncorrelation(x, y, n):
    pass
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pearsoncorrelation(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pearsoncorrelation'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_spearmanrankcorrelation.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_spearmanrankcorrelation.restype = ctypes.c_int32
def spearmanrankcorrelation(x, y, n):
    pass
    __result = ctypes.c_double(0)
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_spearmanrankcorrelation(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'spearmanrankcorrelation'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_pcabuildbasis.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pcabuildbasis.restype = ctypes.c_int32
def pcabuildbasis(x, npoints, nvars):
    pass
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __s2 = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __v = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pcabuildbasis(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__info), ctypes.byref(__s2), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pcabuildbasis'")
        __r__info = __info.val
        __r__s2 = list_from_x(__s2)
        __r__v = listlist_from_x(__v)
        return (__r__info, __r__s2, __r__v)
    finally:
        x_matrix_clear(__x)
        x_vector_clear(__s2)
        x_matrix_clear(__v)


_lib_alglib.alglib_xv2_pcatruncatedsubspace.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pcatruncatedsubspace.restype = ctypes.c_int32
def pcatruncatedsubspace(x, npoints, nvars, nneeded, eps, maxits):
    pass
    if not is_real_matrix(x):
        raise ValueError("'x' parameter can't be cast to real_matrix")
    __x = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __nneeded = x_int()
    __nneeded.val = int(nneeded)
    if __nneeded.val!=nneeded:
        raise ValueError("Error while converting 'nneeded' parameter to 'x_int'")
    __eps = ctypes.c_double(eps)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    __s2 = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __v = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pcatruncatedsubspace(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__nneeded), ctypes.byref(__eps), ctypes.byref(__maxits), ctypes.byref(__s2), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pcatruncatedsubspace'")
        __r__s2 = list_from_x(__s2)
        __r__v = listlist_from_x(__v)
        return (__r__s2, __r__v)
    finally:
        x_matrix_clear(__x)
        x_vector_clear(__s2)
        x_matrix_clear(__v)


_lib_alglib.alglib_xv2_pcatruncatedsubspacesparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_pcatruncatedsubspacesparse.restype = ctypes.c_int32
def pcatruncatedsubspacesparse(x, npoints, nvars, nneeded, eps, maxits):
    pass
    __x = x.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __nneeded = x_int()
    __nneeded.val = int(nneeded)
    if __nneeded.val!=nneeded:
        raise ValueError("Error while converting 'nneeded' parameter to 'x_int'")
    __eps = ctypes.c_double(eps)
    __maxits = x_int()
    __maxits.val = int(maxits)
    if __maxits.val!=maxits:
        raise ValueError("Error while converting 'maxits' parameter to 'x_int'")
    __s2 = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __v = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_pcatruncatedsubspacesparse(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__nneeded), ctypes.byref(__eps), ctypes.byref(__maxits), ctypes.byref(__s2), ctypes.byref(__v), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'pcatruncatedsubspacesparse'")
        __r__s2 = list_from_x(__s2)
        __r__v = listlist_from_x(__v)
        return (__r__s2, __r__v)
    finally:
        x_vector_clear(__s2)
        x_matrix_clear(__v)


_lib_alglib.alglib_xv2_dsoptimalsplit2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_dsoptimalsplit2.restype = ctypes.c_int32
def dsoptimalsplit2(a, c, n):
    pass
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(c):
        raise ValueError("'c' parameter can't be cast to int_vector")
    __c = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __threshold = ctypes.c_double(0)
    __pal = ctypes.c_double(0)
    __pbl = ctypes.c_double(0)
    __par = ctypes.c_double(0)
    __pbr = ctypes.c_double(0)
    __cve = ctypes.c_double(0)
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        x_from_list(__c, c, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_dsoptimalsplit2(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__c), ctypes.byref(__n), ctypes.byref(__info), ctypes.byref(__threshold), ctypes.byref(__pal), ctypes.byref(__pbl), ctypes.byref(__par), ctypes.byref(__pbr), ctypes.byref(__cve), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'dsoptimalsplit2'")
        __r__info = __info.val
        __r__threshold = __threshold.value
        __r__pal = __pal.value
        __r__pbl = __pbl.value
        __r__par = __par.value
        __r__pbr = __pbr.value
        __r__cve = __cve.value
        return (__r__info, __r__threshold, __r__pal, __r__pbl, __r__par, __r__pbr, __r__cve)
    finally:
        x_vector_clear(__a)
        x_vector_clear(__c)


_lib_alglib.alglib_xv2_dsoptimalsplit2fast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_dsoptimalsplit2fast.restype = ctypes.c_int32
def dsoptimalsplit2fast(a, c, tiesbuf, cntbuf, bufr, bufi, n, nc, alpha):
    pass
    if not is_real_vector(a):
        raise ValueError("'a' parameter can't be cast to real_vector")
    __a = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(c):
        raise ValueError("'c' parameter can't be cast to int_vector")
    __c = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(tiesbuf):
        raise ValueError("'tiesbuf' parameter can't be cast to int_vector")
    __tiesbuf = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(cntbuf):
        raise ValueError("'cntbuf' parameter can't be cast to int_vector")
    __cntbuf = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(bufr):
        raise ValueError("'bufr' parameter can't be cast to real_vector")
    __bufr = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_int_vector(bufi):
        raise ValueError("'bufi' parameter can't be cast to int_vector")
    __bufi = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __nc = x_int()
    __nc.val = int(nc)
    if __nc.val!=nc:
        raise ValueError("Error while converting 'nc' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    __info = x_int()
    __info.val = 0
    __threshold = ctypes.c_double(0)
    __rms = ctypes.c_double(0)
    __cvrms = ctypes.c_double(0)
    try:
        x_from_list(__a, a, DT_REAL, X_CREATE)
        x_from_list(__c, c, DT_INT, X_CREATE)
        x_from_list(__tiesbuf, tiesbuf, DT_INT, X_CREATE)
        x_from_list(__cntbuf, cntbuf, DT_INT, X_CREATE)
        x_from_list(__bufr, bufr, DT_REAL, X_CREATE)
        x_from_list(__bufi, bufi, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_dsoptimalsplit2fast(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__c), ctypes.byref(__tiesbuf), ctypes.byref(__cntbuf), ctypes.byref(__bufr), ctypes.byref(__bufi), ctypes.byref(__n), ctypes.byref(__nc), ctypes.byref(__alpha), ctypes.byref(__info), ctypes.byref(__threshold), ctypes.byref(__rms), ctypes.byref(__cvrms), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'dsoptimalsplit2fast'")
        __r__a = list_from_x(__a)
        __r__c = list_from_x(__c)
        __r__tiesbuf = list_from_x(__tiesbuf)
        __r__cntbuf = list_from_x(__cntbuf)
        __r__bufr = list_from_x(__bufr)
        __r__bufi = list_from_x(__bufi)
        __r__info = __info.val
        __r__threshold = __threshold.value
        __r__rms = __rms.value
        __r__cvrms = __cvrms.value
        return (__r__a, __r__c, __r__tiesbuf, __r__cntbuf, __r__bufr, __r__bufi, __r__info, __r__threshold, __r__rms, __r__cvrms)
    finally:
        x_vector_clear(__a)
        x_vector_clear(__c)
        x_vector_clear(__tiesbuf)
        x_vector_clear(__cntbuf)
        x_vector_clear(__bufr)
        x_vector_clear(__bufi)




class x_modelerrors(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("relclserror", ctypes.c_double),
        ("avgce", ctypes.c_double),
        ("rmserror", ctypes.c_double),
        ("avgerror", ctypes.c_double),
        ("avgrelerror", ctypes.c_double)
        ]




class modelerrors(object):
    def __init__(self):
        self.relclserror = 0
        self.avgce = 0
        self.rmserror = 0
        self.avgerror = 0
        self.avgrelerror = 0


def x_modelerrors_zero_fields(x):
    x.relclserror = 0
    x.avgce = 0
    x.rmserror = 0
    x.avgerror = 0
    x.avgrelerror = 0
    return




def x_modelerrors_clear(x):
    x_modelerrors_zero_fields(x)
    return




def x_from_modelerrors(x,v):
    x.relclserror = float(v.relclserror)
    x.avgce = float(v.avgce)
    x.rmserror = float(v.rmserror)
    x.avgerror = float(v.avgerror)
    x.avgrelerror = float(v.avgrelerror)
    return




def modelerrors_from_x(x):
    r = modelerrors()
    r.relclserror = x.relclserror
    r.avgce = x.avgce
    r.rmserror = x.rmserror
    r.avgerror = x.avgerror
    r.avgrelerror = x.avgrelerror
    return r


_lib_alglib.x_obj_free_multilayerperceptron.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_multilayerperceptron.restype = None


class multilayerperceptron(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_multilayerperceptron(self.ptr)
_lib_alglib.alglib_mlpserialize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.alglib_mlpserialize.restype = ctypes.c_int32

def mlpserialize(obj):
    error_msg = ctypes.c_char_p(0)
    _s_out = ctypes.c_char_p(0)
    retval = _lib_alglib.alglib_mlpserialize(ctypes.byref(error_msg), ctypes.byref(obj.ptr), ctypes.byref(_s_out))
    if retval!=0:
        if retval==X_ASSERTION_FAILED:
            raise RuntimeError(error_msg.value)
        else:
            raise RuntimeError("Error while calling 'mlpserialize'")
    s_out = _s_out.value
    _lib_alglib.x_free(_s_out)
    return s_out

_lib_alglib.alglib_mlpunserialize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p]
_lib_alglib.alglib_mlpunserialize.restype = ctypes.c_int32

def mlpunserialize(s_in):
    error_msg = ctypes.c_char_p(0)
    _s_in = ctypes.c_char_p(s_in)
    _obj = ctypes.c_void_p(0)
    retval = _lib_alglib.alglib_mlpunserialize(ctypes.byref(error_msg), ctypes.byref(_s_in), ctypes.byref(_obj), )
    if retval!=0:
        if retval==X_ASSERTION_FAILED:
            raise RuntimeError(error_msg.value)
        else:
            raise RuntimeError("Error while calling 'mlpserialize'")
    return multilayerperceptron(_obj)

_lib_alglib.alglib_xv2_mlpcreate0.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreate0.restype = ctypes.c_int32
def mlpcreate0(nin, nout):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreate0(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nout), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreate0'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreate1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreate1.restype = ctypes.c_int32
def mlpcreate1(nin, nhid, nout):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid = x_int()
    __nhid.val = int(nhid)
    if __nhid.val!=nhid:
        raise ValueError("Error while converting 'nhid' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreate1(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid), ctypes.byref(__nout), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreate1'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreate2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreate2.restype = ctypes.c_int32
def mlpcreate2(nin, nhid1, nhid2, nout):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid1 = x_int()
    __nhid1.val = int(nhid1)
    if __nhid1.val!=nhid1:
        raise ValueError("Error while converting 'nhid1' parameter to 'x_int'")
    __nhid2 = x_int()
    __nhid2.val = int(nhid2)
    if __nhid2.val!=nhid2:
        raise ValueError("Error while converting 'nhid2' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreate2(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid1), ctypes.byref(__nhid2), ctypes.byref(__nout), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreate2'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreateb0.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreateb0.restype = ctypes.c_int32
def mlpcreateb0(nin, nout, b, d):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __b = ctypes.c_double(b)
    __d = ctypes.c_double(d)
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreateb0(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nout), ctypes.byref(__b), ctypes.byref(__d), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreateb0'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreateb1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreateb1.restype = ctypes.c_int32
def mlpcreateb1(nin, nhid, nout, b, d):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid = x_int()
    __nhid.val = int(nhid)
    if __nhid.val!=nhid:
        raise ValueError("Error while converting 'nhid' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __b = ctypes.c_double(b)
    __d = ctypes.c_double(d)
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreateb1(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid), ctypes.byref(__nout), ctypes.byref(__b), ctypes.byref(__d), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreateb1'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreateb2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreateb2.restype = ctypes.c_int32
def mlpcreateb2(nin, nhid1, nhid2, nout, b, d):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid1 = x_int()
    __nhid1.val = int(nhid1)
    if __nhid1.val!=nhid1:
        raise ValueError("Error while converting 'nhid1' parameter to 'x_int'")
    __nhid2 = x_int()
    __nhid2.val = int(nhid2)
    if __nhid2.val!=nhid2:
        raise ValueError("Error while converting 'nhid2' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __b = ctypes.c_double(b)
    __d = ctypes.c_double(d)
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreateb2(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid1), ctypes.byref(__nhid2), ctypes.byref(__nout), ctypes.byref(__b), ctypes.byref(__d), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreateb2'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreater0.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreater0.restype = ctypes.c_int32
def mlpcreater0(nin, nout, a, b):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __a = ctypes.c_double(a)
    __b = ctypes.c_double(b)
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreater0(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nout), ctypes.byref(__a), ctypes.byref(__b), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreater0'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreater1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreater1.restype = ctypes.c_int32
def mlpcreater1(nin, nhid, nout, a, b):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid = x_int()
    __nhid.val = int(nhid)
    if __nhid.val!=nhid:
        raise ValueError("Error while converting 'nhid' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __a = ctypes.c_double(a)
    __b = ctypes.c_double(b)
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreater1(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid), ctypes.byref(__nout), ctypes.byref(__a), ctypes.byref(__b), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreater1'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreater2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreater2.restype = ctypes.c_int32
def mlpcreater2(nin, nhid1, nhid2, nout, a, b):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid1 = x_int()
    __nhid1.val = int(nhid1)
    if __nhid1.val!=nhid1:
        raise ValueError("Error while converting 'nhid1' parameter to 'x_int'")
    __nhid2 = x_int()
    __nhid2.val = int(nhid2)
    if __nhid2.val!=nhid2:
        raise ValueError("Error while converting 'nhid2' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __a = ctypes.c_double(a)
    __b = ctypes.c_double(b)
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreater2(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid1), ctypes.byref(__nhid2), ctypes.byref(__nout), ctypes.byref(__a), ctypes.byref(__b), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreater2'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreatec0.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreatec0.restype = ctypes.c_int32
def mlpcreatec0(nin, nout):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreatec0(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nout), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreatec0'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreatec1.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreatec1.restype = ctypes.c_int32
def mlpcreatec1(nin, nhid, nout):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid = x_int()
    __nhid.val = int(nhid)
    if __nhid.val!=nhid:
        raise ValueError("Error while converting 'nhid' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreatec1(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid), ctypes.byref(__nout), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreatec1'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcreatec2.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcreatec2.restype = ctypes.c_int32
def mlpcreatec2(nin, nhid1, nhid2, nout):
    pass
    __nin = x_int()
    __nin.val = int(nin)
    if __nin.val!=nin:
        raise ValueError("Error while converting 'nin' parameter to 'x_int'")
    __nhid1 = x_int()
    __nhid1.val = int(nhid1)
    if __nhid1.val!=nhid1:
        raise ValueError("Error while converting 'nhid1' parameter to 'x_int'")
    __nhid2 = x_int()
    __nhid2.val = int(nhid2)
    if __nhid2.val!=nhid2:
        raise ValueError("Error while converting 'nhid2' parameter to 'x_int'")
    __nout = x_int()
    __nout.val = int(nout)
    if __nout.val!=nout:
        raise ValueError("Error while converting 'nout' parameter to 'x_int'")
    __network = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcreatec2(ctypes.byref(_error_msg), ctypes.byref(__nin), ctypes.byref(__nhid1), ctypes.byref(__nhid2), ctypes.byref(__nout), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcreatec2'")
        __r__network = multilayerperceptron(__network)
        return __r__network
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcopy.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcopy.restype = ctypes.c_int32
def mlpcopy(network1):
    pass
    __network1 = network1.ptr
    __network2 = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcopy(ctypes.byref(_error_msg), ctypes.byref(__network1), ctypes.byref(__network2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcopy'")
        __r__network2 = multilayerperceptron(__network2)
        return __r__network2
    finally:
        pass


_lib_alglib.alglib_xv2_mlpcopytunableparameters.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpcopytunableparameters.restype = ctypes.c_int32
def mlpcopytunableparameters(network1, network2):
    pass
    __network1 = network1.ptr
    __network2 = network2.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpcopytunableparameters(ctypes.byref(_error_msg), ctypes.byref(__network1), ctypes.byref(__network2), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpcopytunableparameters'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlprandomize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlprandomize.restype = ctypes.c_int32
def mlprandomize(network):
    pass
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlprandomize(ctypes.byref(_error_msg), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlprandomize'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlprandomizefull.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlprandomizefull.restype = ctypes.c_int32
def mlprandomizefull(network):
    pass
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlprandomizefull(ctypes.byref(_error_msg), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlprandomizefull'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlpinitpreprocessor.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpinitpreprocessor.restype = ctypes.c_int32
def mlpinitpreprocessor(network, xy, ssize):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpinitpreprocessor(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpinitpreprocessor'")
        return
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlpproperties.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpproperties.restype = ctypes.c_int32
def mlpproperties(network):
    pass
    __network = network.ptr
    __nin = x_int()
    __nin.val = 0
    __nout = x_int()
    __nout.val = 0
    __wcount = x_int()
    __wcount.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpproperties(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__nin), ctypes.byref(__nout), ctypes.byref(__wcount), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpproperties'")
        __r__nin = __nin.val
        __r__nout = __nout.val
        __r__wcount = __wcount.val
        return (__r__nin, __r__nout, __r__wcount)
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetinputscount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetinputscount.restype = ctypes.c_int32
def mlpgetinputscount(network):
    pass
    __result = x_int()
    __result.val = 0
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetinputscount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetinputscount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetoutputscount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetoutputscount.restype = ctypes.c_int32
def mlpgetoutputscount(network):
    pass
    __result = x_int()
    __result.val = 0
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetoutputscount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetoutputscount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetweightscount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetweightscount.restype = ctypes.c_int32
def mlpgetweightscount(network):
    pass
    __result = x_int()
    __result.val = 0
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetweightscount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetweightscount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpissoftmax.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpissoftmax.restype = ctypes.c_int32
def mlpissoftmax(network):
    pass
    __result = ctypes.c_uint64(0)
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpissoftmax(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpissoftmax'")
        __r__result = __result.value!=0
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetlayerscount.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetlayerscount.restype = ctypes.c_int32
def mlpgetlayerscount(network):
    pass
    __result = x_int()
    __result.val = 0
    __network = network.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetlayerscount(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetlayerscount'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetlayersize.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetlayersize.restype = ctypes.c_int32
def mlpgetlayersize(network, k):
    pass
    __result = x_int()
    __result.val = 0
    __network = network.ptr
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetlayersize(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetlayersize'")
        __r__result = __result.val
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetinputscaling.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetinputscaling.restype = ctypes.c_int32
def mlpgetinputscaling(network, i):
    pass
    __network = network.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __mean = ctypes.c_double(0)
    __sigma = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetinputscaling(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__i), ctypes.byref(__mean), ctypes.byref(__sigma), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetinputscaling'")
        __r__mean = __mean.value
        __r__sigma = __sigma.value
        return (__r__mean, __r__sigma)
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetoutputscaling.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetoutputscaling.restype = ctypes.c_int32
def mlpgetoutputscaling(network, i):
    pass
    __network = network.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __mean = ctypes.c_double(0)
    __sigma = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetoutputscaling(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__i), ctypes.byref(__mean), ctypes.byref(__sigma), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetoutputscaling'")
        __r__mean = __mean.value
        __r__sigma = __sigma.value
        return (__r__mean, __r__sigma)
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetneuroninfo.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetneuroninfo.restype = ctypes.c_int32
def mlpgetneuroninfo(network, k, i):
    pass
    __network = network.ptr
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __fkind = x_int()
    __fkind.val = 0
    __threshold = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetneuroninfo(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__k), ctypes.byref(__i), ctypes.byref(__fkind), ctypes.byref(__threshold), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetneuroninfo'")
        __r__fkind = __fkind.val
        __r__threshold = __threshold.value
        return (__r__fkind, __r__threshold)
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgetweight.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgetweight.restype = ctypes.c_int32
def mlpgetweight(network, k0, i0, k1, i1):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __k0 = x_int()
    __k0.val = int(k0)
    if __k0.val!=k0:
        raise ValueError("Error while converting 'k0' parameter to 'x_int'")
    __i0 = x_int()
    __i0.val = int(i0)
    if __i0.val!=i0:
        raise ValueError("Error while converting 'i0' parameter to 'x_int'")
    __k1 = x_int()
    __k1.val = int(k1)
    if __k1.val!=k1:
        raise ValueError("Error while converting 'k1' parameter to 'x_int'")
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgetweight(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__k0), ctypes.byref(__i0), ctypes.byref(__k1), ctypes.byref(__i1), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgetweight'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpsetinputscaling.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpsetinputscaling.restype = ctypes.c_int32
def mlpsetinputscaling(network, i, mean, sigma):
    pass
    __network = network.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __mean = ctypes.c_double(mean)
    __sigma = ctypes.c_double(sigma)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpsetinputscaling(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__i), ctypes.byref(__mean), ctypes.byref(__sigma), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpsetinputscaling'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlpsetoutputscaling.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpsetoutputscaling.restype = ctypes.c_int32
def mlpsetoutputscaling(network, i, mean, sigma):
    pass
    __network = network.ptr
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __mean = ctypes.c_double(mean)
    __sigma = ctypes.c_double(sigma)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpsetoutputscaling(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__i), ctypes.byref(__mean), ctypes.byref(__sigma), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpsetoutputscaling'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlpsetneuroninfo.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpsetneuroninfo.restype = ctypes.c_int32
def mlpsetneuroninfo(network, k, i, fkind, threshold):
    pass
    __network = network.ptr
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __i = x_int()
    __i.val = int(i)
    if __i.val!=i:
        raise ValueError("Error while converting 'i' parameter to 'x_int'")
    __fkind = x_int()
    __fkind.val = int(fkind)
    if __fkind.val!=fkind:
        raise ValueError("Error while converting 'fkind' parameter to 'x_int'")
    __threshold = ctypes.c_double(threshold)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpsetneuroninfo(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__k), ctypes.byref(__i), ctypes.byref(__fkind), ctypes.byref(__threshold), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpsetneuroninfo'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlpsetweight.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpsetweight.restype = ctypes.c_int32
def mlpsetweight(network, k0, i0, k1, i1, w):
    pass
    __network = network.ptr
    __k0 = x_int()
    __k0.val = int(k0)
    if __k0.val!=k0:
        raise ValueError("Error while converting 'k0' parameter to 'x_int'")
    __i0 = x_int()
    __i0.val = int(i0)
    if __i0.val!=i0:
        raise ValueError("Error while converting 'i0' parameter to 'x_int'")
    __k1 = x_int()
    __k1.val = int(k1)
    if __k1.val!=k1:
        raise ValueError("Error while converting 'k1' parameter to 'x_int'")
    __i1 = x_int()
    __i1.val = int(i1)
    if __i1.val!=i1:
        raise ValueError("Error while converting 'i1' parameter to 'x_int'")
    __w = ctypes.c_double(w)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpsetweight(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__k0), ctypes.byref(__i0), ctypes.byref(__k1), ctypes.byref(__i1), ctypes.byref(__w), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpsetweight'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_mlpactivationfunction.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpactivationfunction.restype = ctypes.c_int32
def mlpactivationfunction(net, k):
    pass
    __net = ctypes.c_double(net)
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    __f = ctypes.c_double(0)
    __df = ctypes.c_double(0)
    __d2f = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpactivationfunction(ctypes.byref(_error_msg), ctypes.byref(__net), ctypes.byref(__k), ctypes.byref(__f), ctypes.byref(__df), ctypes.byref(__d2f), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpactivationfunction'")
        __r__f = __f.value
        __r__df = __df.value
        __r__d2f = __d2f.value
        return (__r__f, __r__df, __r__d2f)
    finally:
        pass


_lib_alglib.alglib_xv2_mlpprocess.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpprocess.restype = ctypes.c_int32
def mlpprocess(network, x, y):
    pass
    __network = network.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpprocess(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpprocess'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_mlpprocessi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpprocessi.restype = ctypes.c_int32
def mlpprocessi(network, x):
    pass
    __network = network.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __y = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpprocessi(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpprocessi'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_mlperror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlperror.restype = ctypes.c_int32
def mlperror(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlperror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlperror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlperrorsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlperrorsparse.restype = ctypes.c_int32
def mlperrorsparse(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlperrorsparse(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlperrorsparse'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlperrorn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlperrorn.restype = ctypes.c_int32
def mlperrorn(network, xy, ssize):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlperrorn(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlperrorn'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlpclserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpclserror.restype = ctypes.c_int32
def mlpclserror(network, xy, npoints):
    pass
    __result = x_int()
    __result.val = 0
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpclserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpclserror'")
        __r__result = __result.val
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlprelclserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlprelclserror.restype = ctypes.c_int32
def mlprelclserror(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlprelclserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlprelclserror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlprelclserrorsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlprelclserrorsparse.restype = ctypes.c_int32
def mlprelclserrorsparse(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlprelclserrorsparse(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlprelclserrorsparse'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpavgce.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpavgce.restype = ctypes.c_int32
def mlpavgce(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpavgce(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpavgce'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlpavgcesparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpavgcesparse.restype = ctypes.c_int32
def mlpavgcesparse(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpavgcesparse(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpavgcesparse'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlprmserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlprmserror.restype = ctypes.c_int32
def mlprmserror(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlprmserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlprmserror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlprmserrorsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlprmserrorsparse.restype = ctypes.c_int32
def mlprmserrorsparse(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlprmserrorsparse(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlprmserrorsparse'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpavgerror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpavgerror.restype = ctypes.c_int32
def mlpavgerror(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpavgerror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpavgerror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlpavgerrorsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpavgerrorsparse.restype = ctypes.c_int32
def mlpavgerrorsparse(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpavgerrorsparse(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpavgerrorsparse'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpavgrelerror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpavgrelerror.restype = ctypes.c_int32
def mlpavgrelerror(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpavgrelerror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpavgrelerror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mlpavgrelerrorsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpavgrelerrorsparse.restype = ctypes.c_int32
def mlpavgrelerrorsparse(network, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpavgrelerrorsparse(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpavgrelerrorsparse'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_mlpgrad.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgrad.restype = ctypes.c_int32
def mlpgrad(network, x, desiredy, grad):
    pass
    __network = network.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(desiredy):
        raise ValueError("'desiredy' parameter can't be cast to real_vector")
    __desiredy = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__desiredy, desiredy, DT_REAL, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgrad(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__x), ctypes.byref(__desiredy), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgrad'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_vector_clear(__x)
        x_vector_clear(__desiredy)
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlpgradn.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgradn.restype = ctypes.c_int32
def mlpgradn(network, x, desiredy, grad):
    pass
    __network = network.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(desiredy):
        raise ValueError("'desiredy' parameter can't be cast to real_vector")
    __desiredy = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__desiredy, desiredy, DT_REAL, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgradn(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__x), ctypes.byref(__desiredy), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgradn'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_vector_clear(__x)
        x_vector_clear(__desiredy)
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlpgradbatch.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgradbatch.restype = ctypes.c_int32
def mlpgradbatch(network, xy, ssize, grad):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgradbatch(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgradbatch'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlpgradbatchsparse.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgradbatchsparse.restype = ctypes.c_int32
def mlpgradbatchsparse(network, xy, ssize, grad):
    pass
    __network = network.ptr
    __xy = xy.ptr
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgradbatchsparse(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgradbatchsparse'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlpgradbatchsubset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgradbatchsubset.restype = ctypes.c_int32
def mlpgradbatchsubset(network, xy, setsize, idx, subsetsize, grad):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __setsize = x_int()
    __setsize.val = int(setsize)
    if __setsize.val!=setsize:
        raise ValueError("Error while converting 'setsize' parameter to 'x_int'")
    if not is_int_vector(idx):
        raise ValueError("'idx' parameter can't be cast to int_vector")
    __idx = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __subsetsize = x_int()
    __subsetsize.val = int(subsetsize)
    if __subsetsize.val!=subsetsize:
        raise ValueError("Error while converting 'subsetsize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__idx, idx, DT_INT, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgradbatchsubset(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__setsize), ctypes.byref(__idx), ctypes.byref(__subsetsize), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgradbatchsubset'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__idx)
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlpgradbatchsparsesubset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgradbatchsparsesubset.restype = ctypes.c_int32
def mlpgradbatchsparsesubset(network, xy, setsize, idx, subsetsize, grad):
    pass
    __network = network.ptr
    __xy = xy.ptr
    __setsize = x_int()
    __setsize.val = int(setsize)
    if __setsize.val!=setsize:
        raise ValueError("Error while converting 'setsize' parameter to 'x_int'")
    if not is_int_vector(idx):
        raise ValueError("'idx' parameter can't be cast to int_vector")
    __idx = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __subsetsize = x_int()
    __subsetsize.val = int(subsetsize)
    if __subsetsize.val!=subsetsize:
        raise ValueError("Error while converting 'subsetsize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__idx, idx, DT_INT, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgradbatchsparsesubset(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__setsize), ctypes.byref(__idx), ctypes.byref(__subsetsize), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgradbatchsparsesubset'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_vector_clear(__idx)
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlpgradnbatch.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpgradnbatch.restype = ctypes.c_int32
def mlpgradnbatch(network, xy, ssize, grad):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpgradnbatch(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), ctypes.byref(__e), ctypes.byref(__grad), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpgradnbatch'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        return (__r__e, __r__grad)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__grad)


_lib_alglib.alglib_xv2_mlphessiannbatch.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlphessiannbatch.restype = ctypes.c_int32
def mlphessiannbatch(network, xy, ssize, grad, h):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(h):
        raise ValueError("'h' parameter can't be cast to real_matrix")
    __h = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        x_from_listlist(__h, h, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlphessiannbatch(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), ctypes.byref(__e), ctypes.byref(__grad), ctypes.byref(__h), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlphessiannbatch'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        __r__h = listlist_from_x(__h)
        return (__r__e, __r__grad, __r__h)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__grad)
        x_matrix_clear(__h)


_lib_alglib.alglib_xv2_mlphessianbatch.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlphessianbatch.restype = ctypes.c_int32
def mlphessianbatch(network, xy, ssize, grad, h):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    __e = ctypes.c_double(0)
    if not is_real_vector(grad):
        raise ValueError("'grad' parameter can't be cast to real_vector")
    __grad = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_matrix(h):
        raise ValueError("'h' parameter can't be cast to real_matrix")
    __h = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__grad, grad, DT_REAL, X_CREATE)
        x_from_listlist(__h, h, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlphessianbatch(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__ssize), ctypes.byref(__e), ctypes.byref(__grad), ctypes.byref(__h), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlphessianbatch'")
        __r__e = __e.value
        __r__grad = list_from_x(__grad)
        __r__h = listlist_from_x(__h)
        return (__r__e, __r__grad, __r__h)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__grad)
        x_matrix_clear(__h)


_lib_alglib.alglib_xv2_mlpallerrorssubset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpallerrorssubset.restype = ctypes.c_int32
def mlpallerrorssubset(network, xy, setsize, subset, subsetsize):
    pass
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __setsize = x_int()
    __setsize.val = int(setsize)
    if __setsize.val!=setsize:
        raise ValueError("Error while converting 'setsize' parameter to 'x_int'")
    if not is_int_vector(subset):
        raise ValueError("'subset' parameter can't be cast to int_vector")
    __subset = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __subsetsize = x_int()
    __subsetsize.val = int(subsetsize)
    if __subsetsize.val!=subsetsize:
        raise ValueError("Error while converting 'subsetsize' parameter to 'x_int'")
    __rep = x_modelerrors()
    x_modelerrors_zero_fields(__rep)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__subset, subset, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpallerrorssubset(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__setsize), ctypes.byref(__subset), ctypes.byref(__subsetsize), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpallerrorssubset'")
        __r__rep = modelerrors_from_x(__rep)
        return __r__rep
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__subset)
        x_modelerrors_clear(__rep)


_lib_alglib.alglib_xv2_mlpallerrorssparsesubset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlpallerrorssparsesubset.restype = ctypes.c_int32
def mlpallerrorssparsesubset(network, xy, setsize, subset, subsetsize):
    pass
    __network = network.ptr
    __xy = xy.ptr
    __setsize = x_int()
    __setsize.val = int(setsize)
    if __setsize.val!=setsize:
        raise ValueError("Error while converting 'setsize' parameter to 'x_int'")
    if not is_int_vector(subset):
        raise ValueError("'subset' parameter can't be cast to int_vector")
    __subset = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __subsetsize = x_int()
    __subsetsize.val = int(subsetsize)
    if __subsetsize.val!=subsetsize:
        raise ValueError("Error while converting 'subsetsize' parameter to 'x_int'")
    __rep = x_modelerrors()
    x_modelerrors_zero_fields(__rep)
    try:
        x_from_list(__subset, subset, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlpallerrorssparsesubset(ctypes.byref(_error_msg), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__setsize), ctypes.byref(__subset), ctypes.byref(__subsetsize), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlpallerrorssparsesubset'")
        __r__rep = modelerrors_from_x(__rep)
        return __r__rep
    finally:
        x_vector_clear(__subset)
        x_modelerrors_clear(__rep)


_lib_alglib.alglib_xv2_mlperrorsubset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlperrorsubset.restype = ctypes.c_int32
def mlperrorsubset(network, xy, setsize, subset, subsetsize):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __setsize = x_int()
    __setsize.val = int(setsize)
    if __setsize.val!=setsize:
        raise ValueError("Error while converting 'setsize' parameter to 'x_int'")
    if not is_int_vector(subset):
        raise ValueError("'subset' parameter can't be cast to int_vector")
    __subset = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __subsetsize = x_int()
    __subsetsize.val = int(subsetsize)
    if __subsetsize.val!=subsetsize:
        raise ValueError("Error while converting 'subsetsize' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__subset, subset, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlperrorsubset(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__setsize), ctypes.byref(__subset), ctypes.byref(__subsetsize), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlperrorsubset'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__subset)


_lib_alglib.alglib_xv2_mlperrorsparsesubset.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mlperrorsparsesubset.restype = ctypes.c_int32
def mlperrorsparsesubset(network, xy, setsize, subset, subsetsize):
    pass
    __result = ctypes.c_double(0)
    __network = network.ptr
    __xy = xy.ptr
    __setsize = x_int()
    __setsize.val = int(setsize)
    if __setsize.val!=setsize:
        raise ValueError("Error while converting 'setsize' parameter to 'x_int'")
    if not is_int_vector(subset):
        raise ValueError("'subset' parameter can't be cast to int_vector")
    __subset = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __subsetsize = x_int()
    __subsetsize.val = int(subsetsize)
    if __subsetsize.val!=subsetsize:
        raise ValueError("Error while converting 'subsetsize' parameter to 'x_int'")
    try:
        x_from_list(__subset, subset, DT_INT, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mlperrorsparsesubset(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__network), ctypes.byref(__xy), ctypes.byref(__setsize), ctypes.byref(__subset), ctypes.byref(__subsetsize), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mlperrorsparsesubset'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__subset)


_lib_alglib.alglib_xv2_fisherlda.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_fisherlda.restype = ctypes.c_int32
def fisherlda(xy, npoints, nvars, nclasses):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __nclasses = x_int()
    __nclasses.val = int(nclasses)
    if __nclasses.val!=nclasses:
        raise ValueError("Error while converting 'nclasses' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __w = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_fisherlda(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__nclasses), ctypes.byref(__info), ctypes.byref(__w), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'fisherlda'")
        __r__info = __info.val
        __r__w = list_from_x(__w)
        return (__r__info, __r__w)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__w)


_lib_alglib.alglib_xv2_fisherldan.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_fisherldan.restype = ctypes.c_int32
def fisherldan(xy, npoints, nvars, nclasses):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __nclasses = x_int()
    __nclasses.val = int(nclasses)
    if __nclasses.val!=nclasses:
        raise ValueError("Error while converting 'nclasses' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __w = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_fisherldan(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__nclasses), ctypes.byref(__info), ctypes.byref(__w), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'fisherldan'")
        __r__info = __info.val
        __r__w = listlist_from_x(__w)
        return (__r__info, __r__w)
    finally:
        x_matrix_clear(__xy)
        x_matrix_clear(__w)


_lib_alglib.x_obj_free_ssamodel.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_ssamodel.restype = None


class ssamodel(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_ssamodel(self.ptr)
_lib_alglib.alglib_xv2_ssacreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssacreate.restype = ctypes.c_int32
def ssacreate():
    pass
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssacreate(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssacreate'")
        __r__s = ssamodel(__s)
        return __r__s
    finally:
        pass


_lib_alglib.alglib_xv2_ssasetwindow.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetwindow.restype = ctypes.c_int32
def ssasetwindow(s, windowwidth):
    pass
    __s = s.ptr
    __windowwidth = x_int()
    __windowwidth.val = int(windowwidth)
    if __windowwidth.val!=windowwidth:
        raise ValueError("Error while converting 'windowwidth' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetwindow(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__windowwidth), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetwindow'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssasetseed.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetseed.restype = ctypes.c_int32
def ssasetseed(s, seed):
    pass
    __s = s.ptr
    __seed = x_int()
    __seed.val = int(seed)
    if __seed.val!=seed:
        raise ValueError("Error while converting 'seed' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetseed(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__seed), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetseed'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssasetpoweruplength.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetpoweruplength.restype = ctypes.c_int32
def ssasetpoweruplength(s, pwlen):
    pass
    __s = s.ptr
    __pwlen = x_int()
    __pwlen.val = int(pwlen)
    if __pwlen.val!=pwlen:
        raise ValueError("Error while converting 'pwlen' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetpoweruplength(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__pwlen), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetpoweruplength'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssasetmemorylimit.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetmemorylimit.restype = ctypes.c_int32
def ssasetmemorylimit(s, memlimit):
    pass
    __s = s.ptr
    __memlimit = x_int()
    __memlimit.val = int(memlimit)
    if __memlimit.val!=memlimit:
        raise ValueError("Error while converting 'memlimit' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetmemorylimit(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__memlimit), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetmemorylimit'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssaaddsequence.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaaddsequence.restype = ctypes.c_int32
def ssaaddsequence(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        s,x,n = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        s,x = functionargs
        n = safe_len("'ssaaddsequence': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'ssaaddsequence': function must have 2 or 3 parameters")
    __s = s.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaaddsequence(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__x), ctypes.byref(__n), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaaddsequence'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_ssaappendpointandupdate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaappendpointandupdate.restype = ctypes.c_int32
def ssaappendpointandupdate(s, x, updateits):
    pass
    __s = s.ptr
    __x = ctypes.c_double(x)
    __updateits = ctypes.c_double(updateits)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaappendpointandupdate(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__x), ctypes.byref(__updateits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaappendpointandupdate'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssaappendsequenceandupdate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaappendsequenceandupdate.restype = ctypes.c_int32
def ssaappendsequenceandupdate(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        s,x,nticks,updateits = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        s,x,updateits = functionargs
        nticks = safe_len("'ssaappendsequenceandupdate': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'ssaappendsequenceandupdate': function must have 3 or 4 parameters")
    __s = s.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nticks = x_int()
    __nticks.val = int(nticks)
    if __nticks.val!=nticks:
        raise ValueError("Error while converting 'nticks' parameter to 'x_int'")
    __updateits = ctypes.c_double(updateits)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaappendsequenceandupdate(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__x), ctypes.byref(__nticks), ctypes.byref(__updateits), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaappendsequenceandupdate'")
        return
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_ssasetalgoprecomputed.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetalgoprecomputed.restype = ctypes.c_int32
def ssasetalgoprecomputed(*functionargs):
    if len(functionargs)==4:
        __friendly_form = False
        s,a,windowwidth,nbasis = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        s,a = functionargs
        windowwidth = safe_rows("'ssasetalgoprecomputed': incorrect parameters",a)
        nbasis = safe_cols("'ssasetalgoprecomputed': incorrect parameters",a)
    else:
        raise RuntimeError("Error while calling 'ssasetalgoprecomputed': function must have 2 or 4 parameters")
    __s = s.ptr
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __windowwidth = x_int()
    __windowwidth.val = int(windowwidth)
    if __windowwidth.val!=windowwidth:
        raise ValueError("Error while converting 'windowwidth' parameter to 'x_int'")
    __nbasis = x_int()
    __nbasis.val = int(nbasis)
    if __nbasis.val!=nbasis:
        raise ValueError("Error while converting 'nbasis' parameter to 'x_int'")
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetalgoprecomputed(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__a), ctypes.byref(__windowwidth), ctypes.byref(__nbasis), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetalgoprecomputed'")
        return
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_ssasetalgotopkdirect.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetalgotopkdirect.restype = ctypes.c_int32
def ssasetalgotopkdirect(s, topk):
    pass
    __s = s.ptr
    __topk = x_int()
    __topk.val = int(topk)
    if __topk.val!=topk:
        raise ValueError("Error while converting 'topk' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetalgotopkdirect(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__topk), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetalgotopkdirect'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssasetalgotopkrealtime.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssasetalgotopkrealtime.restype = ctypes.c_int32
def ssasetalgotopkrealtime(s, topk):
    pass
    __s = s.ptr
    __topk = x_int()
    __topk.val = int(topk)
    if __topk.val!=topk:
        raise ValueError("Error while converting 'topk' parameter to 'x_int'")
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssasetalgotopkrealtime(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__topk), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssasetalgotopkrealtime'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssacleardata.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssacleardata.restype = ctypes.c_int32
def ssacleardata(s):
    pass
    __s = s.ptr
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssacleardata(ctypes.byref(_error_msg), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssacleardata'")
        return
    finally:
        pass


_lib_alglib.alglib_xv2_ssagetbasis.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssagetbasis.restype = ctypes.c_int32
def ssagetbasis(s):
    pass
    __s = s.ptr
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __sv = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __windowwidth = x_int()
    __windowwidth.val = 0
    __nbasis = x_int()
    __nbasis.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssagetbasis(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__a), ctypes.byref(__sv), ctypes.byref(__windowwidth), ctypes.byref(__nbasis), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssagetbasis'")
        __r__a = listlist_from_x(__a)
        __r__sv = list_from_x(__sv)
        __r__windowwidth = __windowwidth.val
        __r__nbasis = __nbasis.val
        return (__r__a, __r__sv, __r__windowwidth, __r__nbasis)
    finally:
        x_matrix_clear(__a)
        x_vector_clear(__sv)


_lib_alglib.alglib_xv2_ssagetlrr.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssagetlrr.restype = ctypes.c_int32
def ssagetlrr(s):
    pass
    __s = s.ptr
    __a = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __windowwidth = x_int()
    __windowwidth.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssagetlrr(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__a), ctypes.byref(__windowwidth), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssagetlrr'")
        __r__a = list_from_x(__a)
        __r__windowwidth = __windowwidth.val
        return (__r__a, __r__windowwidth)
    finally:
        x_vector_clear(__a)


_lib_alglib.alglib_xv2_ssaanalyzelastwindow.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaanalyzelastwindow.restype = ctypes.c_int32
def ssaanalyzelastwindow(s):
    pass
    __s = s.ptr
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __noise = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nticks = x_int()
    __nticks.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaanalyzelastwindow(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__trend), ctypes.byref(__noise), ctypes.byref(__nticks), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaanalyzelastwindow'")
        __r__trend = list_from_x(__trend)
        __r__noise = list_from_x(__noise)
        __r__nticks = __nticks.val
        return (__r__trend, __r__noise, __r__nticks)
    finally:
        x_vector_clear(__trend)
        x_vector_clear(__noise)


_lib_alglib.alglib_xv2_ssaanalyzelast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaanalyzelast.restype = ctypes.c_int32
def ssaanalyzelast(s, nticks):
    pass
    __s = s.ptr
    __nticks = x_int()
    __nticks.val = int(nticks)
    if __nticks.val!=nticks:
        raise ValueError("Error while converting 'nticks' parameter to 'x_int'")
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __noise = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaanalyzelast(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__nticks), ctypes.byref(__trend), ctypes.byref(__noise), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaanalyzelast'")
        __r__trend = list_from_x(__trend)
        __r__noise = list_from_x(__noise)
        return (__r__trend, __r__noise)
    finally:
        x_vector_clear(__trend)
        x_vector_clear(__noise)


_lib_alglib.alglib_xv2_ssaanalyzesequence.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaanalyzesequence.restype = ctypes.c_int32
def ssaanalyzesequence(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        s,data,nticks = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        s,data = functionargs
        nticks = safe_len("'ssaanalyzesequence': incorrect parameters",data)
    else:
        raise RuntimeError("Error while calling 'ssaanalyzesequence': function must have 2 or 3 parameters")
    __s = s.ptr
    if not is_real_vector(data):
        raise ValueError("'data' parameter can't be cast to real_vector")
    __data = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nticks = x_int()
    __nticks.val = int(nticks)
    if __nticks.val!=nticks:
        raise ValueError("Error while converting 'nticks' parameter to 'x_int'")
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __noise = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__data, data, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaanalyzesequence(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__data), ctypes.byref(__nticks), ctypes.byref(__trend), ctypes.byref(__noise), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaanalyzesequence'")
        __r__trend = list_from_x(__trend)
        __r__noise = list_from_x(__noise)
        return (__r__trend, __r__noise)
    finally:
        x_vector_clear(__data)
        x_vector_clear(__trend)
        x_vector_clear(__noise)


_lib_alglib.alglib_xv2_ssaforecastlast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaforecastlast.restype = ctypes.c_int32
def ssaforecastlast(s, nticks):
    pass
    __s = s.ptr
    __nticks = x_int()
    __nticks.val = int(nticks)
    if __nticks.val!=nticks:
        raise ValueError("Error while converting 'nticks' parameter to 'x_int'")
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaforecastlast(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__nticks), ctypes.byref(__trend), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaforecastlast'")
        __r__trend = list_from_x(__trend)
        return __r__trend
    finally:
        x_vector_clear(__trend)


_lib_alglib.alglib_xv2_ssaforecastsequence.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaforecastsequence.restype = ctypes.c_int32
def ssaforecastsequence(*functionargs):
    if len(functionargs)==5:
        __friendly_form = False
        s,data,datalen,forecastlen,applysmoothing = functionargs
    elif len(functionargs)==3:
        __friendly_form = True
        s,data,forecastlen = functionargs
        datalen = safe_len("'ssaforecastsequence': incorrect parameters",data)
        applysmoothing = True
    else:
        raise RuntimeError("Error while calling 'ssaforecastsequence': function must have 3 or 5 parameters")
    __s = s.ptr
    if not is_real_vector(data):
        raise ValueError("'data' parameter can't be cast to real_vector")
    __data = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __datalen = x_int()
    __datalen.val = int(datalen)
    if __datalen.val!=datalen:
        raise ValueError("Error while converting 'datalen' parameter to 'x_int'")
    __forecastlen = x_int()
    __forecastlen.val = int(forecastlen)
    if __forecastlen.val!=forecastlen:
        raise ValueError("Error while converting 'forecastlen' parameter to 'x_int'")
    __applysmoothing = ctypes.c_uint64(applysmoothing)
    if __applysmoothing.value!=0:
        __applysmoothing = ctypes.c_uint64(1)
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__data, data, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaforecastsequence(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__data), ctypes.byref(__datalen), ctypes.byref(__forecastlen), ctypes.byref(__applysmoothing), ctypes.byref(__trend), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaforecastsequence'")
        __r__trend = list_from_x(__trend)
        return __r__trend
    finally:
        x_vector_clear(__data)
        x_vector_clear(__trend)


_lib_alglib.alglib_xv2_ssaforecastavglast.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaforecastavglast.restype = ctypes.c_int32
def ssaforecastavglast(s, m, nticks):
    pass
    __s = s.ptr
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __nticks = x_int()
    __nticks.val = int(nticks)
    if __nticks.val!=nticks:
        raise ValueError("Error while converting 'nticks' parameter to 'x_int'")
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaforecastavglast(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__m), ctypes.byref(__nticks), ctypes.byref(__trend), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaforecastavglast'")
        __r__trend = list_from_x(__trend)
        return __r__trend
    finally:
        x_vector_clear(__trend)


_lib_alglib.alglib_xv2_ssaforecastavgsequence.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_ssaforecastavgsequence.restype = ctypes.c_int32
def ssaforecastavgsequence(*functionargs):
    if len(functionargs)==6:
        __friendly_form = False
        s,data,datalen,m,forecastlen,applysmoothing = functionargs
    elif len(functionargs)==4:
        __friendly_form = True
        s,data,m,forecastlen = functionargs
        datalen = safe_len("'ssaforecastavgsequence': incorrect parameters",data)
        applysmoothing = True
    else:
        raise RuntimeError("Error while calling 'ssaforecastavgsequence': function must have 4 or 6 parameters")
    __s = s.ptr
    if not is_real_vector(data):
        raise ValueError("'data' parameter can't be cast to real_vector")
    __data = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __datalen = x_int()
    __datalen.val = int(datalen)
    if __datalen.val!=datalen:
        raise ValueError("Error while converting 'datalen' parameter to 'x_int'")
    __m = x_int()
    __m.val = int(m)
    if __m.val!=m:
        raise ValueError("Error while converting 'm' parameter to 'x_int'")
    __forecastlen = x_int()
    __forecastlen.val = int(forecastlen)
    if __forecastlen.val!=forecastlen:
        raise ValueError("Error while converting 'forecastlen' parameter to 'x_int'")
    __applysmoothing = ctypes.c_uint64(applysmoothing)
    if __applysmoothing.value!=0:
        __applysmoothing = ctypes.c_uint64(1)
    __trend = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__data, data, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_ssaforecastavgsequence(ctypes.byref(_error_msg), ctypes.byref(__s), ctypes.byref(__data), ctypes.byref(__datalen), ctypes.byref(__m), ctypes.byref(__forecastlen), ctypes.byref(__applysmoothing), ctypes.byref(__trend), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'ssaforecastavgsequence'")
        __r__trend = list_from_x(__trend)
        return __r__trend
    finally:
        x_vector_clear(__data)
        x_vector_clear(__trend)


_lib_alglib.alglib_xv2_gammafunction.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_gammafunction.restype = ctypes.c_int32
def gammafunction(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_gammafunction(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'gammafunction'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_lngamma.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lngamma.restype = ctypes.c_int32
def lngamma(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    __sgngam = ctypes.c_double(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lngamma(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__sgngam), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lngamma'")
        __r__result = __result.value
        __r__sgngam = __sgngam.value
        return (__r__result, __r__sgngam)
    finally:
        pass


_lib_alglib.alglib_xv2_errorfunction.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_errorfunction.restype = ctypes.c_int32
def errorfunction(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_errorfunction(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'errorfunction'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_errorfunctionc.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_errorfunctionc.restype = ctypes.c_int32
def errorfunctionc(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_errorfunctionc(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'errorfunctionc'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_normaldistribution.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normaldistribution.restype = ctypes.c_int32
def normaldistribution(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normaldistribution(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normaldistribution'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_normalpdf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normalpdf.restype = ctypes.c_int32
def normalpdf(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normalpdf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normalpdf'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_normalcdf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_normalcdf.restype = ctypes.c_int32
def normalcdf(x):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_normalcdf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'normalcdf'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_inverf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_inverf.restype = ctypes.c_int32
def inverf(e):
    pass
    __result = ctypes.c_double(0)
    __e = ctypes.c_double(e)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_inverf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__e), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'inverf'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_invnormaldistribution.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_invnormaldistribution.restype = ctypes.c_int32
def invnormaldistribution(y0):
    pass
    __result = ctypes.c_double(0)
    __y0 = ctypes.c_double(y0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_invnormaldistribution(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__y0), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'invnormaldistribution'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_invnormalcdf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_invnormalcdf.restype = ctypes.c_int32
def invnormalcdf(y0):
    pass
    __result = ctypes.c_double(0)
    __y0 = ctypes.c_double(y0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_invnormalcdf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__y0), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'invnormalcdf'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_bivariatenormalpdf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_bivariatenormalpdf.restype = ctypes.c_int32
def bivariatenormalpdf(x, y, rho):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    __y = ctypes.c_double(y)
    __rho = ctypes.c_double(rho)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_bivariatenormalpdf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__rho), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'bivariatenormalpdf'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_bivariatenormalcdf.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_bivariatenormalcdf.restype = ctypes.c_int32
def bivariatenormalcdf(x, y, rho):
    pass
    __result = ctypes.c_double(0)
    __x = ctypes.c_double(x)
    __y = ctypes.c_double(y)
    __rho = ctypes.c_double(rho)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_bivariatenormalcdf(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__x), ctypes.byref(__y), ctypes.byref(__rho), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'bivariatenormalcdf'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_incompletegamma.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_incompletegamma.restype = ctypes.c_int32
def incompletegamma(a, x):
    pass
    __result = ctypes.c_double(0)
    __a = ctypes.c_double(a)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_incompletegamma(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'incompletegamma'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_incompletegammac.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_incompletegammac.restype = ctypes.c_int32
def incompletegammac(a, x):
    pass
    __result = ctypes.c_double(0)
    __a = ctypes.c_double(a)
    __x = ctypes.c_double(x)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_incompletegammac(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'incompletegammac'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.alglib_xv2_invincompletegammac.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_invincompletegammac.restype = ctypes.c_int32
def invincompletegammac(a, y0):
    pass
    __result = ctypes.c_double(0)
    __a = ctypes.c_double(a)
    __y0 = ctypes.c_double(y0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_invincompletegammac(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__a), ctypes.byref(__y0), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'invincompletegammac'")
        __r__result = __result.value
        return __r__result
    finally:
        pass


_lib_alglib.x_obj_free_linearmodel.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_linearmodel.restype = None


class linearmodel(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_linearmodel(self.ptr)


class x_lrreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("c", x_matrix),
        ("rmserror", ctypes.c_double),
        ("avgerror", ctypes.c_double),
        ("avgrelerror", ctypes.c_double),
        ("cvrmserror", ctypes.c_double),
        ("cvavgerror", ctypes.c_double),
        ("cvavgrelerror", ctypes.c_double),
        ("ncvdefects", x_int),
        ("cvdefects", x_vector)
        ]




class lrreport(object):
    def __init__(self):
        self.c = [[]]
        self.rmserror = 0
        self.avgerror = 0
        self.avgrelerror = 0
        self.cvrmserror = 0
        self.cvavgerror = 0
        self.cvavgrelerror = 0
        self.ncvdefects = 0
        self.cvdefects = []


def x_lrreport_zero_fields(x):
    x.c = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    x.rmserror = 0
    x.avgerror = 0
    x.avgrelerror = 0
    x.cvrmserror = 0
    x.cvavgerror = 0
    x.cvavgrelerror = 0
    x.ncvdefects.val = 0
    x.cvdefects = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    return




def x_lrreport_clear(x):
    x_matrix_clear(x.c)
    x_vector_clear(x.cvdefects)
    x_lrreport_zero_fields(x)
    return




def x_from_lrreport(x,v):
    x_from_listlist(x.c, v.c, DT_REAL, X_CREATE)
    x.rmserror = float(v.rmserror)
    x.avgerror = float(v.avgerror)
    x.avgrelerror = float(v.avgrelerror)
    x.cvrmserror = float(v.cvrmserror)
    x.cvavgerror = float(v.cvavgerror)
    x.cvavgrelerror = float(v.cvavgrelerror)
    x.ncvdefects.val = int(v.ncvdefects)
    x_from_list(x.cvdefects, v.cvdefects, DT_INT, X_CREATE)
    return




def lrreport_from_x(x):
    r = lrreport()
    r.c = listlist_from_x(x.c)
    r.rmserror = x.rmserror
    r.avgerror = x.avgerror
    r.avgrelerror = x.avgrelerror
    r.cvrmserror = x.cvrmserror
    r.cvavgerror = x.cvavgerror
    r.cvavgrelerror = x.cvavgrelerror
    r.ncvdefects = x.ncvdefects.val
    r.cvdefects = list_from_x(x.cvdefects)
    return r


_lib_alglib.alglib_xv2_lrbuild.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrbuild.restype = ctypes.c_int32
def lrbuild(xy, npoints, nvars):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __lm = ctypes.c_void_p(0)
    __ar = x_lrreport()
    x_lrreport_zero_fields(__ar)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrbuild(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__info), ctypes.byref(__lm), ctypes.byref(__ar), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrbuild'")
        __r__info = __info.val
        __r__lm = linearmodel(__lm)
        __r__ar = lrreport_from_x(__ar)
        return (__r__info, __r__lm, __r__ar)
    finally:
        x_matrix_clear(__xy)
        x_lrreport_clear(__ar)


_lib_alglib.alglib_xv2_lrbuilds.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrbuilds.restype = ctypes.c_int32
def lrbuilds(xy, s, npoints, nvars):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __lm = ctypes.c_void_p(0)
    __ar = x_lrreport()
    x_lrreport_zero_fields(__ar)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrbuilds(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__s), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__info), ctypes.byref(__lm), ctypes.byref(__ar), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrbuilds'")
        __r__info = __info.val
        __r__lm = linearmodel(__lm)
        __r__ar = lrreport_from_x(__ar)
        return (__r__info, __r__lm, __r__ar)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__s)
        x_lrreport_clear(__ar)


_lib_alglib.alglib_xv2_lrbuildzs.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrbuildzs.restype = ctypes.c_int32
def lrbuildzs(xy, s, npoints, nvars):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(s):
        raise ValueError("'s' parameter can't be cast to real_vector")
    __s = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __lm = ctypes.c_void_p(0)
    __ar = x_lrreport()
    x_lrreport_zero_fields(__ar)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        x_from_list(__s, s, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrbuildzs(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__s), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__info), ctypes.byref(__lm), ctypes.byref(__ar), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrbuildzs'")
        __r__info = __info.val
        __r__lm = linearmodel(__lm)
        __r__ar = lrreport_from_x(__ar)
        return (__r__info, __r__lm, __r__ar)
    finally:
        x_matrix_clear(__xy)
        x_vector_clear(__s)
        x_lrreport_clear(__ar)


_lib_alglib.alglib_xv2_lrbuildz.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrbuildz.restype = ctypes.c_int32
def lrbuildz(xy, npoints, nvars):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __lm = ctypes.c_void_p(0)
    __ar = x_lrreport()
    x_lrreport_zero_fields(__ar)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrbuildz(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__info), ctypes.byref(__lm), ctypes.byref(__ar), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrbuildz'")
        __r__info = __info.val
        __r__lm = linearmodel(__lm)
        __r__ar = lrreport_from_x(__ar)
        return (__r__info, __r__lm, __r__ar)
    finally:
        x_matrix_clear(__xy)
        x_lrreport_clear(__ar)


_lib_alglib.alglib_xv2_lrunpack.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrunpack.restype = ctypes.c_int32
def lrunpack(lm):
    pass
    __lm = lm.ptr
    __v = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nvars = x_int()
    __nvars.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrunpack(ctypes.byref(_error_msg), ctypes.byref(__lm), ctypes.byref(__v), ctypes.byref(__nvars), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrunpack'")
        __r__v = list_from_x(__v)
        __r__nvars = __nvars.val
        return (__r__v, __r__nvars)
    finally:
        x_vector_clear(__v)


_lib_alglib.alglib_xv2_lrpack.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrpack.restype = ctypes.c_int32
def lrpack(v, nvars):
    pass
    if not is_real_vector(v):
        raise ValueError("'v' parameter can't be cast to real_vector")
    __v = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __lm = ctypes.c_void_p(0)
    try:
        x_from_list(__v, v, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrpack(ctypes.byref(_error_msg), ctypes.byref(__v), ctypes.byref(__nvars), ctypes.byref(__lm), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrpack'")
        __r__lm = linearmodel(__lm)
        return __r__lm
    finally:
        x_vector_clear(__v)


_lib_alglib.alglib_xv2_lrprocess.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrprocess.restype = ctypes.c_int32
def lrprocess(lm, x):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrprocess(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__x), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrprocess'")
        __r__result = __result.value
        return __r__result
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_lrrmserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lrrmserror.restype = ctypes.c_int32
def lrrmserror(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lrrmserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lrrmserror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_lravgerror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lravgerror.restype = ctypes.c_int32
def lravgerror(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lravgerror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lravgerror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_lravgrelerror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_lravgrelerror.restype = ctypes.c_int32
def lravgrelerror(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_lravgrelerror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'lravgrelerror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_filtersma.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_filtersma.restype = ctypes.c_int32
def filtersma(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,k = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,k = functionargs
        n = safe_len("'filtersma': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'filtersma': function must have 2 or 3 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_filtersma(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'filtersma'")
        __r__x = list_from_x(__x)
        return __r__x
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_filterema.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_filterema.restype = ctypes.c_int32
def filterema(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,alpha = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,alpha = functionargs
        n = safe_len("'filterema': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'filterema': function must have 2 or 3 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __alpha = ctypes.c_double(alpha)
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_filterema(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__alpha), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'filterema'")
        __r__x = list_from_x(__x)
        return __r__x
    finally:
        x_vector_clear(__x)


_lib_alglib.alglib_xv2_filterlrma.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_filterlrma.restype = ctypes.c_int32
def filterlrma(*functionargs):
    if len(functionargs)==3:
        __friendly_form = False
        x,n,k = functionargs
    elif len(functionargs)==2:
        __friendly_form = True
        x,k = functionargs
        n = safe_len("'filterlrma': incorrect parameters",x)
    else:
        raise RuntimeError("Error while calling 'filterlrma': function must have 2 or 3 parameters")
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __k = x_int()
    __k.val = int(k)
    if __k.val!=k:
        raise ValueError("Error while converting 'k' parameter to 'x_int'")
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_filterlrma(ctypes.byref(_error_msg), ctypes.byref(__x), ctypes.byref(__n), ctypes.byref(__k), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'filterlrma'")
        __r__x = list_from_x(__x)
        return __r__x
    finally:
        x_vector_clear(__x)


_lib_alglib.x_obj_free_logitmodel.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_logitmodel.restype = None


class logitmodel(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_logitmodel(self.ptr)


class x_mnlreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("ngrad", x_int),
        ("nhess", x_int)
        ]




class mnlreport(object):
    def __init__(self):
        self.ngrad = 0
        self.nhess = 0


def x_mnlreport_zero_fields(x):
    x.ngrad.val = 0
    x.nhess.val = 0
    return




def x_mnlreport_clear(x):
    x_mnlreport_zero_fields(x)
    return




def x_from_mnlreport(x,v):
    x.ngrad.val = int(v.ngrad)
    x.nhess.val = int(v.nhess)
    return




def mnlreport_from_x(x):
    r = mnlreport()
    r.ngrad = x.ngrad.val
    r.nhess = x.nhess.val
    return r


_lib_alglib.alglib_xv2_mnltrainh.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnltrainh.restype = ctypes.c_int32
def mnltrainh(xy, npoints, nvars, nclasses):
    pass
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __nclasses = x_int()
    __nclasses.val = int(nclasses)
    if __nclasses.val!=nclasses:
        raise ValueError("Error while converting 'nclasses' parameter to 'x_int'")
    __info = x_int()
    __info.val = 0
    __lm = ctypes.c_void_p(0)
    __rep = x_mnlreport()
    x_mnlreport_zero_fields(__rep)
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnltrainh(ctypes.byref(_error_msg), ctypes.byref(__xy), ctypes.byref(__npoints), ctypes.byref(__nvars), ctypes.byref(__nclasses), ctypes.byref(__info), ctypes.byref(__lm), ctypes.byref(__rep), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnltrainh'")
        __r__info = __info.val
        __r__lm = logitmodel(__lm)
        __r__rep = mnlreport_from_x(__rep)
        return (__r__info, __r__lm, __r__rep)
    finally:
        x_matrix_clear(__xy)
        x_mnlreport_clear(__rep)


_lib_alglib.alglib_xv2_mnlprocess.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlprocess.restype = ctypes.c_int32
def mnlprocess(lm, x, y):
    pass
    __lm = lm.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    if not is_real_vector(y):
        raise ValueError("'y' parameter can't be cast to real_vector")
    __y = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        x_from_list(__y, y, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlprocess(ctypes.byref(_error_msg), ctypes.byref(__lm), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlprocess'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_mnlprocessi.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlprocessi.restype = ctypes.c_int32
def mnlprocessi(lm, x):
    pass
    __lm = lm.ptr
    if not is_real_vector(x):
        raise ValueError("'x' parameter can't be cast to real_vector")
    __x = x_vector(cnt=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __y = x_vector(cnt=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    try:
        x_from_list(__x, x, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlprocessi(ctypes.byref(_error_msg), ctypes.byref(__lm), ctypes.byref(__x), ctypes.byref(__y), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlprocessi'")
        __r__y = list_from_x(__y)
        return __r__y
    finally:
        x_vector_clear(__x)
        x_vector_clear(__y)


_lib_alglib.alglib_xv2_mnlunpack.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlunpack.restype = ctypes.c_int32
def mnlunpack(lm):
    pass
    __lm = lm.ptr
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=DT_REAL,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nvars = x_int()
    __nvars.val = 0
    __nclasses = x_int()
    __nclasses.val = 0
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlunpack(ctypes.byref(_error_msg), ctypes.byref(__lm), ctypes.byref(__a), ctypes.byref(__nvars), ctypes.byref(__nclasses), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlunpack'")
        __r__a = listlist_from_x(__a)
        __r__nvars = __nvars.val
        __r__nclasses = __nclasses.val
        return (__r__a, __r__nvars, __r__nclasses)
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_mnlpack.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlpack.restype = ctypes.c_int32
def mnlpack(a, nvars, nclasses):
    pass
    if not is_real_matrix(a):
        raise ValueError("'a' parameter can't be cast to real_matrix")
    __a = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __nvars = x_int()
    __nvars.val = int(nvars)
    if __nvars.val!=nvars:
        raise ValueError("Error while converting 'nvars' parameter to 'x_int'")
    __nclasses = x_int()
    __nclasses.val = int(nclasses)
    if __nclasses.val!=nclasses:
        raise ValueError("Error while converting 'nclasses' parameter to 'x_int'")
    __lm = ctypes.c_void_p(0)
    try:
        x_from_listlist(__a, a, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlpack(ctypes.byref(_error_msg), ctypes.byref(__a), ctypes.byref(__nvars), ctypes.byref(__nclasses), ctypes.byref(__lm), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlpack'")
        __r__lm = logitmodel(__lm)
        return __r__lm
    finally:
        x_matrix_clear(__a)


_lib_alglib.alglib_xv2_mnlavgce.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlavgce.restype = ctypes.c_int32
def mnlavgce(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlavgce(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlavgce'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mnlrelclserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlrelclserror.restype = ctypes.c_int32
def mnlrelclserror(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlrelclserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlrelclserror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mnlrmserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlrmserror.restype = ctypes.c_int32
def mnlrmserror(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlrmserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlrmserror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mnlavgerror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlavgerror.restype = ctypes.c_int32
def mnlavgerror(lm, xy, npoints):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlavgerror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlavgerror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mnlavgrelerror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlavgrelerror.restype = ctypes.c_int32
def mnlavgrelerror(lm, xy, ssize):
    pass
    __result = ctypes.c_double(0)
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __ssize = x_int()
    __ssize.val = int(ssize)
    if __ssize.val!=ssize:
        raise ValueError("Error while converting 'ssize' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlavgrelerror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__ssize), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlavgrelerror'")
        __r__result = __result.value
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.alglib_xv2_mnlclserror.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mnlclserror.restype = ctypes.c_int32
def mnlclserror(lm, xy, npoints):
    pass
    __result = x_int()
    __result.val = 0
    __lm = lm.ptr
    if not is_real_matrix(xy):
        raise ValueError("'xy' parameter can't be cast to real_matrix")
    __xy = x_matrix(rows=0,cols=0,stride=0,datatype=0,owner=OWN_CALLER,last_action=0,ptr=x_multiptr(p_ptr=0))
    __npoints = x_int()
    __npoints.val = int(npoints)
    if __npoints.val!=npoints:
        raise ValueError("Error while converting 'npoints' parameter to 'x_int'")
    try:
        x_from_listlist(__xy, xy, DT_REAL, X_CREATE)
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mnlclserror(ctypes.byref(_error_msg), ctypes.byref(__result), ctypes.byref(__lm), ctypes.byref(__xy), ctypes.byref(__npoints), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mnlclserror'")
        __r__result = __result.val
        return __r__result
    finally:
        x_matrix_clear(__xy)


_lib_alglib.x_obj_free_mcpdstate.argtypes = [ctypes.c_void_p]
_lib_alglib.x_obj_free_mcpdstate.restype = None


class mcpdstate(object):
    def __init__(self,ptr):
        self.ptr = ptr
        self.lib = _lib_alglib # make sure that _lib_alglib survives as long as object is here
    def __del__(self):
        self.lib.x_obj_free_mcpdstate(self.ptr)


class x_mcpdreport(ctypes.Structure):
    _pack_ = 8
    _fields_ = [
        ("inneriterationscount", x_int),
        ("outeriterationscount", x_int),
        ("nfev", x_int),
        ("terminationtype", x_int)
        ]




class mcpdreport(object):
    def __init__(self):
        self.inneriterationscount = 0
        self.outeriterationscount = 0
        self.nfev = 0
        self.terminationtype = 0


def x_mcpdreport_zero_fields(x):
    x.inneriterationscount.val = 0
    x.outeriterationscount.val = 0
    x.nfev.val = 0
    x.terminationtype.val = 0
    return




def x_mcpdreport_clear(x):
    x_mcpdreport_zero_fields(x)
    return




def x_from_mcpdreport(x,v):
    x.inneriterationscount.val = int(v.inneriterationscount)
    x.outeriterationscount.val = int(v.outeriterationscount)
    x.nfev.val = int(v.nfev)
    x.terminationtype.val = int(v.terminationtype)
    return




def mcpdreport_from_x(x):
    r = mcpdreport()
    r.inneriterationscount = x.inneriterationscount.val
    r.outeriterationscount = x.outeriterationscount.val
    r.nfev = x.nfev.val
    r.terminationtype = x.terminationtype.val
    return r


_lib_alglib.alglib_xv2_mcpdcreate.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mcpdcreate.restype = ctypes.c_int32
def mcpdcreate(n):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mcpdcreate(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mcpdcreate'")
        __r__s = mcpdstate(__s)
        return __r__s
    finally:
        pass


_lib_alglib.alglib_xv2_mcpdcreateentry.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mcpdcreateentry.restype = ctypes.c_int32
def mcpdcreateentry(n, entrystate):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __entrystate = x_int()
    __entrystate.val = int(entrystate)
    if __entrystate.val!=entrystate:
        raise ValueError("Error while converting 'entrystate' parameter to 'x_int'")
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.alglib_xv2_mcpdcreateentry(ctypes.byref(_error_msg), ctypes.byref(__n), ctypes.byref(__entrystate), ctypes.byref(__s), 0)
        if __x__retval!=0:
            if __x__retval==X_ASSERTION_FAILED:
                raise RuntimeError(_error_msg.value)
            else:
                raise RuntimeError("Error while calling 'mcpdcreateentry'")
        __r__s = mcpdstate(__s)
        return __r__s
    finally:
        pass


_lib_alglib.alglib_xv2_mcpdcreateexit.argtypes = [ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_void_p, ctypes.c_uint64]
_lib_alglib.alglib_xv2_mcpdcreateexit.restype = ctypes.c_int32
def mcpdcreateexit(n, exitstate):
    pass
    __n = x_int()
    __n.val = int(n)
    if __n.val!=n:
        raise ValueError("Error while converting 'n' parameter to 'x_int'")
    __exitstate = x_int()
    __exitstate.val = int(exitstate)
    if __exitstate.val!=exitstate:
        raise ValueError("Error while converting 'exitstate' parameter to 'x_int'")
    __s = ctypes.c_void_p(0)
    try:
        pass
        _error_msg = ctypes.c_char_p(0)
        __x__retval =  _lib_alglib.