# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QNotebook
                                 A QGIS plugin
 Jupyter-style notebook for QGIS Python Console
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-01-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Your Name
        email                : your.email@example.com
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsMessageLog, Qgis

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .qnotebook_dockwidget import QNotebookDockWidget
import os.path


class QNotebook:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.
        
        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'QNotebook_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&QNotebook')

        self.toolbar = self.iface.addToolBar(u'QNotebook')
        self.toolbar.setObjectName(u'QNotebook')

        self.pluginIsActive = False
        self.dockwidget = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('QNotebook', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar."""

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Open QNotebook'),
            callback=self.run,
            parent=self.iface.mainWindow())

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed."""
        # Disconnetti segnali
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        
        # Log chiusura
        QgsMessageLog.logMessage(
            "QNotebook closed", 
            "QNotebook", 
            Qgis.Info
        )
        
        self.pluginIsActive = False

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&QNotebook'),
                action)
            self.iface.removeToolBarIcon(action)
        
        # remove the toolbar
        del self.toolbar

    def run(self):
        """Run method that loads and starts the plugin."""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            try:
                # Create the dockwidget if it doesn't exist
                if self.dockwidget == None:
                    # Create the dockwidget
                    self.dockwidget = QNotebookDockWidget(self.iface)
                    
                    # Connect to close event
                    self.dockwidget.closingPlugin.connect(self.onClosePlugin)

                # Show the dockwidget
                self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)
                self.dockwidget.show()
                
                # Messaggio di benvenuto
                self.iface.messageBar().pushMessage(
                    "QNotebook", 
                    "Notebook ready! Check the Python Console for the notebook tab.", 
                    level=Qgis.Info,
                    duration=3
                )
            except Exception as e:
                self.iface.messageBar().pushMessage(
                    "QNotebook Error", 
                    f"Failed to initialize: {str(e)}", 
                    level=Qgis.Critical,
                    duration=5
                )
                self.pluginIsActive = False