# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QNotebookDockWidget
                                 A QGIS plugin
 Jupyter-style notebook for QGIS Python Console
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-09-01
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Federico Gianoli
        email                : gianoli.federico@gmail.com
 ***************************************************************************/
"""

import os
from qgis.PyQt import QtGui, QtWidgets
from qgis.PyQt.QtCore import pyqtSignal, Qt, QTimer
from qgis.PyQt.QtWidgets import QTabWidget, QVBoxLayout, QDockWidget, QWidget
from qgis.core import QgsMessageLog, Qgis

# Import il widget notebook
from .qnotebook_widget import QNotebookWidget


class QNotebookDockWidget(QDockWidget):
    """Dock widget contenitore per QNotebook."""

    closingPlugin = pyqtSignal()

    def __init__(self, iface, parent=None):
        """Constructor."""
        super(QNotebookDockWidget, self).__init__(parent)
        
        self.iface = iface
        
        # Setup base widget
        self.main_widget = QWidget()
        self.setWidget(self.main_widget)
        
        # References
        self.console = None
        self.console_tabwidget = None
        self.notebook_widget = None
        
        # Inizializza l'interfaccia
        self.init_notebook_interface()
        
        # Cerca la console Python e aggiungi il notebook
        QTimer.singleShot(500, self.integrate_with_console)

    def init_notebook_interface(self):
        """Inizializza l'interfaccia del notebook nel dock widget."""
        # Crea layout per il widget principale
        layout = QVBoxLayout()
        layout.setContentsMargins(0, 0, 0, 0)
        
        # Crea il widget notebook standalone
        self.notebook_widget = QNotebookWidget(self.iface, parent=self)
        layout.addWidget(self.notebook_widget)
        
        # Imposta il layout al widget principale
        self.main_widget.setLayout(layout)
        
        # Imposta titolo e proprietà 
        self.setWindowTitle("QNotebook")
        self.setObjectName("QNotebookDockWidget")

    def integrate_with_console(self):
        """Integra il notebook con la Python Console se disponibile."""
        try:
            # Importa la console
            from console.console import PythonConsole
            
            # Cerca la console Python
            console = None
            for widget in self.iface.mainWindow().findChildren(PythonConsole):
                console = widget
                break
            
            if console:
                self.console = console
                self.add_notebook_tab_to_console()
                QgsMessageLog.logMessage(
                    "QNotebook integrated with Python Console", 
                    "QNotebook", 
                    Qgis.Info
                )
            else:
                # La console non è ancora aperta, riprova
                QTimer.singleShot(2000, self.integrate_with_console)
                
        except ImportError as e:
            QgsMessageLog.logMessage(
                f"Python Console not available: {str(e)}", 
                "QNotebook", 
                Qgis.Warning
            )
            # Usa il notebook standalone nel dock widget
        except Exception as e:
            QgsMessageLog.logMessage(
                f"Error integrating with console: {str(e)}", 
                "QNotebook", 
                Qgis.Warning
            )

    def add_notebook_tab_to_console(self):
        """Aggiunge il notebook come tab nella console Python."""
        if not self.console:
            return
        
        try:
            # Trova il TabWidget nella console
            self.console_tabwidget = self.console.findChild(QTabWidget)
            
            if self.console_tabwidget:
                # Crea un nuovo widget notebook per la console
                console_notebook = QNotebookWidget(
                    self.iface, 
                    console=self.console,
                    parent=self.console_tabwidget
                )
                
                # Aggiungi come tab
                icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
                if os.path.exists(icon_path):
                    icon = QtGui.QIcon(icon_path)
                    tab_index = self.console_tabwidget.addTab(
                        console_notebook,
                        icon,
                        "Notebook"
                    )
                else:
                    tab_index = self.console_tabwidget.addTab(
                        console_notebook,
                        "📓 Notebook"
                    )
                
                # Imposta il notebook della console come riferimento
                self.console_notebook = console_notebook
                
                # Inietta variabili nel namespace
                self.inject_notebook_variables()
                
                QgsMessageLog.logMessage(
                    "QNotebook tab added to Python Console", 
                    "QNotebook", 
                    Qgis.Success
                )
                
        except Exception as e:
            QgsMessageLog.logMessage(
                f"Error adding notebook tab: {str(e)}", 
                "QNotebook", 
                Qgis.Critical
            )

    def inject_notebook_variables(self):
        """Inietta variabili utili nel namespace della console."""
        if not self.console:
            return
        
        try:
            shell = None
            
            # Trova lo shell della console
            if hasattr(self.console, 'shell'):
                shell = self.console.shell
            elif hasattr(self.console, 'console') and hasattr(self.console.console, 'shell'):
                shell = self.console.console.shell
            
            if shell:
                # Inietta le variabili
                if hasattr(shell, 'inject_variables'):
                    shell.inject_variables({
                        'notebook': self.console_notebook if hasattr(self, 'console_notebook') else self.notebook_widget,
                        'nb': self.console_notebook if hasattr(self, 'console_notebook') else self.notebook_widget,
                        'qnotebook': self
                    })
                elif hasattr(shell, 'locals'):
                    shell.locals['notebook'] = self.console_notebook if hasattr(self, 'console_notebook') else self.notebook_widget
                    shell.locals['nb'] = self.console_notebook if hasattr(self, 'console_notebook') else self.notebook_widget
                    shell.locals['qnotebook'] = self
                    
                QgsMessageLog.logMessage(
                    "Notebook variables injected into console", 
                    "QNotebook", 
                    Qgis.Info
                )
                
        except Exception as e:
            QgsMessageLog.logMessage(
                f"Could not inject variables: {str(e)}", 
                "QNotebook", 
                Qgis.Warning
            )

    def closeEvent(self, event):
        """Handle close event."""
        # Rimuovi il tab dalla console se esiste
        if hasattr(self, 'console_notebook') and self.console_tabwidget:
            idx = self.console_tabwidget.indexOf(self.console_notebook)
            if idx >= 0:
                self.console_tabwidget.removeTab(idx)
        
        self.closingPlugin.emit()
        event.accept()