# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QMapPermalinkPanel
                                 A QGIS plugin
 Navigate QGIS map views through external permalink system - Panel Version
                             -------------------
        begin                : 2025-10-05
        git sha              : $Format:%H$
        copyright            : (C) 2025 by yamamoto-ryuzo
        email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDockWidget, QWidget
from qgis.PyQt.QtCore import Qt

# UIファイルのパスを指定
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'qmap_permalink_panel_base.ui'))


class QMapPermalinkPanel(QDockWidget):
    """QMapPermalinkのパネルクラス
    
    Qt Designerで作成されたUIファイルを読み込んでドッキング可能なパネルとして表示
    """
    
    def __init__(self, parent=None):
        """コンストラクタ
        
        Args:
            parent: 親ウィジェット
        """
        super(QMapPermalinkPanel, self).__init__(parent)
        
        # パネルのタイトルを設定
        self.setWindowTitle("QMap Permalink")
        
        # UIファイルが正しく読み込まれているかチェック
        if not hasattr(FORM_CLASS, '__name__'):
            raise ImportError("UIファイルの読み込みに失敗しました")
        
        # ドッキングエリアを設定（左側を優先、右側も可能）
        self.setAllowedAreas(Qt.LeftDockWidgetArea | Qt.RightDockWidgetArea)
        
        # 内部ウィジェットを作成
        self.widget = QWidget()
        self.ui = FORM_CLASS()
        self.ui.setupUi(self.widget)
        
        # 直接アクセス用のプロパティを追加
        self.pushButton_generate = self.ui.pushButton_generate
        self.pushButton_navigate = self.ui.pushButton_navigate  
        self.pushButton_copy = self.ui.pushButton_copy
        self.pushButton_open = self.ui.pushButton_open
        self.lineEdit_permalink = self.ui.lineEdit_permalink
        self.lineEdit_navigate = self.ui.lineEdit_navigate
        self.label_server_status = self.ui.label_server_status
        self.comboBox_themes = self.ui.comboBox_themes
        
        # Google Maps/Earth用のUI要素
        self.pushButton_google_maps = self.ui.pushButton_google_maps
        self.pushButton_google_earth = self.ui.pushButton_google_earth
        self.label_google_maps = self.ui.label_google_maps  
        self.label_google_earth = self.ui.label_google_earth
        
        # ウィジェットを設定
        self.setWidget(self.widget)
        
        # パネルのサイズを設定（左側パネルに適したサイズ）
        self.setMinimumWidth(250)
        self.setMaximumWidth(400)
        
        # パネルの特徴を設定
        self.setFeatures(QDockWidget.DockWidgetMovable | 
                        QDockWidget.DockWidgetFloatable | 
                        QDockWidget.DockWidgetClosable)
        
        # UI要素を翻訳
        self.translate_ui()
        
    def translate_ui(self):
        """UI要素のテキストを翻訳"""
        from qgis.PyQt.QtCore import QCoreApplication
        
        def tr(text):
            return QCoreApplication.translate('QMapPermalink', text)
            
            # グループボックスのタイトル
            if hasattr(self.ui, 'groupBox_server'):
                self.ui.groupBox_server.setTitle(tr("HTTP Server Status"))
            if hasattr(self.ui, 'groupBox_generate'):
                self.ui.groupBox_generate.setTitle(tr("Generate Permalink"))
            if hasattr(self.ui, 'groupBox_permalink'):
                self.ui.groupBox_permalink.setTitle(tr("Current Permalink"))
            if hasattr(self.ui, 'groupBox_external_links'):
                self.ui.groupBox_external_links.setTitle(tr("External Maps"))
            if hasattr(self.ui, 'groupBox_navigate'):
                self.ui.groupBox_navigate.setTitle(tr("Navigate to Location"))
            
            # ラベル
            if hasattr(self.ui, 'label_generate_info'):
                self.ui.label_generate_info.setText(tr("Generate a permalink for the current map view"))
            if hasattr(self.ui, 'label_theme_selection'):
                self.ui.label_theme_selection.setText(tr("Theme/Layer State:"))
            if hasattr(self.ui, 'label_external_info'):
                self.ui.label_external_info.setText(tr("Open current location in external services"))
            if hasattr(self.ui, 'label_navigate_info'):
                self.ui.label_navigate_info.setText(tr("Enter a permalink to navigate"))
            if hasattr(self.ui, 'label_google_maps'):
                self.ui.label_google_maps.setText(tr("🗺️ Google Maps:"))
            if hasattr(self.ui, 'label_google_earth'):
                self.ui.label_google_earth.setText(tr("🌍 Google Earth:"))
            
            # ボタン
            if hasattr(self.ui, 'pushButton_generate'):
                self.ui.pushButton_generate.setText(tr("Generate Permalink"))
            if hasattr(self.ui, 'pushButton_copy'):
                self.ui.pushButton_copy.setText(tr("Copy"))
            if hasattr(self.ui, 'pushButton_open'):
                self.ui.pushButton_open.setText(tr("Open"))
            if hasattr(self.ui, 'pushButton_navigate'):
                self.ui.pushButton_navigate.setText(tr("Navigate"))
            if hasattr(self.ui, 'pushButton_google_maps'):
                self.ui.pushButton_google_maps.setText(tr("Open"))
            if hasattr(self.ui, 'pushButton_google_earth'):
                self.ui.pushButton_google_earth.setText(tr("Open"))
            
            # プレースホルダーテキスト
            if hasattr(self.ui, 'lineEdit_permalink'):
                self.ui.lineEdit_permalink.setPlaceholderText(tr("Generated permalink will appear here"))
            if hasattr(self.ui, 'lineEdit_navigate'):
                self.ui.lineEdit_navigate.setPlaceholderText(tr("Paste permalink here"))
            
            # コンボボックスの項目
            if hasattr(self.ui, 'comboBox_themes'):
                # 既存の項目をクリアして翻訳済みの項目を追加
                self.ui.comboBox_themes.clear()
                self.ui.comboBox_themes.addItem(tr("-- No Theme (Position Only) --"))
                # ツールチップも翻訳
                self.ui.comboBox_themes.setToolTip(tr("Select theme option: no theme (position only) or specific theme"))
    
    def update_server_status(self, port, running):
        """サーバーステータスを更新
        
        Args:
            port: サーバーポート番号
            running: サーバーが実行中かどうか
        """
        if running:
            status_text = f"HTTP Server: Running on http://localhost:{port}"
            style = "color: green; font-weight: bold;"
        else:
            status_text = "HTTP Server: Stopped"
            style = "color: red; font-weight: bold;"
            
        self.label_server_status.setText(status_text)
        self.label_server_status.setStyleSheet(style)
    
    def update_google_buttons_state(self, enabled=True):
        """Google Maps/Earthボタンの状態を更新
        
        Args:
            enabled: ボタンを有効にするかどうか
        """
        if hasattr(self, 'pushButton_google_maps'):
            self.pushButton_google_maps.setEnabled(enabled)
        if hasattr(self, 'pushButton_google_earth'):
            self.pushButton_google_earth.setEnabled(enabled)