# -*- coding: utf-8 -*-
"""
/***************************************************************************
 qlyrxDialog
                                 A QGIS plugin
 Apply Arcgis Pro .lyrx style
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-04-09
        git sha              : $Format:%H$
        copyright            : (C) 2019 by arc2qgis
        email                : dror.bogin@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import re
from qgis.core import ( QgsMessageLog, Qgis, QgsWkbTypes, QgsColorRampShader, QgsPresetSchemeColorRamp, QgsRasterShader, QgsRasterBandStats, 
                        QgsSymbol, QgsSingleSymbolRenderer,QgsSingleBandPseudoColorRenderer, QgsSimpleLineSymbolLayer, 
                        QgsLinePatternFillSymbolLayer, QgsFontMarkerSymbolLayer, QgsSettings,
                        QgsPointPatternFillSymbolLayer, QgsMarkerLineSymbolLayer, QgsMarkerSymbol, 
                        QgsSimpleMarkerSymbolLayerBase, QgsSimpleMarkerSymbolLayer, QgsSVGFillSymbolLayer, 
                        QgsPalLayerSettings, QgsTextFormat, QgsVectorLayerSimpleLabeling, QgsRendererCategory, QgsCategorizedSymbolRenderer)
from PyQt5.QtWidgets import QHBoxLayout, QLabel, QComboBox
from PyQt5.QtCore import QPointF
from collections import OrderedDict
from PyQt5.QtGui import QColor, QFont


class qlyrxStyler():
    def __init__(self, parent=None):
        
        self.capStyles = {"Round" : 32, "Square" : 1, "Butt": 0}
        self.joinStyles = {"Miter": 0, "Bevel" : 64, "Round": 128}
        self.point2mm =  0.352778
        self.paths_to_shapes_array = {
            "Cross2" : {"paths" : [
                [[-0.5,0.5],[0.5,-0.5]],
                [[-0.5,-0.5],[0.5,0.5]]
            ]},
            "Line" : {"paths" : [
                [[3,0],[-3,0]]
            ]
            }
        }

        self.circle_rings = {
                            "curveRings" : [
                            [[1.2246467991473532e-16,2],
                                {
                                "a" : [[1.2246467991473532e-16,2],
                                    [0,0],[0,1]]
                                }]
                            ]
                        }

    def apply_lyrx_symbols(self, dlg, layer, lyrx_data, geometry_general_type_str):
        simple_symbol = False
        raster_symbol = False
        label_symbol = False
        layerDef = lyrx_data['layerDefinitions']
        renderer = ''
        renderers = []
        renderers_symb_type = []
        dataset_names = []
        raster_data = ''
        label_symb_array = []
        label_expessions = []
        labels = ''

        for p in layerDef :
            if 'type' in p:
               if p['type'] == 'CIMRasterLayer':
                   raster_symbol = True
                   raster_data = p
               else:
                    raster_symbol = False
            ## Check for renderers
            temp_renderer = p['renderer'] if 'renderer' in p else ''
            renderers.append(temp_renderer)
            temp_label = p['labelClasses'] if 'labelClasses' in p else ''
            label_symb_array.append(temp_label)
            try:
                label_expr = self.getLabelField(temp_label[0]) if len(temp_label) else ''
                if label_expr:
                    label_symbol = True
                    label_expessions.append(label_expr)
                else:
                    label_expessions.append('')
                ## Get lyrx shape type and original names
                if not temp_renderer == '' and not raster_symbol:
                    if 'symbol' in temp_renderer:
                        rend_type = temp_renderer['symbol']['type']
                    elif 'defaultSymbol' in temp_renderer:
                        rend_type = temp_renderer['defaultSymbol']['symbol']['type']
                    elif 'groups' in temp_renderer:
                        group0 = temp_renderer['groups'][0]
                        if 'classes' in group0:
                            symbol0 = group0['classes'][0]
                            rend_type = symbol0['symbol']['symbol']['type']

                    #rend_type = temp_renderer['symbol']['type'] if 'symbol' in temp_renderer else  temp_renderer['defaultSymbol']['symbol']['type']
                    renderers_symb_type.append(rend_type.lower())
                    dataset = p['featureTable']['dataConnection']['dataset']
                    dataset_names.append(dataset)
            except Exception as e:
                QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
        QgsMessageLog.logMessage("there are " + str(len(label_symb_array)) + " label def", 'qlyrxStyler', level=Qgis.MessageLevel.Info)

                
        # Find a renderer with the active layer field attribute
        rend_to_check = []
        x = 0   
        for r in renderers_symb_type:
            if geometry_general_type_str in r:            
                rend_to_check.append(x)
            x = x + 1

        rend_idx = -1
        self.used_fields = []
        ## Check in the active layers for matching classification fields  
        for z in rend_to_check:
            for f in renderers[z]['fields']:
                if f not in self.used_fields:
                    self.used_fields.append(f)
            ## Check for matching column names
            field_exist = layer.fields().indexFromName(renderers[z]['fields'][0])
            if field_exist > -1:
                rend_idx = z
        
        #for u in range(0,len(self.used_fields)):
        #    self.add_field_layout(layer,self.used_fields[u],u)
        
        # Check simple symbol        
        if rend_idx < 0 and not raster_symbol:
            active_name = layer.sourceName()
            rend_idx = dataset_names.index(active_name) if layer.sourceName() in dataset_names else 0
            if renderers[0]['type'] != "CIMSimpleRenderer":
                simple_symbol = False
            else:    
                simple_symbol = True

        if rend_idx > -1 and not simple_symbol:
            ## Create data arrays for symbols, labels, symbolLayers, halo options
            categories = []
            allSymbolLayers = {}
            class_field = renderers[rend_idx]['fields'][0] if len(renderers[rend_idx]['fields']) > 0 else 'CODE'
            class_field2 = renderers[rend_idx]['fields'][1] if len(renderers[rend_idx]['fields']) > 1 else ''
            ## TODO: check why unused
            #class_field3 = renderers[rend_idx]['fields'][2] if len(renderers[rend_idx]['fields']) > 2 else ''
            classes = renderers[rend_idx]["groups"][0]["classes"]
            symbols_labels = []
            symbol_layers = []
            symbol_values = []    
            halo_symbols = []
            multi_cat = []
            for c in classes :    
                symbol_layers.append(self.getSymbolLayers(c))
                halo_symbols.append(self.getSymbolHalo(c))
                symbols_labels.append(c['label'])
                symbol_values.append(c['values'][0]['fieldValues'])
                if len(c['values']) > 1:
                    vf_idx = 0
                    multi_array = []
                    for vf in c['values']:
                        if vf_idx > 0:
                           multi_array.append(vf['fieldValues'])             
                        vf_idx = vf_idx + 1    
                    multi_cat.append(multi_array)
                else:
                    multi_cat.append('')

            ## Convert the symbolLayers definition of each CIMUniqueValueClass to qgis symbol and create a category
            idx = 0
            for sl in symbol_layers:
                allSymbolLayers = {}                                    
                ## Create definition array - add order and more    
                symbol_def = self.checkSymbolType(sl)
                layer_num = symbol_def['layer_count']                  
                ret_arr = self.parseSolidFill(symbol_def, layer)            
                ret = ret_arr[0]
                allSymbolLayers[ret_arr[1]] = ret                        
                noSolid = False
                firstDash = False
                if ret_arr[1] < 0:
                    noSolid = True                   

                svg_file_appendix = str(symbol_values[idx][0]).replace(" ","_")
                picture_ret = self.parsePictureFill(symbol_def, svg_file_appendix)
                if not picture_ret[0] == '':
                    QgsMessageLog.logMessage("pic fill try", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                    allSymbolLayers[picture_ret[1]] = picture_ret[0]
                    ret.appendSymbolLayer(picture_ret[0])
                ## Create hatch fill 
                lines_ret = self.parseLineFill(symbol_def, layer)            
                if not lines_ret == '':
                    line_ret = lines_ret[0]
                    for line in line_ret:
                        try:
                            ret.appendSymbolLayer(line)
                        except Exception as e:
                            QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
                            QgsMessageLog.logMessage(line.__class__.__name__, 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
                    for line_sym in lines_ret[1]:
                        allSymbolLayers[line_sym] = lines_ret[1][line_sym]                    

                ## Create line strokes symbols
                if 'template_stroke_num' in symbol_def and not ret == '':                
                    ret_val = self.parseStroke(symbol_def, ret, layer)  
                    ret = ret_val[0]
                    stroke_symbols = ret_val[1] 
                    for str_s in stroke_symbols:
                        allSymbolLayers[str_s] = stroke_symbols[str_s]                                    
                    firstDash = ret_val[2]
                        
                vector_layers = self.parseVectorSymbolLine(symbol_def, False, layer)
                if not vector_layers == '':
                    ## TODO: check why unused
                    #vl_idx = vector_layers
                    for vl in vector_layers:
                        v_symb = vl[0]
                        v_ord = vl[1]
                        allSymbolLayers[v_ord] = v_symb
                        ret.appendSymbolLayer(v_symb)
                    
                    #allSymbolLayers[vl_idx] = vector_layers[0]
                    #ret.appendSymbolLayer(vector_layers[0])
                    

                ## Create character fills
                layers = []
                max_size = 0            
                for charSl in sl:            
                    if 'characterIndex' in charSl and charSl['type'] == 'CIMCharacterMarker':
                        if charSl["enable"]:
                            ret_sym = self.parseCharacterFill(charSl, max_size, layer)
                            symbol = ret_sym[0]                        
                            if not symbol == '':                            
                                layers.append(symbol)                            
                                allSymbolLayers[ret_sym[1]] = symbol
                                if geometry_general_type_str == 'point':          
                                    max_size = max(symbol.size(), max_size)            
                
                if not halo_symbols[idx] == '':
                    layers = self.tweakHaloSymbol(layers, halo_symbols[idx], layer)
                    allSymbolLayers[len(allSymbolLayers) + 1] = layers[len(layers) - 1].clone()            
                
                ## Add the font fill 
                x = 0                                        
                for rl in layers:                
                    ret.appendSymbolLayer(rl)                
                    x = x + 1
                
                ## Delete default base layer if font marker filled or symbol mismatch
                #print("is Halo " + str(halo_symbols[idx] == ''))            
                #print("ret count is " + str(ret.symbolLayerCount()))
                
                if ((len(layers) > 0 and noSolid ) or (layer_num < ret.symbolLayerCount()) or firstDash ):                                
                    QgsMessageLog.logMessage("delete first symbol layer", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                    # add user interaction
                    ret.deleteSymbolLayer(0)
                    if -1 in allSymbolLayers:
                        QgsMessageLog.logMessage("fix demo first layer", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                        # add user interaction        
                        del(allSymbolLayers[-1])
                
                
                ## Create ordered object from allSymbolLayers
                ordered_obj = OrderedDict(sorted(allSymbolLayers.items(), key=lambda t: t[0]))
                total_len = ret.symbolLayerCount()
                total_sym_len = len(ordered_obj)
                if -1 in ordered_obj and total_len not in ordered_obj:
                    # TODO: add user interaction
                    ordered_obj[total_len] = ordered_obj[-1].clone()
                    del(ordered_obj[-1])
                                    
                ## Create the new symbol from reveresed ordered_obj
                new_symbol = QgsSymbol.defaultSymbol(layer.geometryType())
                baseLayer = False
                try:
                    if total_sym_len > 1:
                        for ord_sym_idx in reversed(ordered_obj):
                            newSymbolLayer  = ordered_obj[ord_sym_idx].clone()
                            locked = ''
                            if 'SymbolLayer' not in newSymbolLayer.__class__.__name__:
                                # try symbolLayer
                                newSymbolLayer = ordered_obj[ord_sym_idx].symbolLayer(0).clone()
                                locked = ordered_obj[ord_sym_idx].symbolLayer(0).isLocked()                                
                            else:
                                locked = ordered_obj[ord_sym_idx].isLocked()
                            newSymbolLayer.setLocked(locked)    
                            if not baseLayer:                                                        
                                if "SymbolLayer" in newSymbolLayer.__class__.__name__:                                
                                    new_symbol.changeSymbolLayer(0, newSymbolLayer)
                                baseLayer = True
                            else:                                                        
                                if "SymbolLayer" in newSymbolLayer.__class__.__name__:                                
                                    new_symbol.appendSymbolLayer(newSymbolLayer)                                
                    else:
                        new_symbol = ret
                except Exception as e:
                    QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
                    QgsMessageLog.logMessage("order fail", 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
                    # add user interaction
                        

                ## Create new category                            
                symbol_val_prep = symbol_values[idx][0] + ", " + symbol_values[idx][1] if len(symbol_values[idx]) > 1 else symbol_values[idx][0]            
                category = QgsRendererCategory(symbol_val_prep, new_symbol, symbols_labels[idx])            
                categories.append(category)
                
                #if len(symbol_values[idx] > 2):
                if not multi_cat[idx] == '':
                    for extra_label in multi_cat[idx]:
                        symbol_val_prep1 = extra_label[0] + ", " + extra_label[1] if len(extra_label) > 1 else extra_label[0]            
                        category = QgsRendererCategory(symbol_val_prep1, new_symbol.clone(), symbols_labels[idx])            
                        categories.append(category)
                       
                idx = idx + 1
                
            ## Create renderer                        
            concat_str =  ", " + "', ', " + class_field2 + ")" if not class_field2 == "" else ")"
            renderer = QgsCategorizedSymbolRenderer("concat(" + class_field + concat_str, categories)
            
        elif not raster_symbol and renderers[rend_idx]['type'] == 'CIMSimpleRenderer' and simple_symbol:
            single_symbology = self.parseSimpleRenderer(renderers[rend_idx], layer)
            if not single_symbology == '':
                symbol = QgsSymbol.defaultSymbol(layer.geometryType())
                try:
                    symbol.changeSymbolLayer(0, single_symbology)
                except Exception as e:
                    QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                    symbol = single_symbology
                    
                renderer = QgsSingleSymbolRenderer(symbol)
        elif raster_symbol:
            self.mb.pushWarning('Warning',"Raster symbology is still experimental")
            self.parseRasterData(raster_data, layer)
            #layer.triggerRepaint()
            #self.iface.legendInterface().refreshLayerSymbology(layer)
        else:
            self.mb.pushCritical('',"No matching lyrx symbology fields found for the active layer")
            # add user interaction
        
        if label_symbol: 
            labels = self.parseLabels(label_symb_array, label_expessions, layer, rend_idx)
            QgsMessageLog.logMessage("label by layer num " + str(rend_idx) + " in lyrx", 'qlyrxStyler', level=Qgis.MessageLevel.Info)

        # assign the created renderer to the layer
        if not renderer == '' :
            layer.setRenderer(renderer)
            layer.triggerRepaint()
        
        if not labels == '':
            layer.setLabeling(labels)
            if not dlg.parseLables.isChecked():
                layer.setLabelsEnabled(False) 
            layer.triggerRepaint()


    def initial_lyrx_parse(self,lyrx_data,layer):
        "perform initial parsing of lyrx values and create ui elements for the required fields"
        #simple_symbol = False
        raster_symbol = False
        ## TODO: check why unused
        #label_symbol = False
        layerDef = lyrx_data['layerDefinitions']
        #renderer = ''
        renderers = []
        renderers_symb_type = []
        dataset_names = []
        ## TODO: check why unused
        #raster_data = ''
        label_symb_array = []
        label_expessions = []
        #labels = ''
        for p in layerDef :
            if 'type' in p:
               if p['type'] == 'CIMRasterLayer':
                   raster_symbol = True
                   #raster_data = p
            ## Check for renderers
            temp_renderer = p['renderer'] if 'renderer' in p else ''
            renderers.append(temp_renderer)
            temp_label = p['labelClasses'] if 'labelClasses' in p else ''
            label_symb_array.append(temp_label)
            try:
                label_expr = self.getLabelField(temp_label[0]) if len(temp_label) else ''
                if label_expr:
                    #label_symbol = True
                    label_expessions.append(label_expr)
                else:
                    label_expessions.append('')
                ## Get lyrx shape type and original names
                if not temp_renderer == '' and not raster_symbol:
                    rend_type = temp_renderer['symbol']['type'] if 'symbol' in temp_renderer else  temp_renderer['defaultSymbol']['symbol']['type']
                    renderers_symb_type.append(rend_type.lower())
                    dataset = p['featureTable']['dataConnection']['dataset']
                    dataset_names.append(dataset)
            except Exception as e:
                QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
        QgsMessageLog.logMessage("there are " + str(len(label_symb_array)) + " label def", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
        # Find a renderer with the active layer field attribute
        rend_to_check = []
        x = 0    
        try:
            for r in renderers_symb_type:
                #if geometry_general_type_str in r:            
                rend_to_check.append(x)
                x = x + 1

            ## TODO: check why unused
            #rend_idx = -1
            self.used_fields = []
            ## Check in the active layers for matching classification fields  
            for z in rend_to_check:
                if 'fields' in renderers[z]:
                    for f in renderers[z]['fields']:
                        if f not in self.used_fields:
                            self.used_fields.append(f)
                    field_exist = layer.fields().indexFromName(renderers[z]['fields'][0])
                    if field_exist > -1:
                        ## TODO: check why unused
                        #rend_idx = z
                        pass
            #for u in range(0,len(self.used_fields)):
                #self.add_field_layout(dlg,layer,self.used_fields[u],u)
        except Exception as e:
            QgsMessageLog.logMessage("Error parsing style {}".format(str(e)), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)

    def clear_field_layout(self, dlg):
        fields_layout = dlg.field_selection
        for n in range(0,fields_layout.count()):
            fields_layout.removeItem(fields_layout.itemAt(n))


    def add_field_layout(self,dlg,layer,field_name,index):
        self.clear_field_layout(dlg)
        fields_layout = dlg.field_selection
        span = QHBoxLayout()
        #span.setObjectName("span_{}+{}".format(str(field_name)+str(index+1)))
        label = QLabel()
        #label.setObjectName("label_{}+{}".format(str(field_name)+str(index+1)))
        label.setText("{}  :  ".format(str(field_name)))
        field_select = QComboBox()
        #field_select.setObjectName("fieldSelect_{}+{}".format(str(field_name)+str(index+1)))
        field_select.addItems(layer.fields().names())
        span.addWidget(label)
        span.addWidget(field_select)
        fields_layout.insertLayout(index,span)
        #return
        
    def getLabelField(self, labelObj):
        label_exp = ''
        if 'expression' in labelObj:
            label_exp = labelObj['expression']
        return label_exp
    
    def parseLabels(self, labelSymbArr, labelExpArr, layer, layerId = 0):
        #label = ''
        labelExp = labelExpArr[layerId]
        ## Parse label expression - by default - one label with brackets (VB syntax)
        ##TODO: Generelize
        if "[" in labelExp:
            labelExp = labelExp[1:-1]
            
        labelParse = labelSymbArr[layerId][0]
        labelSymbol = labelParse['textSymbol']
        
        ## Init properties
        try:
            fontFamily = labelSymbol['symbol']['fontFamilyName'] if labelSymbol['symbol']['fontFamilyName'] else 'David'
            fontSize = labelSymbol['symbol']['height'] if labelSymbol['symbol']['height'] else 12
            color = labelSymbol['symbol']['symbol']['symbolLayers'][0]['color']
            ptColor = self.colorToRgbArray(color['values'], color['type'])
            fontWeight = labelSymbol['symbol']['fontStyleName'] if labelSymbol['symbol']['fontStyleName'] else 'Regular'
            minimumScale = labelParse['minimumScale'] if 'minimumScale' in labelParse else ''            
        except Exception as e:
            QgsMessageLog.logMessage(str(e),'qlyrxStyler', level=Qgis.MessageLevel.Critical)
        
        # Create label settings    
        label_settings  = QgsPalLayerSettings()
        # Create font settings    
        text_format = QgsTextFormat()
        text_format.setFont(QFont(fontFamily, fontSize))
        text_format.setSize(fontSize)
        text_format.setColor(ptColor)
        text_format.setNamedStyle(fontWeight)
        #buffer_settings = QgsTextBufferSettings()
        #buffer_settings.setEnabled(True)
        #buffer_settings.setSize(0.30)
        #buffer_settings.setColor(QColor("black"))
        #text_format.setBuffer(buffer_settings)
        
        label_settings.setFormat(text_format)
        label_settings.fieldName = labelExp
        
        ## Default label placement 
        ## TODO: create conversion object to all placement properties
        label_settings.placement = Qgis.LabelPlacement(1)
        label_settings.centroidInside = 1
        label_settings.centroidWhole = 1
        ## Scale visibility
        try:
            label_settings.scaleVisibility = True if not minimumScale == '' else False
            label_settings.minimumScale = minimumScale if not minimumScale == '' else 0
        except Exception as e:
            QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)    
        ## Label visibility
        label_settings.enabled = True
        label_settings = QgsVectorLayerSimpleLabeling(label_settings)
        layer.setLabelsEnabled(True)        
        ## 
        #layer.setLabeling(label_settings)        
        
        return label_settings

    def getSymbolLayers(self, obj):    
        return obj['symbol']['symbol']['symbolLayers']
    
    
    def getSymbolHalo(self, obj):
        halo = ''
        if 'haloSymbol' in obj['symbol']['symbol']:
            halo = obj['symbol']['symbol']['haloSymbol']
        return halo


    def readValueDef(self, obj):
        return obj['symbol']['symbol']['symbolLayers']


    def checkSymbolType(self, obj):       
        obj_arr = {}
        sl_idx = 0
        count_disabled = 0
        for o in obj:               
            if 'desc' not in obj_arr  :
                obj_arr['desc'] = []
            type = o['type']    
            if  type not in obj_arr  :
                obj_arr[type] = 0
            obj_arr[type] = obj_arr[type] + 1
            o['sl_idx'] = sl_idx
            obj_arr['desc'].append(o)
            if 'enable' in o and not o['enable']:
                count_disabled = count_disabled + 1
            sl_idx = sl_idx + 1
        obj_arr['layer_count'] = sl_idx - count_disabled
        if 'CIMHatchFill' in obj_arr:
            obj_arr['template'] = 'hatch'
            obj_arr['template_hatch_num'] = obj_arr['CIMHatchFill']        
        else:
            obj_arr['template'] = 'simple'
            
        if 'CIMLineSymbol' in obj_arr:
            obj_arr['template_line_num'] = obj_arr['CIMLineSymbol']        
        if 'CIMSolidFill' in obj_arr:
            obj_arr['template_solid_num'] = obj_arr['CIMSolidFill']
        if 'CIMSolidStroke' in obj_arr:
            obj_arr['template_stroke_num'] = obj_arr['CIMSolidStroke']
        if 'CIMCharacterMarker' in obj_arr:
            obj_arr['template_font_num'] = obj_arr['CIMCharacterMarker']
        
        return obj_arr


    def tweakHaloSymbol(self, layers, haloDef, layer):
        if not haloDef == '':
            #halo_symbol_def = checkSymbolType(haloDef[0])
            new_layer = layers[len(layers) - 1].clone()
            new_layer.setSize(new_layer.size()*1.1)
            symbolHalo = haloDef['symbolLayers']
            halo_symbol_def = self.checkSymbolType(symbolHalo)
            hallo_arr = self.parseSolidFill(halo_symbol_def, layer)            
            newFillSymbol = hallo_arr[0]        
            newStroke = self.parseStroke(halo_symbol_def, newFillSymbol, layer)  
            #for h in symbolHalo:
                #print("halo symbol layer is " + h['type'])
            if newFillSymbol != '':    
                new_layer.setStrokeColor(newFillSymbol.color())
                new_layer.setStrokeWidth(0.5)
            if not newStroke == '':
                #new_layer.setColor(newFillSymbol.color())
                new_layer.setStrokeColor(newStroke[0].color())
            layers.append(new_layer)
        return layers


    def parseSymbolLayerSolidFill(self, layers):
        colors = []
        for l in layers:  # noqa: E741
            if l['type'] == 'CIMSolidFill':            
                temp_color = l['color']['values']
                new_color = self.colorToRgbArray(temp_color, l['color']['type'])
                colors.append(new_color)
        return colors

    def generalise_geom_type(self, layer):
        geometry_type_str = QgsWkbTypes.displayString(layer.wkbType())
        geometry_general_type_str = geometry_type_str.replace('Multi', '').replace('Z', '').lower()  
        geometry_general_type_str = geometry_general_type_str.replace('string', '')
        return geometry_general_type_str

    def parseRasterData(self, obj, layer):
        colorizer = obj['colorizer']
        #renderer = ''
        if 'Classify' in colorizer['type']:
            self.parseRasterClassBreaks(colorizer, layer)
        elif 'Unique' in colorizer['type']:
            self.parseRasterGroups(colorizer, layer)
        
        #return renderer
        #return ''
            
    def parseRasterGroups(self, obj, layer):
        groups = obj['groups']        
        renderer = ''
        col_array = []        
        #val_array = []
        rampArray = []
        stats = self.getRasterLayerStats(layer)
        QgsMessageLog.logMessage(stats, 'qlyrxStyler', level=Qgis.MessageLevel.Info)
        min= stats.minimumValue
        max = stats.maximumValue
        #initMin = False        
        classes = groups[0]['classes']
        
        for gr in classes:            
            color = self.colorToRgbArray(gr['color']['values'], gr['color']['type'])
            label = gr['label']            
            col_array.append(color)
            vals = gr['values'] if 'values' in gr else []
            val_arr = []
            for gr_val in vals:
                val_arr.append(float(gr_val))
                rampArray.append(QgsColorRampShader.ColorRampItem(float(gr_val), color,label ))
        
        try:
            fcn = QgsColorRampShader()            
            fcn.setColorRampType(QgsColorRampShader.Exact)            
            fcn.setColorRampItemList(rampArray)                        
            cRamp = QgsPresetSchemeColorRamp(col_array)            
            fcn.setSourceColorRamp(cRamp)            
            
            shader = QgsRasterShader()
            shader.setRasterShaderFunction(fcn)
            
            renderer = QgsSingleBandPseudoColorRenderer(layer.dataProvider(), layer.type(), shader)                
            layer.setRenderer(renderer)            
            layer.renderer().setClassificationMin(min)
            layer.renderer().setClassificationMax(max)
            layer.renderer().shader().rasterShaderFunction().setColorRampItemList(rampArray)            
            layer.triggerRepaint()
            QgsMessageLog.logMessage("after raster repaint", 'qlyrxStyler', level=Qgis.MessageLevel.Info)            
                        
        except Exception as e:                                
            QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
                
        
    def parseRasterClassBreaks(self, obj, layer):
        classBreaks = obj['classBreaks']
        col_array = []        
        val_array = []
        rampArray = []
        stats = self.getRasterLayerStats(layer)
        min= stats.minimumValue
        max = stats.maximumValue                
        initMin = False
        for cb in classBreaks:
            color = self.colorToRgbArray(cb['color']['values'], cb['color']['type'])
            col_array.append(color)
            val = cb['upperBound'] if 'upperBound' in cb else 0
            val_array.append(val)
            label = cb['label']
            if not initMin:
                rampArray.append(QgsColorRampShader.ColorRampItem(val, color, label))
                initMin = True
            if len(val_array) > 1:    
                rampArray.append(QgsColorRampShader.ColorRampItem(val, color, label))            
        
        try:                                
            
            fcn = QgsColorRampShader()            
            fcn.setColorRampType(QgsColorRampShader.Discrete)            
            fcn.setColorRampItemList(rampArray)                        
            cRamp = QgsPresetSchemeColorRamp(col_array)            
            fcn.setSourceColorRamp(cRamp)            
            
            shader = QgsRasterShader()
            shader.setRasterShaderFunction(fcn)
            
            renderer = QgsSingleBandPseudoColorRenderer(layer.dataProvider(), layer.type(), shader)                
            layer.setRenderer(renderer)            
            layer.renderer().setClassificationMin(min)
            layer.renderer().setClassificationMax(max)
            layer.renderer().shader().rasterShaderFunction().setColorRampItemList(rampArray)            
            layer.triggerRepaint()
            QgsMessageLog.logMessage("after raster repaint", 'qlyrxStyler', level=Qgis.MessageLevel.Info)            
                        
        except Exception as e:                                
            QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
            
        #return ''

    def getRasterLayerStats(self, layer):
        ## TODO: check why unused
        #rend = layer.renderer()
        provider = layer.dataProvider()
        ver = provider.hasStatistics(1, QgsRasterBandStats.All)
        stats = provider.bandStatistics(1, QgsRasterBandStats.All,layer.extent(), 0)
        if ver is not False:
            QgsMessageLog.logMessage("RasterLayerStats.minimumValue = ", stats.minimumValue, 'qlyrxStyler', level=Qgis.MessageLevel.Info)
            QgsMessageLog.logMessage("RasterLayerStats.maximumValue = ", stats.maximumValue, 'qlyrxStyler', level=Qgis.MessageLevel.Info)
        return(stats)
        
    def parseSolidFill(self, obj, layer):
        symbol = ""
        i = 0
        solid_index = -1
        for ls in obj['desc']:
            if ls['type'] == 'CIMSolidFill' and ls['enable']:
                temp_color = ls['color']['values']
                new_color = self.colorToRgbArray(temp_color, ls['color']['type'])            
                symbol = QgsSymbol.defaultSymbol(layer.geometryType())
                symbol.setColor(new_color)  
                ### TODO add lock
                #symbol.setStrokeColor(new_color)     
                solid_index = ls['sl_idx'] if 'sl_idx' in ls else 0
                i = i + 1
        if i > 1:
            QgsMessageLog.logMessage("parseSolidFill, Extra " + str(i) + " solid fills", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
        # Add default shape fill.
        if symbol == '' or  self.generalise_geom_type(layer) == 'line':
            symbol = QgsSymbol.defaultSymbol(layer.geometryType())
            new_color = self.colorToRgbArray([255,255,255,0], 'CIMRGBColor')            
            symbol.setColor(new_color)   
                                
        #symbol['order'] = 0
        return [symbol, solid_index]


    def parseLineCap(self, obj):
        lineCap = 1
        if 'capStyle' in obj:        
            lineCap = self.capStyles[obj['capStyle']]
        return lineCap


    def parseLineJoin(self, obj):
        lineJoin = 1
        
        if 'joinStyle' in obj:        
            lineJoin = self.joinStyles[obj['joinStyle']]
        return lineJoin 


    def parseStroke(self, obj, symb, layer):                
        #layers = []
        i = 0
        layers_obj = {}
        firstWidth = 0
        firstColor = ''
        geometry_general_type_str = self.generalise_geom_type(layer)
        for ls in obj['desc']:
            firstDash = False
            if ls['type'] == 'CIMSolidStroke' and ls['enable']:
                ## Check dash effects
                dp = self.parseStrokeEffects(ls)            
                new_color = self.colorToRgbArray(ls['color']['values'], ls['color']['type'])            
                stroke_width = ls['width']*self.point2mm                         
                cap = self.parseLineCap(ls)                                
                join = self.parseLineJoin(ls)
                stroke_order = ls['sl_idx'] if 'sl_idx' in ls else 0
                if  i == 0 and  dp == '' and not geometry_general_type_str == 'line':
                    #Change the first symbol layer stroke by layer type            
                    symb.symbolLayer(0).setStrokeColor(new_color)
                    symb.symbolLayer(0).setStrokeWidth(stroke_width)                
                    
                    cleanStrokeSymbol = symbol_layer = QgsSimpleLineSymbolLayer()
                    cleanStrokeSymbol.setColor(new_color)
                    cleanStrokeSymbol.setWidth(stroke_width)
                    firstWidth = stroke_width
                    firstColor = cleanStrokeSymbol.color()                
                    cleanStrokeSymbol.setPenCapStyle(cap)                                        
                    cleanStrokeSymbol.setPenJoinStyle(join)
                    ## Fix stroke offset
                    if not geometry_general_type_str == 'line':
                        cleanStrokeSymbol.setOffset(stroke_width/2)
                    
                    layers_obj[stroke_order] = cleanStrokeSymbol
                else :
                    if (i == 0):
                        firstDash = True
                    # Add simple line symbol layer (stroke)                
                    symbol_layer = QgsSimpleLineSymbolLayer()                
                    symbol_layer.setColor(new_color)
                    symbol_layer.setWidth(stroke_width)
                    if firstWidth < stroke_width:
                        if symbol_layer.color() == firstColor:
                            if 0 in layers_obj:
                                layers_obj[0].setWidth(stroke_width)
                                if not geometry_general_type_str == 'line':
                                    layers_obj[0].setOffset(stroke_width/2)
                                                    
                    symbol_layer.setPenCapStyle(cap)                                        
                    symbol_layer.setPenJoinStyle(join)
                    ## Fix stroke offset
                    if not geometry_general_type_str == 'line':
                        symbol_layer.setOffset(stroke_width/2)
                    # Add dash pattern
                    if not dp == '':
                        symbol_layer.setUseCustomDashPattern(True)
                        symbol_layer.setCustomDashVector(dp)
                    symbol_layer = self.changeColorLock(symbol_layer, ls)    
                    symb.appendSymbolLayer(symbol_layer)                            
                    layers_obj[stroke_order] = symbol_layer
                i = i + 1            
        return [symb, layers_obj, firstDash]


    def parseStrokeEffects(self, obj):
        dash_pattern = ''
        temp_array = []
        if 'effects' in obj:
            if obj['effects'][0]['type'] == 'CIMGeometricEffectDashes' :
                temp_pattern = obj['effects'][0]['dashTemplate']
                for tp in temp_pattern:
                    temp_array.append(tp*self.point2mm)
                dash_pattern = temp_array
        return dash_pattern


    def parseLineFill(self, obj, layer):    
        ## TODO: check why unused
        #isDoubleHatch = False
        ## TODO: check why unused
        #isOffsetEqFirstWidth = True 
        symbol = ""
        layers = []
        layers_obj = {}
        i = 0
        ## TODO: check why unused
        #first_width = 0
        prev_hatch = 0
        ## TODO: check why unused
        #geometry_general_type_str = self.generalise_geom_type(layer)
        for ls in obj['desc']:        
            if ls['type'] == 'CIMHatchFill' and ls['enable']:            
                sd_num = 0
                full_symbol_layer = ''
                for sd in reversed(ls['lineSymbol']['symbolLayers']):
                    symb_def = sd
                    QgsMessageLog.logMessage("parseLineFill, Line symbol sl num is " + str(sd_num) + "From " + str(len(ls['lineSymbol']['symbolLayers'])), 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                    ## New definitions
                    angle = ls['rotation'] if 'rotation' in ls else 0            
                    temp_color = symb_def['color']['values']
                    new_color = self.colorToRgbArray(temp_color, symb_def['color']['type'])
                    ## Hatch definitions
                    fill_width = symb_def['width'] if 'width' in symb_def else 1
                    fill_width = fill_width*self.point2mm
                    fill_distance = ls['separation'] if 'separation' in ls else 0
                    fill_distance = fill_distance*self.point2mm
                    if fill_distance <= 0.6 and not fill_distance == 0:
                        # TODO: add user interaction
                        QgsMessageLog.logMessage("QGIS problem with line fill small distances", 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                        widthRatio = fill_width/self.point2mm/fill_distance
                        if widthRatio < 1:
                            widthRatio = 1/widthRatio 
                        fill_distance = max(fill_distance*2,0.8)
                        fill_width = fill_width/self.point2mm*widthRatio
                        if fill_width > fill_distance:
                            # TODO: add user interaction
                            QgsMessageLog.logMessage("parseLineFill, Fill width error", 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                           
                    fill_offset = ls['offsetX'] if 'offsetX' in ls else 0
                    #fill_offset = fill_offset*self.point2mm
                    ## Create symbol and set properties
                    symbol_layer = QgsLinePatternFillSymbolLayer() #if symbol_layer == '' else QgsSimpleLineSymbolLayer()
                    if sd_num == 0:
                        full_symbol_layer = symbol_layer
                    else:
                        symbol_layer = QgsSimpleLineSymbolLayer()    
                        
                    dp = self.parseStrokeEffects(symb_def)
                    
                    symbol_layer.setColor(new_color)
                    if sd_num >= 0:
                        if sd_num == 0:
                            symbol_layer.setLineAngle(angle)
                            symbol_layer.setLineWidth(fill_width)                    
                            symbol_layer.setDistance(fill_distance)                     
                            symbol_layer = self.changeColorLock(symbol_layer, ls)
                        else:
                            #symbol_layer.setAngle(angle)
                            try:
                                # TODO: add user interaction
                                QgsMessageLog.logMessage("parseLineFill, Try width", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                                symbol_layer.setWidth(fill_width)                    
                            except Exception as e:
                                # TODO: add user interaction
                                QgsMessageLog.logMessage("set width error", 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                                QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Warning)

                    
                        if not dp == '':
                            symbol_layer.subSymbol().symbolLayer(0).setUseCustomDashPattern(True)
                            symbol_layer.subSymbol().symbolLayer(0).setCustomDashVector(dp)
                        ## Tweak save the first hatch width and use as offset
                        # TODO: Real fix, mark problematic files and unusual offsets
                        if prev_hatch > 0 and sd_num == 0:
                            symbol_layer.setLineWidth(fill_width)
                            symbol_layer.setOffset(fill_width)
                            #isOffsetEqFirstWidth = fill_width == prev_hatch
                            ## TODO: check why unused
                            #isDoubleHatch = True
                        elif not fill_offset == 0 and not dp == '' :
                            symbol_layer.setOffset(fill_offset)
                    
                        if not sd_num == 0:          
                            try:                                
                                full_symbol_layer.subSymbol().appendSymbolLayer(symbol_layer)
                                
                            except Exception as e:
                                # TODO: add user interaction
                                QgsMessageLog.logMessage("Failed append subsymbol", 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                                QgsMessageLog.logMessage(full_symbol_layer.__class__.__name__, 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                                QgsMessageLog.logMessage(full_symbol_layer.subSymbol().__class__.__name__, 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                                QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                            
                    sd_num = sd_num + 1                                       
                    
                layers.append(full_symbol_layer)
                if 'sl_idx' in ls:
                    layers_obj[ls['sl_idx']] = full_symbol_layer
                
                if i == 0:
                    prev_hatch = fill_width
                i = i + 1
                    
                    
        if len(layers) > 0:
            return [layers, layers_obj]
        else:
            return symbol


    def cmyk2Rgb(self, cmyk_array):
        c = cmyk_array[0]
        m  = cmyk_array[1]
        y  = cmyk_array[2]
        k  = cmyk_array[3]
        
        r = int((1 - ((c + k)/100)) * 255)
        g = int((1 - ((m + k)/100)) * 255)
        b = int((1 - ((y + k)/100)) * 255)
        
        return [r, g, b]


    def changeColorLock(self, sl, symbol_def):
        color_lock = symbol_def['colorLocked'] if 'colorLocked' in symbol_def else ''    
        if not color_lock == '':
            sl.setLocked(True)
        return sl


    def colorToRgbArray(self, color_array, type):
        try:
            color_array = [int(x) for x in color_array]
            opacity = 255
            if len(color_array) > 2 and type == 'CIMRGBColor':
                opacity = int(color_array[3]/100*255) # ensure opacity is an int in the 0-255 range
                new_color = QColor.fromRgb(color_array[0],color_array[1], color_array[2], opacity) 
            else:    
                new_color = QColor.fromRgb(color_array[0],color_array[1], color_array[2])        
            if type == 'CIMHSVColor':
                new_color = QColor.fromHsvF(color_array[0]/360,color_array[1]/100, color_array[2]/100,1)
            elif type == 'CIMCMYKColor':
                temp_color = self.cmyk2Rgb(color_array)
                new_color = QColor.fromRgb(temp_color[0],temp_color[1], temp_color[2])
            return new_color
        except Exception as e:
            QgsMessageLog.logMessage('Error in color conversion', 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
            QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
            return QColor.fromRgb(255,255,255)



    def parseSimpleRenderer(self, obj, layer):
    
        symbol = ''
        symb_def = obj['symbol']['symbol']['symbolLayers'][0]
        
        if 'characterIndex' in symb_def and symb_def['type'] == 'CIMCharacterMarker':
            symbol_ret = self.parseCharacterFill(symb_def, 0, layer)
            symbol = symbol_ret[0]
        
        if  symb_def['type'] == 'CIMVectorMarker':
            vector_layers = self.parseVectorSymbolLine(symb_def, True, layer)
            if not vector_layers == '':
                ## TODO: check why unused
                #vl_idx = vector_layers
                for vl in vector_layers:
                    v_symb = vl[0]
                    ## TODO: check why unused
                    #v_ord = vl[1]
                    #allSymbolLayers[v_ord] = v_symb
                    symbol = v_symb
                    #print("After simple vector")
        QgsMessageLog.logMessage("parseSimpleRenderer, Geometry type is " + QgsWkbTypes.displayString(layer.wkbType()), 'qlyrxStyler', level=Qgis.MessageLevel.Info)
        # Polygon
        if layer.geometryType() == 2:            
            solid_array = self.parseSolidFill({"desc": [symb_def]}, layer)
            symbol = solid_array[0]
            for sl in obj['symbol']['symbol']['symbolLayers']:                        
                lines_ret = self.parseLineFill({'desc': [sl]} , layer)                
                if not lines_ret == '':
                    line_ret = lines_ret[0]
                    for line in line_ret:
                        try:
                            solid_array[0].appendSymbolLayer(line)
                        except Exception as e:
                            QgsMessageLog.logMessage("Failed append line symbol", 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
                            QgsMessageLog.logMessage(line.__class__.__name__)
                            QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Warning)
            
            stroke = self.parseStroke({"desc": [symb_def], "sl_idx": 0}, solid_array[0], layer)
            
            if(stroke):
                symbol = stroke[0]
                if len(stroke[1]):
                    symbol.appendSymbolLayer(stroke[1][0])
            
        return symbol


    def parseCharacterFill(self, symb_def, max_size, layer):
        ret_val = ''
        symbol = QgsFontMarkerSymbolLayer()            
        symbol.setFontFamily(symb_def['fontFamilyName'])
        symbol.setCharacter(chr(symb_def['characterIndex']))
        ## TODO: check why unused
        #new_size = symb_def['size']*self.point2mm
        symbol.setSize(symb_def['size']*self.point2mm)
        geometry_general_type_str = self.generalise_geom_type(layer)
        
        if 'rotation' in symb_def:
            new_angle = symb_def['rotation']
            negative_angle = new_angle < 0
            if (new_angle < 0 and new_angle <= -90) or new_angle == -45:
                new_angle = abs(new_angle)
            elif new_angle < 0 and new_angle > -90:
                new_angle = new_angle
                
            if abs(new_angle) > 180:                       
                new_angle = 360 - new_angle
                if negative_angle:
                    new_angle = new_angle*-1
                #print("180 correction to " + str(new_angle))
            symbol.setAngle(new_angle)
            
            # Fix offset - rotation twaek
            #symbol.setOffset(QPointF(0.3,0.0))
            #offset_tweak = (max_size - new_size)/2 if max_size > new_size else 0
            #print(offset_tweak)
            #if offset_tweak > 0:
            #    symbol.setOffset(QPointF(0,0))
        #print(symb_def['characterIndex'])
        # Check fill color     
        if 'symbol' in symb_def :
            if 'symbolLayers' in symb_def['symbol']:
                color = self.parseSymbolLayerSolidFill(symb_def['symbol']['symbolLayers'])
                #print(color)
                symbol.setColor(color[0])
        ## Check offset        
        offset_def = symb_def['anchorPoint'] if 'anchorPoint' in symb_def else ''
        if 'x' in offset_def:
            offsetX = offset_def['x']*self.point2mm
            offsetY = offset_def['y']*self.point2mm 
            symbol.setOffset(QPointF(offsetX,offsetY))
            
        ### TODO Fix offset after rotation
        #print(symbol.markerOffsetWithWidthAndHeight(symbol, 8, 8))
            
        if not geometry_general_type_str == 'point':
            symbol_base = QgsPointPatternFillSymbolLayer()
            if geometry_general_type_str == 'line':
                symbol_base = QgsMarkerLineSymbolLayer()
            ## Change to line symbol when diplacement is along line
            if 'markerPlacement' in symb_def and 'type' in symb_def['markerPlacement']:
                if symb_def['markerPlacement']['type'] == 'CIMMarkerPlacementAlongLineSameSize':
                    symbol_base = QgsMarkerLineSymbolLayer()
            #print("Special fill " + geometry_general_type_str)        
            ## Fill pattern
            if 'markerPlacement' in symb_def and 'stepX' in symb_def['markerPlacement']:
                symbol_base.setDistanceX(symb_def['markerPlacement']['stepX']*self.point2mm)
                symbol_base.setDistanceY(symb_def['markerPlacement']['stepY']*self.point2mm)    
                    
            marker = QgsMarkerSymbol()
            marker.changeSymbolLayer(0, symbol)
            symbol_base.setSubSymbol(marker)                
            ret_val = symbol_base
        else:    
            ret_val = symbol
        ret_val = self.changeColorLock(ret_val, symb_def)
        
        #join = parseLineJoin(symb_def)
        #ret_val.setPenJoinStyle(join)
        sym_ord = symb_def['sl_idx'] if 'sl_idx' in symb_def else -2
        return [ret_val, sym_ord]


    def parseVectorSymbolLine(self, obj, simple, layer):
        # unsused
        #vector_idx = 0
        vector_symbols = []
        vector_sl_array = []
        ## TODO: check why unused
        #symb_idx = -1
        base_symbol = ''
        order = ''
        geometry_general_type_str = self.generalise_geom_type(layer)
        if 'desc' not in obj:
            obj['desc'] = [obj]
        for ls in obj['desc']:        
            if ls['type'] == 'CIMVectorMarker' and ls['enable']: 
                
                order = ls['sl_idx'] if 'sl_idx' in ls else -3
                if 'markerGraphics' in ls:
                    mg = ls['markerGraphics']
                    placement = 1
                    markerDistanceX = ''
                    markerDistanceY = ''
                    if 'markerPlacement' in ls and 'placementTemplate' in ls['markerPlacement']:
                        placement = ls['markerPlacement']['placementTemplate'][0]
                        placement = placement*self.point2mm 
                    if 'markerPlacement' in ls and 'stepX' in ls['markerPlacement']:
                        markerDistanceX = ls['markerPlacement']['stepX']*self.point2mm
                        markerDistanceY = ls['markerPlacement']['stepY']*self.point2mm
                            
                    symbol_size = ls['size']*self.point2mm
                        
                    for mgs in mg:
                        if 'geometry' in mgs and 'x' in mgs['geometry']:
                            mgs_sl = mgs['symbol']['symbolLayers']
                            vector_symbols = []
                            for sl in mgs_sl:
                                if sl['type'] == 'CIMCharacterMarker':                                
                                    parsed_symb = self.parseCharacterFill(sl, 0, layer) 
                                    if not parsed_symb[0] == '':
                                        symb_type = parsed_symb[0].__class__.__name__
                                        if 'MarkerLine' in symb_type:
                                            parsed_symb[0].setInterval(placement)
                                        else:
                                            if not markerDistanceX == '':
                                                parsed_symb[0].setDistanceX(markerDistanceX)
                                                parsed_symb[0].setDistanceY(markerDistanceY)
                                        vector_symbols.append(parsed_symb[0])
                            if len(vector_symbols) > 1:
                                base_symbol = vector_symbols[0].clone()
                                vs_idx = 0
                                for vs in vector_symbols:
                                    if vs_idx > 0:
                                        subSymbLayer = vs.subSymbol().symbolLayer(0).clone()
                                        origFirstSubSymbLayer = base_symbol.subSymbol().symbolLayer(0).clone()
                                        base_symbol.subSymbol().appendSymbolLayer(origFirstSubSymbLayer)
                                        base_symbol.subSymbol().changeSymbolLayer(0, subSymbLayer)
                                    vs_idx = vs_idx + 1
                                vector_sl_array.append([base_symbol, order])
                            else:
                                vector_sl_array.append([vector_symbols[0], order])
                                
                        else:
                            geom = mgs['geometry']
                            ## Finding matching pattern
                            if 'paths' in geom: 
                                for path_obj in self.paths_to_shapes_array:
                                    path_pattern = []
                                    for path_p in geom['paths']:
                                        pair = []
                                        for path_pair in path_p:                                
                                            new_str = ",".join(map(str, path_pair))                                    
                                            new_str  = re.sub('[1-9]', '3', new_str)
                                            new_str = new_str.split(',')
                                            try:
                                                new_str = [int(i) for i in new_str]
                                            except Exception as e:
                                                QgsMessageLog.logMessage(str(e), 'qlyrxStyler', level=Qgis.MessageLevel.Critical)
                                                new_str = [float(i) for i in new_str]
                                            pair.append(new_str)                                    
                                                                           
                                        path_pattern.append(pair)
                                    
                                    alt_path_object = {"paths": path_pattern}
                                    if self.paths_to_shapes_array[path_obj] == geom or self.paths_to_shapes_array[path_obj] == alt_path_object:
                                        QgsMessageLog.logMessage("Found geom!!!!!!!!!!!!!!!!!!!!!!!!!!!!", 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                                        QgsMessageLog.logMessage(QgsSimpleMarkerSymbolLayerBase.decodeShape(path_obj), 'qlyrxStyler', level=Qgis.MessageLevel.Info)
                                        shape_id, isShape = QgsSimpleMarkerSymbolLayerBase.decodeShape(path_obj)
                                        main_sym = QgsMarkerLineSymbolLayer.create()
                                        vect_symb = QgsSimpleMarkerSymbolLayer.create()                                
                                        vect_symb.setShape(shape_id)                                
                                        vect_symb.setSize(symbol_size)                                
                                        main_sym.subSymbol().changeSymbolLayer(0, vect_symb)
                                        main_sym.setInterval(placement)
                                        vector_sl_array.append([main_sym, order])
                            elif 'curveRings' in geom:                                                    
                                vect_symb = QgsSimpleMarkerSymbolLayer.create()                                                            
                                vect_symb.setSize(symbol_size)                                

                                if not geometry_general_type_str == 'point':
                                    main_sym = QgsMarkerLineSymbolLayer.create()
                                    main_sym.subSymbol().changeSymbolLayer(0, vect_symb)
                                    main_sym.setInterval(placement)
                                    vector_sl_array.append([main_sym, order])
                                else:
                                    vector_sl_array.append([vect_symb, order])
        if len(vector_sl_array) == 0:
            vector_sl_array = ''
        else:   
            QgsMessageLog.logMessage("vector array length " + str(len(vector_sl_array)), 'qlyrxStyler', level=Qgis.MessageLevel.Info)
        return vector_sl_array


    def parsePictureFill(self, obj, appendix):
        pic_idx = 0
        svg_symbol = ''
        symb_idx = -1
        for ls in obj['desc']:        
            if ls['type'] == 'CIMPictureFill' and ls['enable']:   
                url_data = ls['url']
                ## TODO: check why unused
                # url_data_array = url_data.split(",")
                plugin_path = os.path.dirname(os.path.realpath(__file__))
                svg_path = plugin_path+"\\img"
                svg_paths = QgsSettings().value('svg/searchPathsForSVG')
                if plugin_path not in svg_paths:
                    QgsSettings().setValue('svg/searchPathsForSVG', svg_paths + [plugin_path, svg_path])
                
                template_f = open(plugin_path+"/img/svg_template.svg")
                template_str = template_f.read()            
                template_str = str(template_str)            
                
                template_str = template_str.replace("image_url", str(url_data))
                        
                f = open(str(pic_idx)+appendix + ".svg","w")
                name = f.name
                f.write(template_str)
                template_f.close()
                f.close()
                svg_symbol = QgsSVGFillSymbolLayer.create()
                svg_symbol.setSvgFilePath( name )
                new_color = self.colorToRgbArray([80,80,80,100], 'CIMRGBColor')     
                svg_symbol.setSvgFillColor(new_color)
                svg_symbol.setSvgStrokeColor(new_color)
                symb_idx = ls['sl_idx']
                pic_idx = pic_idx + 1
                
        return [svg_symbol, symb_idx]