# -*- coding: utf-8 -*-
"""
/***************************************************************************
 qlyrx
                                 A QGIS plugin
 Apply Arcgis Pro .lyrx style
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-09
        git sha              : $Format:%H$
        copyright            : (C) 2019 by arc2qgis
        email                : dror.bogin@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QPointF
from PyQt5.QtGui import QIcon, QColor, QFont
from PyQt5.QtWidgets import QAction, QFileDialog, QHBoxLayout, QLabel, QComboBox, QDialog
from qgis.core import (QgsMessageLog, Qgis, QgsProject, QgsWkbTypes, QgsColorRampShader, QgsPresetSchemeColorRamp, 
                       QgsRasterShader, QgsRasterBandStats, 
                        QgsSymbol, QgsSingleSymbolRenderer,QgsSingleBandPseudoColorRenderer, QgsSimpleLineSymbolLayer, 
                        QgsLinePatternFillSymbolLayer, QgsFontMarkerSymbolLayer, QgsSettings,
                        QgsPointPatternFillSymbolLayer, QgsMarkerLineSymbolLayer, QgsMarkerSymbol, 
                        QgsSimpleMarkerSymbolLayerBase, QgsSimpleMarkerSymbolLayer, QgsSVGFillSymbolLayer, 
                        QgsPalLayerSettings, QgsTextFormat, QgsVectorLayerSimpleLabeling, QgsRendererCategory, QgsCategorizedSymbolRenderer)
from qgis.utils import *
import json
import re


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .qlyrx_dialog import qlyrxDialog
from .qlyrx_styler import qlyrxStyler
import os
import os.path





class qlyrx:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.mb = self.iface.messageBar()
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        self.j_data = None
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'qlyrx_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        
        self.dlg = qlyrxDialog()
        self.styler = qlyrxStyler()
        
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&qlyrx')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None


    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('qlyrx', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        lyrx_icon_path = ':/plugins/qlyrx/icon_lyrx.png'
        self.add_action(
            lyrx_icon_path,
            text=self.tr(u'Apply lyrx symbology'),
            callback=self.run,
            parent=self.iface.mainWindow())

        qml_icon_path = ':/plugins/qlyrx/icon_qml.png'
        LoadStyleAction = QAction('Load Style From QML/SLD')
        LoadStyleAction.setIcon(QIcon(qml_icon_path))
        LoadStyleAction.triggered.connect(self.LoadStyle)
        self.add_action(
            qml_icon_path,
            text=self.tr(u'Load Style From QML/SLD'),
            callback=self.LoadStyle,
            parent=self.iface.mainWindow())
        #self.iface.addCustomActionForLayerType(LoadStyleAction,'',qgis.core.QgsMapLayerType(0),True)
        # will be set False in run()
        self.first_start = True
        

    def LoadStyle(self):
        """
        Adding a context menu option to apply previously saved QML\\SLD styles
        """
        layer = self.iface.activeLayer()
        self.fd = QFileDialog()
        self.fd.show()
        self.fd.setFileMode(QFileDialog.ExistingFile)
        self.fd.setNameFilter("QGIS Layer Style File, SLD File (*.qml *.sld )")
        if self.fd.exec_() == QDialog.Accepted:
            file = str(self.fd.selectedFiles()[0])
            if file.endswith('sld'):
                layer.loadSldStyle(file)
            elif file.endswith('qml'):
                layer.loadNamedStyle(file)
            layer.triggerRepaint()


    def getIcon(self,layer):
        layerType = layer.type()
        provider = layer.providerType()
        if layerType == 0:
            # Vector
            geomType = layer.geometryType()
            if geomType == 0:
                # Points
                icon = QIcon(":images/themes/default/mIconPointLayer.svg")
            elif geomType == 1:
                # Lines
                icon = QIcon(":images/themes/default/mIconLineLayer.svg")
            elif geomType == 2:
                # Polygons
                icon = QIcon(":images/themes/default/mIconPolygonLayer.svg")
            else:
                # Tables, maybe filter in advance
                icon = QIcon(":images/themes/default/mIconTableLayer.svg")
        elif layerType == 1:
            # Raster
            if provider == "wms":
                icon = QIcon(":images/themes/default/mIconWms.svg")
            elif provider == "gdal":
                icon = QIcon(":images/themes/default/mIconRaster.svg")
            elif provider == "arcgismapserver":
                icon = QIcon(":images/themes/default/mIconRaster.svg")
        elif layerType == 3:
            icon = QIcon(":images/themes/default/mIconMeshLayer.svg")
        return icon


    def load_vectors(self):
        """
        Populate the layer selection with vector layers only
        """
        self.dlg.layer_select.clear()
        layers = [layer for layer in QgsProject.instance().mapLayers().values()]
        for layer in layers:
            icon = self.getIcon(layer)
            name = layer.name()
            userData = {'id':layer.id()}
            self.dlg.layer_select.addItem(icon,name,userData)

    
    def enableQmlSaving(self):
        if self.dlg.saveQmlCheck.isChecked():
            self.dlg.QMLSaveLocation.setEnabled(True)
            self.dlg.qmlLabel.setEnabled(True)
        else:
            self.dlg.QMLSaveLocation.setDisabled(True)
            self.dlg.qmlLabel.setDisabled(True)

    
    def saveQML(self,layer):
        try:
            if(len(self.dlg.QMLSaveLocation.filePath())) > 0:
                QmlPath = self.dlg.QMLSaveLocation.filePath()
                layer.saveNamedStyle(QmlPath)
            else:
                self.mb.pushWarning('QML Not Saved','missing Path')
        except Exception as e:
            self.mb.pushCritical('Error',"Something went wrong with saving the QML, please send us the following error: {}".format(e))


    def read_lyrx(self, file=None):    
        with open(file, mode="r", encoding="utf-8") as json_file:  
            data = json.load(json_file)
            layerID = self.dlg.layer_select.currentData()["id"]
            layer = [layer for layer in QgsProject.instance().mapLayers().values() if layer.id() == layerID][0]
            self.styler.initial_lyrx_parse(data,layer)
        return data



    

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&qlyrx'),
                action)
            self.iface.removeToolBarIcon(action)



    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started

        # show the dialog
        self.dlg.show()
        self.load_vectors()
        self.dlg.saveQmlCheck.stateChanged.connect(self.enableQmlSaving)
        self.dlg.file_select.fileChanged.connect(self.read_lyrx)
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            
            self.j_data = self.read_lyrx(self.dlg.file_select.filePath())
            
            layerName = self.dlg.layer_select.currentText()
            layer = [layer for layer in QgsProject.instance().mapLayers().values() if layer.name() == layerName][0]
            
            #fields = layer.fields() if layer.fields() else ''
            fields = layer.fields() if "fields" in dir(layer) else ''            
            isRaster = 'Raster' in layer.__class__.__name__ 
            geometry_general_type_str = self.styler.generalise_geom_type(layer) if not isRaster else 'raster'
            
            self.styler.apply_lyrx_symbols(self.dlg, layer, self.j_data, geometry_general_type_str)
            if self.dlg.saveQmlCheck.isChecked():
                self.saveQML(layer)
            self.mb.pushSuccess('qlyrx',"Style Applied Successfully")
            QgsMessageLog.logMessage("Style '{}' Applied Successfully to layer: '{}'".format(self.dlg.file_select.filePath(),layerName), tag=
                                     "qlyrx", level=Qgis.Success)
            #pass
