import os
from datetime import datetime

from qgis.core import (
	Qgis,
	QgsProject,
	QgsVectorLayer,
	QgsDataSourceUri,
)
from qgis.utils import iface, spatialite_connect

from qkan.utils import get_logger

from qkan import enums

logger = get_logger("QKan.zustand.import")


class Zustandsklassen_funkt:
	def __init__(self, check_cb, db, date, epsg, datetype):

		self.check_cb = check_cb
		self.db = db
		self.date = date
		self.crs = epsg
		self.datetype = datetype

		self.haltung=False
		self.leitung=False

	def run(self):
		check_cb = self.check_cb

		#x = os.path.dirname(os.path.abspath(__file__))
		# for file in os.listdir(x+"/Layouts"):
		#     if file.endswith(".qpt"):
		#         project = QgsProject.instance()
		#         composition = QgsPrintLayout(project)
		#         document = QDomDocument()
		#         template = open(x+"/Layouts/" + file)
		#         template_content = template.read()
		#         template.close()
		#         document.setContent(template_content)
		#         composition.loadFromTemplate(document, QgsReadWriteContext())
		#         project.layoutManager().addLayout(composition)

		if check_cb['cb7']:
			self.haltung = True
			self.leitung = False
			self.bewertungstexte_haltung()

		if check_cb['cb8']:
			self.bewertungstexte_schacht()

		if check_cb['cb10']:
			self.leitung = True
			self.haltung = False
			self.bewertungstexte_leitung()

		if check_cb['cb3'] and check_cb['cb1']:
			self.haltung = True
			self.leitung = False
			self.bewertung_dwa_haltung()

		if check_cb['cb5'] and check_cb['cb4']:
			self.bewertung_dwa_schacht()

		if check_cb['cb3'] and check_cb['cb2']:
			self.bewertung_isy_haltung()

		if check_cb['cb5'] and check_cb['cb6']:
			self.bewertung_isy_schacht()

		if check_cb['cb9']:
			self.haltung = True
			self.leitung = False
			self.bewertung_dwa_neu_haltung()

		if check_cb['cb14']:
			self.bewertung_dwa_neu_schaechte()

		if check_cb['cb15']:
			self.leitung = True
			self.haltung = False
			self.bewertung_dwa_neu_leitung()

		if check_cb['cb11'] and check_cb['cb12']:
			self.leitung = True
			self.haltung = False
			self.bewertung_dwa_leitung()

		if check_cb['cb11'] and check_cb['cb13']:
			self.bewertung_isy_leitung()

		if check_cb['cb16']:
			self.einzelfallbetrachtung_haltung()
			self.bewertung_dwa_neu_haltung()

		if check_cb['cb17']:
			self.einzelfallbetrachtung_schacht()
			self.bewertung_dwa_neu_schaechte()

		if check_cb['cb18']:
			self.einzelfallbetrachtung_leitung()
			self.bewertung_dwa_neu_leitung()

		if check_cb['cb19']:
			self.tab_dwa_haltung()
			self.tab_dwa_leitung()
			self.tab_dwa_schacht()

		if check_cb['cb20']:
			self.tab_isybau_haltung()
			self.tab_isybau_leitung()
			self.tab_isybau_schacht()

	def bewertungstexte_haltung(self):
		date = self.date+'%'
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()

		logger.debug(f'Start_Haltungstexte.liste: {datetime.now()}')

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_haltung_bewertung AS SELECT * FROM untersuchdat_haltung"""
		curs.execute(sql)

		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Beschreibung TEXT ;""")
			db.commit()
		except:
			pass

		if self.datetype == 'Befahrungsdatum':

			if haltung is True:

				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						NULL,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.untersuchtag,
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe,
						haltungen.createdat
					FROM untersuchdat_haltung_bewertung, haltungen
					WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ?
				"""
				data = (date, )
				curs.execute(sql, data)

			elif leitung is True:

				sql = """
						SELECT
							untersuchdat_haltung_bewertung.pk,
							untersuchdat_haltung_bewertung.untersuchhal,
							anschlussleitungen.createdat,
							untersuchdat_haltung_bewertung.schoben,
							untersuchdat_haltung_bewertung.schunten,
							untersuchdat_haltung_bewertung.id,
							untersuchdat_haltung_bewertung.videozaehler,
							untersuchdat_haltung_bewertung.inspektionslaenge,
							untersuchdat_haltung_bewertung.station,
							untersuchdat_haltung_bewertung.timecode,
							untersuchdat_haltung_bewertung.kuerzel,
							untersuchdat_haltung_bewertung.charakt1,
							untersuchdat_haltung_bewertung.charakt2,
							untersuchdat_haltung_bewertung.quantnr1,
							untersuchdat_haltung_bewertung.quantnr2,
							untersuchdat_haltung_bewertung.streckenschaden,
							untersuchdat_haltung_bewertung.pos_von,
							untersuchdat_haltung_bewertung.pos_bis,
							untersuchdat_haltung_bewertung.foto_dateiname,
							untersuchdat_haltung_bewertung.film_dateiname,
							untersuchdat_haltung_bewertung.kommentar,
							untersuchdat_haltung_bewertung.untersuchtag,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe
						FROM untersuchdat_haltung_bewertung, anschlussleitungen
						WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ? 
					"""
				data = (date,)
				curs.execute(sql, data)

		elif self.datetype == 'Importdatum':


			if haltung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						NULL,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.createdat,
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe,
						haltungen.createdat
					FROM untersuchdat_haltung_bewertung, haltungen
					WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ?
				"""
				data = (date,)
				curs.execute(sql, data)

			elif leitung is True:
				sql = """
						SELECT
							untersuchdat_haltung_bewertung.pk,
							untersuchdat_haltung_bewertung.untersuchhal,
							anschlussleitungen.createdat,
							untersuchdat_haltung_bewertung.schoben,
							untersuchdat_haltung_bewertung.schunten,
							untersuchdat_haltung_bewertung.id,
							untersuchdat_haltung_bewertung.videozaehler,
							untersuchdat_haltung_bewertung.inspektionslaenge,
							untersuchdat_haltung_bewertung.station,
							untersuchdat_haltung_bewertung.timecode,
							untersuchdat_haltung_bewertung.kuerzel,
							untersuchdat_haltung_bewertung.charakt1,
							untersuchdat_haltung_bewertung.charakt2,
							untersuchdat_haltung_bewertung.quantnr1,
							untersuchdat_haltung_bewertung.quantnr2,
							untersuchdat_haltung_bewertung.streckenschaden,
							untersuchdat_haltung_bewertung.pos_von,
							untersuchdat_haltung_bewertung.pos_bis,
							untersuchdat_haltung_bewertung.foto_dateiname,
							untersuchdat_haltung_bewertung.film_dateiname,
							untersuchdat_haltung_bewertung.kommentar,
							untersuchdat_haltung_bewertung.createdat,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe
						FROM untersuchdat_haltung_bewertung, anschlussleitungen
						WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ? 
					"""
				data = (date,)
				curs.execute(sql, data)

		for attr in curs.fetchall():

			sql = ""
			data = ()
			# Tab A.2
			if attr[10] == "BAA":
				z = 'Verformung'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			# Tab A.3
			elif attr[10] == "BAB":
				z = 'Rissbildung'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAC":
				z = 'Rohrbruch/Einsturz'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAD":
				z = 'Defektes Mauerwerk'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAE":
				z = 'Fehlender Mörtel'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAF":
				z = 'Oberflächenschäden'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAG":
				z = 'Einragender Anschluss'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAH":
				z = 'Schadhafter Anschluss'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAI":
				z = 'Einragendes Dichtungsmaterial'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAJ":
				z = 'Verschobene Verbindung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "A":
				z = 'Feststellung der Innenauskleidung: Innenauskleidung abgelöst'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "B":
				z = 'Feststellung der Innenauskleidung: Innenauskleidung verfärbt'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "C":
				z = 'Feststellung der Innenauskleidung: Endstelle der Auskleidung schadhaft'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "D":
				z = 'Feststellung der Innenauskleidung: Faten in der Auskleidung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "E":
				z = 'Feststellung der Innenauskleidung: Blasen oder Beulen in der Auskleidung nach innen'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "F":
				z = 'Feststellung der Innenauskleidung: Beulen aussen'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "G":
				z = 'Feststellung der Innenauskleidung: Ablösen der Innenhaut/Beschichtung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "H":
				z = 'Feststellung der Innenauskleidung: Ablösen der Abdeckung der Verbindungsnaht'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "I":
				z = 'Feststellung der Innenauskleidung: Riss oder Spalt (einschließlich schadhafter Schweissnaht)'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "J":
				z = 'Feststellung der Innenauskleidung: Loch in der Auskleidung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "K":
				z = 'Feststellung der Innenauskleidung: Auskleidungsverbindung defekt'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "L":
				z = 'Feststellung der Innenauskleidung: Auskleidungswerkstoff erscheint weich'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "M":
				z = 'Feststellung der Innenauskleidung: Harz fehlt im Laminat'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "N":
				z = 'Feststellung der Innenauskleidung: Ende der Auskleidung ist nicht abgedichtet, um das Rohr oder den Schacht aufzunehmen.'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "Z":
				z = 'Feststellung der Innenauskleidung: Anderer Auskleidungsschaden'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "A":
				z = 'Schadhafte Reperatur: Wand fehlt teilweise'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "B":
				z = 'Schadhafte Reperatur: Reperatur zur Abdichtung eines Lochs ist schadhaft'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "C":
				z = 'Schadhafte Reperatur: Ablösen des Reperaturwerkstofes vom Basisrohr'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "D":
				z = 'Schadhafte Reperatur: fehlender Reperaturwerkstoff an der Kontaktfläche'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "E":
				z = 'Schadhafte Reperatur: überschüssiger Reperaturwerkstoff, der ein Hindernis darstellt'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "P":
				z = 'Schadhafte Reperatur: Loch im Reperaturwerkstoff'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "G":
				z = 'Schadhafte Reperatur: Riss im Reperaturwerkstoff'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "Z":
				z = 'Schadhafte Reperatur: Andere'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAM":
				z = 'Schadhafte Schweissnaht'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAN":
				z = 'Poroeses Rohr'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = 'Boden sichtbar'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = 'Hohlraum sichtbar'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA":
				z = 'Wurzeln'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBB":
				z = 'Anhaftende Stoffe'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBC":
				z = 'Ablagerungen'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBD":
				z = 'Eindringen von Bodenmaterial'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				z = 'Andere Hindernisse'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBF":
				z = 'Infiltration'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBG":
				z = 'Exfiltration'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBH":
				z = 'Ungeziefer'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCA":
				z = 'Anschluss'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "A":
				z = 'Punktuelle Reperatur: Reperatur mit Injektionstechnik'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "B":
				z = 'Punktuelle Reperatur: Reperatur mit Roboter'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "C":
				z = 'Punktuelle Reperatur: Reperatur mit partieller Auskleidungs-/Manchettentechnik'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "D":
				z = 'Punktuelle Reperatur: Zulaufeinbindung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "E":
				z = 'Punktuelle Reperatur: Reperatur Rohrwand manuell'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "F":
				z = 'Punktuelle Reperatur: Reperatur Rohrverbindung manuell'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "G":
				z = 'Punktuelle Reperatur: Ringspalt-/-raumdichtung (der Auskleidung) zum Anschluss an Schacht/Inspektionsöffnung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "H":
				z = 'Punktuelle Reperatur: Zulauföffnung ohne Einbindung (Auskleidung)'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "I":
				z = 'Punktuelle Reperatur: Rohr ausgetauscht'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "Z":
				z = 'Punktuelle Reperatur: sonstige Technink'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCC":
				z = 'Krümmung der Leitung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCD":
				z = 'Anfangsknoten'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCE":
				z = 'Endknoten'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDA":
				z = 'Allgemeines Foto'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AA":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, eingesteckt, gerade'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AB":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, uebergestuelpt, gerade'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AC":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, eingesteckt, abgewinkelt'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AD":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, uebergestuelpt, abgewinkelt'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AE":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, stumpf aneinandergestossen'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "BA":
				z = 'Allgemeine Anmerkung: Verschluss eines Rohrs durch Abmauerung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "BB":
				z = 'Allgemeine Anmerkung: Verschluss eines Rohrs durch Moertel'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "BC":
				z = 'Allgemeine Anmerkung: Verschluss eines Rohrs durch Deckel (Muffenstopfen)'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDC":
				z = 'Inspektion endet vor dem Endknoten'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDD":
				z = 'Wasserspiegel'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDE":
				z = 'Zufluss aus einem Anschluss'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDF":
				z = 'Atmosphäre in der Leitung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDG":
				z = 'Keine Sicht'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			try:
				db.commit()
			except:
				pass
		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		logger.debug(f'Ende_Haltungstexte.liste: {datetime.now()}')

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_haltung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_haltung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HALTUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_haltung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_haltung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def bewertungstexte_leitung(self):
		date = self.date+'%'
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()

		logger.debug(f'Start_Haltungstexte.liste: {datetime.now()}')

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_anschlussleitung_bewertung AS SELECT * FROM untersuchdat_anschlussleitung"""
		curs.execute(sql)

		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass

		if self.datetype == 'Importdatum':

			if leitung is True:

				sql = """
						SELECT
							untersuchdat_anschlussleitung_bewertung.pk,
							untersuchdat_anschlussleitung_bewertung.untersuchleit,
							NULL,
							untersuchdat_anschlussleitung_bewertung.schoben,
							untersuchdat_anschlussleitung_bewertung.schunten,
							untersuchdat_anschlussleitung_bewertung.id,
							untersuchdat_anschlussleitung_bewertung.videozaehler,
							untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
							untersuchdat_anschlussleitung_bewertung.station,
							untersuchdat_anschlussleitung_bewertung.timecode,
							untersuchdat_anschlussleitung_bewertung.kuerzel,
							untersuchdat_anschlussleitung_bewertung.charakt1,
							untersuchdat_anschlussleitung_bewertung.charakt2,
							untersuchdat_anschlussleitung_bewertung.quantnr1,
							untersuchdat_anschlussleitung_bewertung.quantnr2,
							untersuchdat_anschlussleitung_bewertung.streckenschaden,
							untersuchdat_anschlussleitung_bewertung.pos_von,
							untersuchdat_anschlussleitung_bewertung.pos_bis,
							untersuchdat_anschlussleitung_bewertung.foto_dateiname,
							untersuchdat_anschlussleitung_bewertung.film_dateiname,
							untersuchdat_anschlussleitung_bewertung.baujahr,
							untersuchdat_anschlussleitung_bewertung.createdat,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							anschlussleitungen.createdat
						FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
						WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit AND untersuchdat_anschlussleitung_bewertung.createdat like ? 
					"""
				data = (date,)
				curs.execute(sql, data)
		if self.datetype == 'Befahrungsdatum':

			if leitung is True:
				sql = """
						SELECT
							untersuchdat_anschlussleitung_bewertung.pk,
							untersuchdat_anschlussleitung_bewertung.untersuchleit,
							NULL,
							untersuchdat_anschlussleitung_bewertung.schoben,
							untersuchdat_anschlussleitung_bewertung.schunten,
							untersuchdat_anschlussleitung_bewertung.id,
							untersuchdat_anschlussleitung_bewertung.videozaehler,
							untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
							untersuchdat_anschlussleitung_bewertung.station,
							untersuchdat_anschlussleitung_bewertung.timecode,
							untersuchdat_anschlussleitung_bewertung.kuerzel,
							untersuchdat_anschlussleitung_bewertung.charakt1,
							untersuchdat_anschlussleitung_bewertung.charakt2,
							untersuchdat_anschlussleitung_bewertung.quantnr1,
							untersuchdat_anschlussleitung_bewertung.quantnr2,
							untersuchdat_anschlussleitung_bewertung.streckenschaden,
							untersuchdat_anschlussleitung_bewertung.pos_von,
							untersuchdat_anschlussleitung_bewertung.pos_bis,
							untersuchdat_anschlussleitung_bewertung.foto_dateiname,
							untersuchdat_anschlussleitung_bewertung.film_dateiname,
							untersuchdat_anschlussleitung_bewertung.baujahr,
							untersuchdat_anschlussleitung_bewertung.untersuchtag,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							anschlussleitungen.createdat
						FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
						WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit AND untersuchdat_anschlussleitung_bewertung.untersuchtag like ? 
					"""
				data = (date,)
				curs.execute(sql, data)


		for attr in curs.fetchall():
			sql = ""
			data = ()


			# Tab A.2
			if attr[10] == "BAA":
				z = 'Verformung'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			# Tab A.3
			elif attr[10] == "BAB":
				z = 'Rissbildung'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAC":
				z = 'Rohrbruch/Einsturz'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAD":
				z = 'Defektes Mauerwerk'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAE":
				z = 'Fehlender Mörtel'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAF":
				z = 'Oberflächenschäden'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAG":
				z = 'Einragender Anschluss'
				sql = f"""
						UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAH":
				z = 'Schadhafter Anschluss'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass

			elif attr[10] == "BAI":
				z = 'Einragendes Dichtungsmaterial'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Beschreibung = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAJ":
				z = 'Verschobene Verbindung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "A":
				z = 'Feststellung der Innenauskleidung: Innenauskleidung abgelöst'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "B":
				z = 'Feststellung der Innenauskleidung: Innenauskleidung verfärbt'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "C":
				z = 'Feststellung der Innenauskleidung: Endstelle der Auskleidung schadhaft'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "D":
				z = 'Feststellung der Innenauskleidung: Faten in der Auskleidung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "E":
				z = 'Feststellung der Innenauskleidung: Blasen oder Beulen in der Auskleidung nach innen'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "F":
				z = 'Feststellung der Innenauskleidung: Beulen aussen'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "G":
				z = 'Feststellung der Innenauskleidung: Ablösen der Innenhaut/Beschichtung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "H":
				z = 'Feststellung der Innenauskleidung: Ablösen der Abdeckung der Verbindungsnaht'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "I":
				z = 'Feststellung der Innenauskleidung: Riss oder Spalt (einschließlich schadhafter Schweissnaht)'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "J":
				z = 'Feststellung der Innenauskleidung: Loch in der Auskleidung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "K":
				z = 'Feststellung der Innenauskleidung: Auskleidungsverbindung defekt'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "L":
				z = 'Feststellung der Innenauskleidung: Auskleidungswerkstoff erscheint weich'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "M":
				z = 'Feststellung der Innenauskleidung: Harz fehlt im Laminat'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "N":
				z = 'Feststellung der Innenauskleidung: Ende der Auskleidung ist nicht abgedichtet, um das Rohr oder den Schacht aufzunehmen.'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAK" and attr[11] == "Z":
				z = 'Feststellung der Innenauskleidung: Anderer Auskleidungsschaden'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "A":
				z = 'Schadhafte Reperatur: Wand fehlt teilweise'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "B":
				z = 'Schadhafte Reperatur: Reperatur zur Abdichtung eines Lochs ist schadhaft'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "C":
				z = 'Schadhafte Reperatur: Ablösen des Reperaturwerkstofes vom Basisrohr'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "D":
				z = 'Schadhafte Reperatur: fehlender Reperaturwerkstoff an der Kontaktfläche'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "E":
				z = 'Schadhafte Reperatur: überschüssiger Reperaturwerkstoff, der ein Hindernis darstellt'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "P":
				z = 'Schadhafte Reperatur: Loch im Reperaturwerkstoff'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "G":
				z = 'Schadhafte Reperatur: Riss im Reperaturwerkstoff'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAL" and attr[11] == "Z":
				z = 'Schadhafte Reperatur: Andere'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAM":
				z = 'Schadhafte Schweissnaht'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAN":
				z = 'Poroeses Rohr'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = 'Boden sichtbar'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = 'Hohlraum sichtbar'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA":
				z = 'Wurzeln'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBB":
				z = 'Anhaftende Stoffe'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBC":
				z = 'Ablagerungen'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBD":
				z = 'Eindringen von Bodenmaterial'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				z = 'Andere Hindernisse'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBF":
				z = 'Infiltration'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBG":
				z = 'Exfiltration'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBH":
				z = 'Ungeziefer'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCA":
				z = 'Anschluss'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "A":
				z = 'Punktuelle Reperatur: Reperatur mit Injektionstechnik'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "B":
				z = 'Punktuelle Reperatur: Reperatur mit Roboter'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "C":
				z = 'Punktuelle Reperatur: Reperatur mit partieller Auskleidungs-/Manchettentechnik'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "D":
				z = 'Punktuelle Reperatur: Zulaufeinbindung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "E":
				z = 'Punktuelle Reperatur: Reperatur Rohrwand manuell'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "F":
				z = 'Punktuelle Reperatur: Reperatur Rohrverbindung manuell'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "G":
				z = 'Punktuelle Reperatur: Ringspalt-/-raumdichtung (der Auskleidung) zum Anschluss an Schacht/Inspektionsöffnung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "H":
				z = 'Punktuelle Reperatur: Zulauföffnung ohne Einbindung (Auskleidung)'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "I":
				z = 'Punktuelle Reperatur: Rohr ausgetauscht'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCB" and attr[11] == "Z":
				z = 'Punktuelle Reperatur: sonstige Technink'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCC":
				z = 'Krümmung der Leitung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCD":
				z = 'Anfangsknoten'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BCE":
				z = 'Endknoten'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDA":
				z = 'Allgemeines Foto'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AA":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, eingesteckt, gerade'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AB":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, uebergestuelpt, gerade'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AC":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, eingesteckt, abgewinkelt'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AD":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, uebergestuelpt, abgewinkelt'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "AE":
				z = 'Allgemeine Anmerkung: Verbindung zweier Rohre ohne Fomrstück, stumpf aneinandergestossen'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "BA":
				z = 'Allgemeine Anmerkung: Verschluss eines Rohrs durch Abmauerung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "BB":
				z = 'Allgemeine Anmerkung: Verschluss eines Rohrs durch Moertel'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB" and attr[11] == "BC":
				z = 'Allgemeine Anmerkung: Verschluss eines Rohrs durch Deckel (Muffenstopfen)'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDC":
				z = 'Inspektion endet vor dem Endknoten'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDD":
				z = 'Wasserspiegel'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDE":
				z = 'Zufluss aus einem Anschluss'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDF":
				z = 'Atmosphäre in der Leitung'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDG":
				z = 'Keine Sicht'
				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Beschreibung = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#     db.commit()
					continue
				except:
					pass
			try:
				db.commit()
			except:
				pass
		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		logger.debug(f'Ende_Haltungstexte.liste: {datetime.now()}')

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_anschlussleitung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_anschlussleitung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HA_LEITUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_anschlussleitung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_anschlussleitung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)

		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)


	def bewertungstexte_schacht(self):
		date = self.date+'%'
		db = self.db
		data = db
		db = spatialite_connect(data)
		curs = db.cursor()
		db_x = self.db
		crs = self.crs

		logger.debug(f'Start_Schachttexte.liste: {datetime.now()}')

		sql = """CREATE TABLE IF NOT EXISTS Untersuchdat_schacht_bewertung AS SELECT * FROM Untersuchdat_schacht"""
		curs.execute(sql)

		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass

		if self.datetype == 'Importdatum':

			sql = """
				SELECT
					Untersuchdat_schacht_bewertung.pk,
					Untersuchdat_schacht_bewertung.untersuchsch,
					Untersuchdat_schacht_bewertung.id,
					Untersuchdat_schacht_bewertung.videozaehler,
					Untersuchdat_schacht_bewertung.timecode,
					Untersuchdat_schacht_bewertung.kuerzel,
					Untersuchdat_schacht_bewertung.charakt1,
					Untersuchdat_schacht_bewertung.charakt2,
					Untersuchdat_schacht_bewertung.quantnr1,
					Untersuchdat_schacht_bewertung.quantnr2,
					Untersuchdat_schacht_bewertung.streckenschaden,
					Untersuchdat_schacht_bewertung.pos_von,
					Untersuchdat_schacht_bewertung.pos_bis,
					Untersuchdat_schacht_bewertung.bereich,
					Untersuchdat_schacht_bewertung.foto_dateiname,
					Untersuchdat_schacht_bewertung.createdat
				FROM Untersuchdat_schacht_bewertung
				WHERE Untersuchdat_schacht_bewertung.createdat like ? 
			"""
			data = (date,)
			curs.execute(sql, data)

		if self.datetype == 'Befahrungsdatum':
			sql = """
							SELECT
								Untersuchdat_schacht_bewertung.pk,
								Untersuchdat_schacht_bewertung.untersuchsch,
								Untersuchdat_schacht_bewertung.id,
								Untersuchdat_schacht_bewertung.videozaehler,
								Untersuchdat_schacht_bewertung.timecode,
								Untersuchdat_schacht_bewertung.kuerzel,
								Untersuchdat_schacht_bewertung.charakt1,
								Untersuchdat_schacht_bewertung.charakt2,
								Untersuchdat_schacht_bewertung.quantnr1,
								Untersuchdat_schacht_bewertung.quantnr2,
								Untersuchdat_schacht_bewertung.streckenschaden,
								Untersuchdat_schacht_bewertung.pos_von,
								Untersuchdat_schacht_bewertung.pos_bis,
								Untersuchdat_schacht_bewertung.bereich,
								Untersuchdat_schacht_bewertung.foto_dateiname,
								Untersuchdat_schacht_bewertung.untersuchtag
							FROM Untersuchdat_schacht_bewertung
							WHERE Untersuchdat_schacht_bewertung.untersuchtag like ? 
						"""
			data = (date,)
			curs.execute(sql, data)


		for attr in curs.fetchall():


			if attr[5] == "DAA":
				z = 'Verformung'
				sql = f"""
					  UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAB":
				z = 'Rissbildung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAC":
				z = 'Bruch/Einsturz'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAD":
				z = 'Defektes Mauerwerk'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAE":
				z = 'Fehlender Moertel'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAF":
				z = 'Oberflaechenschaden'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAG":
				z = 'Einragender Anschluss'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAH":
				z = 'Schadhafter Anschluss'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAI":
				z = 'Einragendes Dichtungsmaterial'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAJ":
				z = 'Verschobene Verbindung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "A":
				z = 'Feststellung der Innenauskleidung: Innenauskleidung abgeloest'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "B":
				z = 'Feststellung der Innenauskleidung: Innenauskleidung verfaerbt'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "C":
				z = 'Feststellung der Innenauskleidung: Endstelle der Auskleidung schadhaft'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "D":
				z = 'Feststellung der Innenauskleidung: Falten in der Innenauskleidung'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "E":
				z = 'Feststellung der Innenauskleidung: Blasen oder Beulen in der Auskleidung innen'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "F":
				z = 'Feststellung der Innenauskleidung: Beulen aussen'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "G":
				z = 'Feststellung der Innenauskleidung: Abloesen der Innenhaut/Beschichtung'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "H":
				z = 'Feststellung der Innenauskleidung: Abloesen der Abdeckung der Verbindungsnaht'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "I":
				z = 'Feststellung der Innenauskleidung: Riss oder Spalt (einschliesslich schadhafter Schweissnaht)'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "J":
				z = 'Feststellung der Innenauskleidung: Loch in der Auskleidung'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "K":
				z = 'Feststellung der Innenauskleidung: Auskleidungsverbindung defekt'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "L":
				z = 'Feststellung der Innenauskleidung: Auskleidungswerkstoff erscheint weich'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "M":
				z = 'Feststellung der Innenauskleidung: Harz fehlt im Laminat'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "N":
				z = 'Feststellung der Innenauskleidung: Ende der Auskleidung ist nicht abgedichtet, um das Rohr oder den Schacht aufzunehmen'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAK" and attr[6] == "Z":
				z = 'Feststellung der Innenauskleidung: Anderer Auskleidungsschaden'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "A":
				z = 'Schadhafte Reperatur: Wand fehlt teilweise'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "B":
				z = 'Schadhafte Reperatur: Reperatur zur Abdichtung eines Lochs ist schadhaft'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "C":
				z = 'Schadhafte Reperatur: Abloesen des Reperaturwerkstoffs vom Basisrohr'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "D":
				z = 'Schadhafte Reperatur: fehlender Reperaturwerkstoff an der Kontaktflaeche'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "E":
				z = 'Schadhafte Reperatur: ueberschuessiger Reperaturwerkstof, der ein Hindernis darstellt'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "F":
				z = 'Schadhafte Reperatur: Loch im Reperaturwerkstoff'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "G":
				z = 'Schadhafte Reperatur: Riss im Reperaturwerkstoff'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAL" and attr[6] == "Z":
				z = 'Schadhafte Reperatur: Andere'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAM":
				z = 'Schadhafte Schweissnaht'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAN":
				z = 'Poroese Wand'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAO":
				z = 'Boden sichtbar'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAP":
				z = 'Hohlraum sichtbar'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAQ":
				z = 'Schadhafte Steighilfen'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DAR":
				z = 'Schaeden an Abdeckung oder Rahmen'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Beschreibung = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBA":
				z = 'Wurzeln'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBB":
				z = 'Anaftene Stoffe'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBC":
				z = 'Ablagerungen'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBD":
				z = 'Eindringen von Bodenmaterial'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBE":
				z = 'Andere Hindernisse'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Beschreibung = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBF":
				z = 'Infiltration'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBG":
				z = 'Exfiltration'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBH":
				z = 'Ungeziefer'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCA":
				z = 'Anschluss'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "A":
				z = 'Punktuelle Reperatur: Reperatur mit Injektionstechnik'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "B":
				z = 'Punktuelle Reperatur: Reperatur Bauteilwandung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "C":
				z = 'Punktuelle Reperatur: Reperatur Bauteilverbindung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "D":
				z = 'Punktuelle Reperatur: Ringsplat-/-raumabdichtung(Auskleidung in Kanaelen/Leitungen) zum Anschuss an Schacht/Inspektionsoeffnung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "E":
				z = 'Punktuelle Reperatur: Anschlusseinbindung manuell'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "F":
				z = 'Punktuelle Reperatur: Anschlusseoeffnung ohne Einbindung(Auskleidung)'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "G":
				z = 'Punktuelle Reperatur: Schachtbauteil ausgetauscht'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCB" and attr[6] == "Z":
				z = 'Punktuelle Reperatur: Reperatur sonstige Technik'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCG":
				z = 'Anschlussleitung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCH":
				z = 'Auftritt'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCI":
				z = 'Gerinne'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCJ":
				z = 'Sicherheitsketten/-balken'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCK":
				z = 'Abflussregulierung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCL":
				z = 'Rohrdurchfuehrung durch andere Abwasserleitung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCM":
				z = 'Schmutzfaenger unter der Abdeckung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCN":
				z = 'Schlammfang in der Sohle'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCO":
				z = 'Querschnitt'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDA":
				z = 'Allgemeines Foto'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDB":
				z = 'Allgemeine Anmerkung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDC":
				z = 'Inspektion nicht vollstaendig durchgefuehrt'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDD":
				z = 'Wasserspiegel'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ?; 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDE":
				z = 'Zufluss aus einem Anschluss'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDF":
				z = 'Atmosphäre im Schacht oder in der Inspektionsoeffnung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDG":
				z = 'Keine Sicht'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Beschreibung = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass
		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		logger.debug(f'Ende_Schachttexte.liste: {datetime.now()}')

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'Untersuchdat_schacht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		Untersuchdat_schacht_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_SCHAECHTE.value
		vlayer = QgsVectorLayer(uri.uri(), Untersuchdat_schacht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(Untersuchdat_schacht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_schacht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)

		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)


	def bewertung_dwa_neu_haltung(self):
		date = self.date+'%'
		db_x = self.db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung

		data = db_x
		db = spatialite_connect(db_x)
		curs = db.cursor()

		if self.datetype == 'Befahrungsdatum':

			if haltung is True:
				sql = """
							SELECT
								untersuchdat_haltung_bewertung.pk,
								untersuchdat_haltung_bewertung.untersuchhal,
								haltungen.createdat,
								untersuchdat_haltung_bewertung.schoben,
								untersuchdat_haltung_bewertung.schunten,
								untersuchdat_haltung_bewertung.id,
								untersuchdat_haltung_bewertung.videozaehler,
								untersuchdat_haltung_bewertung.inspektionslaenge,
								untersuchdat_haltung_bewertung.station,
								untersuchdat_haltung_bewertung.timecode,
								untersuchdat_haltung_bewertung.kuerzel,
								untersuchdat_haltung_bewertung.charakt1,
								untersuchdat_haltung_bewertung.charakt2,
								untersuchdat_haltung_bewertung.quantnr1,
								untersuchdat_haltung_bewertung.quantnr2,
								untersuchdat_haltung_bewertung.streckenschaden,
								untersuchdat_haltung_bewertung.pos_von,
								untersuchdat_haltung_bewertung.pos_bis,
								untersuchdat_haltung_bewertung.foto_dateiname,
								untersuchdat_haltung_bewertung.film_dateiname,
								untersuchdat_haltung_bewertung.kommentar,
								untersuchdat_haltung_bewertung.bw_bs,
								untersuchdat_haltung_bewertung.untersuchtag,
								haltungen.haltnam,
								haltungen.material,
								haltungen.hoehe
							FROM untersuchdat_haltung_bewertung, haltungen
							WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ? 
						"""
				data = (date,)

				curs.execute(sql, data)

			elif leitung is True:
				sql = """
							SELECT
								untersuchdat_haltung_bewertung.pk,
								untersuchdat_haltung_bewertung.untersuchhal,
								anschlussleitungen.createdat,
								untersuchdat_haltung_bewertung.schoben,
								untersuchdat_haltung_bewertung.schunten,
								untersuchdat_haltung_bewertung.id,
								untersuchdat_haltung_bewertung.videozaehler,
								untersuchdat_haltung_bewertung.inspektionslaenge,
								untersuchdat_haltung_bewertung.station,
								untersuchdat_haltung_bewertung.timecode,
								untersuchdat_haltung_bewertung.kuerzel,
								untersuchdat_haltung_bewertung.charakt1,
								untersuchdat_haltung_bewertung.charakt2,
								untersuchdat_haltung_bewertung.quantnr1,
								untersuchdat_haltung_bewertung.quantnr2,
								untersuchdat_haltung_bewertung.streckenschaden,
								untersuchdat_haltung_bewertung.pos_von,
								untersuchdat_haltung_bewertung.pos_bis,
								untersuchdat_haltung_bewertung.foto_dateiname,
								untersuchdat_haltung_bewertung.film_dateiname,
								untersuchdat_haltung_bewertung.kommentar,
								untersuchdat_haltung_bewertung.bw_bs,
								untersuchdat_haltung_bewertung.untersuchtag,
								anschlussleitungen.leitnam,
								anschlussleitungen.material,
								anschlussleitungen.hoehe
							FROM untersuchdat_haltung_bewertung, anschlussleitungen
							WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ? 
						"""
				data = (date, )

				curs.execute(sql, data)

		if self.datetype == 'Importdatum':

			if haltung is True:
				sql = """
							SELECT
								untersuchdat_haltung_bewertung.pk,
								untersuchdat_haltung_bewertung.untersuchhal,
								haltungen.createdat,
								untersuchdat_haltung_bewertung.schoben,
								untersuchdat_haltung_bewertung.schunten,
								untersuchdat_haltung_bewertung.id,
								untersuchdat_haltung_bewertung.videozaehler,
								untersuchdat_haltung_bewertung.inspektionslaenge,
								untersuchdat_haltung_bewertung.station,
								untersuchdat_haltung_bewertung.timecode,
								untersuchdat_haltung_bewertung.kuerzel,
								untersuchdat_haltung_bewertung.charakt1,
								untersuchdat_haltung_bewertung.charakt2,
								untersuchdat_haltung_bewertung.quantnr1,
								untersuchdat_haltung_bewertung.quantnr2,
								untersuchdat_haltung_bewertung.streckenschaden,
								untersuchdat_haltung_bewertung.pos_von,
								untersuchdat_haltung_bewertung.pos_bis,
								untersuchdat_haltung_bewertung.foto_dateiname,
								untersuchdat_haltung_bewertung.film_dateiname,
								untersuchdat_haltung_bewertung.kommentar,
								untersuchdat_haltung_bewertung.bw_bs,
								untersuchdat_haltung_bewertung.createdat,
								haltungen.haltnam,
								haltungen.material,
								haltungen.hoehe
							FROM untersuchdat_haltung_bewertung, haltungen
							WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ? 
						"""
				data = (date,)

				curs.execute(sql, data)

			elif leitung is True:
				sql = """
							SELECT
								untersuchdat_haltung_bewertung.pk,
								untersuchdat_haltung_bewertung.untersuchhal,
								anschlussleitungen.createdat,
								untersuchdat_haltung_bewertung.schoben,
								untersuchdat_haltung_bewertung.schunten,
								untersuchdat_haltung_bewertung.id,
								untersuchdat_haltung_bewertung.videozaehler,
								untersuchdat_haltung_bewertung.inspektionslaenge,
								untersuchdat_haltung_bewertung.station,
								untersuchdat_haltung_bewertung.timecode,
								untersuchdat_haltung_bewertung.kuerzel,
								untersuchdat_haltung_bewertung.charakt1,
								untersuchdat_haltung_bewertung.charakt2,
								untersuchdat_haltung_bewertung.quantnr1,
								untersuchdat_haltung_bewertung.quantnr2,
								untersuchdat_haltung_bewertung.streckenschaden,
								untersuchdat_haltung_bewertung.pos_von,
								untersuchdat_haltung_bewertung.pos_bis,
								untersuchdat_haltung_bewertung.foto_dateiname,
								untersuchdat_haltung_bewertung.film_dateiname,
								untersuchdat_haltung_bewertung.kommentar,
								untersuchdat_haltung_bewertung.bw_bs,
								untersuchdat_haltung_bewertung.createdat,
								anschlussleitungen.leitnam,
								anschlussleitungen.material,
								anschlussleitungen.hoehe
							FROM untersuchdat_haltung_bewertung, anschlussleitungen
							WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ? 
						"""
				data = (date,)

				curs.execute(sql, data)


		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung 
								SET objektklasse_dichtheit =
								(SELECT min(Zustandsklasse_D) 
								FROM untersuchdat_haltung_bewertung
								WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_D <> '-'
								GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung 
								SET objektklasse_standsicherheit =
								(SELECT min(Zustandsklasse_S) 
								FROM untersuchdat_haltung_bewertung
								WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_S <> '-'
								GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung 
								SET objektklasse_betriebssicherheit =
								(SELECT min(Zustandsklasse_B) 
								FROM untersuchdat_haltung_bewertung
								WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_B <> '-'
								GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung 
								set objektklasse_standsicherheit = '-'
								WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung 
								set objektklasse_dichtheit = '-'
								WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung 
								set objektklasse_betriebssicherheit = '-'
								WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""Update
								haltungen_untersucht_bewertung
								SET
								objektklasse_gesamt =
								(
								   SELECT MIN(wert)
								   FROM (
									   SELECT objektklasse_dichtheit AS wert
									   UNION ALL
									   SELECT objektklasse_standsicherheit
									   UNION ALL
									   SELECT objektklasse_betriebssicherheit
								   )
								   WHERE wert IS NOT NULL
							   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('haltungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_haltung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_haltung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HALTUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_haltung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_haltung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)

		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'haltungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		haltungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HALTUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), haltungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(haltungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def bewertung_dwa_neu_leitung(self):
		date = self.date+'%'
		db_x = self.db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung

		data = db_x
		db = spatialite_connect(db_x)
		curs = db.cursor()

		if self.datetype == 'Befahrungsdatum':

			if leitung is True:
				sql = """
							SELECT
								untersuchdat_anschlussleitung_bewertung.pk,
								untersuchdat_anschlussleitung_bewertung.untersuchleit,
								NULL,
								untersuchdat_anschlussleitung_bewertung.schoben,
								untersuchdat_anschlussleitung_bewertung.schunten,
								untersuchdat_anschlussleitung_bewertung.id,
								untersuchdat_anschlussleitung_bewertung.videozaehler,
								untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
								untersuchdat_anschlussleitung_bewertung.station,
								untersuchdat_anschlussleitung_bewertung.timecode,
								untersuchdat_anschlussleitung_bewertung.kuerzel,
								untersuchdat_anschlussleitung_bewertung.charakt1,
								untersuchdat_anschlussleitung_bewertung.charakt2,
								untersuchdat_anschlussleitung_bewertung.quantnr1,
								untersuchdat_anschlussleitung_bewertung.quantnr2,
								untersuchdat_anschlussleitung_bewertung.streckenschaden,
								untersuchdat_anschlussleitung_bewertung.pos_von,
								untersuchdat_anschlussleitung_bewertung.pos_bis,
								untersuchdat_anschlussleitung_bewertung.foto_dateiname,
								untersuchdat_anschlussleitung_bewertung.film_dateiname,
								untersuchdat_anschlussleitung_bewertung.baujahr,
								untersuchdat_anschlussleitung_bewertung.bw_bs,
								untersuchdat_anschlussleitung_bewertung.untersuchtag,
								anschlussleitungen.leitnam,
								anschlussleitungen.material,
								anschlussleitungen.hoehe,
								anschlussleitungen.createdat
							FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
							WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit AND untersuchdat_anschlussleitung_bewertung.untersuchtag like ? 
						"""
				data = (date, )

				curs.execute(sql, data)

		elif self.datetype == 'Importdatum':
			if leitung is True:
				sql = """
							SELECT
								untersuchdat_anschlussleitung_bewertung.pk,
								untersuchdat_anschlussleitung_bewertung.untersuchleit,
								NULL,
								untersuchdat_anschlussleitung_bewertung.schoben,
								untersuchdat_anschlussleitung_bewertung.schunten,
								untersuchdat_anschlussleitung_bewertung.id,
								untersuchdat_anschlussleitung_bewertung.videozaehler,
								untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
								untersuchdat_anschlussleitung_bewertung.station,
								untersuchdat_anschlussleitung_bewertung.timecode,
								untersuchdat_anschlussleitung_bewertung.kuerzel,
								untersuchdat_anschlussleitung_bewertung.charakt1,
								untersuchdat_anschlussleitung_bewertung.charakt2,
								untersuchdat_anschlussleitung_bewertung.quantnr1,
								untersuchdat_anschlussleitung_bewertung.quantnr2,
								untersuchdat_anschlussleitung_bewertung.streckenschaden,
								untersuchdat_anschlussleitung_bewertung.pos_von,
								untersuchdat_anschlussleitung_bewertung.pos_bis,
								untersuchdat_anschlussleitung_bewertung.foto_dateiname,
								untersuchdat_anschlussleitung_bewertung.film_dateiname,
								untersuchdat_anschlussleitung_bewertung.baujahr,
								untersuchdat_anschlussleitung_bewertung.bw_bs,
								untersuchdat_anschlussleitung_bewertung.createdat,
								anschlussleitungen.leitnam,
								anschlussleitungen.material,
								anschlussleitungen.hoehe,
								anschlussleitungen.createdat
							FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
							WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit AND untersuchdat_anschlussleitung_bewertung.createdat like ? 
						"""
				data = (date,)

				curs.execute(sql, data)


		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung 
								SET objektklasse_dichtheit =
								(SELECT min(Zustandsklasse_D) 
								FROM untersuchdat_anschlussleitung_bewertung
								WHERE untersuchdat_anschlussleitung_bewertung.untersuchleit = anschlussleitungen_untersucht_bewertung.leitnam AND Zustandsklasse_D <> '-'
								GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchleit);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung 
								SET objektklasse_standsicherheit =
								(SELECT min(Zustandsklasse_S) 
								FROM untersuchdat_anschlussleitung_bewertung
								WHERE untersuchdat_anschlussleitung_bewertung.untersuchleit = anschlussleitungen_untersucht_bewertung.leitnam AND Zustandsklasse_S <> '-'
								GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchleit);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung 
								SET objektklasse_betriebssicherheit =
								(SELECT min(Zustandsklasse_B) 
								FROM untersuchdat_anschlussleitung_bewertung
								WHERE untersuchdat_anschlussleitung_bewertung.untersuchleit = anschlussleitungen_untersucht_bewertung.leitnam AND Zustandsklasse_B <> '-'
								GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchleit);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung 
								set objektklasse_standsicherheit = '-'
								WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung 
								set objektklasse_dichtheit = '-'
								WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung 
								set objektklasse_betriebssicherheit = '-'
								WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""Update
								anschlussleitungen_untersucht_bewertung
								SET
								objektklasse_gesamt =
								(
								   SELECT MIN(wert)
								   FROM (
									   SELECT objektklasse_dichtheit AS wert
									   UNION ALL
									   SELECT objektklasse_standsicherheit
									   UNION ALL
									   SELECT objektklasse_betriebssicherheit
								   )
								   WHERE wert IS NOT NULL
							   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('anschlussleitungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_anschlussleitung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_anschlussleitung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HA_LEITUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_anschlussleitung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_anschlussleitung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'anschlussleitungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		anschlussleitungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HA_LEITUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), anschlussleitungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(anschlussleitungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def bewertung_dwa_neu_schaechte(self):
		date = self.date+'%'
		db_x = self.db
		crs = self.crs

		data = db_x
		db = spatialite_connect(db_x)
		curs = db.cursor()

		if self.datetype == 'Befahrungsdatum':

			sql = """
						SELECT
							Untersuchdat_schacht_bewertung.pk,
							Untersuchdat_schacht_bewertung.untersuchsch,
							Untersuchdat_schacht_bewertung.id,
							Untersuchdat_schacht_bewertung.videozaehler,
							Untersuchdat_schacht_bewertung.timecode,
							Untersuchdat_schacht_bewertung.kuerzel,
							Untersuchdat_schacht_bewertung.charakt1,
							Untersuchdat_schacht_bewertung.charakt2,
							Untersuchdat_schacht_bewertung.quantnr1,
							Untersuchdat_schacht_bewertung.quantnr2,
							Untersuchdat_schacht_bewertung.streckenschaden,
							Untersuchdat_schacht_bewertung.pos_von,
							Untersuchdat_schacht_bewertung.pos_bis,
							Untersuchdat_schacht_bewertung.bereich,
							Untersuchdat_schacht_bewertung.foto_dateiname,
							Untersuchdat_schacht_bewertung.bw_bs,
							Untersuchdat_schacht_bewertung.untersuchtag
						FROM Untersuchdat_schacht_bewertung  
						WHERE Untersuchdat_schacht_bewertung.untersuchtag like ? 
					"""
			data = (date,)
			curs.execute(sql, data)

		elif self.datetype == 'Importdatum':
			sql = """
									SELECT
										Untersuchdat_schacht_bewertung.pk,
										Untersuchdat_schacht_bewertung.untersuchsch,
										Untersuchdat_schacht_bewertung.id,
										Untersuchdat_schacht_bewertung.videozaehler,
										Untersuchdat_schacht_bewertung.timecode,
										Untersuchdat_schacht_bewertung.kuerzel,
										Untersuchdat_schacht_bewertung.charakt1,
										Untersuchdat_schacht_bewertung.charakt2,
										Untersuchdat_schacht_bewertung.quantnr1,
										Untersuchdat_schacht_bewertung.quantnr2,
										Untersuchdat_schacht_bewertung.streckenschaden,
										Untersuchdat_schacht_bewertung.pos_von,
										Untersuchdat_schacht_bewertung.pos_bis,
										Untersuchdat_schacht_bewertung.bereich,
										Untersuchdat_schacht_bewertung.foto_dateiname,
										Untersuchdat_schacht_bewertung.bw_bs,
										Untersuchdat_schacht_bewertung.createdat
									FROM Untersuchdat_schacht_bewertung  
									WHERE Untersuchdat_schacht_bewertung.createdat like ? 
								"""
			data = (date,)
			curs.execute(sql, data)


		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_dichtheit =
									(SELECT min(Zustandsklasse_D) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_D <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_standsicherheit =
									(SELECT min(Zustandsklasse_S) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_S <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_betriebssicherheit =
									(SELECT min(Zustandsklasse_B) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_B <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_standsicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_dichtheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_betriebssicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""Update
									schaechte_untersucht_bewertung
									set
									objektklasse_gesamt =
									(
									   SELECT MIN(wert)
									   FROM (
										   SELECT objektklasse_dichtheit AS wert
										   UNION ALL
										   SELECT objektklasse_standsicherheit
										   UNION ALL
										   SELECT objektklasse_betriebssicherheit
									   )
									   WHERE wert IS NOT NULL
								   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('schaechte_untersucht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'Untersuchdat_schacht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		Untersuchdat_schacht_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_SCHAECHTE.value
		vlayer = QgsVectorLayer(uri.uri(), Untersuchdat_schacht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(Untersuchdat_schacht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_schacht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'schaechte_untersucht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		schaechte_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_SCHAECHTE_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), schaechte_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(schaechte_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/schaechte_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def bewertung_dwa_haltung(self):
		date = self.date+'%'
		db_x = self.db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung

		data = db_x

		db1 = spatialite_connect(data)
		curs1 = db1.cursor()

		logger.debug(f'Start_Bewertung_Haltungen.liste: {datetime.now()}')
		# nach DWA

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_haltung_bewertung AS SELECT * FROM untersuchdat_haltung"""
		curs1.execute(sql)

		if haltung is True:
			sql = """
				SELECT
					haltungen.haltnam,
					haltungen.material,
					haltungen.hoehe,
					untersuchdat_haltung_bewertung.untersuchhal
				FROM haltungen
				INNER JOIN untersuchdat_haltung_bewertung  ON haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal
			"""

		if leitung is True:
			sql = """
					SELECT
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe,
						untersuchdat_haltung_bewertung.untersuchhal
					FROM anschlussleitungen
					INNER JOIN untersuchdat_haltung_bewertung ON anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal
				"""

		try:
			curs1.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs1.fetchall():

			untersuchleit = attr1[0]
			try:
				curs1.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass
			else:
				continue
		db1.commit()


		db = spatialite_connect(db_x)
		curs = db.cursor()

		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Zustandsklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Zustandsklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Zustandsklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Zustandsklasse_D = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Zustandsklasse_B = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Zustandsklasse_S = NULL ;""")
		except:
			pass

		db.commit()

		if self.datetype == 'Befahrungsdatum':

			if haltung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						haltungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.untersuchtag, 
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe
					FROM untersuchdat_haltung_bewertung, haltungen
					WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ? 
				"""
				data = (date, )

				curs.execute(sql, data)

			if leitung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						anschlussleitungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.untersuchtag,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe
					FROM untersuchdat_haltung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag , 0, 15 like ? 
				"""
				data = (date, )

				curs.execute(sql, data)

		elif self.datetype == 'Importdatum':

			if haltung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						haltungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.createdat, 
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe
					FROM untersuchdat_haltung_bewertung, haltungen
					WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ? 
				"""
				data = (date,)

				curs.execute(sql, data)

			if leitung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						anschlussleitungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.createdat,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe
					FROM untersuchdat_haltung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat , 0, 15 like ? 
				"""
				data = (date,)

				curs.execute(sql, data)

		logger.debug(f'Start_forloop_Bewertung_Haltungen.liste: {datetime.now()}')

		for attr in curs.fetchall():

			# Tab A.2
			if (attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 7:
					z = '0'
				elif 4 <= attr[13] < 7:
					z = '1'
				elif 3 <= attr[13] < 4:
					z = '2'
				elif 1 <= attr[13] < 3:
					z = '3'
				elif attr[13] < 1:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '0'
				elif 40 <= attr[13] < 50:
					z = '1'
				elif 25 <= attr[13] < 40:
					z = '2'
				elif 10 <= attr[13] < 25:
					z = '3'
				elif attr[13] < 10:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ? 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
					continue
				except:
					pass
			if (attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 15:
					z = '0'
				elif 10 <= attr[13] < 15:
					z = '1'
				elif 6 <= attr[13] < 10:
					z = '2'
				elif 2 <= attr[13] < 6:
					z = '3'
				elif attr[13] < 2:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ? 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '0'
				elif 40 <= attr[13] < 50:
					z = '1'
				elif 25 <= attr[13] < 40:
					z = '2'
				elif 10 <= attr[13] < 25:
					z = '3'
				elif attr[13] < 10:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ? 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
					continue
				except:
					pass

			sql = ""
			data = ()

			# Tab A.3
			if attr[10] == "BAB":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#     db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C"]:
					if attr[12] in ["A","B", "C", "D", "E"]:
						if attr[13] >= 3:
							z = '1'
						elif 3 > attr[13] >= 2:
							z = '2'
						elif attr[13] < 2:
							z = '3'
						else:
							z = '5'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#     db.commit()
						except:
							pass
					if attr[12] == "A" and attr[25] in ["", "NULL", "None", None, "not found"]:
						if attr[13] >= 8:
							z = '0'
						elif 8 > attr[13] >= 5:
							z = '1'
						elif 5 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 1:
							z = '3'
						elif attr[13] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[12] == "A" and attr[25]/1000 <= 0.3:
						if attr[13] >= 3:
							z = '0'
						elif 3 > attr[13] >= 2:
							z = '1'
						elif 2 > attr[13] >= 1:
							z = '2'
						elif 1 > attr[13] >= 0.5:
							z = '3'
						else:
							z = '5'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[12] == "A" and 0.5 >= attr[25]/1000 > 0.3:
						if attr[13] >= 5:
							z = '0'
						elif 5 > attr[13] >= 3:
							z = '1'
						elif 3 > attr[13] >= 2:
							z = '2'
						elif 2 > attr[13] >= 1:
							z = '3'
						elif attr[13] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[12] == "A" and 0.7 >= attr[25]/1000 > 0.5:
						if attr[13] >= 8:
							z = '0'
						elif 8 > attr[13] >= 4:
							z = '1'
						elif 4 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 2:
							z = '3'
						elif attr[13] < 2:
							z = '4'
						else:
							z = '5'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[12] == "B":
						z = '4'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[12] in ["C", "D", "E"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[10] == "BAC":
				if attr[11] == "A":
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAD":
				if attr[11] == "A":
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] == "A":
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] == "B":
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAE":
				if attr[13] >= 100:
					z = '2'
				if attr[13] < 100:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 100:
					z = '1'
				elif 100 > attr[13] > 50:
					z = '2'
				elif 50 > attr[13] > 20:
					z = '3'
				elif attr[13] < 20:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAF":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D", "E","Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "H" and attr[12] in ["B", "C", "D", "E"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "I" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "J" and attr[12] in ["B", "C", "D", "E", "Z"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "K" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_B = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAG":
				if attr[25]/1000 <= 0.25:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 30:
						z = '1'
					elif 30 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
				elif 0.25 < attr[25]/1000 <= 0.5:
					if attr[13] >= 80:
						z = '0'
					elif 80 > attr[13] >= 60:
						z = '1'
					elif 60 > attr[13] >= 40:
						z = '2'
					elif 40 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
				elif 0.5 < attr[25]/1000 <= 0.8:
					if attr[13] >= 70:
						z = '2'
					elif 70 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
				elif attr[25]/1000 > 0.8:
					if attr[13] >= 30:
						z = '3'
					elif attr[13] < 30:
						z = '4'
					else:
						z = '5'
				else:
					z = 'Bitte prüfen!'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAH":
				if attr[11] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "D"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "E":
					z = '-'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = 'Einzelfallbetrachtung'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAI":
				if attr[11] == "A" and attr[12] == "A":
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "A" and attr[12] in ["B", "C", "D"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAJ":
				if attr[11] == "A":
					if attr[25]/1000 <= 0.4:
						if attr[13] >= 70:
							z = '0'
						elif 70 > attr[13] >= 50:
							z = '1'
						elif 50 > attr[13] >= 30:
							z = '2'
						elif 30 > attr[13] >= 20:
							z = '3'
						elif attr[13] < 20:
							z = '4'
						else:
							z = '5'
						sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if 0.4 < attr[25]/1000 <= 0.8:
						if attr[13] >= 80:
							z = '0'
						elif 80 > attr[13] >= 60:
							z = '1'
						elif 60 > attr[13] >= 40:
							z = '2'
						elif 40 > attr[13] >= 20:
							z = '3'
						elif attr[13] < 20:
							z = '4'
						else:
							z = '5'
						sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[25]/1000 > 0.8:
						if attr[13] >= 90:
							z = '0'
						elif 90 > attr[13] >= 65:
							z = '1'
						elif 65 > attr[13] >= 40:
							z = '2'
						elif 40 > attr[13] >= 20:
							z = '3'
						elif attr[13] < 20:
							z = '4'
						else:
							z = '5'
						sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					if attr[13] >= 30:
						z = '0'
					elif 30 > attr[13] >= 20:
						z = '1'
					elif 20 > attr[13] >= 15:
						z = '2'
					elif 15 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					if attr[25]/1000 <= 0.2:
						if attr[13] >= 12:
							z = '0'
						elif 12 > attr[13] >= 9:
							z = '1'
						elif 9 > attr[13] >= 7:
							z = '2'
						elif 7 > attr[13] >= 5:
							z = '3'
						elif attr[13] < 5:
							z = '4'
						else:
							z = '5'
						sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if 0.2 < attr[25]/1000 <= 0.5:
						if attr[13] >= 6:
							z = '0'
						elif 6 > attr[13] >= 4:
							z = '1'
						elif 4 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 2:
							z = '3'
						elif attr[13] < 2:
							z = '4'
						else:
							z = '5'
						sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[25]/1000 > 0.5:
						if attr[13] >= 6:
							z = '0'
						elif 6 > attr[13] >= 4:
							z = '1'
						elif 4 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 1:
							z = '3'
						elif attr[13] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAK":
				if attr[11] == "A":
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '4'
					sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "D"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] == "C":
					z = 'Einzelfallbetrachtung'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "E":
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "F":
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "G":
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "H":
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "I":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "J":
					z = '1'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "K":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "L":
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "M":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "N":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAL":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D"]:
					z = '1'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "B", "C", "D"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D"]:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D"]:
					z = '1'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D"]:
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAM":
				if attr[11] in ["A", "C"]:
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAN":
				z = '2'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_S = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = '1'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_S = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = '1'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '0'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_S = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA" and attr[11] in ["A", "B", "C"]:
				z = '2'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '0'
				elif 30 > attr[13] >= 20:
					z = '1'
				elif 20 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '3'
				else:
					z = '5'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_B = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBB":
				if attr[11] == "A":
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					if attr[13] >= 30:
						z = '0'
					elif 30 > attr[13] >= 20:
						z = '1'
					elif 20 > attr[13] >= 10:
						z = '2'
					elif 10 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "Z"]:
					if attr[13] >= 30:
						z = '0'
					elif 30 > attr[13] >= 20:
						z = '1'
					elif 20 > attr[13] >= 10:
						z = '2'
					elif 10 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBC":
				if attr[11] in ["A", "B"]:
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["C", "Z"]:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 40:
						z = '1'
					elif 40 > attr[13] >= 25:
						z = '2'
					elif 25 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBD" and attr[11] in ["A", "B", "C", "D", "Z"]:
				z = '1'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '0'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_S = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '0'
				elif 30 > attr[13] >= 20:
					z = '1'
				elif 20 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '3'
				else:
					z = '5'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_B = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				if attr[11] in ["D", "G"]:
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "B", "C", "E", "F", "H", "Z"]:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBF":
				if attr[11] == "A":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C"]:
					z = '1'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '1'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBG":
				z = '1'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = 'Einzelfallbetrachtung'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_S = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBH" and attr[11] in ["A", "B", "Z"] and attr[12] in ["A", "B", "C", "Z"]:
				z = '-'
				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_B = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB":
				if attr[11] in ["AA", "AB", "AC", "AD", "AE"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["BA", "BB", "BC"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDD":
				if attr[11] in ["A", "B", "C", "D", "E"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDE":
				if attr[11] in ["A", "C", "D", "E"] and attr[12] == "A":
					z = '1'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "C", "D", "E"] and attr[12] == "B":
					z = '2'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass

			#if für alle übrigen sachen Haltungsanfang ende usw.
			# Zustandsklasse 5 vergeben, damit die gesamte Zustandsklasse für die Haltung 5 ist!
			elif attr[10] in ["BCD", "BCE", "BDC", "BCA", "BCB", "BCC", "BDA", "BDF", "BDG", "BDB", "AEC", "AED"]:
				z = '-'
				sql = f"""
							   UPDATE untersuchdat_haltung_bewertung
							   SET Zustandsklasse_D = ?
							   WHERE untersuchdat_haltung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE untersuchdat_haltung_bewertung
							   SET Zustandsklasse_B = ?
							   WHERE untersuchdat_haltung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE untersuchdat_haltung_bewertung
							   SET Zustandsklasse_S = ?
							   WHERE untersuchdat_haltung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass

			z = 'Bitte pruefen!'
			sql = f"""
				UPDATE untersuchdat_haltung_bewertung
				SET Zustandsklasse_D = ?
				WHERE untersuchdat_haltung_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE untersuchdat_haltung_bewertung
				SET Zustandsklasse_B = ?
				WHERE untersuchdat_haltung_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE untersuchdat_haltung_bewertung
				SET Zustandsklasse_S = ?
				WHERE untersuchdat_haltung_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			z = '5'
			sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_D = ?
					WHERE Zustandsklasse_D is Null;
					"""
			data = (z, )
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_B = ?
					WHERE Zustandsklasse_B is Null;
					"""
			data = (z, )
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Zustandsklasse_S = ?
					WHERE Zustandsklasse_S is Null;
					"""
			data = (z, )
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass

			try:
				db.commit()
			except:
				pass


		sql = """CREATE TABLE IF NOT EXISTS haltungen_untersucht_bewertung AS SELECT * FROM haltungen_untersucht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_dichtheit INTEGER ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_standsicherheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_betriebssicherheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_gesamt INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN hydraulische_auslastung TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN lage_grundwasser TEXT;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN ueberdeckung INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN bodengruppe TEXT ;""")
			#db.commit()
		except:
			pass


		#Objektklasse berechnen für jede Haltung dafür abfragen

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung 
							SET objektklasse_dichtheit =
							(SELECT min(Zustandsklasse_D) 
							FROM untersuchdat_haltung_bewertung
							WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_D <> '-'
							GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung 
							SET objektklasse_standsicherheit =
							(SELECT min(Zustandsklasse_S) 
							FROM untersuchdat_haltung_bewertung
							WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_S <> '-'
							GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung 
							SET objektklasse_betriebssicherheit =
							(SELECT min(Zustandsklasse_B) 
							FROM untersuchdat_haltung_bewertung
							WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_B <> '-'
							GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung 
							set objektklasse_standsicherheit = '-'
							WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung 
							set objektklasse_dichtheit = '-'
							WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung 
							set objektklasse_betriebssicherheit = '-'
							WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""Update
							haltungen_untersucht_bewertung
							SET
							objektklasse_gesamt =
							(
							   SELECT MIN(wert)
							   FROM (
								   SELECT objektklasse_dichtheit AS wert
								   UNION ALL
								   SELECT objektklasse_standsicherheit
								   UNION ALL
								   SELECT objektklasse_betriebssicherheit
							   )
							   WHERE wert IS NOT NULL
						   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('haltungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		logger.debug(f'Ende_Bewertung_Haltungen.liste: {datetime.now()}')

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_haltung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_haltung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HALTUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_haltung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_haltung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)



		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'haltungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		haltungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HALTUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), haltungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(haltungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)


	def bewertung_dwa_leitung(self):
		date = self.date+'%'
		db_x = self.db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung

		data = db_x

		db1 = spatialite_connect(data)
		curs1 = db1.cursor()

		logger.debug(f'Start_Bewertung_Haltungen.liste: {datetime.now()}')
		# nach DWA

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_anschlussleitung_bewertung AS SELECT * FROM untersuchdat_anschlussleitung"""
		curs1.execute(sql)

		if leitung is True:
			sql = """
					SELECT
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe,
						untersuchdat_anschlussleitung_bewertung.untersuchleit
					FROM anschlussleitungen
					INNER JOIN untersuchdat_anschlussleitung_bewertung ON anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit
				"""

		try:
			curs1.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs1.fetchall():

			untersuchleit = attr1[0]
			try:
				curs1.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass
			else:
				continue
		db1.commit()


		db = spatialite_connect(db_x)
		curs = db.cursor()

		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Zustandsklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Zustandsklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Zustandsklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_anschlussleitung_bewertung set Zustandsklasse_D = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_anschlussleitung_bewertung set Zustandsklasse_B = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_anschlussleitung_bewertung set Zustandsklasse_S = NULL ;""")
		except:
			pass

		db.commit()

		if self.datetype == 'Importdatum':

			if leitung is True:
				sql = """
					SELECT
						untersuchdat_anschlussleitung_bewertung.pk,
						untersuchdat_anschlussleitung_bewertung.untersuchhal,
						NULL,
						untersuchdat_anschlussleitung_bewertung.schoben,
						untersuchdat_anschlussleitung_bewertung.schunten,
						untersuchdat_anschlussleitung_bewertung.id,
						untersuchdat_anschlussleitung_bewertung.videozaehler,
						untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
						untersuchdat_anschlussleitung_bewertung.station,
						untersuchdat_anschlussleitung_bewertung.timecode,
						untersuchdat_anschlussleitung_bewertung.kuerzel,
						untersuchdat_anschlussleitung_bewertung.charakt1,
						untersuchdat_anschlussleitung_bewertung.charakt2,
						untersuchdat_anschlussleitung_bewertung.quantnr1,
						untersuchdat_anschlussleitung_bewertung.quantnr2,
						untersuchdat_anschlussleitung_bewertung.streckenschaden,
						untersuchdat_anschlussleitung_bewertung.pos_von,
						untersuchdat_anschlussleitung_bewertung.pos_bis,
						untersuchdat_anschlussleitung_bewertung.foto_dateiname,
						untersuchdat_anschlussleitung_bewertung.film_dateiname,
						untersuchdat_anschlussleitung_bewertung.baujahr,
						untersuchdat_anschlussleitung_bewertung.bw_bs,
						untersuchdat_anschlussleitung_bewertung.createdat,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe,
						anschlussleitungen.createdat
					FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchhal AND untersuchdat_anschlussleitung_bewertung.createdat , 0, 15 like ? 
				"""
				data = (date, )

				curs.execute(sql, data)

		elif self.datetype == 'Befahrungsdatum':

			if leitung is True:
				sql = """
					SELECT
						untersuchdat_anschlussleitung_bewertung.pk,
						untersuchdat_anschlussleitung_bewertung.untersuchhal,
						NULL,
						untersuchdat_anschlussleitung_bewertung.schoben,
						untersuchdat_anschlussleitung_bewertung.schunten,
						untersuchdat_anschlussleitung_bewertung.id,
						untersuchdat_anschlussleitung_bewertung.videozaehler,
						untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
						untersuchdat_anschlussleitung_bewertung.station,
						untersuchdat_anschlussleitung_bewertung.timecode,
						untersuchdat_anschlussleitung_bewertung.kuerzel,
						untersuchdat_anschlussleitung_bewertung.charakt1,
						untersuchdat_anschlussleitung_bewertung.charakt2,
						untersuchdat_anschlussleitung_bewertung.quantnr1,
						untersuchdat_anschlussleitung_bewertung.quantnr2,
						untersuchdat_anschlussleitung_bewertung.streckenschaden,
						untersuchdat_anschlussleitung_bewertung.pos_von,
						untersuchdat_anschlussleitung_bewertung.pos_bis,
						untersuchdat_anschlussleitung_bewertung.foto_dateiname,
						untersuchdat_anschlussleitung_bewertung.film_dateiname,
						untersuchdat_anschlussleitung_bewertung.baujahr,
						untersuchdat_anschlussleitung_bewertung.bw_bs,
						untersuchdat_anschlussleitung_bewertung.untersuchtag,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe,
						anschlussleitungen.createdat
					FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchhal AND untersuchdat_anschlussleitung_bewertung.untersuchtag , 0, 15 like ? 
				"""
				data = (date,)

				curs.execute(sql, data)

		logger.debug(f'Start_forloop_Bewertung_Haltungen.liste: {datetime.now()}')

		for attr in curs.fetchall():


			# Tab A.2
			if (attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 7:
					z = '0'
				elif 4 <= attr[13] < 7:
					z = '1'
				elif 3 <= attr[13] < 4:
					z = '2'
				elif 1 <= attr[13] < 3:
					z = '3'
				elif attr[13] < 1:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '0'
				elif 40 <= attr[13] < 50:
					z = '1'
				elif 25 <= attr[13] < 40:
					z = '2'
				elif 10 <= attr[13] < 25:
					z = '3'
				elif attr[13] < 10:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
					continue
				except:
					pass
			if (attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 15:
					z = '0'
				elif 10 <= attr[13] < 15:
					z = '1'
				elif 6 <= attr[13] < 10:
					z = '2'
				elif 2 <= attr[13] < 6:
					z = '3'
				elif attr[13] < 2:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Zustandsklasse_S = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '0'
				elif 40 <= attr[13] < 50:
					z = '1'
				elif 25 <= attr[13] < 40:
					z = '2'
				elif 10 <= attr[13] < 25:
					z = '3'
				elif attr[13] < 10:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					db.commit()
					continue
				except:
					pass

			sql = ""
			data = ()

			# Tab A.3
			if attr[10] == "BAB":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#     db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C"]:
					if attr[12] in ["A", "B", "C", "D", "E"]:
						if attr[13] >= 3:
							z = '1'
						elif 3 > attr[13] >= 2:
							z = '2'
						elif attr[13] < 2:
							z = '3'
						else:
							z = '5'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_D = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						#     db.commit()
						except:
							pass
					if attr[12] == "A" and ((attr[25] in ["", "NULL", "None", None, "not found"]) or (attr[25] / 1000 > 0.7)):
						if attr[13] >= 8:
							z = '0'
						elif 8 > attr[13] >= 5:
							z = '1'
						elif 5 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 1:
							z = '3'
						elif attr[13] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_S = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[12] == "A" and attr[25] / 1000 <= 0.3:
						if attr[13] >= 3:
							z = '0'
						elif 3 > attr[13] >= 2:
							z = '1'
						elif 2 > attr[13] >= 1:
							z = '2'
						elif 1 > attr[13] >= 0.5:
							z = '3'
						else:
							z = '5'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_S = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[12] == "A" and 0.5 >= attr[25] / 1000 > 0.3:
						if attr[13] >= 5:
							z = '0'
						elif 5 > attr[13] >= 3:
							z = '1'
						elif 3 > attr[13] >= 2:
							z = '2'
						elif 2 > attr[13] >= 1:
							z = '3'
						elif attr[13] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_S = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[12] == "A" and 0.7 >= attr[25] / 1000 > 0.5:
						if attr[13] >= 8:
							z = '0'
						elif 8 > attr[13] >= 4:
							z = '1'
						elif 4 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 2:
							z = '3'
						elif attr[13] < 2:
							z = '4'
						else:
							z = '5'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_S = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[12] == "B":
						z = '4'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_S = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[12] in ["C", "D", "E"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
										  UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_S = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
			elif attr[10] == "BAC":
				if attr[11] == "A":
					z = '1'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '0'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAD":
				if attr[11] == "A":
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] == "A":
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] == "B":
					z = '1'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '0'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '0'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAE":
				if attr[13] >= 100:
					z = '2'
				if attr[13] < 100:
					z = '4'
				else:
					z = '5'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 100:
					z = '1'
				elif 100 > attr[13] > 50:
					z = '2'
				elif 50 > attr[13] > 20:
					z = '3'
				elif attr[13] < 20:
					z = '4'
				else:
					z = '5'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAF":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "E", "Z"]:
					z = '3'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H" and attr[12] in ["B", "C", "D", "E"]:
					z = '1'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J" and attr[12] in ["B", "C", "D", "E", "Z"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
													  UPDATE untersuchdat_haltung_bewertung
														SET Zustandsklasse_B = ?
														WHERE untersuchdat_haltung_bewertung.pk = ?;
														"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAG":
				if attr[25] / 1000 <= 0.25:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 30:
						z = '1'
					elif 30 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
				elif 0.25 < attr[25] / 1000 <= 0.5:
					if attr[13] >= 80:
						z = '0'
					elif 80 > attr[13] >= 60:
						z = '1'
					elif 60 > attr[13] >= 40:
						z = '2'
					elif 40 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
				elif 0.5 < attr[25] / 1000 <= 0.8:
					if attr[13] >= 70:
						z = '2'
					elif 70 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
				elif attr[25] / 1000 > 0.8:
					if attr[13] >= 30:
						z = '3'
					elif attr[13] < 30:
						z = '4'
					else:
						z = '5'
				sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAH":
				if attr[11] == "A":
					z = '3'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "D"]:
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E":
					z = '-'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = 'Einzelfallbetrachtung'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAI":
				if attr[11] == "A" and attr[12] == "A":
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "A" and attr[12] in ["B", "C", "D"]:
					z = '2'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '3'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAJ":
				if attr[11] == "A":
					if attr[25] / 1000 <= 0.4:
						if attr[13] >= 70:
							z = '0'
						elif 70 > attr[13] >= 50:
							z = '1'
						elif 50 > attr[13] >= 30:
							z = '2'
						elif 30 > attr[13] >= 20:
							z = '3'
						elif attr[13] < 20:
							z = '4'
						else:
							z = '5'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if 0.4 < attr[25] / 1000 <= 0.8:
						if attr[13] >= 80:
							z = '0'
						elif 80 > attr[13] >= 60:
							z = '1'
						elif 60 > attr[13] >= 40:
							z = '2'
						elif 40 > attr[13] >= 20:
							z = '3'
						elif attr[13] < 20:
							z = '4'
						else:
							z = '5'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[25] / 1000 > 0.8:
						if attr[13] >= 90:
							z = '0'
						elif 90 > attr[13] >= 65:
							z = '1'
						elif 65 > attr[13] >= 40:
							z = '2'
						elif 40 > attr[13] >= 20:
							z = '3'
						elif attr[13] < 20:
							z = '4'
						else:
							z = '5'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					z = '4'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					if attr[13] >= 30:
						z = '0'
					elif 30 > attr[13] >= 20:
						z = '1'
					elif 20 > attr[13] >= 15:
						z = '2'
					elif 15 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					if attr[25] / 1000 <= 0.2:
						if attr[13] >= 12:
							z = '0'
						elif 12 > attr[13] >= 9:
							z = '1'
						elif 9 > attr[13] >= 7:
							z = '2'
						elif 7 > attr[13] >= 5:
							z = '3'
						elif attr[13] < 5:
							z = '4'
						else:
							z = '5'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if 0.2 < attr[25] / 1000 <= 0.5:
						if attr[13] >= 6:
							z = '0'
						elif 6 > attr[13] >= 4:
							z = '1'
						elif 4 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 2:
							z = '3'
						elif attr[13] < 2:
							z = '4'
						else:
							z = '5'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[25] / 1000 > 0.5:
						if attr[13] >= 6:
							z = '0'
						elif 6 > attr[13] >= 4:
							z = '1'
						elif 4 > attr[13] >= 3:
							z = '2'
						elif 3 > attr[13] >= 1:
							z = '3'
						elif attr[13] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAK":
				if attr[11] == "A":
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '4'
					sql = f"""
													UPDATE untersuchdat_haltung_bewertung
													SET Zustandsklasse_D = ?
													WHERE untersuchdat_haltung_bewertung.pk = ?;
													"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '2'
					sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "D"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] == "C":
					z = 'Einzelfallbetrachtung'
					sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?;
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E":
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F":
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G":
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H":
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J":
					z = '1'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "L":
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
													UPDATE untersuchdat_haltung_bewertung
													SET Zustandsklasse_S = ?
													WHERE untersuchdat_haltung_bewertung.pk = ?;
													"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "M":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "N":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAL":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D"]:
					z = '1'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "B", "C", "D"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D"]:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D"]:
					z = '1'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D"]:
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAM":
				if attr[11] in ["A", "C"]:
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAN":
				z = '2'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = '1'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = '1'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '0'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA" and attr[11] in ["A", "B", "C"]:
				z = '2'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '0'
				elif 30 > attr[13] >= 20:
					z = '1'
				elif 20 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '3'
				else:
					z = '5'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBB":
				if attr[11] == "A":
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 30:
						z = '0'
					elif 30 > attr[13] >= 20:
						z = '1'
					elif 20 > attr[13] >= 10:
						z = '2'
					elif 10 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "Z"]:
					if attr[13] >= 30:
						z = '0'
					elif 30 > attr[13] >= 20:
						z = '1'
					elif 20 > attr[13] >= 10:
						z = '2'
					elif 10 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBC":
				if attr[11] in ["A", "B"]:
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["C", "Z"]:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 40:
						z = '1'
					elif 40 > attr[13] >= 25:
						z = '2'
					elif 25 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBD" and attr[11] in ["A", "B", "C", "D", "Z"]:
				z = '1'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '0'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '0'
				elif 30 > attr[13] >= 20:
					z = '1'
				elif 20 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '3'
				else:
					z = '5'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				if attr[11] in ["D", "G"]:
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "B", "C", "E", "F", "H", "Z"]:
					if attr[13] >= 50:
						z = '0'
					elif 50 > attr[13] >= 35:
						z = '1'
					elif 35 > attr[13] >= 20:
						z = '2'
					elif 20 > attr[13] >= 5:
						z = '3'
					elif attr[13] < 5:
						z = '4'
					else:
						z = '5'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBF":
				if attr[11] == "A":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C"]:
					z = '1'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '1'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '3'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBG":
				z = '1'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = 'Einzelfallbetrachtung'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBH" and attr[11] in ["A", "B", "Z"] and attr[12] in ["A", "B", "C", "Z"]:
				z = '-'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?;
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB":
				if attr[11] in ["AA", "AB", "AC", "AD", "AE"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
													UPDATE untersuchdat_haltung_bewertung
													SET Zustandsklasse_D = ?
													WHERE untersuchdat_haltung_bewertung.pk = ?;
													"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["BA", "BB", "BC"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
											UPDATE untersuchdat_haltung_bewertung
											SET Zustandsklasse_D = ?
											WHERE untersuchdat_haltung_bewertung.pk = ?;
											"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDD":
				if attr[11] in ["A", "B", "C", "D", "E"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDE":
				if attr[11] in ["A", "C", "D", "E"] and attr[12] == "A":
					z = '1'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "C", "D", "E"] and attr[12] == "B":
					z = '2'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?;
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			#if für alle übrigen sachen Haltungsanfang ende usw.
			elif attr[10] in ["BCD", "BCE", "BDC", "BCA", "BCB", "BCC", "BDA", "BDF", "BDG", "BDB", "AEC", "AED"]:
				z = '-'
				sql = f"""
							   UPDATE untersuchdat_anschlussleitung_bewertung
							   SET Zustandsklasse_D = ?
							   WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE untersuchdat_anschlussleitung_bewertung
							   SET Zustandsklasse_B = ?
							   WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE untersuchdat_anschlussleitung_bewertung
							   SET Zustandsklasse_S = ?
							   WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass

			z = 'Bitte pruefen!'
			sql = f"""
				UPDATE untersuchdat_anschlussleitung_bewertung
				SET Zustandsklasse_D = ?
				WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE untersuchdat_anschlussleitung_bewertung
				SET Zustandsklasse_B = ?
				WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE untersuchdat_anschlussleitung_bewertung
				SET Zustandsklasse_S = ?
				WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			z = '5'
			sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Zustandsklasse_D = ?
					WHERE Zustandsklasse_D is Null;
					"""
			data = (z, )
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Zustandsklasse_B = ?
					WHERE Zustandsklasse_B is Null;
					"""
			data = (z, )
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Zustandsklasse_S = ?
					WHERE Zustandsklasse_S is Null;
					"""
			data = (z, )
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass

			try:
				db.commit()
			except:
				pass


		sql = """CREATE TABLE IF NOT EXISTS anschlussleitungen_untersucht_bewertung AS SELECT * FROM haltungen_untersucht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_dichtheit INTEGER ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_standsicherheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_betriebssicherheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_gesamt INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN hydraulische_auslastung TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN lage_grundwasser TEXT;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN ueberdeckung INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN bodengruppe TEXT ;""")
			#db.commit()
		except:
			pass


		#Objektklasse berechnen für jede Haltung dafür abfragen

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung 
							SET objektklasse_dichtheit =
							(SELECT min(Zustandsklasse_D) 
							FROM untersuchdat_anschlussleitung_bewertung
							WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = anschlussleitungen_untersucht_bewertung.leitnam AND Zustandsklasse_D <> '-'
							GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung 
							SET objektklasse_standsicherheit =
							(SELECT min(Zustandsklasse_S) 
							FROM untersuchdat_anschlussleitung_bewertung
							WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = anschlussleitungen_untersucht_bewertung.leitnam AND Zustandsklasse_S <> '-'
							GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung 
							SET objektklasse_betriebssicherheit =
							(SELECT min(Zustandsklasse_B) 
							FROM untersuchdat_anschlussleitung_bewertung
							WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = anschlussleitungen_untersucht_bewertung.leitnam AND Zustandsklasse_B <> '-'
							GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchhal);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung 
							set objektklasse_standsicherheit = '-'
							WHERE objektklasse_standsicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung 
							set objektklasse_dichtheit = '-'
							WHERE objektklasse_dichtheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung 
							set objektklasse_betriebssicherheit = '-'
							WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""Update
							anschlussleitungen_untersucht_bewertung
							SET
							objektklasse_gesamt =
							(
							   SELECT MIN(wert)
							   FROM (
								   SELECT objektklasse_dichtheit AS wert
								   UNION ALL
								   SELECT objektklasse_standsicherheit
								   UNION ALL
								   SELECT objektklasse_betriebssicherheit
							   )
							   WHERE wert IS NOT NULL
						   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('anschlussleitungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		logger.debug(f'Ende_Bewertung_Haltungen.liste: {datetime.now()}')

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_anschlussleitung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_anschlussleitung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HA_LEITUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_anschlussleitung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_anschlussleitung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)



		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'anschlussleitungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		anschlussleitungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HA_LEITUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), anschlussleitungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(anschlussleitungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)


	def bewertung_dwa_schacht(self):
		date = self.date+'%'
		db = self.db
		crs = self.crs
		db_x = db

		data = db
		db1 = spatialite_connect(data)
		curs1 = db1.cursor()
		# nach DWA

		logger.debug(f'Start_Bewertung_Schaechte.liste: {datetime.now()}')

		sql = """CREATE TABLE IF NOT EXISTS Untersuchdat_schacht_bewertung AS SELECT * FROM Untersuchdat_schacht"""
		curs1.execute(sql)

		sql = """
			SELECT
				schaechte.schnam,
				schaechte.material,
				Untersuchdat_schacht_bewertung.untersuchsch
			FROM schaechte
				INNER JOIN Untersuchdat_schacht_bewertung  ON schaechte.schnam = Untersuchdat_schacht_bewertung.untersuchsch
		"""

		try:
			curs1.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)


		for attr1 in curs1.fetchall():
			try:
				curs1.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET bw_bs = ?
						WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE Untersuchdat_schacht_bewertung
						SET bw_bs = ?
						WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass
		db1.commit()

		db = spatialite_connect(db_x)
		curs = db.cursor()

		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Zustandsklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Zustandsklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Zustandsklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""update Untersuchdat_schacht_bewertung set Zustandsklasse_D = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update Untersuchdat_schacht_bewertung set Zustandsklasse_B = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update Untersuchdat_schacht_bewertung set Zustandsklasse_S = NULL ;""")
		except:
			pass

		db.commit()

		if self.datetype == 'Importdatum':

			sql = """
				SELECT
					Untersuchdat_schacht_bewertung.pk,
					Untersuchdat_schacht_bewertung.untersuchsch,
					Untersuchdat_schacht_bewertung.id,
					Untersuchdat_schacht_bewertung.videozaehler,
					Untersuchdat_schacht_bewertung.timecode,
					Untersuchdat_schacht_bewertung.kuerzel,
					Untersuchdat_schacht_bewertung.charakt1,
					Untersuchdat_schacht_bewertung.charakt2,
					Untersuchdat_schacht_bewertung.quantnr1,
					Untersuchdat_schacht_bewertung.quantnr2,
					Untersuchdat_schacht_bewertung.streckenschaden,
					Untersuchdat_schacht_bewertung.pos_von,
					Untersuchdat_schacht_bewertung.pos_bis,
					Untersuchdat_schacht_bewertung.bereich,
					Untersuchdat_schacht_bewertung.foto_dateiname,
					Untersuchdat_schacht_bewertung.bw_bs,
					Untersuchdat_schacht_bewertung.createdat
				FROM Untersuchdat_schacht_bewertung  
				WHERE Untersuchdat_schacht_bewertung.createdat like ?  
			"""
			data = (date,)
			curs.execute(sql, data)

		elif self.datetype == 'Befahrungsdatum':

			sql = """
				SELECT
					Untersuchdat_schacht_bewertung.pk,
					Untersuchdat_schacht_bewertung.untersuchsch,
					Untersuchdat_schacht_bewertung.id,
					Untersuchdat_schacht_bewertung.videozaehler,
					Untersuchdat_schacht_bewertung.timecode,
					Untersuchdat_schacht_bewertung.kuerzel,
					Untersuchdat_schacht_bewertung.charakt1,
					Untersuchdat_schacht_bewertung.charakt2,
					Untersuchdat_schacht_bewertung.quantnr1,
					Untersuchdat_schacht_bewertung.quantnr2,
					Untersuchdat_schacht_bewertung.streckenschaden,
					Untersuchdat_schacht_bewertung.pos_von,
					Untersuchdat_schacht_bewertung.pos_bis,
					Untersuchdat_schacht_bewertung.bereich,
					Untersuchdat_schacht_bewertung.foto_dateiname,
					Untersuchdat_schacht_bewertung.bw_bs,
					Untersuchdat_schacht_bewertung.untersuchtag
				FROM Untersuchdat_schacht_bewertung  
				WHERE Untersuchdat_schacht_bewertung.untersuchtag like ?  
			"""
			data = (date,)
			curs.execute(sql, data)


		for attr in curs.fetchall():

			if attr[5] == "DAA" and attr[6] in ["A", "B"]:
				if attr[8] >= 40:
					z = '0'
				elif 40 > attr[8] >= 30:
					z = '1'
				elif 30 > attr[8] >= 20:
					z = '2'
				elif 20 > attr[8] >= 10:
					z = '3'
				elif attr[8] < 10:
					z = '4'
				else:
					z = '5'
				sql = f"""
					  UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '5'
				sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_D = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass

				if attr[13] in ["B", "C", "D", "F"] and attr[15] == "biegesteif":
					if attr[8] >= 7:
						z = '0'
					elif 7 > attr[8] >= 4:
						z = '1'
					elif 4 > attr[8] >= 3:
						z = '2'
					elif 3 > attr[8] >= 1:
						z = '3'
					elif attr[8] < 1:
						z = '4'
					else:
						z = '5'
					sql = f"""
					  UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_S = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[13] in ["B", "C", "D", "F"] and attr[15] == "biegeweich":
					z = 'Einzelfallbetrachtung'
					sql = f"""
					  UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_S = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass

			elif attr[5] == "DAB":
				if attr[6] == "A":
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["B", "C", "D", "F", "H", "I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass

				elif attr[6] in ["B", "C"]:
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["C", "D", "E", "F"]:
						z = '5'
						sql = f"""
									UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["I", "J"]:
						if attr[8] >= 3:
							z = '1'
						elif 3 > attr[8] >= 2:
							z = '2'
						elif 2 > attr[8]:
							z = '3'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[7] == "A" and attr[13] in ["B", "C", "D", "F"]:
						if attr[8] >= 8:
							z = '0'
						elif 8 > attr[8] >= 5:
							z = '1'
						elif 5 > attr[8] >= 3:
							z = '2'
						elif 3 > attr[8] >= 1:
							z = '3'
						elif attr[8] < 1:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[7] == "B" and attr[13] in ["B", "C", "D", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[7] in ["C", "D", "E"] and attr[13] in ["B", "C", "D", "F"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAC":
				if attr[6] == "A":
					if attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "F", "H"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B":
					if attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "F", "H"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["I", "J"]:
						z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ?; 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ; 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "F", "H"]:
						z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ?; 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAD":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ?; 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B" and attr[7] == "A":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B" and attr[7] == "B":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F", "H", "I", "J"]:
						z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAE":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					if attr[8] >= 100:
						z = '3'
					elif attr[8] < 100:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					if attr[8] >= 100:
						z = '2'
					elif attr[8] < 100:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["C", "D", "F"]:
					if attr[8] >= 100:
						z = '2'
					elif 100 > attr[8] >= 10:
						z = '3'
					elif attr[8] < 10:
						z = '4'
					else:
						z = '5'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAF":
				if attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "B" and attr[7] in ["A", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
				elif attr[6] == "D" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "E" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "G" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "H" and attr[7] in ["B", "C", "D", "E"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "I" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F", "H"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "J" and attr[7] in ["B", "C", "D", "E"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
											UPDATE Untersuchdat_schacht_bewertung
												SET Zustandsklasse_B = ?
												WHERE Untersuchdat_schacht_bewertung.pk = ? ;
												"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "K" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "Z" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F", "H"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAG":
				if attr[6] in ["", "NULL", "None", None, "not found"] and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						if attr[8] >= 400:
							z = '0'
						elif 400 > attr[8] >= 300:
							z = '1'
						elif 300 > attr[8] >= 200:
							z = '2'
						elif 200 > attr[8] >= 100:
							z = '3'
						elif attr[8] < 100:
							z = '4'
						else:
							z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_B = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ?; 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_B = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAH":
				if attr[6] in ["B", "C", "D"] and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "E" and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAI":
				if attr[6] == "A" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							#curs.execute(sql, data)
							db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z":
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAJ" and attr[6] in ["A", "B", "C"]:
				if attr[13] in ["C", "D", "E", "F"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["B", "C", "D", "F"]:
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAK":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						if attr[8] >= 40:
							z = '0'
						elif 40 > attr[8] >= 30:
							z = '1'
						elif 30 > attr[8] >= 20:
							z = '2'
						elif 20 > attr[8] >= 10:
							z = '3'
						elif attr[8] < 10:
							z = '4'
						else:
							z = '5'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_B = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '0'
						elif 50 > attr[8] >= 35:
							z = '1'
						elif 35 > attr[8] >= 20:
							z = '2'
						elif 20 > attr[8] >= 5:
							z = '3'
						elif attr[8] < 5:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "B" and attr[13] in ["C", "D", "E", "F", "I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ?; 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_B = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "D":
					if attr[7] in ["A", "B", "C", "D"] and attr[13] in ["I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[7] == "C" and attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "E":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						if attr[8] >= 40:
							z = '0'
						elif 40 > attr[8] >= 30:
							z = '1'
						elif 30 > attr[8] >= 20:
							z = '2'
						elif 20 > attr[8] >= 10:
							z = '3'
						elif attr[8] < 10:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '0'
						elif 50 > attr[8] >= 35:
							z = '1'
						elif 35 > attr[8] >= 20:
							z = '2'
						elif 20 > attr[8] >= 5:
							z = '3'
						elif attr[8] < 5:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F" and attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "G" and attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ?; 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "H" and attr[13] in ["I", "J"]:
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "I":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "J":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "K":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "L":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "M":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "N" and attr[13] in ["C", "D", "E", "F", "I", "J"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "Z":
					if attr[13] in ["C", "D", "E", "F", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ?; 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAL":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "I", "J"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "D":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "E":
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H"]:
						if attr[8] >= 40:
							z = '0'
						elif 40 > attr[8] >= 30:
							z = '1'
						elif 30 > attr[8] >= 20:
							z = '2'
						elif 20 > attr[8] >= 10:
							z = '3'
						elif attr[8] < 10:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '0'
						elif 50 > attr[8] >= 35:
							z = '1'
						elif 35 > attr[8] >= 20:
							z = '2'
						elif 20 > attr[8] >= 5:
							z = '3'
						elif attr[8] < 5:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "G":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z":
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAM":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '4'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = 'Einzelfallbetrachtung'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? ;
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAN":
				if attr[13] in ["C", "D", "E", "F"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAO":
				if attr[13] in ["C", "D", "E", "F"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ?; 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAP":
				if attr[13] in ["C", "D", "E", "F"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAQ":
				if attr[6] in ["A", "C", "D", "F", "G", "H", "I", "J", "K"] and attr[13] in ["C", "D", "F"]:
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[6] == "B") and attr[13] in ["C", "D", "F"]:
					z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[6] == "E") and attr[13] in ["C", "D", "F"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[6] == "Z") and attr[13] in ["C", "D", "F"]:
					z = 'Einzelfallbetrachtung'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAR":
				if attr[6] in ["A", "C", "F"] and (attr[13] == "A"):
					z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] in ["B", "E"] and (attr[13] == "A"):
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[6] == "D") and (attr[13] == "A"):
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] in ["G", "H"] and (attr[13] == "A"):
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[6] == "Z") and (attr[13] == "A"):
					z = 'Einzelfallbetrachtung'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBA":
				if attr[6] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? ;
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBB":
				if attr[6] == "A":
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[6] in ["A", "B", "C", "Z"]:
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBC":
				if attr[6] in ["C", "Z"]:
					if attr[13] == "J":
						if attr[8] >= 300:
							z = '1'
						elif 300 > attr[8] >= 100:
							z = '2'
						elif 100 > attr[8] >= 50:
							z = '3'
						elif attr[8] < 50:
							z = '4'
						else:
							z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] == "H":
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DBD":
				if attr[13] in ["C", "D", "E", "F"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = 'Einzelfallbetrachtung'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBE":
				if attr[6] in ["A", "B", "C"] and attr[13] in ["I", "J"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "D":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] in ["E", "F", "H", "Z"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "G":
					if attr[13] in ["C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBF":
				if attr[6] == "A" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] in ["B", "C"] and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "D" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? ;
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBG" and attr[13] in ["I", "J"]:
				z = '1'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_D = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = 'Einzelfallbetrachtung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_S = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DBH" and attr[6] in ["A", "B", "Z"] and attr[7] in ["A", "B", "C", "Z"]:
				z = '-'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCH" and (attr[6] == "A") and (attr[13] == "H"):
				z = 'Einzelfallbetrachtung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCI":
				if (attr[6] == "A") and attr[7] in ["A", "B", "C", "D"] and (attr[13] == "I"):
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[6] == "C") and (attr[7] == "Y") and (attr[13] == "I"):
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DCJ":
				if attr[6] in ["B", "F"] and (attr[13] == "F"):
					z = '0'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				elif attr[6] in ["C", "D", "G", "H"] and (attr[13] == "F"):
					z = 'Einzelfallbetrachtung'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?; 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DCL" and attr[6] in ["A", "B", "C"] and attr[7] == "A" and (
					attr[13] == "F"):
				z = 'Einzelfallbetrachtung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCM" and attr[6] in ["B", "C"] and (attr[13] == "A"):
				z = '3'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCN" and (attr[6] == "B") and (attr[13] == "J"):
				z = 'Einzelfallbetrachtung'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? ;
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDE" and attr[6] in ["A", "C", "D", "E"]:
				if attr[7] == "A":
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[7] == "B":
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? ;
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass

			# if für alle übrigen sachen Haltungsanfang ende usw.
			elif attr[5] in ["CED", "DCA", "DCB", "DCG", "DCK", "DCO", "DDA", "DDB", "DDC", "DDD", "DDF", "DDG"]:
				z = '-'
				sql = f"""
							   UPDATE Untersuchdat_schacht_bewertung
							   SET Zustandsklasse_D = ?
							   WHERE Untersuchdat_schacht_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE Untersuchdat_schacht_bewertung
							   SET Zustandsklasse_B = ?
							   WHERE Untersuchdat_schacht_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE Untersuchdat_schacht_bewertung
							   SET Zustandsklasse_S = ?
							   WHERE Untersuchdat_schacht_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass

			z = 'Bitte prüfen!'
			sql = f"""
				UPDATE Untersuchdat_schacht_bewertung
				SET Zustandsklasse_D = ?
				WHERE Untersuchdat_schacht_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE Untersuchdat_schacht_bewertung
				SET Zustandsklasse_B = ?
				WHERE Untersuchdat_schacht_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE Untersuchdat_schacht_bewertung
				SET Zustandsklasse_S = ?
				WHERE Untersuchdat_schacht_bewertung.pk = ?;
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			z = '5'
			sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_D = ?
					WHERE Zustandsklasse_D is Null;
					"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Zustandsklasse_B is Null;
					"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_S = ?
					WHERE Zustandsklasse_S is Null;
					"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass

			try:
				db.commit()
			except:
				pass



		sql = """CREATE TABLE IF NOT EXISTS schaechte_untersucht_bewertung AS SELECT * FROM schaechte_untersucht"""
		curs.execute(sql)
		#db.commit()

		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_dichtheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_standsicherheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_betriebssicherheit INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_gesamt INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN hydraulische_auslastung TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN lage_grundwasser TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN ueberdeckung INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN bodengruppe TEXT ;""")
			#db.commit()
		except:
			pass


		# objektklasse berechnen für jede Schacht dafür abfragen

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_dichtheit =
									(SELECT min(Zustandsklasse_D) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_D <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_standsicherheit =
									(SELECT min(Zustandsklasse_S) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_S <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_betriebssicherheit =
									(SELECT min(Zustandsklasse_B) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_B <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_standsicherheit = '-'
									WHERE objektklasse_standsicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_dichtheit = '-'
									WHERE objektklasse_dichtheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_betriebssicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
			#db.commit()
		except:
			pass

		try:
			curs.execute("""Update
									schaechte_untersucht_bewertung
									set
									objektklasse_gesamt =
									(
									   SELECT MIN(wert)
									   FROM (
										   SELECT objektklasse_dichtheit AS wert
										   UNION ALL
										   SELECT objektklasse_standsicherheit
										   UNION ALL
										   SELECT objektklasse_betriebssicherheit
									   )
									   WHERE wert IS NOT NULL
								   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('schaechte_untersucht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'Untersuchdat_schacht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		Untersuchdat_schacht_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_SCHAECHTE.value
		vlayer = QgsVectorLayer(uri.uri(), Untersuchdat_schacht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(Untersuchdat_schacht_bewertung)[0].id())
		except:
			pass

		logger.debug(f'Ende_Bewertung_Schaechte.liste: {datetime.now()}')

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_schacht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'schaechte_untersucht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		schaechte_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_SCHAECHTE_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), schaechte_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(schaechte_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/schaechte_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)


	def bewertung_isy_haltung(self):
		date = self.date+'%'
		db = self.db
		db_x = db
		data = db
		leitung = self.leitung
		haltung = self.haltung
		crs = self.crs

		db1 = spatialite_connect(data)
		curs1 = db1.cursor()

		# nach Isybau

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_haltung_bewertung AS SELECT * FROM untersuchdat_haltung"""
		curs1.execute(sql)

		if haltung is True:
			sql = """
				SELECT
					haltungen.haltnam,
					haltungen.material,
					haltungen.hoehe,
					untersuchdat_haltung_bewertung.untersuchhal
				FROM haltungen
				INNER JOIN untersuchdat_haltung_bewertung  ON haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal
			"""

		if leitung is True:
			sql = """
				SELECT
					anschlussleitungen.leitnam,
					anschlussleitungen.material,
					anschlussleitungen.hoehe,
					untersuchdat_haltung_bewertung.untersuchhal
				FROM anschlussleitungen
				INNER JOIN untersuchdat_haltung_bewertung  ON anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal
			"""

		try:
			curs1.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs1.fetchall():
			untersuchhalt = attr1[0]
			try:
				curs1.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass
		db1.commit()

		data = db
		db = spatialite_connect(data)
		curs = db.cursor()

		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Schadensklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Schadensklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Schadensklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Schadensklasse_D = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Schadensklasse_S = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Schadensklasse_B = NULL ;""")
		except:
			pass

		db.commit()

		if self.datetype == 'Importdatum':

			if haltung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						haltungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.createdat,
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe
					FROM untersuchdat_haltung_bewertung, Haltungen
					WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ?
				"""
				data = (date, )
				curs.execute(sql, data)

			elif leitung is True:
				sql = """
				
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						anschlussleitungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						NULL,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.createdat,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe
					FROM untersuchdat_haltung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.createdat like ? 
				"""
				data = (date, )
				curs.execute(sql, data)

		elif self.datetype == 'Befahrungsdatum':

			if haltung is True:
				sql = """
					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						haltungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						untersuchdat_haltung_bewertung.kommentar,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.untersuchtag,
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe
					FROM untersuchdat_haltung_bewertung, Haltungen
					WHERE haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ?
				"""
				data = (date,)
				curs.execute(sql, data)

			elif leitung is True:
				sql = """

					SELECT
						untersuchdat_haltung_bewertung.pk,
						untersuchdat_haltung_bewertung.untersuchhal,
						anschlussleitungen.createdat,
						untersuchdat_haltung_bewertung.schoben,
						untersuchdat_haltung_bewertung.schunten,
						untersuchdat_haltung_bewertung.id,
						untersuchdat_haltung_bewertung.videozaehler,
						untersuchdat_haltung_bewertung.inspektionslaenge,
						untersuchdat_haltung_bewertung.station,
						untersuchdat_haltung_bewertung.timecode,
						untersuchdat_haltung_bewertung.kuerzel,
						untersuchdat_haltung_bewertung.charakt1,
						untersuchdat_haltung_bewertung.charakt2,
						untersuchdat_haltung_bewertung.quantnr1,
						untersuchdat_haltung_bewertung.quantnr2,
						untersuchdat_haltung_bewertung.streckenschaden,
						untersuchdat_haltung_bewertung.pos_von,
						untersuchdat_haltung_bewertung.pos_bis,
						untersuchdat_haltung_bewertung.foto_dateiname,
						untersuchdat_haltung_bewertung.film_dateiname,
						NULL,
						untersuchdat_haltung_bewertung.bw_bs,
						untersuchdat_haltung_bewertung.untersuchtag,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe
					FROM untersuchdat_haltung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal AND untersuchdat_haltung_bewertung.untersuchtag like ? 
				"""
				data = (date,)
				curs.execute(sql, data)


		for attr in curs.fetchall():

			if (attr[21] == "biegesteif" and attr[10] == "BAA" and (attr[11] == "A")) or (
					attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] < 6:
					z = '3'
				elif 6 <= attr[13] < 15:
					z = '4'
				elif attr[13] >= 15:
					z = '5'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '5'
				elif 40 <= attr[13] < 50:
					z = '4'
				elif 25 <= attr[13] < 40:
					z = '3'
				elif 10 <= attr[13] < 25:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ? 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif (attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 15:
					z = '5'
				elif 10 <= attr[13] < 15:
					z = '4'
				elif 6 <= attr[13] < 10:
					z = '3'
				elif 2 <= attr[13] < 6:
					z = '2'
				elif attr[13] < 2:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ? 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
				if attr[13] >= 50:
					z = '5'
				elif 40 <= attr[13] < 50:
					z = '4'
				elif 25 <= attr[13] < 40:
					z = '3'
				elif 10 <= attr[13] < 25:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ? 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass

			# Tab A.3
			elif attr[10] == "BAB":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[11] == "B") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] in ["A", "C", "D", "E"]:
					if attr[13] >= 10:
						z = '5'
					elif 10 > attr[13] >= 5:
						z = '4'
					elif 5 > attr[13] >= 2:
						z = '3'
					elif 2 > attr[13] >= 0.5:
						z = '2'
					else:
						z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] == "B":
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[11] == "C") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[10] == "BAC":
				if attr[11] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[11] in ["A", "B"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[11] == "C":
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAD":
				if attr[11] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "B"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass

			elif attr[10] == "BAE":
				if attr[13] >= 100:
					z = '3'
				elif attr[13] < 100:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 100:
					z = '3'
				elif 100 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAF":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "H" and attr[12] in ["B", "C", "D", "E"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "I" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "J" and attr[12] in ["B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "K" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAG":
				if attr[13] >= 75:
					z = '5'
				elif 75 > attr[13] >= 60:
					z = '4'
				elif 60 > attr[13] >= 40:
					z = '3'
				elif 40 > attr[13] >= 15:
					z = '2'
				elif attr[13] < 15:
					z = '1'
				else:
					z = '0'
				sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAH":
				if attr[11] in ["A"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "D"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAI":
				if attr[11] == "A" and attr[12] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "A" and attr[12] in ["B", "C", "D"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAJ":
				if attr[11] == "A":
					if attr[25]/1000 <= 0.4:
						if attr[13] >= 70:
							z = '5'
						elif 70 > attr[13] >= 50:
							z = '4'
						elif 50 > attr[13] >= 30:
							z = '3'
						elif 30 > attr[13] >= 20:
							z = '2'
						elif attr[13] < 20:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif 0.4 < attr[25]/1000 <= 0.8:
						if attr[13] >= 80:
							z = '5'
						elif 80 > attr[13] >= 60:
							z = '4'
						elif 60 > attr[13] >= 40:
							z = '3'
						elif 40 > attr[13] >= 20:
							z = '2'
						elif attr[13] < 20:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif attr[25]/1000 > 0.8:
						if attr[13] >= 90:
							z = '5'
						elif 90 > attr[13] >= 65:
							z = '4'
						elif 65 > attr[13] >= 40:
							z = '3'
						elif 40 > attr[13] >= 20:
							z = '2'
						elif attr[13] < 20:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '1'
					sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					if attr[13] >= 30:
						z = '5'
					elif 30 > attr[13] >= 20:
						z = '4'
					elif 20 > attr[13] >= 15:
						z = '3'
					elif 15 > attr[13] >= 10:
						z = '2'
					elif attr[13] < 10:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					if attr[13] < 10:
						z = '1'
					elif attr[13] >= 10:
						z = '2'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					if attr[25]/1000 <= 0.2:
						if attr[13] >= 12:
							z = '5'
						elif 12 > attr[13] >= 9:
							z = '4'
						elif 9 > attr[13] >= 7:
							z = '3'
						elif 7 > attr[13] >= 5:
							z = '2'
						elif attr[13] < 5:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif 0.2 < attr[25]/1000 <= 0.5:
						if attr[13] >= 6:
							z = '5'
						elif 6 > attr[13] >= 4:
							z = '4'
						elif 4 > attr[13] >= 3:
							z = '3'
						elif 3 > attr[13] >= 2:
							z = '2'
						elif attr[13] < 2:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					elif attr[25]/1000 > 0.5:
						if attr[13] >= 6:
							z = '5'
						elif 6 > attr[13] >= 4:
							z = '4'
						elif 4 > attr[13] >= 3:
							z = '3'
						elif 3 > attr[13] >= 1:
							z = '2'
						elif attr[13] < 1:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAK":
				if attr[11] == "A":
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					if attr[12] in ["A", "B", "C", "D"]:
						z = '2'
						sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[12] == "C":
						z = '3'
						sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[11] == "E":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "F":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "G":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "H":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "I":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "J":
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "K":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "L":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "M":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "N":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAL":
				if attr[11] in ["A", "B"] and attr[12] in ["A", "B", "C", "D"]:
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["C", "D"] and attr[12] in ["A", "B", "C", "D"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D"]:
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D"]:
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[11] == "G") and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAM":
				if attr[11] in ["A", "B", "C"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[11] in ["A", "C"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[11] == "B":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAN":
				z = '3'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '5'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA":
				if attr[11] in ["A", "B", "C"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					if attr[13] >= 30:
						z = '5'
					elif 30 > attr[13] >= 20:
						z = '4'
					elif 20 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '2'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBB":
				if attr[11] in ["A", "B", "C", "Z"]:
					if attr[13] >= 30:
						z = '5'
					elif 30 > attr[13] >= 20:
						z = '4'
					elif 20 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '2'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBC" and attr[11] in ["A", "B", "C", "Z"]:
				if attr[13] >= 50:
					z = '5'
				elif 50 > attr[13] >= 40:
					z = '4'
				elif 40 > attr[13] >= 25:
					z = '3'
				elif 25 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBD" and attr[11] in ["A", "B", "C", "D", "Z"]:
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '5'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '5'
				elif 30 > attr[13] >= 20:
					z = '4'
				elif 20 > attr[13] >= 10:
					z = '3'
				elif attr[13] < 10:
					z = '2'
				else:
					z = '0'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				if attr[11] in ["D", "G"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[11] in ["A", "B", "C", "D", "E", "F", "G", "H", "Z"]:
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBF":
				if attr[11] in ["A", "B"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[11] == "C"):
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if (attr[11] == "D"):
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[11] in ["C", "D"]:
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBG":
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '2'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			#TODO: BBH nicht mehr enthalten in isybau?
			elif attr[10] == "BDB":
				if attr[11] in ["AA", "AB", "AC", "AD", "AE"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["BA", "BB", "BC"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDD" and attr[11] in ["A", "B", "C", "D", "E"]:
				z = '2'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDE":
				if attr[11] in ["A", "C", "D", "E"] and attr[12] == "A":
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "C", "D", "E"] and attr[12] == "B":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass

			# if für alle übrigen sachen Haltungsanfang ende usw.
			if attr[10] in ["BCD", "BCE", "BDC", "BCA", "BCB", "BCC", "BDA", "BDF", "BDG", "BDB", "AEC", "AED"]:
				z = '-'
				sql = f"""
								   UPDATE untersuchdat_haltung_bewertung
								   SET Zustandsklasse_D = ?
								   WHERE untersuchdat_haltung_bewertung.pk = ?;
								   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
								   UPDATE untersuchdat_haltung_bewertung
								   SET Zustandsklasse_B = ?
								   WHERE untersuchdat_haltung_bewertung.pk = ?;
								   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
								   UPDATE untersuchdat_haltung_bewertung
								   SET Zustandsklasse_S = ?
								   WHERE untersuchdat_haltung_bewertung.pk = ?;
								   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass

			z = 'Bitte pruefen!'
			sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Schadensklasse_D = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?
					"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Schadensklasse_B = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?
					"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_haltung_bewertung
					SET Schadensklasse_S = ?
					WHERE untersuchdat_haltung_bewertung.pk = ?
					"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			z = '-'
			sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE Schadensklasse_D is Null
						"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE Schadensklasse_B is Null
						"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE Schadensklasse_S is Null
						"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN vorlaufige_Schadenszahl_D INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN vorlaufige_Schadenszahl_B INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN vorlaufige_Schadenszahl_S INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_haltung_bewertung
					SET vorlaufige_Schadenszahl_D = (Case 
					WHEN Schadensklasse_D = 1  THEN 10
					WHEN Schadensklasse_D = 2  THEN 100
					WHEN Schadensklasse_D = 3  THEN 200
					WHEN Schadensklasse_D = 4  THEN 300
					WHEN Schadensklasse_D = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_haltung_bewertung
					SET vorlaufige_Schadenszahl_B = (Case 
					WHEN Schadensklasse_B = 1  THEN 10
					WHEN Schadensklasse_B = 2  THEN 100
					WHEN Schadensklasse_B = 3  THEN 200
					WHEN Schadensklasse_B = 4  THEN 300
					WHEN Schadensklasse_B = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_haltung_bewertung
					SET vorlaufige_Schadenszahl_S = (Case 
					WHEN Schadensklasse_S = 1  THEN 10
					WHEN Schadensklasse_S = 2  THEN 100
					WHEN Schadensklasse_S = 3  THEN 200
					WHEN Schadensklasse_S = 4  THEN 300
					WHEN Schadensklasse_S = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_haltung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_haltung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HALTUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_haltung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_haltung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_isy.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		sql = """CREATE TABLE IF NOT EXISTS haltungen_untersucht_bewertung AS SELECT * FROM haltungen_untersucht"""
		curs.execute(sql)

		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Entwaesserungssystem TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Abwasserart TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Wasserschutzzone TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Grundwasserabstand INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Bodenart TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Lage_am_Umfang TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Lage_an_Bauteilverbindung TEXT ;""")
			#db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('haltungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'haltungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		haltungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HALTUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), haltungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(haltungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_isy.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def bewertung_isy_leitung(self):
		date = self.date+'%'
		db = self.db
		db_x = db
		data = db
		leitung = self.leitung
		haltung = self.haltung
		crs = self.crs

		db1 = spatialite_connect(data)
		curs1 = db1.cursor()

		# nach Isybau

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_anschlussleitung_bewertung AS SELECT * FROM untersuchdat_anschlussleitung"""
		curs1.execute(sql)

		if leitung is True:
			sql = """
				SELECT
					anschlussleitungen.leitnam,
					anschlussleitungen.material,
					anschlussleitungen.hoehe,
					untersuchdat_anschlussleitung_bewertung.untersuchleit
				FROM anschlussleitungen
				INNER JOIN untersuchdat_anschlussleitung_bewertung  ON anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit
			"""

		try:
			curs1.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs1.fetchall():
			untersuchleitt = attr1[0]
			try:
				curs1.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_anschlussleitung_bewertung.untersuchleit = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_anschlussleitung_bewertung.untersuchleit = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass
		db1.commit()

		data = db
		db = spatialite_connect(data)
		curs = db.cursor()

		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Schadensklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Schadensklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Schadensklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Schadensklasse_D = NULL ;""")
		except:
			pass
		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Schadensklasse_S = NULL ;""")
		except:
			pass
		try:
			curs.execute("""update untersuchdat_haltung_bewertung set Schadensklasse_B = NULL ;""")
		except:
			pass

		db.commit()

		if self.datetype == 'Importdatum':

			if leitung is True:
				sql = """
					SELECT
						untersuchdat_anschlussleitung_bewertung.pk,
						untersuchdat_anschlussleitung_bewertung.untersuchleit,
						NULL,
						untersuchdat_anschlussleitung_bewertung.schoben,
						untersuchdat_anschlussleitung_bewertung.schunten,
						untersuchdat_anschlussleitung_bewertung.id,
						untersuchdat_anschlussleitung_bewertung.videozaehler,
						untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
						untersuchdat_anschlussleitung_bewertung.station,
						untersuchdat_anschlussleitung_bewertung.timecode,
						untersuchdat_anschlussleitung_bewertung.kuerzel,
						untersuchdat_anschlussleitung_bewertung.charakt1,
						untersuchdat_anschlussleitung_bewertung.charakt2,
						untersuchdat_anschlussleitung_bewertung.quantnr1,
						untersuchdat_anschlussleitung_bewertung.quantnr2,
						untersuchdat_anschlussleitung_bewertung.streckenschaden,
						untersuchdat_anschlussleitung_bewertung.pos_von,
						untersuchdat_anschlussleitung_bewertung.pos_bis,
						untersuchdat_anschlussleitung_bewertung.foto_dateiname,
						untersuchdat_anschlussleitung_bewertung.film_dateiname,
						untersuchdat_anschlussleitung_bewertung.baujahr,
						untersuchdat_anschlussleitung_bewertung.bw_bs,
						untersuchdat_anschlussleitung_bewertung.createdat,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe,
						anschlussleitungen.createdat
					FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit AND untersuchdat_anschlussleitung_bewertung.createdat like ? 
				"""
				data = (date, )
				curs.execute(sql, data)

		if self.datetype == 'Befahrungsdatum':

			if leitung is True:
				sql = """
					SELECT
						untersuchdat_anschlussleitung_bewertung.pk,
						untersuchdat_anschlussleitung_bewertung.untersuchleit,
						NULL,
						untersuchdat_anschlussleitung_bewertung.schoben,
						untersuchdat_anschlussleitung_bewertung.schunten,
						untersuchdat_anschlussleitung_bewertung.id,
						untersuchdat_anschlussleitung_bewertung.videozaehler,
						untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
						untersuchdat_anschlussleitung_bewertung.station,
						untersuchdat_anschlussleitung_bewertung.timecode,
						untersuchdat_anschlussleitung_bewertung.kuerzel,
						untersuchdat_anschlussleitung_bewertung.charakt1,
						untersuchdat_anschlussleitung_bewertung.charakt2,
						untersuchdat_anschlussleitung_bewertung.quantnr1,
						untersuchdat_anschlussleitung_bewertung.quantnr2,
						untersuchdat_anschlussleitung_bewertung.streckenschaden,
						untersuchdat_anschlussleitung_bewertung.pos_von,
						untersuchdat_anschlussleitung_bewertung.pos_bis,
						untersuchdat_anschlussleitung_bewertung.foto_dateiname,
						untersuchdat_anschlussleitung_bewertung.film_dateiname,
						untersuchdat_anschlussleitung_bewertung.baujahr,
						untersuchdat_anschlussleitung_bewertung.bw_bs,
						untersuchdat_anschlussleitung_bewertung.untersuchtag,
						anschlussleitungen.leitnam,
						anschlussleitungen.material,
						anschlussleitungen.hoehe,
						anschlussleitungen.createdat
					FROM untersuchdat_anschlussleitung_bewertung, anschlussleitungen
					WHERE anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit AND untersuchdat_anschlussleitung_bewertung.untersuchtag like ? 
				"""
				data = (date, )
				curs.execute(sql, data)


		for attr in curs.fetchall():


			if (attr[21] == "biegesteif" and attr[10] == "BAA" and (attr[11] == "A")) or (
					attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] < 6:
					z = '3'
				elif 6 <= attr[13] < 15:
					z = '4'
				elif attr[13] >= 15:
					z = '5'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_anschlussleitung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '5'
				elif 40 <= attr[13] < 50:
					z = '4'
				elif 25 <= attr[13] < 40:
					z = '3'
				elif 10 <= attr[13] < 25:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_anschlussleitung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif (attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 15:
					z = '5'
				elif 10 <= attr[13] < 15:
					z = '4'
				elif 6 <= attr[13] < 10:
					z = '3'
				elif 2 <= attr[13] < 6:
					z = '2'
				elif attr[13] < 2:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ? 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
				if attr[13] >= 50:
					z = '5'
				elif 40 <= attr[13] < 50:
					z = '4'
				elif 25 <= attr[13] < 40:
					z = '3'
				elif 10 <= attr[13] < 25:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ? 
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			# Tab A.3
			elif attr[10] == "BAB":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "B") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] in ["A", "C", "D", "E"]:
					if attr[13] >= 10:
						z = '5'
					elif 10 > attr[13] >= 5:
						z = '4'
					elif 5 > attr[13] >= 2:
						z = '3'
					elif 2 > attr[13] >= 0.5:
						z = '2'
					else:
						z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] == "B":
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "C") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				continue
			elif attr[10] == "BAC":
				if attr[11] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["A", "B"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "C":
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAD":
				if attr[11] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "B"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			elif attr[10] == "BAE":
				if attr[13] >= 100:
					z = '3'
				elif attr[13] < 100:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 100:
					z = '3'
				elif 100 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAF":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H" and attr[12] in ["B", "C", "D", "E"]:
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '5'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J" and attr[12] in ["B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAG":
				if attr[13] >= 75:
					z = '5'
				elif 75 > attr[13] >= 60:
					z = '4'
				elif 60 > attr[13] >= 40:
					z = '3'
				elif 40 > attr[13] >= 15:
					z = '2'
				elif attr[13] < 15:
					z = '1'
				else:
					z = '0'
				sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAH":
				if attr[11] in ["A"]:
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "D"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAI":
				if attr[11] == "A" and attr[12] == "A":
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "A" and attr[12] in ["B", "C", "D"]:
					z = '3'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAJ":
				if attr[11] == "A":
					if attr[25] / 1000 <= 0.4:
						if attr[13] >= 70:
							z = '5'
						elif 70 > attr[13] >= 50:
							z = '4'
						elif 50 > attr[13] >= 30:
							z = '3'
						elif 30 > attr[13] >= 20:
							z = '2'
						elif attr[13] < 20:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif 0.4 < attr[25] / 1000 <= 0.8:
						if attr[13] >= 80:
							z = '5'
						elif 80 > attr[13] >= 60:
							z = '4'
						elif 60 > attr[13] >= 40:
							z = '3'
						elif 40 > attr[13] >= 20:
							z = '2'
						elif attr[13] < 20:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif attr[25] / 1000 > 0.8:
						if attr[13] >= 90:
							z = '5'
						elif 90 > attr[13] >= 65:
							z = '4'
						elif 65 > attr[13] >= 40:
							z = '3'
						elif 40 > attr[13] >= 20:
							z = '2'
						elif attr[13] < 20:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					z = '1'
					sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					if attr[13] >= 30:
						z = '5'
					elif 30 > attr[13] >= 20:
						z = '4'
					elif 20 > attr[13] >= 15:
						z = '3'
					elif 15 > attr[13] >= 10:
						z = '2'
					elif attr[13] < 10:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] < 10:
						z = '1'
					elif attr[13] >= 10:
						z = '2'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					if attr[25] / 1000 <= 0.2:
						if attr[13] >= 12:
							z = '5'
						elif 12 > attr[13] >= 9:
							z = '4'
						elif 9 > attr[13] >= 7:
							z = '3'
						elif 7 > attr[13] >= 5:
							z = '2'
						elif attr[13] < 5:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif 0.2 < attr[25] / 1000 <= 0.5:
						if attr[13] >= 6:
							z = '5'
						elif 6 > attr[13] >= 4:
							z = '4'
						elif 4 > attr[13] >= 3:
							z = '3'
						elif 3 > attr[13] >= 2:
							z = '2'
						elif attr[13] < 2:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif attr[25] / 1000 > 0.5:
						if attr[13] >= 6:
							z = '5'
						elif 6 > attr[13] >= 4:
							z = '4'
						elif 4 > attr[13] >= 3:
							z = '3'
						elif 3 > attr[13] >= 1:
							z = '2'
						elif attr[13] < 1:
							z = '1'
						else:
							z = '0'
						sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAK":
				if attr[11] == "A":
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					if attr[12] in ["A", "B", "C", "D"]:
						z = '2'
						sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[12] == "C":
						z = '3'
						sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Schadensklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif attr[11] == "E":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J":
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "L":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "M":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "N":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAL":
				if attr[11] in ["A", "B"] and attr[12] in ["A", "B", "C", "D"]:
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["C", "D"] and attr[12] in ["A", "B", "C", "D"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D"]:
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D"]:
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif (attr[11] == "G") and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAM":
				if attr[11] in ["A", "B", "C"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				elif attr[11] in ["A", "C"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAN":
				z = '3'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '5'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA":
				if attr[11] in ["A", "B", "C"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 30:
						z = '5'
					elif 30 > attr[13] >= 20:
						z = '4'
					elif 20 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '2'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBB":
				if attr[11] in ["A", "B", "C", "Z"]:
					if attr[13] >= 30:
						z = '5'
					elif 30 > attr[13] >= 20:
						z = '4'
					elif 20 > attr[13] >= 10:
						z = '3'
					elif attr[13] < 10:
						z = '2'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBC" and attr[11] in ["A", "B", "C", "Z"]:
				if attr[13] >= 50:
					z = '5'
				elif 50 > attr[13] >= 40:
					z = '4'
				elif 40 > attr[13] >= 25:
					z = '3'
				elif 25 > attr[13] >= 10:
					z = '2'
				elif attr[13] < 10:
					z = '1'
				else:
					z = '0'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBD" and attr[11] in ["A", "B", "C", "D", "Z"]:
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '5'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '5'
				elif 30 > attr[13] >= 20:
					z = '4'
				elif 20 > attr[13] >= 10:
					z = '3'
				elif attr[13] < 10:
					z = '2'
				else:
					z = '0'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				if attr[11] in ["D", "G"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] in ["A", "B", "C", "D", "E", "F", "G", "H", "Z"]:
					if attr[13] >= 50:
						z = '5'
					elif 50 > attr[13] >= 35:
						z = '4'
					elif 35 > attr[13] >= 20:
						z = '3'
					elif 20 > attr[13] >= 5:
						z = '2'
					elif attr[13] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBF":
				if attr[11] in ["A", "B"]:
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "C"):
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if (attr[11] == "D"):
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["C", "D"]:
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBG":
				z = '4'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_D = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '2'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_S = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			# TODO: BBH nicht mehr enthalten in isybau?
			elif attr[10] == "BDB":
				if attr[11] in ["AA", "AB", "AC", "AD", "AE"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["BA", "BB", "BC"]:
					z = '2'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDD" and attr[11] in ["A", "B", "C", "D", "E"]:
				z = '2'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Schadensklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDE":
				if attr[11] in ["A", "C", "D", "E"] and attr[12] == "A":
					z = '4'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "C", "D", "E"] and attr[12] == "B":
					z = '3'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Schadensklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			# if für alle übrigen sachen Haltungsanfang ende usw.
			if attr[10] in ["BCD", "BCE", "BDC", "BCA", "BCB", "BCC", "BDA", "BDF", "BDG", "BDB", "AEC", "AED"]:
				z = '-'
				sql = f"""
								   UPDATE untersuchdat_anschlussleitung_bewertung
								   SET Zustandsklasse_D = ?
								   WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
								   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
								   UPDATE untersuchdat_anschlussleitung_bewertung
								   SET Zustandsklasse_B = ?
								   WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
								   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
								   UPDATE untersuchdat_anschlussleitung_bewertung
								   SET Zustandsklasse_S = ?
								   WHERE untersuchdat_anschlussleitung_bewertung.pk = ?;
								   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass

			z = 'Bitte pruefen!'
			sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Schadensklasse_D = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
					"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Schadensklasse_B = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
					"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
					SET Schadensklasse_S = ?
					WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
					"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			z = '-'
			sql = f"""
						UPDATE untersuchdat_anschlussleitung_bewertung
						SET Schadensklasse_D = ?
						WHERE Schadensklasse_D is Null
						"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
						UPDATE untersuchdat_anschlussleitung_bewertung
						SET Schadensklasse_B = ?
						WHERE Schadensklasse_B is Null
						"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
						UPDATE untersuchdat_anschlussleitung_bewertung
						SET Schadensklasse_S = ?
						WHERE Schadensklasse_S is Null
						"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN vorlaufige_Schadenszahl_D INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN vorlaufige_Schadenszahl_B INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN vorlaufige_Schadenszahl_S INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_anschlussleitung_bewertung
					SET vorlaufige_Schadenszahl_D = (Case 
					WHEN Schadensklasse_D = 1  THEN 10
					WHEN Schadensklasse_D = 2  THEN 100
					WHEN Schadensklasse_D = 3  THEN 200
					WHEN Schadensklasse_D = 4  THEN 300
					WHEN Schadensklasse_D = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_anschlussleitung_bewertung
					SET vorlaufige_Schadenszahl_B = (Case 
					WHEN Schadensklasse_B = 1  THEN 10
					WHEN Schadensklasse_B = 2  THEN 100
					WHEN Schadensklasse_B = 3  THEN 200
					WHEN Schadensklasse_B = 4  THEN 300
					WHEN Schadensklasse_B = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_anschlussleitung_bewertung
					SET vorlaufige_Schadenszahl_S = (Case 
					WHEN Schadensklasse_S = 1  THEN 10
					WHEN Schadensklasse_S = 2  THEN 100
					WHEN Schadensklasse_S = 3  THEN 200
					WHEN Schadensklasse_S = 4  THEN 300
					WHEN Schadensklasse_S = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_anschlussleitung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_anschlussleitung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HA_LEITUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_anschlussleitung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_anschlussleitung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_anschlussleitung_bewertung_isy.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		sql = """CREATE TABLE IF NOT EXISTS anschlussleitungen_untersucht_bewertung AS SELECT * FROM haltungen_untersucht"""
		curs.execute(sql)

		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Entwaesserungssystem TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Abwasserart TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Wasserschutzzone TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Grundwasserabstand INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Bodenart TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Lage_am_Umfang TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Lage_an_Bauteilverbindung TEXT ;""")
			#db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('anschlussleitungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'anschlussleitungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		anschlussleitungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HA_LEITUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), anschlussleitungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(anschlussleitungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_isy.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def bewertung_isy_schacht(self):
		date = self.date+'%'
		db = self.db
		db_x = db
		crs = self.crs

		data = db
		db1 = spatialite_connect(data)
		curs1 = db1.cursor()
		# nach Isybau

		sql = """CREATE TABLE IF NOT EXISTS Untersuchdat_schacht_bewertung AS SELECT * FROM Untersuchdat_schacht"""
		curs1.execute(sql)

		sql = """
					SELECT
						schaechte.schnam,
						schaechte.material,
						Untersuchdat_schacht_bewertung.untersuchsch
					FROM schaechte
						INNER JOIN Untersuchdat_schacht_bewertung  ON schaechte.schnam = Untersuchdat_schacht_bewertung.untersuchsch
				"""
		try:
			curs1.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Schächte konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs1.fetchall():

			untersuchhalt = attr1[0]
			try:
				curs1.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
						SET bw_bs = ?
						WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE Untersuchdat_schacht_bewertung
						SET bw_bs = ?
						WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
						"""
				data = (bw_bs, x)
				try:
					curs1.execute(sql, data)
				except:
					pass
		db1.commit()

		data = db
		db = spatialite_connect(data)
		curs = db.cursor()

		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Schadensklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Schadensklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Schadensklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""update Untersuchdat_schacht_bewertung set Schadensklasse_D = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update Untersuchdat_schacht_bewertung set Schadensklasse_S = NULL ;""")
		except:
			pass

		try:
			curs.execute("""update Untersuchdat_schacht_bewertung set Schadensklasse_B = NULL ;""")
		except:
			pass

		db.commit()

		if self.datetype == 'Importdatum':

			sql = """
				SELECT
					Untersuchdat_schacht_bewertung.pk,
					Untersuchdat_schacht_bewertung.untersuchsch,
					Untersuchdat_schacht_bewertung.id,
					Untersuchdat_schacht_bewertung.videozaehler,
					Untersuchdat_schacht_bewertung.timecode,
					Untersuchdat_schacht_bewertung.kuerzel,
					Untersuchdat_schacht_bewertung.charakt1,
					Untersuchdat_schacht_bewertung.charakt2,
					Untersuchdat_schacht_bewertung.quantnr1,
					Untersuchdat_schacht_bewertung.quantnr2,
					Untersuchdat_schacht_bewertung.streckenschaden,
					Untersuchdat_schacht_bewertung.pos_von,
					Untersuchdat_schacht_bewertung.pos_bis,
					Untersuchdat_schacht_bewertung.bereich,
					Untersuchdat_schacht_bewertung.foto_dateiname,
					Untersuchdat_schacht_bewertung.bw_bs,
					Untersuchdat_schacht_bewertung.createdat
				FROM Untersuchdat_schacht_bewertung
				WHERE Untersuchdat_schacht_bewertung.createdat like ? 
			"""
			data = (date,)

			curs.execute(sql, data)

		elif self.datetype == 'Befahrungsdatum':
			sql = """
				SELECT
					Untersuchdat_schacht_bewertung.pk,
					Untersuchdat_schacht_bewertung.untersuchsch,
					Untersuchdat_schacht_bewertung.id,
					Untersuchdat_schacht_bewertung.videozaehler,
					Untersuchdat_schacht_bewertung.timecode,
					Untersuchdat_schacht_bewertung.kuerzel,
					Untersuchdat_schacht_bewertung.charakt1,
					Untersuchdat_schacht_bewertung.charakt2,
					Untersuchdat_schacht_bewertung.quantnr1,
					Untersuchdat_schacht_bewertung.quantnr2,
					Untersuchdat_schacht_bewertung.streckenschaden,
					Untersuchdat_schacht_bewertung.pos_von,
					Untersuchdat_schacht_bewertung.pos_bis,
					Untersuchdat_schacht_bewertung.bereich,
					Untersuchdat_schacht_bewertung.foto_dateiname,
					Untersuchdat_schacht_bewertung.bw_bs,
					Untersuchdat_schacht_bewertung.untersuchtag
				FROM Untersuchdat_schacht_bewertung
				WHERE Untersuchdat_schacht_bewertung.untersuchtag like ? 
			"""
			data = (date,)

			curs.execute(sql, data)

		for attr in curs.fetchall():


			if attr[5] == "DAA":
				if attr[6] in ["A", "B"] and attr[13] in ["B", "C", "D", "F"] and attr[15] == "biegeweich":
					if attr[8] >= 40:
						z = '5'
					elif 40 > attr[8] >= 30:
						z = '4'
					elif 30 > attr[8] >= 20:
						z = '3'
					elif 20 > attr[8] >= 10:
						z = '2'
					elif attr[8] < 10:
						z = '1'
					else:
						z = '0'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] in ["A", "B"] and attr[13] in ["B", "C", "D", "F"] and attr[
					15] == "biegesteif":
					if attr[8] >= 40:
						z = '5'
					elif 40 > attr[8] >= 30:
						z = '4'
					elif 30 > attr[8] >= 20:
						z = '3'
					elif 20 > attr[8] >= 10:
						z = '2'
					elif attr[8] < 10:
						z = '1'
					else:
						z = '0'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '3'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAB":
				if attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "F", "H", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif (attr[6] == "B"):
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[7] == "A") and attr[13] in ["B", "C", "D", "F"]:
						if attr[13] >= 8:
							z = '5'
						elif 8 > attr[13] >= 5:
							z = '4'
						elif 5 > attr[13] >= 3:
							z = '3'
						elif 3 > attr[13] >= 1:
							z = '2'
						elif attr[13] < 1:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if (attr[7] == "B") and attr[13] in ["B", "C", "D", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[7] in ["C", "D", "E"] and attr[13] in ["B", "C", "D", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif (attr[6] == "C"):
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[7] == "A") and attr[13] in ["B", "C", "D", "F"]:
						if attr[13] >= 8:
							z = '5'
						elif 8 > attr[13] >= 5:
							z = '4'
						elif 5 > attr[13] >= 3:
							z = '3'
						elif 3 > attr[13] >= 1:
							z = '2'
						elif attr[13] < 1:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if (attr[7] == "B") and attr[13] in ["B", "C", "D", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[7] in ["C", "D", "E"] and attr[13] in ["B", "C", "D", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAC":
				if attr[6] == "A":
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAD":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B" and attr[7] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B" and attr[7] == "B":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F", "H", "I", "J"]:
						z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAE":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					if attr[8] >= 100:
						z = '2'
					elif attr[8] < 100:
						z = '1'
					else:
						z = '0'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					if attr[8] >= 100:
						z = '3'
					elif attr[8] < 100:
						z = '1'
					else:
						z = '0'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["C", "D", "F"]:
					if attr[8] > 100:
						z = '3'
					elif 100 >= attr[8] > 10:
						z = '2'
					elif attr[8] <= 10:
						z = '1'
					else:
						z = '0'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAF":
				if attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "B" and attr[7] in ["A", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "B" and attr[7] in ["A", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "D" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "D" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "E" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "E" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "F" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "F" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "G" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "G" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "H" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D" "E", "F"]:
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "H" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "I" and attr[7] in ["A", "C", "D", "E", "Z"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '5'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "J" and attr[7] in ["B", "C", "D", "E"]:
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass

						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "K" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "Z" and attr[7] in ["A", "B", "C", "D", "E","Z"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAG" and attr[6] in ["", "NULL", "None", None, "not found"] and attr[7] in ["", "NULL", "None", None, "not found"]:
				if attr[13] in ["C", "D", "E", "F"]:
					if attr[8] >= 400:
						z = '5'
					elif 400 > attr[8] >= 300:
						z = '4'
					elif 300 > attr[8] >= 200:
						z = '3'
					elif 200 > attr[8] >= 100:
						z = '2'
					elif attr[8] < 100:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif (attr[13] == "I" or attr[13] == "J"):
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAH":
				if attr[6] in ["B", "C", "D"] and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAI":
				if attr[6] == "A" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAJ" and attr[6] in ["A", "B", "C"]:
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["B", "C", "D", "F"]:
					z = '1'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAK":
				if attr[6] == "A" and attr[13] in ["C", "D", "E", "F", "H"]:
					if attr[8] >= 40:
						z = '5'
					elif 40 > attr[8] >= 30:
						z = '4'
					elif 30 > attr[8] >= 20:
						z = '3'
					elif 20 > attr[8] >= 10:
						z = '2'
					elif attr[8] < 10:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "A" and attr[13] in ["I", "J"]:
					if attr[8] >= 0:
						z = '5'
					elif 50 > attr[8] >= 35:
						z = '4'
					elif 35 > attr[8] >= 20:
						z = '3'
					elif 20 > attr[8] >= 5:
						z = '2'
					elif attr[8] < 5:
						z = '1'
					else:
						z = '0'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "D":
					if attr[7] in ["A", "B", "C", "D"] and attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[7] == "C") and attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "E":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						if attr[8] >= 40:
							z = '5'
						elif 40 > attr[8] >= 30:
							z = '4'
						elif 30 > attr[8] >= 20:
							z = '3'
						elif 20 > attr[8] >= 10:
							z = '2'
						elif attr[8] < 10:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '5'
						elif 50 > attr[8] >= 35:
							z = '4'
						elif 35 > attr[8] >= 20:
							z = '3'
						elif 20 > attr[8] >= 5:
							z = '2'
						elif attr[8] < 5:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "G":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "H":
					if attr[13] in ["I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "I":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "J":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "K":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "L":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "M":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "N":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
				elif attr[6] == "Z":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAL":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "D":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "E":
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H"]:
						if attr[8] >= 40:
							z = '5'
						elif 40 > attr[8] >= 30:
							z = '4'
						elif 30 > attr[8] >= 20:
							z = '3'
						elif 20 > attr[8] >= 10:
							z = '2'
						elif attr[8] < 10:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '5'
						elif 50 > attr[8] >= 35:
							z = '4'
						elif 35 > attr[8] >= 20:
							z = '3'
						elif 20 > attr[8] >= 5:
							z = '2'
						elif attr[8] < 5:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "G":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAM":
				if attr[6] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[13] == "I" or attr[13] == "J"):
						z = '3'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				if (attr[6] == "A" or attr[13] == "C"):
					if attr[13] in ["B", "C", "D", "F"]:
						z = '2'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				if attr[6] == "B":
					if attr[13] in ["B", "C", "D", "F"]:
						z = '1'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Schadensklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				continue
			elif attr[5] == "DAN":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if (attr[13] == "I" or attr[13] == "J"):
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAO":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if (attr[13] == "I" or attr[13] == "J"):
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAP":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if (attr[13] == "I" or attr[13] == "J"):
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '5'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAQ":
				if attr[6] in ["A", "C", "D", "F", "G", "H", "I", "J", "K"] and attr[13] in ["C", "D", "F"]:
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "B") and attr[13] in ["C", "D", "F"]:
					z = '5'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "E") and attr[13] in ["C", "D", "F"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "Z") and attr[13] in ["C", "D", "F"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAR":
				if attr[6] in ["A", "C", "F"] and (attr[13] == "A"):
					z = '5'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "B" or attr[6] == "E") and (attr[13] == "A"):
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "D") and (attr[13] == "A"):
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "G" or attr[6] == "H") and (attr[13] == "A"):
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "Z") and (attr[13] == "A"):
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBA":
				if attr[6] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[13] == "I" or attr[13] == "J"):
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Schadensklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DBB":
				if attr[6] in ["A", "B", "C", "Z"] and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBC":
				if attr[6] in ["C", "Z"]:
					if attr[13] == "J":
						if attr[8] >= 300:
							z = '4'
						elif 300 > attr[8] >= 100:
							z = '3'
						elif 100 > attr[8] >= 50:
							z = '2'
						elif attr[8] < 50:
							z = '1'
						else:
							z = '0'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] == "H":
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DBD":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '3'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					z = '4'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '5'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DBE":
				if attr[6] in ["A", "B", "C"] and attr[13] in ["I", "J"]:
					z = '2'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[6] in ["D", "E", "F", "G", "H", "Z"] and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Schadensklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[6] in ["D", "G"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				continue
			elif attr[5] == "DBF":
				if attr[6] in ["A", "B"] and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '1'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
				elif (attr[6] == "D") and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Schadensklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
			elif attr[5] == "DBG" and attr[13] in ["I", "J"]:
				z = '4'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_D = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
				except:
					pass
				z = '2'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_S = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCH" and (attr[6] == "A") and (attr[13] == "H"):
				z = '2'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCI" and (attr[6] == "A") and (attr[13] == "I"):
				z = '2'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCJ":
				if attr[6] in ["B", "F"] and (attr[13] == "F"):
					z = '5'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Schadensklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] in ["C", "D", "G", "H"] and (attr[13] == "F"):
					z = '2'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Schadensklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DCL" and attr[6] in ["A", "B", "C"] and attr[7] == "A" and (
					attr[13] == "F"):
				z = '2'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCM" and attr[6] in ["B", "C"] and (attr[13] == "A"):
				z = '2'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCN" and (attr[6] == "B") and (attr[13] == "J"):
				z = '2'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDE" and attr[6] in ["A", "C", "D", "E"]:
				if attr[7] == "A" and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '4'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Schadensklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[7] == "B" and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '3'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Schadensklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass

			# if für alle übrigen sachen Haltungsanfang ende usw.
			elif attr[5] in ["CED", "DCA", "DCB", "DCG", "DCK", "DCO", "DDA", "DDB", "DDC", "DDD", "DDF",
							"DDG"]:
				z = '-'
				sql = f"""
							   UPDATE untersuchdat_haltung_bewertung
							   SET Zustandsklasse_D = ?
							   WHERE untersuchdat_haltung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE untersuchdat_haltung_bewertung
							   SET Zustandsklasse_B = ?
							   WHERE untersuchdat_haltung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
							   UPDATE untersuchdat_haltung_bewertung
							   SET Zustandsklasse_S = ?
							   WHERE untersuchdat_haltung_bewertung.pk = ?;
							   """
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			try:
				db.commit()
			except:
				pass

			z = 'Bitte prüfen!'
			sql = f"""
				UPDATE Untersuchdat_schacht_bewertung
				SET Schadensklasse_D = ?
				WHERE Untersuchdat_schacht_bewertung.pk = ?
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE Untersuchdat_schacht_bewertung
				SET Schadensklasse_B = ?
				WHERE Untersuchdat_schacht_bewertung.pk = ?
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
				UPDATE Untersuchdat_schacht_bewertung
				SET Schadensklasse_S = ?
				WHERE Untersuchdat_schacht_bewertung.pk = ?
				"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			z = '-'
			sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_D = ?
					WHERE Schadensklasse_D is Null
					"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_B = ?
					WHERE Schadensklasse_B is Null
					"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Schadensklasse_S = ?
					WHERE Schadensklasse_S is Null
					"""
			data = (z,)
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass

		try:
			curs.execute(
				"""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN vorlaufige_Schadenszahl_D INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN vorlaufige_Schadenszahl_B INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN vorlaufige_Schadenszahl_S INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE Untersuchdat_schacht_bewertung
					SET vorlaufige_Schadenszahl_D = (Case 
					WHEN Schadensklasse_D = 1  THEN 10
					WHEN Schadensklasse_D = 2  THEN 100
					WHEN Schadensklasse_D = 3  THEN 200
					WHEN Schadensklasse_D = 4  THEN 300
					WHEN Schadensklasse_D = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE Untersuchdat_schacht_bewertung
					SET vorlaufige_Schadenszahl_B = (Case 
					WHEN Schadensklasse_B = 1  THEN 10
					WHEN Schadensklasse_B = 2  THEN 100
					WHEN Schadensklasse_B = 3  THEN 200
					WHEN Schadensklasse_B = 4  THEN 300
					WHEN Schadensklasse_B = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE Untersuchdat_schacht_bewertung
					SET vorlaufige_Schadenszahl_S = (Case 
					WHEN Schadensklasse_S = 1  THEN 10
					WHEN Schadensklasse_S = 2  THEN 100
					WHEN Schadensklasse_S = 3  THEN 200
					WHEN Schadensklasse_S = 4  THEN 300
					WHEN Schadensklasse_S = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'Untersuchdat_schacht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		Untersuchdat_schacht_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_SCHAECHTE.value
		vlayer = QgsVectorLayer(uri.uri(), Untersuchdat_schacht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(Untersuchdat_schacht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_schacht_bewertung_isy.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		sql = """CREATE TABLE IF NOT EXISTS schaechte_untersucht_bewertung AS SELECT * FROM schaechte_untersucht"""
		curs.execute(sql)

		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Entwaesserungssystem TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Abwasserart TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Wasserschutzzone TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Grundwasserabstand INTEGER ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Bodenart TEXT ;""")
			#db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Lage_an_Bauteilverbindung TEXT ;""")
			#db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('schaechte_untersucht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'schaechte_untersucht_bewertung'
		geom_column = 'geop'
		uri.setDataSource(schema, table, geom_column)
		schaechte_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_SCHAECHTE_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), schaechte_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(schaechte_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/schaechte_untersucht_bewertung_isy.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def einzelfallbetrachtung_haltung(self):

		date = self.date+'%'
		db = self.db
		db_x = db
		data = db
		leitung = self.leitung
		haltung = self.haltung
		crs = self.crs
		liste_pk =[]
		db1 = spatialite_connect(data)
		curs1 = db1.cursor()

		# nach Isybau

		data = db
		db = spatialite_connect(data)
		curs = db.cursor()

		if self.datetype == 'Importdatum':

			if self.check_cb['cb16']:
				sql = """SELECT
							untersuchdat_haltung_bewertung.pk,
							untersuchdat_haltung_bewertung.untersuchhal,
							NULL,
							untersuchdat_haltung_bewertung.schoben,
							untersuchdat_haltung_bewertung.schunten,
							untersuchdat_haltung_bewertung.id,
							untersuchdat_haltung_bewertung.videozaehler,
							untersuchdat_haltung_bewertung.inspektionslaenge,
							untersuchdat_haltung_bewertung.station,
							untersuchdat_haltung_bewertung.timecode,
							untersuchdat_haltung_bewertung.kuerzel,
							untersuchdat_haltung_bewertung.charakt1,
							untersuchdat_haltung_bewertung.charakt2,
							untersuchdat_haltung_bewertung.quantnr1,
							untersuchdat_haltung_bewertung.quantnr2,
							untersuchdat_haltung_bewertung.streckenschaden,
							untersuchdat_haltung_bewertung.pos_von,
							untersuchdat_haltung_bewertung.pos_bis,
							untersuchdat_haltung_bewertung.foto_dateiname,
							untersuchdat_haltung_bewertung.film_dateiname,
							NULL,
							untersuchdat_haltung_bewertung.bw_bs,
							untersuchdat_haltung_bewertung.createdat,
							haltungen.haltnam,
							haltungen.material,
							haltungen.hoehe,
							untersuchdat_haltung_bewertung.untersuchtag,
							untersuchdat_haltung_bewertung.Zustandsklasse_D,
							untersuchdat_haltung_bewertung.Zustandsklasse_S,
							untersuchdat_haltung_bewertung.Zustandsklasse_B
							FROM
							untersuchdat_haltung_bewertung, haltungen
							WHERE
							haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal
							AND(untersuchdat_haltung_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND untersuchdat_haltung_bewertung.createdat like ? """
				data = (date,)
				curs.execute(sql, data)

			if self.check_cb['cb18']:
				sql = """SELECT
							untersuchdat_haltung_bewertung.pk,
							untersuchdat_haltung_bewertung.untersuchhal,
							NULL,
							untersuchdat_haltung_bewertung.schoben,
							untersuchdat_haltung_bewertung.schunten,
							untersuchdat_haltung_bewertung.id,
							untersuchdat_haltung_bewertung.videozaehler,
							untersuchdat_haltung_bewertung.inspektionslaenge,
							untersuchdat_haltung_bewertung.station,
							untersuchdat_haltung_bewertung.timecode,
							untersuchdat_haltung_bewertung.kuerzel,
							untersuchdat_haltung_bewertung.charakt1,
							untersuchdat_haltung_bewertung.charakt2,
							untersuchdat_haltung_bewertung.quantnr1,
							untersuchdat_haltung_bewertung.quantnr2,
							untersuchdat_haltung_bewertung.streckenschaden,
							untersuchdat_haltung_bewertung.pos_von,
							untersuchdat_haltung_bewertung.pos_bis,
							untersuchdat_haltung_bewertung.foto_dateiname,
							untersuchdat_haltung_bewertung.film_dateiname,
							NULL,
							untersuchdat_haltung_bewertung.bw_bs,
							untersuchdat_haltung_bewertung.createdat,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							anschlussleitungen.createdat,
							untersuchdat_haltung_bewertung.Zustandsklasse_D,
							untersuchdat_haltung_bewertung.Zustandsklasse_S,
							untersuchdat_haltung_bewertung.Zustandsklasse_B
							FROM
							untersuchdat_haltung_bewertung, haltungen
							WHERE
							anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchleit
							AND(untersuchdat_haltung_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND untersuchdat_haltung_bewertung.createdat like ? """
				data = (date,)
				curs.execute(sql, data)

		if self.datetype == 'Befahrungsdatum':

			if self.check_cb['cb16']:
				sql = """SELECT
							untersuchdat_haltung_bewertung.pk,
							untersuchdat_haltung_bewertung.untersuchhal,
							NULL,
							untersuchdat_haltung_bewertung.schoben,
							untersuchdat_haltung_bewertung.schunten,
							untersuchdat_haltung_bewertung.id,
							untersuchdat_haltung_bewertung.videozaehler,
							untersuchdat_haltung_bewertung.inspektionslaenge,
							untersuchdat_haltung_bewertung.station,
							untersuchdat_haltung_bewertung.timecode,
							untersuchdat_haltung_bewertung.kuerzel,
							untersuchdat_haltung_bewertung.charakt1,
							untersuchdat_haltung_bewertung.charakt2,
							untersuchdat_haltung_bewertung.quantnr1,
							untersuchdat_haltung_bewertung.quantnr2,
							untersuchdat_haltung_bewertung.streckenschaden,
							untersuchdat_haltung_bewertung.pos_von,
							untersuchdat_haltung_bewertung.pos_bis,
							untersuchdat_haltung_bewertung.foto_dateiname,
							untersuchdat_haltung_bewertung.film_dateiname,
							NULL,
							untersuchdat_haltung_bewertung.bw_bs,
							untersuchdat_haltung_bewertung.untersuchtag,
							haltungen.haltnam,
							haltungen.material,
							haltungen.hoehe,
							untersuchdat_haltung_bewertung.createdat,
							untersuchdat_haltung_bewertung.Zustandsklasse_D,
							untersuchdat_haltung_bewertung.Zustandsklasse_S,
							untersuchdat_haltung_bewertung.Zustandsklasse_B
							FROM
							untersuchdat_haltung_bewertung, haltungen
							WHERE
							haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal
							AND(untersuchdat_haltung_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND untersuchdat_haltung_bewertung.untersuchtag like ? """
				data = (date,)
				curs.execute(sql, data)

			if self.check_cb['cb18']:
				sql = """SELECT
							untersuchdat_haltung_bewertung.pk,
							untersuchdat_haltung_bewertung.untersuchhal,
							NULL,
							untersuchdat_haltung_bewertung.schoben,
							untersuchdat_haltung_bewertung.schunten,
							untersuchdat_haltung_bewertung.id,
							untersuchdat_haltung_bewertung.videozaehler,
							untersuchdat_haltung_bewertung.inspektionslaenge,
							untersuchdat_haltung_bewertung.station,
							untersuchdat_haltung_bewertung.timecode,
							untersuchdat_haltung_bewertung.kuerzel,
							untersuchdat_haltung_bewertung.charakt1,
							untersuchdat_haltung_bewertung.charakt2,
							untersuchdat_haltung_bewertung.quantnr1,
							untersuchdat_haltung_bewertung.quantnr2,
							untersuchdat_haltung_bewertung.streckenschaden,
							untersuchdat_haltung_bewertung.pos_von,
							untersuchdat_haltung_bewertung.pos_bis,
							untersuchdat_haltung_bewertung.foto_dateiname,
							untersuchdat_haltung_bewertung.film_dateiname,
							NULL,
							untersuchdat_haltung_bewertung.bw_bs,
							untersuchdat_haltung_bewertung.untersuchtag,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							anschlussleitungen.createdat,
							untersuchdat_haltung_bewertung.Zustandsklasse_D,
							untersuchdat_haltung_bewertung.Zustandsklasse_S,
							untersuchdat_haltung_bewertung.Zustandsklasse_B
							FROM
							untersuchdat_haltung_bewertung, haltungen
							WHERE
							anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchleit
							AND(untersuchdat_haltung_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
							OR
							untersuchdat_haltung_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND untersuchdat_haltung_bewertung.untersuchtag like ? """
				data = (date,)
				curs.execute(sql, data)

		for attr in curs.fetchall():
			liste_pk.append(attr[0])

			if (attr[21] == "biegesteif" and attr[10] == "BAA" and (attr[11] == "A")) or (
					attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] < 6:
					z = '3_isy'
				elif 6 <= attr[13] < 15:
					z = '4_isy'
				elif attr[13] >= 15:
					z = '5_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '5_isy'
				elif 40 <= attr[13] < 50:
					z = '4_isy'
				elif 25 <= attr[13] < 40:
					z = '3_isy'
				elif 10 <= attr[13] < 25:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ? 
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			if (attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 15:
					z = '5_isy'
				elif 10 <= attr[13] < 15:
					z = '4_isy'
				elif 6 <= attr[13] < 10:
					z = '3_isy'
				elif 2 <= attr[13] < 6:
					z = '2_isy'
				elif attr[13] < 2:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ? 
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
				if attr[13] >= 50:
					z = '5_isy'
				elif 40 <= attr[13] < 50:
					z = '4_isy'
				elif 25 <= attr[13] < 40:
					z = '3_isy'
				elif 10 <= attr[13] < 25:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ? 
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			# Tab A.3
			if attr[10] == "BAB":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "B") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] in ["A", "C", "D", "E"]:
					if attr[13] >= 10:
						z = '5_isy'
					elif 10 > attr[13] >= 5:
						z = '4_isy'
					elif 5 > attr[13] >= 2:
						z = '3_isy'
					elif 2 > attr[13] >= 0.5:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] == "B":
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "C") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				continue
			elif attr[10] == "BAC":
				if attr[11] == "A":
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
				if attr[11] in ["A", "B"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						db.commit()
					except:
						pass
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "C":
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAD":
				if attr[11] == "A":
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "B" and attr[12] in ["A", "B"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			elif attr[10] == "BAE":
				if attr[13] >= 100:
					z = '3_isy'
				elif attr[13] < 100:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				if attr[13] >= 100:
					z = '3_isy'
				elif 100 > attr[13] >= 10:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAF":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J" and attr[12] in ["B", "C", "D", "E", "Z"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAG":
				if attr[13] >= 75:
					z = '5_isy'
				elif 75 > attr[13] >= 60:
					z = '4_isy'
				elif 60 > attr[13] >= 40:
					z = '3_isy'
				elif 40 > attr[13] >= 15:
					z = '2_isy'
				elif attr[13] < 15:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAH":
				if attr[11] in ["A"]:
					z = '2_isy'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "D"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAI":
				if attr[11] == "A" and attr[12] == "A":
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "A" and attr[12] in ["B", "C", "D"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAJ":
				if attr[11] == "A":
					if attr[25]/1000 <= 0.4:
						if attr[13] >= 70:
							z = '5_isy'
						elif 70 > attr[13] >= 50:
							z = '4_isy'
						elif 50 > attr[13] >= 30:
							z = '3_isy'
						elif 30 > attr[13] >= 20:
							z = '2_isy'
						elif attr[13] < 20:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					elif 0.4 < attr[25]/1000 <= 0.8:
						if attr[13] >= 80:
							z = '5_isy'
						elif 80 > attr[13] >= 60:
							z = '4_isy'
						elif 60 > attr[13] >= 40:
							z = '3_isy'
						elif 40 > attr[13] >= 20:
							z = '2_isy'
						elif attr[13] < 20:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					elif attr[25]/1000 > 0.8:
						if attr[13] >= 90:
							z = '5_isy'
						elif 90 > attr[13] >= 65:
							z = '4_isy'
						elif 65 > attr[13] >= 40:
							z = '3_isy'
						elif 40 > attr[13] >= 20:
							z = '2_isy'
						elif attr[13] < 20:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					z = '1_isy'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					if attr[13] >= 30:
						z = '5_isy'
					elif 30 > attr[13] >= 20:
						z = '4_isy'
					elif 20 > attr[13] >= 15:
						z = '3_isy'
					elif 15 > attr[13] >= 10:
						z = '2_isy'
					elif attr[13] < 10:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					if attr[13] < 10:
						z = '1_isy'
					elif attr[13] >= 10:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					if attr[25]/1000 <= 0.2:
						if attr[13] >= 12:
							z = '5_isy'
						elif 12 > attr[13] >= 9:
							z = '4_isy'
						elif 9 > attr[13] >= 7:
							z = '3_isy'
						elif 7 > attr[13] >= 5:
							z = '2_isy'
						elif attr[13] < 5:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					elif 0.2 < attr[25]/1000 <= 0.5:
						if attr[13] >= 6:
							z = '5_isy'
						elif 6 > attr[13] >= 4:
							z = '4_isy'
						elif 4 > attr[13] >= 3:
							z = '3_isy'
						elif 3 > attr[13] >= 2:
							z = '2_isy'
						elif attr[13] < 2:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					elif attr[25]/1000 > 0.5:
						if attr[13] >= 6:
							z = '5_isy'
						elif 6 > attr[13] >= 4:
							z = '4_isy'
						elif 4 > attr[13] >= 3:
							z = '3_isy'
						elif 3 > attr[13] >= 1:
							z = '2_isy'
						elif attr[13] < 1:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAK":
				if attr[11] == "A":
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					if attr[12] in ["A", "B", "C", "D"]:
						z = '2_isy'
						sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
						except:
							pass
					if attr[12] == "C":
						z = '3_isy'
						sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif attr[11] == "E":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J":
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "L":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "M":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "N":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAL":
				if attr[11] in ["A", "B"] and attr[12] in ["A", "B", "C", "D"]:
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["C", "D"] and attr[12] in ["A", "B", "C", "D"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D"]:
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D"]:
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D"]:
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D"]:
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAM":
				if attr[11] in ["A", "B", "C"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
				if attr[11] in ["A", "C"]:
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "B":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAN":
				z = '3_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				z = '5_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA":
				if attr[11] in ["A", "B", "C"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					if attr[13] >= 30:
						z = '5_isy'
					elif 30 > attr[13] >= 20:
						z = '4_isy'
					elif 20 > attr[13] >= 10:
						z = '3_isy'
					elif attr[13] < 10:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBB":
				if attr[11] in ["A", "B", "C", "Z"]:
					if attr[13] >= 30:
						z = '5_isy'
					elif 30 > attr[13] >= 20:
						z = '4_isy'
					elif 20 > attr[13] >= 10:
						z = '3_isy'
					elif attr[13] < 10:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBC" and attr[11] in ["A", "B", "C", "Z"]:
				if attr[13] >= 50:
					z = '5_isy'
				elif 50 > attr[13] >= 40:
					z = '4_isy'
				elif 40 > attr[13] >= 25:
					z = '3_isy'
				elif 25 > attr[13] >= 10:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBD" and attr[11] in ["A", "B", "C", "D", "Z"]:
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				z = '5_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '5_isy'
				elif 30 > attr[13] >= 20:
					z = '4_isy'
				elif 20 > attr[13] >= 10:
					z = '3_isy'
				elif attr[13] < 10:
					z = '2_isy'
				else:
					z = '0_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				if attr[11] in ["D", "G"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] in ["A", "B", "C", "D", "E", "F", "G", "H", "Z"]:
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBF":
				if attr[11] in ["A", "B"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "C"):
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
				if (attr[11] == "D"):
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
				if attr[11] in ["C", "D"]:
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBG":
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				z = '2_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB":
				if attr[11] in ["AA", "AB", "AC", "AD", "AE"]:
					z = '2_isy'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["BA", "BB", "BC"]:
					z = '2_isy'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDD" and attr[11] in ["A", "B", "C", "D", "E"]:
				z = '2_isy'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					#db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDE":
				if attr[11] in ["A", "C", "D", "E"] and attr[12] == "A":
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "C", "D", "E"] and attr[12] == "B":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			try:
				db.commit()
			except:
				pass

			z = '-'
			sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
		z = '5'
		sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE Zustandsklasse_D is Null
							"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass
		sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE Zustandsklasse_B is Null
							"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass
		sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_S = ?
							WHERE Zustandsklasse_S is Null
							"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		for i in liste_pk:
			# die nummerierung muss für dwa umgekehrt werden 5 wird zu 0, 4 wird zu 1, 3 wird zu 2, 2 wird zu 3, 1 wird zu 4, 0 wird zu 5 !
			data = (i,)
			sql = """UPDATE untersuchdat_haltung_bewertung
					   SET Zustandsklasse_S = (Case 
					   WHEN Zustandsklasse_S = '5_isy'  THEN 0
					   WHEN Zustandsklasse_S = '4_isy'  THEN 1
					   WHEN Zustandsklasse_S = '3_isy'  THEN 2
					   WHEN Zustandsklasse_S = '2_isy'  THEN 3
					   WHEN Zustandsklasse_S = '1_isy'  THEN 4
					   WHEN Zustandsklasse_S = '0_isy'  THEN 5
					   ELSE Zustandsklasse_S
					   END)
					   WHERE untersuchdat_haltung_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = """UPDATE untersuchdat_haltung_bewertung
								   SET Zustandsklasse_B = (Case 
								   WHEN Zustandsklasse_B = '5_isy'  THEN 0
								   WHEN Zustandsklasse_B = '4_isy'  THEN 1
								   WHEN Zustandsklasse_B = '3_isy'  THEN 2
								   WHEN Zustandsklasse_B = '2_isy'  THEN 3
								   WHEN Zustandsklasse_B = '1_isy'  THEN 4
								   WHEN Zustandsklasse_B = '0_isy'  THEN 5
								   ELSE Zustandsklasse_B
								   END)
								   WHERE untersuchdat_haltung_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = """UPDATE untersuchdat_haltung_bewertung
											   SET Zustandsklasse_D = (Case 
											   WHEN Zustandsklasse_D = '5_isy'  THEN 0
											   WHEN Zustandsklasse_D = '4_isy'  THEN 1
											   WHEN Zustandsklasse_D = '3_isy'  THEN 2
											   WHEN Zustandsklasse_D = '2_isy'  THEN 3
											   WHEN Zustandsklasse_D = '1_isy'  THEN 4
											   WHEN Zustandsklasse_D = '0_isy'  THEN 5
											   ELSE Zustandsklasse_D
											   END)
											   WHERE untersuchdat_haltung_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass


		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('haltungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_haltung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_haltung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HALTUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_haltung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_haltung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'haltungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		haltungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HALTUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), haltungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(haltungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def einzelfallbetrachtung_leitung(self):

		date = self.date+'%'
		db = self.db
		db_x = db
		data = db
		leitung = self.leitung
		haltung = self.haltung
		crs = self.crs
		liste_pk =[]
		db1 = spatialite_connect(data)
		curs1 = db1.cursor()

		# nach Isybau

		data = db
		db = spatialite_connect(data)
		curs = db.cursor()

		if self.datetype == 'Importdatum':

			if self.check_cb['cb18']:
				sql = """SELECT
							untersuchdat_anschlussleitung_bewertung.pk,
							untersuchdat_anschlussleitung_bewertung.untersuchleit,
							NULL,
							untersuchdat_anschlussleitung_bewertung.schoben,
							untersuchdat_anschlussleitung_bewertung.schunten,
							untersuchdat_anschlussleitung_bewertung.id,
							untersuchdat_anschlussleitung_bewertung.videozaehler,
							untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
							untersuchdat_anschlussleitung_bewertung.station,
							untersuchdat_anschlussleitung_bewertung.timecode,
							untersuchdat_anschlussleitung_bewertung.kuerzel,
							untersuchdat_anschlussleitung_bewertung.charakt1,
							untersuchdat_anschlussleitung_bewertung.charakt2,
							untersuchdat_anschlussleitung_bewertung.quantnr1,
							untersuchdat_anschlussleitung_bewertung.quantnr2,
							untersuchdat_anschlussleitung_bewertung.streckenschaden,
							untersuchdat_anschlussleitung_bewertung.pos_von,
							untersuchdat_anschlussleitung_bewertung.pos_bis,
							untersuchdat_anschlussleitung_bewertung.foto_dateiname,
							untersuchdat_anschlussleitung_bewertung.film_dateiname,
							untersuchdat_anschlussleitung_bewertung.baujahr,
							untersuchdat_anschlussleitung_bewertung.bw_bs,
							untersuchdat_anschlussleitung_bewertung.createdat,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							anschlussleitungen.createdat,
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_D,
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_S,
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_B
							FROM
							untersuchdat_anschlussleitung_bewertung, anschlussleitungen
							WHERE
							anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit
							AND(untersuchdat_anschlussleitung_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
							OR
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
							OR
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND untersuchdat_anschlussleitung_bewertung.createdat like ? """
				data = (date,)
				curs.execute(sql, data)

		if self.datetype == 'Befahrungsdatum':

			if self.check_cb['cb18']:
				sql = """SELECT
							untersuchdat_anschlussleitung_bewertung.pk,
							untersuchdat_anschlussleitung_bewertung.untersuchleit,
							NULL,
							untersuchdat_anschlussleitung_bewertung.schoben,
							untersuchdat_anschlussleitung_bewertung.schunten,
							untersuchdat_anschlussleitung_bewertung.id,
							untersuchdat_anschlussleitung_bewertung.videozaehler,
							untersuchdat_anschlussleitung_bewertung.inspektionslaenge,
							untersuchdat_anschlussleitung_bewertung.station,
							untersuchdat_anschlussleitung_bewertung.timecode,
							untersuchdat_anschlussleitung_bewertung.kuerzel,
							untersuchdat_anschlussleitung_bewertung.charakt1,
							untersuchdat_anschlussleitung_bewertung.charakt2,
							untersuchdat_anschlussleitung_bewertung.quantnr1,
							untersuchdat_anschlussleitung_bewertung.quantnr2,
							untersuchdat_anschlussleitung_bewertung.streckenschaden,
							untersuchdat_anschlussleitung_bewertung.pos_von,
							untersuchdat_anschlussleitung_bewertung.pos_bis,
							untersuchdat_anschlussleitung_bewertung.foto_dateiname,
							untersuchdat_anschlussleitung_bewertung.film_dateiname,
							untersuchdat_anschlussleitung_bewertung.baujahr,
							untersuchdat_anschlussleitung_bewertung.bw_bs,
							untersuchdat_anschlussleitung_bewertung.untersuchtag,
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							anschlussleitungen.createdat,
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_D,
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_S,
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_B
							FROM
							untersuchdat_anschlussleitung_bewertung, anschlussleitungen
							WHERE
							anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchleit
							AND(untersuchdat_anschlussleitung_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
							OR
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
							OR
							untersuchdat_anschlussleitung_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND untersuchdat_anschlussleitung_bewertung.untersuchtag like ? """
				data = (date,)
				curs.execute(sql, data)

		for attr in curs.fetchall():
			liste_pk.append(attr[0])

			if (attr[21] == "biegesteif" and attr[10] == "BAA" and (attr[11] == "A")) or (
					attr[21] == "biegesteif" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] < 6:
					z = '3_isy'
				elif 6 <= attr[13] < 15:
					z = '4_isy'
				elif attr[13] >= 15:
					z = '5_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_anschlussleitung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
				except:
					pass
				if attr[13] >= 50:
					z = '5_isy'
				elif 40 <= attr[13] < 50:
					z = '4_isy'
				elif 25 <= attr[13] < 40:
					z = '3_isy'
				elif 10 <= attr[13] < 25:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_anschlussleitung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			if (attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "A") or (
					attr[21] == "biegeweich" and attr[10] == "BAA" and attr[11] == "B"):
				if attr[13] >= 15:
					z = '5_isy'
				elif 10 <= attr[13] < 15:
					z = '4_isy'
				elif 6 <= attr[13] < 10:
					z = '3_isy'
				elif 2 <= attr[13] < 6:
					z = '2_isy'
				elif attr[13] < 2:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_anschlussleitung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
				if attr[13] >= 50:
					z = '5_isy'
				elif 40 <= attr[13] < 50:
					z = '4_isy'
				elif 25 <= attr[13] < 40:
					z = '3_isy'
				elif 10 <= attr[13] < 25:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_anschlussleitung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_anschlussleitung_bewertung.pk = ? 
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass

			# Tab A.3
			if attr[10] == "BAB":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "B") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] in ["A", "C", "D", "E"]:
					if attr[13] >= 10:
						z = '5_isy'
					elif 10 > attr[13] >= 5:
						z = '4_isy'
					elif 5 > attr[13] >= 2:
						z = '3_isy'
					elif 2 > attr[13] >= 0.5:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["B", "C"] and attr[12] == "B":
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "C") and attr[12] in ["A", "B", "C", "D", "E"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				continue
			elif attr[10] == "BAC":
				if attr[11] == "A":
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["A", "B"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						db.commit()
					except:
						pass
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "C":
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAD":
				if attr[11] == "A":
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "B" and attr[12] in ["A", "B"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			elif attr[10] == "BAE":
				if attr[13] >= 100:
					z = '3_isy'
				elif attr[13] < 100:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 100:
					z = '3_isy'
				elif 100 > attr[13] >= 10:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAF":
				if attr[11] == "A" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B" and attr[12] in ["A", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '5_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '4_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J" and attr[12] in ["B", "C", "D", "E", "Z"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D", "E", "Z"]:
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAG":
				if attr[13] >= 75:
					z = '5_isy'
				elif 75 > attr[13] >= 60:
					z = '4_isy'
				elif 60 > attr[13] >= 40:
					z = '3_isy'
				elif 40 > attr[13] >= 15:
					z = '2_isy'
				elif attr[13] < 15:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAH":
				if attr[11] in ["A"]:
					z = '2_isy'
					sql = f"""
						  UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["B", "C", "D"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAI":
				if attr[11] == "A" and attr[12] == "A":
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "A" and attr[12] in ["B", "C", "D"]:
					z = '3_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
								  UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAJ":
				if attr[11] == "A":
					if attr[25] / 1000 <= 0.4:
						if attr[13] >= 70:
							z = '5_isy'
						elif 70 > attr[13] >= 50:
							z = '4_isy'
						elif 50 > attr[13] >= 30:
							z = '3_isy'
						elif 30 > attr[13] >= 20:
							z = '2_isy'
						elif attr[13] < 20:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif 0.4 < attr[25] / 1000 <= 0.8:
						if attr[13] >= 80:
							z = '5_isy'
						elif 80 > attr[13] >= 60:
							z = '4_isy'
						elif 60 > attr[13] >= 40:
							z = '3_isy'
						elif 40 > attr[13] >= 20:
							z = '2_isy'
						elif attr[13] < 20:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif attr[25] / 1000 > 0.8:
						if attr[13] >= 90:
							z = '5_isy'
						elif 90 > attr[13] >= 65:
							z = '4_isy'
						elif 65 > attr[13] >= 40:
							z = '3_isy'
						elif 40 > attr[13] >= 20:
							z = '2_isy'
						elif attr[13] < 20:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					z = '1_isy'
					sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					if attr[13] >= 30:
						z = '5_isy'
					elif 30 > attr[13] >= 20:
						z = '4_isy'
					elif 20 > attr[13] >= 15:
						z = '3_isy'
					elif 15 > attr[13] >= 10:
						z = '2_isy'
					elif attr[13] < 10:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] < 10:
						z = '1_isy'
					elif attr[13] >= 10:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					if attr[25] / 1000 <= 0.2:
						if attr[13] >= 12:
							z = '5_isy'
						elif 12 > attr[13] >= 9:
							z = '4_isy'
						elif 9 > attr[13] >= 7:
							z = '3_isy'
						elif 7 > attr[13] >= 5:
							z = '2_isy'
						elif attr[13] < 5:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif 0.2 < attr[25] / 1000 <= 0.5:
						if attr[13] >= 6:
							z = '5_isy'
						elif 6 > attr[13] >= 4:
							z = '4_isy'
						elif 4 > attr[13] >= 3:
							z = '3_isy'
						elif 3 > attr[13] >= 2:
							z = '2_isy'
						elif attr[13] < 2:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					elif attr[25] / 1000 > 0.5:
						if attr[13] >= 6:
							z = '5_isy'
						elif 6 > attr[13] >= 4:
							z = '4_isy'
						elif 4 > attr[13] >= 3:
							z = '3_isy'
						elif 3 > attr[13] >= 1:
							z = '2_isy'
						elif attr[13] < 1:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
									  UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_D = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAK":
				if attr[11] == "A":
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "B":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "C":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "D":
					if attr[12] in ["A", "B", "C", "D"]:
						z = '2_isy'
						sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_B = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[12] == "C":
						z = '3_isy'
						sql = f"""
										UPDATE untersuchdat_haltung_bewertung
										SET Zustandsklasse_S = ?
										WHERE untersuchdat_haltung_bewertung.pk = ?
										"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif attr[11] == "E":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "H":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "I":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "J":
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "K":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "L":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "M":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "N":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z":
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAL":
				if attr[11] in ["A", "B"] and attr[12] in ["A", "B", "C", "D"]:
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["C", "D"] and attr[12] in ["A", "B", "C", "D"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "E" and attr[12] in ["A", "B", "C", "D"]:
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "F" and attr[12] in ["A", "B", "C", "D"]:
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "G" and attr[12] in ["A", "B", "C", "D"]:
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] == "Z" and attr[12] in ["A", "B", "C", "D"]:
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAM":
				if attr[11] in ["A", "B", "C"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["A", "C"]:
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] == "B":
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BAN":
				z = '3_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAO":
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BAP":
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '5_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBA":
				if attr[11] in ["A", "B", "C"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					if attr[13] >= 30:
						z = '5_isy'
					elif 30 > attr[13] >= 20:
						z = '4_isy'
					elif 20 > attr[13] >= 10:
						z = '3_isy'
					elif attr[13] < 10:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBB":
				if attr[11] in ["A", "B", "C", "Z"]:
					if attr[13] >= 30:
						z = '5_isy'
					elif 30 > attr[13] >= 20:
						z = '4_isy'
					elif 20 > attr[13] >= 10:
						z = '3_isy'
					elif attr[13] < 10:
						z = '2_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBC" and attr[11] in ["A", "B", "C", "Z"]:
				if attr[13] >= 50:
					z = '5_isy'
				elif 50 > attr[13] >= 40:
					z = '4_isy'
				elif 40 > attr[13] >= 25:
					z = '3_isy'
				elif 25 > attr[13] >= 10:
					z = '2_isy'
				elif attr[13] < 10:
					z = '1_isy'
				else:
					z = '0_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBD" and attr[11] in ["A", "B", "C", "D", "Z"]:
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '5_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				if attr[13] >= 30:
					z = '5_isy'
				elif 30 > attr[13] >= 20:
					z = '4_isy'
				elif 20 > attr[13] >= 10:
					z = '3_isy'
				elif attr[13] < 10:
					z = '2_isy'
				else:
					z = '0_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_B = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BBE":
				if attr[11] in ["D", "G"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[11] in ["A", "B", "C", "D", "E", "F", "G", "H", "Z"]:
					if attr[13] >= 50:
						z = '5_isy'
					elif 50 > attr[13] >= 35:
						z = '4_isy'
					elif 35 > attr[13] >= 20:
						z = '3_isy'
					elif 20 > attr[13] >= 5:
						z = '2_isy'
					elif attr[13] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBF":
				if attr[11] in ["A", "B"]:
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '1_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[11] == "C"):
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if (attr[11] == "D"):
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_S = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[11] in ["C", "D"]:
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_D = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BBG":
				z = '4_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_D = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '2_isy'
				sql = f"""
								UPDATE untersuchdat_haltung_bewertung
								SET Zustandsklasse_S = ?
								WHERE untersuchdat_haltung_bewertung.pk = ?
								"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDB":
				if attr[11] in ["AA", "AB", "AC", "AD", "AE"]:
					z = '2_isy'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["BA", "BB", "BC"]:
					z = '2_isy'
					sql = f"""
							UPDATE untersuchdat_haltung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_haltung_bewertung.pk = ?
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[10] == "BDD" and attr[11] in ["A", "B", "C", "D", "E"]:
				z = '2_isy'
				sql = f"""
						UPDATE untersuchdat_haltung_bewertung
						SET Zustandsklasse_B = ?
						WHERE untersuchdat_haltung_bewertung.pk = ?
						"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[10] == "BDE":
				if attr[11] in ["A", "C", "D", "E"] and attr[12] == "A":
					z = '4_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[11] in ["A", "C", "D", "E"] and attr[12] == "B":
					z = '3_isy'
					sql = f"""
									UPDATE untersuchdat_haltung_bewertung
									SET Zustandsklasse_B = ?
									WHERE untersuchdat_haltung_bewertung.pk = ?
									"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass

			try:
				db.commit()
			except:
				pass

			z = '-'
			sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
							SET Zustandsklasse_D = ?
							WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
							"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
							SET Zustandsklasse_B = ?
							WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
							"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
							SET Zustandsklasse_S = ?
							WHERE untersuchdat_anschlussleitung_bewertung.pk = ?
							"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
		z = '5'
		sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
							SET Zustandsklasse_D = ?
							WHERE Zustandsklasse_D is Null
							"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass
		sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
							SET Zustandsklasse_B = ?
							WHERE Zustandsklasse_B is Null
							"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass
		sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
							SET Zustandsklasse_S = ?
							WHERE Zustandsklasse_S is Null
							"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		for i in liste_pk:
			# die nummerierung muss für dwa umgekehrt werden 5 wird zu 0, 4 wird zu 1, 3 wird zu 2, 2 wird zu 3, 1 wird zu 4, 0 wird zu 5 !
			data = (i,)
			sql = """UPDATE untersuchdat_anschlussleitung_bewertung
					   SET Zustandsklasse_S = (Case 
					   WHEN Zustandsklasse_S = '5_isy'  THEN 0
					   WHEN Zustandsklasse_S = '4_isy'  THEN 1
					   WHEN Zustandsklasse_S = '3_isy'  THEN 2
					   WHEN Zustandsklasse_S = '2_isy'  THEN 3
					   WHEN Zustandsklasse_S = '1_isy'  THEN 4
					   WHEN Zustandsklasse_S = '0_isy'  THEN 5
					   ELSE Zustandsklasse_S
					   END)
					   WHERE untersuchdat_anschlussleitung_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = """UPDATE untersuchdat_anschlussleitung_bewertung
								   SET Zustandsklasse_B = (Case 
								   WHEN Zustandsklasse_B = '5_isy'  THEN 0
								   WHEN Zustandsklasse_B = '4_isy'  THEN 1
								   WHEN Zustandsklasse_B = '3_isy'  THEN 2
								   WHEN Zustandsklasse_B = '2_isy'  THEN 3
								   WHEN Zustandsklasse_B = '1_isy'  THEN 4
								   WHEN Zustandsklasse_B = '0_isy'  THEN 5
								   ELSE Zustandsklasse_B
								   END)
								   WHERE untersuchdat_anschlussleitung_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = """UPDATE untersuchdat_anschlussleitung_bewertung
											   SET Zustandsklasse_D = (Case 
											   WHEN Zustandsklasse_D = '5_isy'  THEN 0
											   WHEN Zustandsklasse_D = '4_isy'  THEN 1
											   WHEN Zustandsklasse_D = '3_isy'  THEN 2
											   WHEN Zustandsklasse_D = '2_isy'  THEN 3
											   WHEN Zustandsklasse_D = '1_isy'  THEN 4
											   WHEN Zustandsklasse_D = '0_isy'  THEN 5
											   ELSE Zustandsklasse_D
											   END)
											   WHERE untersuchdat_anschlussleitung_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass


		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('anschlussleitungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'untersuchdat_anschlussleitung_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		untersuchdat_anschlussleitung_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_HA_LEITUNGEN.value
		vlayer = QgsVectorLayer(uri.uri(), untersuchdat_anschlussleitung_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(untersuchdat_anschlussleitung_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/untersuchdat_haltung_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'anschlussleitungen_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		anschlussleitungen_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_HA_LEITUNGEN_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), anschlussleitungen_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(anschlussleitungen_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/haltungen_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def einzelfallbetrachtung_schacht(self):
		date = self.date+'%'
		db = self.db
		db_x = db
		crs = self.crs
		liste_pk = []

		data = db
		db1 = spatialite_connect(data)
		curs1 = db1.cursor()
		# nach Isybau

		data = db
		db = spatialite_connect(data)
		curs = db.cursor()
		if self.datetype == 'Importdatum':
			sql = """SELECT
							Untersuchdat_schacht_bewertung.pk,
							Untersuchdat_schacht_bewertung.untersuchsch,
							Untersuchdat_schacht_bewertung.id,
							Untersuchdat_schacht_bewertung.videozaehler,
							Untersuchdat_schacht_bewertung.timecode,
							Untersuchdat_schacht_bewertung.kuerzel,
							Untersuchdat_schacht_bewertung.charakt1,
							Untersuchdat_schacht_bewertung.charakt2,
							Untersuchdat_schacht_bewertung.quantnr1,
							Untersuchdat_schacht_bewertung.quantnr2,
							Untersuchdat_schacht_bewertung.streckenschaden,
							Untersuchdat_schacht_bewertung.pos_von,
							Untersuchdat_schacht_bewertung.pos_bis,
							Untersuchdat_schacht_bewertung.bereich,
							Untersuchdat_schacht_bewertung.foto_dateiname,
							Untersuchdat_schacht_bewertung.bw_bs,
							Untersuchdat_schacht_bewertung.createdat,
									schaechte.schnam,
									schaechte.material,
									schaechte.createdat,
									Untersuchdat_schacht_bewertung.Zustandsklasse_D,
									Untersuchdat_schacht_bewertung.Zustandsklasse_S,
									Untersuchdat_schacht_bewertung.Zustandsklasse_B
									FROM
									Untersuchdat_schacht_bewertung, schaechte
									WHERE
									schaechte.schnam = Untersuchdat_schacht_bewertung.untersuchsch
									AND(Untersuchdat_schacht_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
									OR
									Untersuchdat_schacht_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
									OR
									Untersuchdat_schacht_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND Untersuchdat_schacht_bewertung.createdat like ? """
			data = (date,)
			curs.execute(sql, data)

		elif self.datetype == 'Befahrungsdatum':
			sql = """SELECT
							Untersuchdat_schacht_bewertung.pk,
							Untersuchdat_schacht_bewertung.untersuchsch,
							Untersuchdat_schacht_bewertung.id,
							Untersuchdat_schacht_bewertung.videozaehler,
							Untersuchdat_schacht_bewertung.timecode,
							Untersuchdat_schacht_bewertung.kuerzel,
							Untersuchdat_schacht_bewertung.charakt1,
							Untersuchdat_schacht_bewertung.charakt2,
							Untersuchdat_schacht_bewertung.quantnr1,
							Untersuchdat_schacht_bewertung.quantnr2,
							Untersuchdat_schacht_bewertung.streckenschaden,
							Untersuchdat_schacht_bewertung.pos_von,
							Untersuchdat_schacht_bewertung.pos_bis,
							Untersuchdat_schacht_bewertung.bereich,
							Untersuchdat_schacht_bewertung.foto_dateiname,
							Untersuchdat_schacht_bewertung.bw_bs,
							Untersuchdat_schacht_bewertung.untersuchtag,
									schaechte.schnam,
									schaechte.material,
									schaechte.createdat,
									Untersuchdat_schacht_bewertung.Zustandsklasse_D,
									Untersuchdat_schacht_bewertung.Zustandsklasse_S,
									Untersuchdat_schacht_bewertung.Zustandsklasse_B
									FROM
									Untersuchdat_schacht_bewertung, schaechte
									WHERE
									schaechte.schnam = Untersuchdat_schacht_bewertung.untersuchsch
									AND (Untersuchdat_schacht_bewertung.Zustandsklasse_D = 'Einzelfallbetrachtung'
									OR
									Untersuchdat_schacht_bewertung.Zustandsklasse_B = 'Einzelfallbetrachtung'
									OR
									Untersuchdat_schacht_bewertung.Zustandsklasse_S = 'Einzelfallbetrachtung') AND Untersuchdat_schacht_bewertung.untersuchtag like ? """
			data = (date,)
			curs.execute(sql, data)



		for attr in curs.fetchall():
			liste_pk.append(attr[0])

			if attr[5] == "DAA":
				if attr[6] in ["A", "B"] and attr[13] in ["B", "C", "D", "F"] and attr[15] == "biegeweich":
					if attr[8] >= 40:
						z = '5_isy'
					elif 40 > attr[8] >= 30:
						z = '4_isy'
					elif 30 > attr[8] >= 20:
						z = '3_isy'
					elif 20 > attr[8] >= 10:
						z = '2_isy'
					elif attr[8] < 10:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] in ["A", "B"] and attr[13] in ["B", "C", "D", "F"] and attr[
					15] == "biegesteif":
					if attr[8] >= 40:
						z = '5_isy'
					elif 40 > attr[8] >= 30:
						z = '4_isy'
					elif 30 > attr[8] >= 20:
						z = '3_isy'
					elif 20 > attr[8] >= 10:
						z = '2_isy'
					elif attr[8] < 10:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
					z = '3_isy'
					sql = f"""
						  UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAB":
				if attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "F", "H", "I", "J"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif (attr[6] == "B"):
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[7] == "A") and attr[13] in ["B", "C", "D", "F"]:
						if attr[13] >= 8:
							z = '5_isy'
						elif 8 > attr[13] >= 5:
							z = '4_isy'
						elif 5 > attr[13] >= 3:
							z = '3_isy'
						elif 3 > attr[13] >= 1:
							z = '2_isy'
						elif attr[13] < 1:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if (attr[7] == "B") and attr[13] in ["B", "C", "D", "F"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[7] in ["C", "D", "E"] and attr[13] in ["B", "C", "D", "F"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif (attr[6] == "C"):
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[7] in ["A", "B", "C", "D", "E"] and attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[7] == "A") and attr[13] in ["B", "C", "D", "F"]:
						if attr[13] >= 8:
							z = '5_isy'
						elif 8 > attr[13] >= 5:
							z = '4_isy'
						elif 5 > attr[13] >= 3:
							z = '3_isy'
						elif 3 > attr[13] >= 1:
							z = '2_isy'
						elif attr[13] < 1:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if (attr[7] == "B") and attr[13] in ["B", "C", "D", "F"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[7] in ["C", "D", "E"] and attr[13] in ["B", "C", "D", "F"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAC":
				if attr[6] == "A":
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '5_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "F"]:
						z = '5_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAD":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B" and attr[7] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "B" and attr[7] == "B":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["H", "I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '5_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F"]:
						z = '5_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "F", "H", "I", "J"]:
						z = '5_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAE":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					if attr[8] >= 100:
						z = '2_isy'
					elif attr[8] < 100:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					if attr[8] >= 100:
						z = '3_isy'
					elif attr[8] < 100:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[13] in ["C", "D", "F"]:
					if attr[8] > 100:
						z = '3_isy'
					elif 100 >= attr[8] > 10:
						z = '2_isy'
					elif attr[8] <= 10:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAF":
				if attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E",
																								 "F"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "A" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "B" and attr[7] in ["A", "E", "Z"] and attr[13] in ["B", "C", "D", "E", "F"]:
					z = '2_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "B" and attr[7] in ["A", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E",
																								   "F"]:
					z = '2_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "D" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E",
																								   "F"]:
					z = '3_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "D" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "E" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E",
																								   "F"]:
					z = '4_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "E" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "F" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E",
																								   "F"]:
					z = '2_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "F" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "G" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D", "E",
																								   "F"]:
					z = '3_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "G" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "H" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["B", "C", "D" "E",
																								   "F"]:
					z = '4_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "H" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '1_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "I" and attr[7] in ["A", "C", "D", "E", "Z"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '5_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "J" and attr[7] in ["B", "C", "D", "E"]:
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass

						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
				elif attr[6] == "K" and attr[7] in ["A", "B", "C", "D", "E", "Z"] and attr[13] in ["I", "J"]:
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] == "Z" and attr[7] in ["A", "B", "C", "D", "E", "Z"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
						# db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DAG" and attr[6] in ["", "NULL", "None", None, "not found"] and attr[7] in ["", "NULL",
																										 "None", None,
																		 "not found"]:
				if attr[13] in ["C", "D", "E", "F"]:
					if attr[8] >= 400:
						z = '5_isy'
					elif 400 > attr[8] >= 300:
						z = '4_isy'
					elif 300 > attr[8] >= 200:
						z = '3_isy'
					elif 200 > attr[8] >= 100:
						z = '2_isy'
					elif attr[8] < 100:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif (attr[13] == "I" or attr[13] == "J"):
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAH":
				if attr[6] in ["B", "C", "D"] and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							# db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAI":
				if attr[6] == "A" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[7] in ["", "NULL", "None", None, "not found"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAJ" and attr[6] in ["A", "B", "C"]:
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["B", "C", "D", "F"]:
					z = '1_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAK":
				if attr[6] == "A" and attr[13] in ["C", "D", "E", "F", "H"]:
					if attr[8] >= 40:
						z = '5_isy'
					elif 40 > attr[8] >= 30:
						z = '4_isy'
					elif 30 > attr[8] >= 20:
						z = '3_isy'
					elif 20 > attr[8] >= 10:
						z = '2_isy'
					elif attr[8] < 10:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "A" and attr[13] in ["I", "J"]:
					if attr[8] >= 0:
						z = '5_isy'
					elif 50 > attr[8] >= 35:
						z = '4_isy'
					elif 35 > attr[8] >= 20:
						z = '3_isy'
					elif 20 > attr[8] >= 5:
						z = '2_isy'
					elif attr[8] < 5:
						z = '1_isy'
					else:
						z = '0_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "D":
					if attr[7] in ["A", "B", "C", "D"] and attr[13] in ["I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[7] == "C") and attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "E":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						if attr[8] >= 40:
							z = '5_isy'
						elif 40 > attr[8] >= 30:
							z = '4_isy'
						elif 30 > attr[8] >= 20:
							z = '3_isy'
						elif 20 > attr[8] >= 10:
							z = '2_isy'
						elif attr[8] < 10:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '5_isy'
						elif 50 > attr[8] >= 35:
							z = '4_isy'
						elif 35 > attr[8] >= 20:
							z = '3_isy'
						elif 20 > attr[8] >= 5:
							z = '2_isy'
						elif attr[8] < 5:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "G":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "H":
					if attr[13] in ["I", "J"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "I":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
				elif attr[6] == "J":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "K":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "L":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "M":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "N":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
				elif attr[6] == "Z":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DAL":
				if attr[6] == "A":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "B":
					if attr[13] in ["C", "D", "E", "F", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "D":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "E":
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H"]:
						if attr[8] >= 40:
							z = '5_isy'
						elif 40 > attr[8] >= 30:
							z = '4_isy'
						elif 30 > attr[8] >= 20:
							z = '3_isy'
						elif 20 > attr[8] >= 10:
							z = '2_isy'
						elif attr[8] < 10:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						if attr[8] >= 50:
							z = '5_isy'
						elif 50 > attr[8] >= 35:
							z = '4_isy'
						elif 35 > attr[8] >= 20:
							z = '3_isy'
						elif 20 > attr[8] >= 5:
							z = '2_isy'
						elif attr[8] < 5:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "F":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "G":
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif (attr[13] == "I" or attr[13] == "J"):
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "Z" and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '2_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAM":
				if attr[6] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[13] == "I" or attr[13] == "J"):
						z = '3_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_D = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				if (attr[6] == "A" or attr[13] == "C"):
					if attr[13] in ["B", "C", "D", "F"]:
						z = '2_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				if attr[6] == "B":
					if attr[13] in ["B", "C", "D", "F"]:
						z = '1_isy'
						sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET Zustandsklasse_S = ?
									WHERE Untersuchdat_schacht_bewertung.pk = ? 
									"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				continue
			elif attr[5] == "DAN":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if (attr[13] == "I" or attr[13] == "J"):
					z = '3_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '3_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAO":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '3_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
					# db.commit()
					except:
						pass
				if (attr[13] == "I" or attr[13] == "J"):
					z = '4_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '4_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAP":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '3_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if (attr[13] == "I" or attr[13] == "J"):
					z = '4_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '5_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_S = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DAQ":
				if attr[6] in ["A", "C", "D", "F", "G", "H", "I", "J", "K"] and attr[13] in ["C", "D", "F"]:
					z = '4_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "B") and attr[13] in ["C", "D", "F"]:
					z = '5_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "E") and attr[13] in ["C", "D", "F"]:
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if (attr[6] == "Z") and attr[13] in ["C", "D", "F"]:
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DAR":
				if attr[6] in ["A", "C", "F"] and (attr[13] == "A"):
					z = '5_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[6] == "B" or attr[6] == "E") and (attr[13] == "A"):
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[6] == "D") and (attr[13] == "A"):
					z = '4_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[6] == "G" or attr[6] == "H") and (attr[13] == "A"):
					z = '3_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				if (attr[6] == "Z") and (attr[13] == "A"):
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBA":
				if attr[6] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if (attr[13] == "I" or attr[13] == "J"):
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_D = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET Zustandsklasse_B = ?
								WHERE Untersuchdat_schacht_bewertung.pk = ? 
								"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					continue
			elif attr[5] == "DBB":
				if attr[6] in ["A", "B", "C", "Z"] and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '2_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
			elif attr[5] == "DBC":
				if attr[6] in ["C", "Z"]:
					if attr[13] == "J":
						if attr[8] >= 300:
							z = '4_isy'
						elif 300 > attr[8] >= 100:
							z = '3_isy'
						elif 100 > attr[8] >= 50:
							z = '2_isy'
						elif attr[8] < 50:
							z = '1_isy'
						else:
							z = '0_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					if attr[13] == "H":
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
			elif attr[5] == "DBD":
				if attr[13] in ["C", "D", "E", "F", "H"]:
					z = '3_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[13] in ["I", "J"]:
					z = '4_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[13] in ["B", "C", "D", "E", "F"]:
					z = '5_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				continue
			elif attr[5] == "DBE":
				if attr[6] in ["A", "B", "C"] and attr[13] in ["I", "J"]:
					z = '2_isy'
					sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
						continue
					except:
						pass
				if attr[6] in ["D", "E", "F", "G", "H", "Z"] and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '3_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						#db.commit()
					except:
						pass
				if attr[6] in ["D", "G"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
					elif attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				continue
			elif attr[5] == "DBF":
				if attr[6] in ["A", "B"] and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '1_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
							continue
						except:
							pass
				elif attr[6] == "C" and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
				elif (attr[6] == "D") and attr[7] in ["A", "B", "C"]:
					if attr[13] in ["B", "C", "D", "E", "F"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_S = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["C", "D", "E", "F", "H"]:
						z = '3_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["I", "J"]:
						z = '4_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_D = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
					if attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
						z = '2_isy'
						sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
							SET Zustandsklasse_B = ?
							WHERE Untersuchdat_schacht_bewertung.pk = ? 
							"""
						data = (z, attr[0])
						try:
							curs.execute(sql, data)
							#db.commit()
						except:
							pass
			elif attr[5] == "DBG" and attr[13] in ["I", "J"]:
				z = '4_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_D = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
				# db.commit()
				except:
					pass
				z = '2_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_S = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCH" and (attr[6] == "A") and (attr[13] == "H"):
				z = '2_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCI" and (attr[6] == "A") and (attr[13] == "I"):
				z = '2_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCJ":
				if attr[6] in ["B", "F"] and (attr[13] == "F"):
					z = '5_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[6] in ["C", "D", "G", "H"] and (attr[13] == "F"):
					z = '2_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			elif attr[5] == "DCL" and attr[6] in ["A", "B", "C"] and attr[7] == "A" and (
					attr[13] == "F"):
				z = '2_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCM" and attr[6] in ["B", "C"] and (attr[13] == "A"):
				z = '2_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[5] == "DCN" and (attr[6] == "B") and (attr[13] == "J"):
				z = '2_isy'
				sql = f"""
					UPDATE Untersuchdat_schacht_bewertung
					SET Zustandsklasse_B = ?
					WHERE Untersuchdat_schacht_bewertung.pk = ? 
					"""
				data = (z, attr[0])
				try:
					curs.execute(sql, data)
					# db.commit()
					continue
				except:
					pass
			elif attr[5] == "DDE" and attr[6] in ["A", "C", "D", "E"]:
				if attr[7] == "A" and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '4_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
				elif attr[7] == "B" and attr[13] in ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J"]:
					z = '3_isy'
					sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ? 
						"""
					data = (z, attr[0])
					try:
						curs.execute(sql, data)
						# db.commit()
						continue
					except:
						pass
			try:
				db.commit()
			except:
				pass

			z = '-'
			sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_D = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?
						"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?
						"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				#db.commit()
			except:
				pass
			sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_S = ?
						WHERE Untersuchdat_schacht_bewertung.pk = ?
						"""
			data = (z, attr[0])
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
		z = '5'
		sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_D = ?
						WHERE Zustandsklasse_D is Null
						"""
		data = (z,)
		try:
			curs.execute(sql, data)
			#db.commit()
		except:
			pass
		sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_B = ?
						WHERE Zustandsklasse_B is Null
						"""
		data = (z,)
		try:
			curs.execute(sql, data)
			#db.commit()
		except:
			pass
		sql = f"""
						UPDATE Untersuchdat_schacht_bewertung
						SET Zustandsklasse_S = ?
						WHERE Zustandsklasse_S is Null
						"""
		data = (z,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		for i in liste_pk:
			# die nummerierung muss für dwa umgekehrt werden 5 wird zu 0, 4 wird zu 1, 3 wird zu 2, 2 wird zu 3, 1 wird zu 4, 0 wird zu 5 !
			data = (i,)
			sql = """UPDATE Untersuchdat_schacht_bewertung
					   SET Zustandsklasse_S = (Case 
					   WHEN Zustandsklasse_S = '5_isy'  THEN 0
					   WHEN Zustandsklasse_S = '4_isy'  THEN 1
					   WHEN Zustandsklasse_S = '3_isy'  THEN 2
					   WHEN Zustandsklasse_S = '2_isy'  THEN 3
					   WHEN Zustandsklasse_S = '1_isy'  THEN 4
					   WHEN Zustandsklasse_S = '0_isy'  THEN 5
					   ELSE Zustandsklasse_S
					   END)
					   WHERE Untersuchdat_schacht_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = """UPDATE Untersuchdat_schacht_bewertung
								   SET Zustandsklasse_B = (Case 
								   WHEN Zustandsklasse_B = '5_isy'  THEN 0
								   WHEN Zustandsklasse_B = '4_isy'  THEN 1
								   WHEN Zustandsklasse_B = '3_isy'  THEN 2
								   WHEN Zustandsklasse_B = '2_isy'  THEN 3
								   WHEN Zustandsklasse_B = '1_isy'  THEN 4
								   WHEN Zustandsklasse_B = '0_isy'  THEN 5
								   ELSE Zustandsklasse_B
								   END)
								   WHERE Untersuchdat_schacht_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass
			sql = """UPDATE Untersuchdat_schacht_bewertung
											   SET Zustandsklasse_D = (Case 
											   WHEN Zustandsklasse_D = '5_isy'  THEN 0
											   WHEN Zustandsklasse_D = '4_isy'  THEN 1
											   WHEN Zustandsklasse_D = '3_isy'  THEN 2
											   WHEN Zustandsklasse_D = '2_isy'  THEN 3
											   WHEN Zustandsklasse_D = '1_isy'  THEN 4
											   WHEN Zustandsklasse_D = '0_isy'  THEN 5
											   ELSE Zustandsklasse_D
											   END)
											   WHERE Untersuchdat_schacht_bewertung.pk = ? ;"""
			try:
				curs.execute(sql, data)
				db.commit()
			except:
				pass

		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('schaechte_untersucht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'Untersuchdat_schacht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		Untersuchdat_schacht_bewertung = enums.LAYERBEZ.ZK_EINZELSCHAEDEN_SCHAECHTE.value
		vlayer = QgsVectorLayer(uri.uri(), Untersuchdat_schacht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(Untersuchdat_schacht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/Untersuchdat_schacht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

		uri = QgsDataSourceUri()
		uri.setDatabase(db_x)
		schema = ''
		table = 'schaechte_untersucht_bewertung'
		geom_column = 'geom'
		uri.setDataSource(schema, table, geom_column)
		schaechte_untersucht_bewertung = enums.LAYERBEZ.ZK_ZUSTAND_SCHAECHTE_GESAMT.value
		vlayer = QgsVectorLayer(uri.uri(), schaechte_untersucht_bewertung, 'spatialite')
		x = QgsProject.instance()
		try:
			x.removeMapLayer(x.mapLayersByName(schaechte_untersucht_bewertung)[0].id())
		except:
			pass

		x = os.path.dirname(os.path.abspath(__file__))
		vlayer.loadNamedStyle(x + '/schaechte_untersucht_bewertung_dwa.qml')
		#QgsProject.instance().addMapLayer(vlayer)
		group = 'Ergebnisse'
		layersRoot = QgsProject.instance().layerTreeRoot()
		QgsProject.instance().addMapLayer(vlayer, False)
		atcGroup = layersRoot.findGroup(group)
		if atcGroup is None:
			atcGroup = layersRoot.addGroup(group)
		atcGroup.addLayer(vlayer)

	def tab_dwa_haltung(self):
		#tabellen DWA anlegen und vorhandene Zustandsklassen in richtige Spalte kopieren
		date = self.date
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()


		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_haltung_bewertung AS SELECT * FROM untersuchdat_haltung"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass


		sql = """
			SELECT
				haltungen.haltnam,
				haltungen.material,
				haltungen.hoehe,
				untersuchdat_haltung_bewertung.untersuchhal
			FROM haltungen
			INNER JOIN untersuchdat_haltung_bewertung  ON haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal
		"""


		try:
			curs.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs.fetchall():

			untersuchleit = attr1[0]
			try:
				curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE untersuchdat_haltung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE untersuchdat_haltung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass
			else:
				continue
		db.commit()
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Zustandsklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Zustandsklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Zustandsklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""Update untersuchdat_haltung_bewertung set Zustandsklasse_B = ZB ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_haltung_bewertung set Zustandsklasse_D = ZD ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_haltung_bewertung set Zustandsklasse_S = ZS ;""")
		except:
			pass
		sql = """CREATE TABLE IF NOT EXISTS haltungen_untersucht_bewertung AS SELECT * FROM haltungen_untersucht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_dichtheit INTEGER ;""")
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_standsicherheit INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_betriebssicherheit INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN objektklasse_gesamt INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN hydraulische_auslastung TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN lage_grundwasser TEXT;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN ueberdeckung INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN bodengruppe TEXT ;""")
		# db.commit()
		except:
			pass

		#Objektklasse berechnen für jede Haltung dafür abfragen

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung
									SET objektklasse_dichtheit =
									(SELECT min(Zustandsklasse_D)
									FROM untersuchdat_haltung_bewertung
									WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_D <> '-'
									GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung
									SET objektklasse_standsicherheit =
									(SELECT min(Zustandsklasse_S)
									FROM untersuchdat_haltung_bewertung
									WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_S <> '-'
									GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE haltungen_untersucht_bewertung
									SET objektklasse_betriebssicherheit =
									(SELECT min(Zustandsklasse_B)
									FROM untersuchdat_haltung_bewertung
									WHERE untersuchdat_haltung_bewertung.untersuchhal = haltungen_untersucht_bewertung.haltnam AND Zustandsklasse_B <> '-'
									GROUP BY untersuchdat_haltung_bewertung.untersuchhal);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung
									set objektklasse_standsicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung
									set objektklasse_dichtheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update haltungen_untersucht_bewertung
									set objektklasse_betriebssicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""Update
									haltungen_untersucht_bewertung
									SET
									objektklasse_gesamt =
									(
									   SELECT MIN(wert)
									   FROM (
										   SELECT objektklasse_dichtheit AS wert
										   UNION ALL
										   SELECT objektklasse_standsicherheit
										   UNION ALL
										   SELECT objektklasse_betriebssicherheit
									   )
									   WHERE wert IS NOT NULL
								   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('haltungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

	def tab_dwa_leitung(self):
		#tabellen DWA anlegen und vorhandene Zustandsklassen in richtige Spalte kopieren
		date = self.date
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()


		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_anschlussleitung_bewertung AS SELECT * FROM untersuchdat_anschlussleitung"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass

		sql = """
				SELECT
					anschlussleitungen.leitnam,
					anschlussleitungen.material,
					anschlussleitungen.hoehe,
					untersuchdat_haltung_bewertung.untersuchhal
				FROM anschlussleitungen
				INNER JOIN untersuchdat_anschlussleitung_bewertung ON anschlussleitungen.leitnam = untersuchdat_anschlussleitung_bewertung.untersuchhal
			"""

		try:
			curs.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs.fetchall():

			untersuchleit = attr1[0]
			try:
				curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC", "PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk", "Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton", "Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
					UPDATE untersuchdat_anschlussleitung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK", "GFK Glasfaserverstärkter Kunststoff",
							"GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST", "KST Nichtidentifizier Kunststoff",
							"PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP", "PP Polypropylen",
							"PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							"Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							"Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							"Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
					  UPDATE untersuchdat_anschlussleitung_bewertung
						SET bw_bs = ?
						WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = ?
						"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass
			else:
				continue
		db.commit()
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Zustandsklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Zustandsklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Zustandsklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""Update untersuchdat_anschlussleitung_bewertung set Zustandsklasse_B = ZB ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_anschlussleitung_bewertung set Zustandsklasse_D = ZD ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_anschlussleitung_bewertung set Zustandsklasse_S = ZS ;""")
		except:
			pass
		sql = """CREATE TABLE IF NOT EXISTS anschlussleitungen_untersucht_bewertung AS SELECT * FROM anschlussleitungen_untersucht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_dichtheit INTEGER ;""")
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_standsicherheit INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_betriebssicherheit INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN objektklasse_gesamt INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN hydraulische_auslastung TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN lage_grundwasser TEXT;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN ueberdeckung INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN bodengruppe TEXT ;""")
		# db.commit()
		except:
			pass

		#Objektklasse berechnen für jede Haltung dafür abfragen

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung
									SET objektklasse_dichtheit =
									(SELECT min(Zustandsklasse_D)
									FROM untersuchdat_anschlussleitung_bewertung
									WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = anschlussleitungen_untersucht_bewertung.haltnam AND Zustandsklasse_D <> '-'
									GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchhal);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung
									SET objektklasse_standsicherheit =
									(SELECT min(Zustandsklasse_S)
									FROM untersuchdat_anschlussleitung_bewertung
									WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = anschlussleitungen_untersucht_bewertung.haltnam AND Zustandsklasse_S <> '-'
									GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchhal);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE anschlussleitungen_untersucht_bewertung
									SET objektklasse_betriebssicherheit =
									(SELECT min(Zustandsklasse_B)
									FROM untersuchdat_anschlussleitung_bewertung
									WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = anschlussleitungen_untersucht_bewertung.haltnam AND Zustandsklasse_B <> '-'
									GROUP BY untersuchdat_anschlussleitung_bewertung.untersuchhal);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung
									set objektklasse_standsicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung
									set objektklasse_dichtheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update anschlussleitungen_untersucht_bewertung
									set objektklasse_betriebssicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""Update
									anschlussleitungen_untersucht_bewertung
									SET
									objektklasse_gesamt =
									(
								   SELECT MIN(wert)
								   FROM (
									   SELECT objektklasse_dichtheit AS wert
									   UNION ALL
									   SELECT objektklasse_standsicherheit
									   UNION ALL
									   SELECT objektklasse_betriebssicherheit
								   )
								   WHERE wert IS NOT NULL
							   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('anschlussleitungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

	def tab_dwa_schacht(self):
		#tabellen DWA anlegen und vorhandene Zustandsklassen in richtige Spalte kopieren
		date = self.date
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()


		sql = """CREATE TABLE IF NOT EXISTS Untersuchdat_schacht_bewertung AS SELECT * FROM Untersuchdat_schacht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass

		sql = """
					SELECT
						schaechte.schnam,
						schaechte.material,
						Untersuchdat_schacht_bewertung.untersuchsch
					FROM schaechte
						INNER JOIN Untersuchdat_schacht_bewertung  ON schaechte.schnam = Untersuchdat_schacht_bewertung.untersuchsch
				"""

		try:
			curs.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs.fetchall():
			try:
				curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC",
							"PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk",
							"Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton",
							"Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
							UPDATE Untersuchdat_schacht_bewertung
								SET bw_bs = ?
								WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
								"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK",
							  "GFK Glasfaserverstärkter Kunststoff",
							  "GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST",
							  "KST Nichtidentifizier Kunststoff",
							  "PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP",
							  "PP Polypropylen",
							  "PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							  "Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							  "Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							  "Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
							  UPDATE Untersuchdat_schacht_bewertung
								SET bw_bs = ?
								WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
								"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass
		db.commit()

		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Zustandsklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Zustandsklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Zustandsklasse_B TEXT ;""")
		except:
			pass

		try:
			curs.execute("""Update Untersuchdat_schacht_bewertung set Zustandsklasse_B = ZB ;""")
		except:
			pass
		try:
			curs.execute("""Update Untersuchdat_schacht_bewertung set Zustandsklasse_D = ZD ;""")
		except:
			pass
		try:
			curs.execute("""Update Untersuchdat_schacht_bewertung set Zustandsklasse_S = ZS ;""")
		except:
			pass
		sql = """CREATE TABLE IF NOT EXISTS schaechte_untersucht_bewertung AS SELECT * FROM schaechte_untersucht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_dichtheit INTEGER ;""")
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_standsicherheit INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_betriebssicherheit INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN objektklasse_gesamt INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN hydraulische_auslastung TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN lage_grundwasser TEXT;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN ueberdeckung INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN bodengruppe TEXT ;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_dichtheit =
									(SELECT min(Zustandsklasse_D) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_D <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_standsicherheit =
									(SELECT min(Zustandsklasse_S) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_S <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""UPDATE schaechte_untersucht_bewertung 
									SET objektklasse_betriebssicherheit =
									(SELECT min(Zustandsklasse_B) 
									FROM Untersuchdat_schacht_bewertung
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = schaechte_untersucht_bewertung.schnam AND Zustandsklasse_B <> '-'
									GROUP BY Untersuchdat_schacht_bewertung.untersuchsch);""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_standsicherheit = '-'
									WHERE objektklasse_standsicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_dichtheit = '-'
									WHERE objektklasse_dichtheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""update schaechte_untersucht_bewertung 
									set objektklasse_betriebssicherheit = '-'
									WHERE objektklasse_betriebssicherheit IS NULL;""")
		# db.commit()
		except:
			pass

		try:
			curs.execute("""Update
									schaechte_untersucht_bewertung
									set
									objektklasse_gesamt =
									(
									   SELECT MIN(wert)
									   FROM (
										   SELECT objektklasse_dichtheit AS wert
										   UNION ALL
										   SELECT objektklasse_standsicherheit
										   UNION ALL
										   SELECT objektklasse_betriebssicherheit
									   )
									   WHERE wert IS NOT NULL
								   );""")
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('schaechte_untersucht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

	def tab_isybau_haltung(self):
		# tabellen ISYBAU anlegen und vorhandene Zustandsklassen in richtige Spalte kopieren

		date = self.date
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_haltung_bewertung AS SELECT * FROM untersuchdat_haltung"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass


		sql = """
					SELECT
						haltungen.haltnam,
						haltungen.material,
						haltungen.hoehe,
						untersuchdat_haltung_bewertung.untersuchhal
					FROM haltungen
					INNER JOIN untersuchdat_haltung_bewertung  ON haltungen.haltnam = untersuchdat_haltung_bewertung.untersuchhal
				"""

		try:
			curs.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs.fetchall():

			untersuchleit = attr1[0]
			try:
				curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC",
							"PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk",
							"Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton",
							"Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
							UPDATE untersuchdat_haltung_bewertung
								SET bw_bs = ?
								WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
								"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK",
							  "GFK Glasfaserverstärkter Kunststoff",
							  "GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST",
							  "KST Nichtidentifizier Kunststoff",
							  "PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP",
							  "PP Polypropylen",
							  "PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							  "Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							  "Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							  "Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
							  UPDATE untersuchdat_haltung_bewertung
								SET bw_bs = ?
								WHERE untersuchdat_haltung_bewertung.untersuchhal = ?
								"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass
			else:
				continue
		db.commit()

		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Schadensklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Schadensklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN Schadensklasse_B TEXT ;""")
		except:
			pass


		try:
			curs.execute("""Update untersuchdat_haltung_bewertung set Schadensklasse_B = ZB ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_haltung_bewertung set Schadensklasse_D = ZD ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_haltung_bewertung set Schadensklasse_S = ZS ;""")
		except:
			pass


		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN vorlaufige_Schadenszahl_D INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN vorlaufige_Schadenszahl_B INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_haltung_bewertung ADD COLUMN vorlaufige_Schadenszahl_S INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_haltung_bewertung
					SET vorlaufige_Schadenszahl_D = (Case 
					WHEN Schadensklasse_D = 1  THEN 10
					WHEN Schadensklasse_D = 2  THEN 100
					WHEN Schadensklasse_D = 3  THEN 200
					WHEN Schadensklasse_D = 4  THEN 300
					WHEN Schadensklasse_D = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_haltung_bewertung
					SET vorlaufige_Schadenszahl_B = (Case 
					WHEN Schadensklasse_B = 1  THEN 10
					WHEN Schadensklasse_B = 2  THEN 100
					WHEN Schadensklasse_B = 3  THEN 200
					WHEN Schadensklasse_B = 4  THEN 300
					WHEN Schadensklasse_B = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_haltung_bewertung
					SET vorlaufige_Schadenszahl_S = (Case 
					WHEN Schadensklasse_S = 1  THEN 10
					WHEN Schadensklasse_S = 2  THEN 100
					WHEN Schadensklasse_S = 3  THEN 200
					WHEN Schadensklasse_S = 4  THEN 300
					WHEN Schadensklasse_S = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass
		sql = """CREATE TABLE IF NOT EXISTS haltungen_untersucht_bewertung AS SELECT * FROM haltungen_untersucht"""
		curs.execute(sql)

		try:
			curs.execute(
				"""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Entwaesserungssystem TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Abwasserart TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Wasserschutzzone TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Grundwasserabstand INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Bodenart TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Lage_am_Umfang TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE haltungen_untersucht_bewertung ADD COLUMN Lage_an_Bauteilverbindung TEXT ;""")
		# db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_haltung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('haltungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

	def tab_isybau_leitung(self):
		# tabellen ISYBAU anlegen und vorhandene Zustandsklassen in richtige Spalte kopieren
		date = self.date
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()

		sql = """CREATE TABLE IF NOT EXISTS untersuchdat_anschlussleitung_bewertung AS SELECT * FROM untersuchdat_anschlussleitung"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass

		sql = """
						SELECT
							anschlussleitungen.leitnam,
							anschlussleitungen.material,
							anschlussleitungen.hoehe,
							untersuchdat_haltung_bewertung.untersuchhal
						FROM anschlussleitungen
						INNER JOIN untersuchdat_haltung_bewertung ON anschlussleitungen.leitnam = untersuchdat_haltung_bewertung.untersuchhal
					"""

		try:
			curs.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs.fetchall():

			untersuchleit = attr1[0]
			try:
				curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

			if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ", "FZ Fasezement",
							"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC",
							"PC Polymermodifizierter Zementbeton",
							"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB", "SPB Spannbeton",
							"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
							"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement", "Mauerwerk",
							"Ortbeton",
							"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton",
							"Spannbeton",
							"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
				bw_bs = "biegesteif"
				x = attr1[0]

				sql = f"""
							UPDATE untersuchdat_anschlussleitung_bewertung
								SET bw_bs = ?
								WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = ?
								"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass

			elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK",
							  "GFK Glasfaserverstärkter Kunststoff",
							  "GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST",
							  "KST Nichtidentifizier Kunststoff",
							  "PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP",
							  "PP Polypropylen",
							  "PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
							  "Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff", "Grauguß",
							  "Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
							  "Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
				bw_bs = 'biegeweich'
				x = attr1[0]

				sql = f"""
							  UPDATE untersuchdat_anschlussleitung_bewertung
								SET bw_bs = ?
								WHERE untersuchdat_anschlussleitung_bewertung.untersuchhal = ?
								"""
				data = (bw_bs, x)
				try:
					curs.execute(sql, data)
				except:
					pass
			else:
				continue
		db.commit()

		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Schadensklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Schadensklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN Schadensklasse_B TEXT ;""")
		except:
			pass


		try:
			curs.execute("""Update untersuchdat_anschlussleitung_bewertung set Schadensklasse_B = ZB ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_anschlussleitung_bewertung set Schadensklasse_D = ZD ;""")
		except:
			pass
		try:
			curs.execute("""Update untersuchdat_anschlussleitung_bewertung set Schadensklasse_S = ZS ;""")
		except:
			pass


		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN vorlaufige_Schadenszahl_D INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN vorlaufige_Schadenszahl_B INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE untersuchdat_anschlussleitung_bewertung ADD COLUMN vorlaufige_Schadenszahl_S INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_anschlussleitung_bewertung
					SET vorlaufige_Schadenszahl_D = (Case 
					WHEN Schadensklasse_D = 1  THEN 10
					WHEN Schadensklasse_D = 2  THEN 100
					WHEN Schadensklasse_D = 3  THEN 200
					WHEN Schadensklasse_D = 4  THEN 300
					WHEN Schadensklasse_D = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_anschlussleitung_bewertung
					SET vorlaufige_Schadenszahl_B = (Case 
					WHEN Schadensklasse_B = 1  THEN 10
					WHEN Schadensklasse_B = 2  THEN 100
					WHEN Schadensklasse_B = 3  THEN 200
					WHEN Schadensklasse_B = 4  THEN 300
					WHEN Schadensklasse_B = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE untersuchdat_anschlussleitung_bewertung
					SET vorlaufige_Schadenszahl_S = (Case 
					WHEN Schadensklasse_S = 1  THEN 10
					WHEN Schadensklasse_S = 2  THEN 100
					WHEN Schadensklasse_S = 3  THEN 200
					WHEN Schadensklasse_S = 4  THEN 300
					WHEN Schadensklasse_S = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass
		sql = """CREATE TABLE IF NOT EXISTS anschlussleitungen_untersucht_bewertung AS SELECT * FROM anschlussleitungen_untersucht"""
		curs.execute(sql)

		try:
			curs.execute(
				"""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Entwaesserungssystem TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Abwasserart TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Wasserschutzzone TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Grundwasserabstand INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Bodenart TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Lage_am_Umfang TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE anschlussleitungen_untersucht_bewertung ADD COLUMN Lage_an_Bauteilverbindung TEXT ;""")
		# db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('untersuchdat_anschlussleitung_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('anschlussleitungen_untersucht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

	def tab_isybau_schacht(self):
		# tabellen ISYBAU anlegen und vorhandene Zustandsklassen in richtige Spalte kopieren

		date = self.date
		db = self.db
		data = db
		crs = self.crs
		leitung = self.leitung
		haltung = self.haltung
		db_x = self.db
		db = spatialite_connect(data)
		curs = db.cursor()

		sql = """CREATE TABLE IF NOT EXISTS Untersuchdat_schacht_bewertung AS SELECT * FROM Untersuchdat_schacht"""
		curs.execute(sql)
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Beschreibung TEXT ;""")
		except:
			pass

		sql = """
							SELECT
								schaechte.schnam,
								schaechte.material,
								Untersuchdat_schacht_bewertung.untersuchsch
							FROM schaechte
								INNER JOIN Untersuchdat_schacht_bewertung  ON schaechte.schnam = Untersuchdat_schacht_bewertung.untersuchsch
						"""

		try:
			curs.execute(sql)
		except:
			iface.messageBar().pushMessage("Error",
										   "Die Klassifizierung der Haltungen/Leitungen konnte nicht ermittelt werden",
										   level=Qgis.Critical)

		for attr1 in curs.fetchall():

			untersuchleit = attr1[0]
			try:
				curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN bw_bs TEXT;""")
			except:
				pass

				if attr1[1] in ["AZ", "AZ Asbestzement", "B", "B Beton", "BS", "BS Betonsegmente ", "FZ",
								"FZ Fasezement",
								"MA", "MA Mauerwerk", "OB", "OB Ortbeton", "P", "P Polymerbeton", "PC",
								"PC Polymermodifizierter Zementbeton",
								"PCC", "PHB", "PHB Polyesterharz", "SFB", "SFB Stahlfaserbeton", "SPB",
								"SPB Spannbeton",
								"SB", "SB Stahlbeton", "STZ", "STZ Steinzeug", "SZB", "SZB Spritzbeton",
								"ZG", "ZG Ziegelwerk", "Asbestzement", "Beton", "Betonsegmente", "Fasezement",
								"Mauerwerk",
								"Ortbeton",
								"Polymerbeton", "Polymermodifizierter Zementbeton", "Polyesterharz", "Stahlfaserbeton",
								"Spannbeton",
								"Stahlbeton", "Steinzeug", "Spritzbeton", "Ziegelwerk"]:
					bw_bs = "biegesteif"
					x = attr1[0]

					sql = f"""
								UPDATE Untersuchdat_schacht_bewertung
									SET bw_bs = ?
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
									"""
					data = (bw_bs, x)
					try:
						curs.execute(sql, data)
					except:
						pass

				elif attr1[1] in ["CN", "CN Edelstahl", "EIS", "EIS Nichtidentifiziertes Metall", "GFK",
								  "GFK Glasfaserverstärkter Kunststoff",
								  "GG", "GG Grauguß", "GGG", "GGG Duktiles Gußeisen", "KST",
								  "KST Nichtidentifizier Kunststoff",
								  "PE", "PE Polyethylen", "PEHD", "PEHD Polyethylen", "PH", "PH Polyesterharz", "PP",
								  "PP Polypropylen",
								  "PVC", "PVC Polyvinylchlorid", "PVCU", "PVCU Polyvinylchlorid hart", "ST", "ST Stahl",
								  "Edelstahl", "Nichtidentifiziertes Metall", "Glasfaserverstärkter Kunststoff",
								  "Grauguß",
								  "Duktiles Gußeisen", "Nichtidentifizier Kunststoff", "Polyethylen", "Polyesterharz",
								  "Polypropylen", "Polyvinylchlorid", "Polyvinylchlorid hart", "Stahl"]:
					bw_bs = 'biegeweich'
					x = attr1[0]

					sql = f"""
								  UPDATE Untersuchdat_schacht_bewertung
									SET bw_bs = ?
									WHERE Untersuchdat_schacht_bewertung.untersuchsch = ?
									"""
					data = (bw_bs, x)
					try:
						curs.execute(sql, data)
					except:
						pass
			db.commit()

		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Schadensklasse_D TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Schadensklasse_S TEXT ;""")
		except:
			pass
		try:
			curs.execute("""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN Schadensklasse_B TEXT ;""")
		except:
			pass


		try:
			curs.execute("""Update Untersuchdat_schacht_bewertung set Schadensklasse_B = ZB ;""")
		except:
			pass
		try:
			curs.execute("""Update Untersuchdat_schacht_bewertung set Schadensklasse_D = ZD ;""")
		except:
			pass
		try:
			curs.execute("""Update Untersuchdat_schacht_bewertung set Schadensklasse_S = ZS ;""")
		except:
			pass


		try:
			curs.execute(
				"""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN vorlaufige_Schadenszahl_D INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN vorlaufige_Schadenszahl_B INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""ALTER TABLE Untersuchdat_schacht_bewertung ADD COLUMN vorlaufige_Schadenszahl_S INTEGER ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE Untersuchdat_schacht_bewertung
					SET vorlaufige_Schadenszahl_D = (Case 
					WHEN Schadensklasse_D = 1  THEN 10
					WHEN Schadensklasse_D = 2  THEN 100
					WHEN Schadensklasse_D = 3  THEN 200
					WHEN Schadensklasse_D = 4  THEN 300
					WHEN Schadensklasse_D = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE Untersuchdat_schacht_bewertung
					SET vorlaufige_Schadenszahl_B = (Case 
					WHEN Schadensklasse_B = 1  THEN 10
					WHEN Schadensklasse_B = 2  THEN 100
					WHEN Schadensklasse_B = 3  THEN 200
					WHEN Schadensklasse_B = 4  THEN 300
					WHEN Schadensklasse_B = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass

		try:
			curs.execute(
				"""UPDATE Untersuchdat_schacht_bewertung
					SET vorlaufige_Schadenszahl_S = (Case 
					WHEN Schadensklasse_S = 1  THEN 10
					WHEN Schadensklasse_S = 2  THEN 100
					WHEN Schadensklasse_S = 3  THEN 200
					WHEN Schadensklasse_S = 4  THEN 300
					WHEN Schadensklasse_S = 5  THEN 400
					ELSE NULL
					END
					) ;""")
		except:
			pass
		sql = """CREATE TABLE IF NOT EXISTS schaechte_untersucht_bewertung AS SELECT * FROM schaechte_untersucht"""
		curs.execute(sql)

		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Entwaesserungssystem TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Abwasserart TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Wasserschutzzone TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Grundwasserabstand INTEGER ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Bodenart TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute("""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Lage_am_Umfang TEXT ;""")
		# db.commit()
		except:
			pass
		try:
			curs.execute(
				"""ALTER TABLE schaechte_untersucht_bewertung ADD COLUMN Lage_an_Bauteilverbindung TEXT ;""")
		# db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('Untersuchdat_schacht_bewertung', 'geom', ?, 'LINESTRING', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass

		sql = """SELECT RecoverGeometryColumn('schaechte_untersucht_bewertung', 'geop', ?, 'POINT', 'XY');"""
		data = (crs,)
		try:
			curs.execute(sql, data)
			db.commit()
		except:
			pass