# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QGreenlandDownload
                                 A QGIS plugin
 Download QGreenland dataset
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-08-17
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Matteo Ghetta (Faunalia)
        email                : matteo.ghetta@faunalia.eu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import json

from qgis.PyQt import uic, QtWidgets

from qgis.core import(
    QgsSettings
)

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ui','qgreenland_server_dialog.ui'))



class QGreenlandServer(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(QGreenlandServer, self).__init__(parent)
        self.setupUi(self)

        self.settings = QgsSettings()

        # fill the combobox with the values
        self.server_list_combo.addItem(self.tr('NSIDC: http://qgreenland.apps.nsidc.org/layers/'), 'http://qgreenland.apps.nsidc.org/layers/')
        self.server_list_combo.addItem(self.tr('PGC: https://example.com/qgreenland'), 'https://example.com/qgreenland')

        self.buttonBox.accepted.connect(self.write_settings)

    def write_settings(self):

        self.settings.setValue("/QGreenland/server-chosen", True)

    def get_server(self):

        # if we have data (default links have been chosen) then get the url from the data
        # if a custom url has been entered get the text else get the text
        if self.server_list_combo.currentData():
            downloading_url = self.server_list_combo.currentData()
        else:
            downloading_url = self.server_list_combo.currentText()

        # save some setting in QgsSettings
        self.settings.setValue("/QGreenland/server-url", downloading_url)

        # return the url
        return downloading_url