<div style="text-align:center">
    <img width="200px" hight="200px" src="icon_full.png" alt="QGPT Agent Icon">
</div>

# QGPT Agent Documentation

QGPT Agent is a plugin for QGIS that allows users to interact with QGIS using natural language commands. It utilizes the advanced natural language processing capabilities of the OpenAI GPT model to automate various processes in QGIS. This significantly reduces the time and effort required to complete various tasks in QGIS.

https://user-images.githubusercontent.com/20235263/235729556-5913541c-c408-459d-bfad-1ce754c14542.mp4

## Installation

To install QGPT Agent, follow the steps below:

1. Open QGIS and go to the "Plugins" menu.
2. Select "Manage and Install Plugins".
3. In the "All" tab, search for "QGPT Agent".
4. Click on "Install Plugin" to install QGPT Agent.

To install from ZIP file 

1. Download the plugin zip file from the plugin repository or from Releases.
2. Open QGIS and go to the "Plugins" menu.
3. Select "Manage and Install Plugins".
4. In the "Installed" tab, click on the "Install from ZIP" button.
5. In the "Install Plugin" dialog box, click on the "Choose Plugin ZIP" button and select the downloaded zip file.
6. Click on "Install Plugin" to install the plugin.
7. Once the installation is complete, you should see a message confirming the successful installation of the plugin.
8. Close and reopen QGIS for the newly installed plugin to take effect.

## Open AI access tocken 

To get an OpenAI API access token, follow these steps:

1. Create an OpenAI account at https://beta.openai.com/signup/
2. Once you've created an account, navigate to the API page at https://platform.openai.com/account/api-keys .
3. Click on the "Create new API key" button to generate a new secret key.
4. Copy the API key and insert it in setting tab.

Note: Be sure to keep your API key secure, as it can be used to access your OpenAI resources and make API calls on your behalf.


## Usage

Once QGPT Agent is installed, you can use natural language commands to interact with QGIS. To use QGPT Agent, follow the steps below:

1. Open QGIS and load the data you want to work with.
2. In the QGIS menu, go to "Plugins" and select "QGPT Agent".
3. The QGPT Agent dialog box will appear. Type your natural language command in the text box provided.
4. Press "Enter" or click on "Send" to execute the command.

getting started <a href='https://youtu.be/OkYSWwpduiw'>here </a>

## Commands

QGPT Agent supports a wide range of natural language commands but, try to write command properly.

## Chat 

It can be worked as chat to answer your questions about GIS.





## Limitations

QGPT Agent is a powerful plugin that can automate various processes in QGIS. However, it has some limitations that users should be aware of. Some of the limitations of QGPT Agent are listed below:

- QGPT Agent requires an internet connection to use the OpenAI GPT model for natural language processing.
- QGPT Agent may not recognize some natural language commands correctly.
- QGPT Agent may not be able to perform some complex tasks that require multiple steps or complex workflows.
- QGPT Agent may not be suitable for users who prefer a more hands-on approach to working with QGIS.

## Conclusion

QGPT Agent is a powerful plugin that can help users automate various processes in QGIS using natural language commands. It utilizes the advanced natural language processing capabilities of the OpenAI GPT model to interpret natural language commands and execute them in QGIS. Although QGPT Agent has some limitations, it can be a valuable tool for users who want to streamline their workflow and save time and effort when working with QGIS.

## To be Done 


[+] Supporting step by step supervised execution (suggestion by Julius Petri).

[+] Multiple Prompt Support.

[+] Adding new tab to edit code and run it.

[+] Save History and setting.

[-] Support Complex analysis processes.

[-] Adding long-term memory.

[*] More prompt optimization.

## Disclaimer

It is important to exercise caution when using the "run directly" mode in QGPT Agent, as running code without any supervision may lead to unintended consequences or errors. While the natural language autonomous agent can automate tasks and save time, it is still important to review the generated code before executing it. This will ensure that the code aligns with your intended goals and does not cause any unintended side effects or errors. 

## Contact 
Email: momaabna2019@gmail.com
