# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Triple2Layer
                                 A QGIS plugin
 this plugin imports data
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-01-22
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Nerval Junior 
        email                : nerval1@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QVariant
from qgis.PyQt.QtGui import QIcon
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QProgressDialog
from qgis.PyQt.QtWidgets import QAction, QComboBox, QCheckBox, QLineEdit, QTableWidgetItem, QFileDialog, QInputDialog
from qgis.core import QgsVectorLayer, QgsField, QgsGeometry, QgsFeature, QgsProject,  Qgis, QgsTask, QgsTaskManager, QgsApplication, QgsMessageLog

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Triple2Layer_dialog import Triple2LayerDialog
import os.path
import json
import os

from functools import partial

plugin_dir = os.path.dirname(__file__)

from SPARQLWrapper import SPARQLWrapper, JSON, N3

import datadotworld as dw


dic_attr_type = {
    "String": QVariant.String,
    "Int": QVariant.Int,
    "Double": QVariant.Double,
}


path_plugin = os.path.dirname(__file__)
path_file = os.path.join(path_plugin, "endpoint.json")


class Triple2Layer:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Triple2Layer_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&QGISSPARQL')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Triple2Layer', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Triple2Layer/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Triple2Layer'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&QGISSPARQL'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Triple2LayerDialog()
            self.file_name = None
            self.endpoint_defaut()
            self.dlg.pushButton.clicked.connect(self.execute)
            self.dlg.button_box.rejected.connect(self.close)
            self.dlg.buttonSPARQL.clicked.connect(self.open_sparql)
            self.dlg.actionToken.triggered.connect(self.set_token)
            self.dlg.comboSourceType.textActivated.connect(
                self.endpoint_defaut)

        # show the dialog
        self.dlg.show()


    def execute(self):
        if self.check_attributes():
            self.save_endpoint()
            self.import_layer()
        else:
            self.erroOnLoadLayer = True
            self.errorMessage = "Select the geo atribute"
            self.check_if_imported_layer()
            print ("erroor")

    def set_token(self):

        token, ok = QInputDialog.getText(
            self.dlg, "Data.World Token", "Enter with token")
        if (ok and token != ""):
            os.environ['DW_AUTH_TOKEN'] = token

    def check_attributes(self):
        selected_geo = False

        self.geo_column = ""
        self.saveAttrs = []
        self.id_column = "id:integer"
        for row in range(self.dlg.tableAttributes.rowCount()):
            line_edit = self.dlg.tableAttributes.cellWidget(row, 4)
            attr_name = line_edit.text()

            item = self.dlg.tableAttributes.item(row, 3)
            var_name = item.text()

            check_id = self.dlg.tableAttributes.cellWidget(row, 1)
            check_geo = self.dlg.tableAttributes.cellWidget(row, 2)
            check = self.dlg.tableAttributes.cellWidget(row, 0)
            combo_type = self.dlg.tableAttributes.cellWidget(row, 5)

            if check_id.isChecked():
                self.id_column = attr_name

            if check_geo.isChecked():
                self.geo_column = attr_name
                selected_geo = True

            if check.isChecked() or check_id.isChecked():
                self.saveAttrs.append(
                    (attr_name, dic_attr_type[combo_type.currentText()], var_name))
        print ("check", selected_geo)
        return selected_geo

    def load_data_world(self, time):
        QgsMessageLog.logMessage('A tarefa já está em execução.', 'Triple2Layer')

        try:
            ds = dw.query(self.dlg.lineEndpoint.text(),
                      self.sparql, query_type='sparql')

            QgsMessageLog.logMessage('carregado os dados do dataworld.', 'Triple2Layer')
            dict = ds.dataframe.to_dict('records')
            return dict
        except:
            QgsMessageLog.logMessage('Fail to load from dataworld', 'Triple2Layer')
            self.errorMessage = 'Fail to load data from dataworld: check dataset name'
            self.erroOnLoadLayer = True


    def load_triple_store(self, time):
        try:
            sparql = SPARQLWrapper(self.dlg.lineEndpoint.text())
            sparql.setQuery(self.sparql)
            sparql.setReturnFormat(JSON)
            results = sparql.query().convert()
            return results["results"]["bindings"]
        except:
            QgsMessageLog.logMessage('Fail to load from triple store', 'Triple2Layer')
            self.errorMessage = 'Fail to load data from triple store: check triple store endpoint'
            self.erroOnLoadLayer = True

    def get_value(self, row, attr, source='dw'):
        if source == 'triple':
            return row[attr]['value']
        else:
            return row[attr]

    def create_layer(self, source, time, records):

        layer = QgsVectorLayer('Polygon?crs=epsg:4326?field=' +
                               self.id_column, self.dlg.lineLayer.text(), "memory")
        pr = layer.dataProvider()
        layer.startEditing()
        # não funcionou com o map ???
        attributes = [QgsField(x[0], x[1]) for x in self.saveAttrs]
        pr.addAttributes(attributes)
        layer.updateFields()

        features = []
        i = 0
        total = 0
        total = len(records)
        #verifica se o atributo de geometria esta correto
        geom = QgsGeometry.fromWkt( self.get_value(records[0], self.geo_column, source))
        print ("geommmmmm", geom)
        if geom.isNull():
            self.erroOnLoadLayer = True
            self.errorMessage = "Invalid geometry attribute, select a wkt attribute value"
            self.check_if_imported_layer()
            return

        QgsMessageLog.logMessage(
            'A tarefa já está concluindo. '+str(time) + "-" + str(total), 'Triple2Layer')

        progressDialog = QProgressDialog(
            "Importing layer...", "Cancel", 0, 0, self.iface.mainWindow())
        progressDialog.setWindowTitle("Importing layer")
        progressDialog.setLabelText("Importing features...")
        progressDialog.setMaximum(total)
        progressDialog.setValue(0)
        progressDialog.show()
        progressDialog.setCancelButton(None)

        for row in records:
            fet = QgsFeature()
            geom = QgsGeometry.fromWkt(
                self.get_value(row, self.geo_column, source))
            fet.setGeometry(geom)
            attrs = []
            for attr in self.saveAttrs:
                attrs.append(self.get_value(row, attr[2], source))
            fet.setAttributes(attrs)
            features.append(fet)
            i += 1
            progressDialog.setValue(i)
            progressDialog.setLabelText(
                "Importing feature {} of {}".format(i, total))
            QCoreApplication.processEvents()

        layer.addFeatures(features)
        layer.updateExtents()
        layer.commitChanges()
        QgsProject.instance().addMapLayer(layer)

        progressDialog.close()

        self.iface.messageBar().pushMessage(
            "Success", "Imported layer",
            level=Qgis.Success, duration=3)
        

    def check_if_imported_layer (self):
        self.iface.messageBar().clearWidgets()
        if self.erroOnLoadLayer == True:
            self.iface.messageBar().pushMessage(
            "Fail", self.errorMessage,
            level=Qgis.Warning, duration=3)
            


    def import_from_dataworld(self):

        if "DW_AUTH_TOKEN" not in os.environ:
            self.iface.messageBar().pushMessage(
                "Ooops", "Token not defined",
                level=Qgis.Info, duration=3
            )
            self.set_token()
        else:
            QgsMessageLog.logMessage('criando tarefa.', 'Triple2Layer')
            self.task = QgsTask.fromFunction('Importing a layer', self.load_data_world, on_finished=partial(self.create_layer, 'dw'))
            self.task.taskCompleted.connect(self.check_if_imported_layer)
            QgsApplication.taskManager().addTask(self.task)

    def save_endpoint(self):
        caminho = self.buscapath()
        source = self.dlg.comboSourceType.currentText()
        try:
            with open(caminho, "r") as arquivo:
                endpoints = json.load(arquivo)
        except:
            endpoints = {}

        url_ds = self.dlg.lineEndpoint.text()

        endpoints[source] = url_ds
    
        with open(caminho, "w") as arquivo:
            json.dump(endpoints, arquivo)

    def endpoint_defaut(self):
        caminho = self.buscapath()
        source = self.dlg.comboSourceType.currentText()
        try:
            with open(caminho, "r") as arquivo:
                endpoints = json.load(arquivo)
            endpoint = endpoints[source]
            self.dlg.lineEndpoint.setText(endpoint)
        except:
            self.dlg.lineEndpoint.setText("")

    def buscapath(self):
        path_plugin = os.path.dirname(__file__)
        path_file = os.path.join(path_plugin, "endpoint.json")
        return path_file

    def import_from_triple(self):
        QgsMessageLog.logMessage('criando tarefa.', 'Triple2Layer')
        self.task = QgsTask.fromFunction(
            'Importing a layer', self.load_triple_store, on_finished=partial(self.create_layer, 'triple'))
        self.task.taskCompleted.connect(self.check_if_imported_layer)
        QgsApplication.taskManager().addTask(self.task)

    def import_layer(self):

        self.erroOnLoadLayer = False

        source = self.dlg.comboSourceType.currentText()

        self.dlg.close()

        self.iface.messageBar().pushMessage(
                "Importing a layer", "Importing a layer ...",
                level=Qgis.Info, duration=10)

        if source == "Triple Store Endpoint":
            self.import_from_triple()
        else:
            self.import_from_dataworld()

    def open_sparql(self):
        self.file_name = str(QFileDialog.getOpenFileName(
            caption="Defining input file", filter="SPARQL(*.sparql)")[0])
        self.dlg.lineSPARQL.setText(self.file_name)

        try:
            with open(self.file_name, 'r') as file:
                data = file.read()
                self.sparql = data
                self.fill_table(data)
        except:
            return

    def geo_selected (self,row, state):
        #self.dlg.tableAttributes.
        w1 = self.dlg.tableAttributes.cellWidget(row, 4)
        w2 = self.dlg.tableAttributes.cellWidget(row, 5)
        if state == QtCore.Qt.Checked:
            w1.setEnabled(False)
            w2.setEnabled(False)  
            self.dlg.pushButton.setEnabled(True)
        else:
            w1.setEnabled(True)
            w2.setEnabled(True)
            self.dlg.pushButton.setEnabled(False)
        print (state)
        

    def fill_table(self, s):

        tokens = s.replace('\n', ' ').split(" ")
        tokens = list(filter(lambda x: x != '', tokens))
        print(tokens)
        tokens_upper = list(map(lambda x: x.upper(), tokens))
        start = tokens_upper.index('SELECT') + 1
        end = tokens_upper.index('WHERE')
        attributes = tokens[start:end]  # identificar os atributos
        attributes = list(map(lambda x: x[1:], attributes))
        print(attributes)

        self.dlg.tableAttributes.setRowCount(len(attributes))
        self.dlg.tableAttributes.setColumnCount(6)
        self.dlg.tableAttributes.setHorizontalHeaderLabels(
            ["Import?", "IDColumn?", "GeoColumn?", "Variable", "Attribute name", "Attribute type"])

        start = 0
        for attr in attributes:
            self.dlg.tableAttributes.setCellWidget(start, 0, QCheckBox())
            self.dlg.tableAttributes.setCellWidget(start, 1, QCheckBox())
            geo_check = QCheckBox()
            geo_check.stateChanged.connect (partial (self.geo_selected, start))
            self.dlg.tableAttributes.setCellWidget(start, 2, geo_check)
            self.dlg.tableAttributes.setItem(start, 3, QTableWidgetItem(attr))
            self.dlg.tableAttributes.setCellWidget(start, 4, QLineEdit(attr))
            comboBox = QComboBox()
            comboBox.addItem("String")
            comboBox.addItem("Int")
            comboBox.addItem("Double")
            self.dlg.tableAttributes.setCellWidget(start, 5, comboBox)
            start += 1

    def close(self):
        self.dlg.setVisible(False)
