# QGIS YOLOX Plugin - Installation Guide

## Table of Contents
1. [System Requirements](#system-requirements)
2. [Pre-Installation Steps](#pre-installation-steps)
3. [Installation Methods](#installation-methods)
4. [Post-Installation Configuration](#post-installation-configuration)
5. [Verification](#verification)
6. [Troubleshooting](#troubleshooting)

---

## System Requirements

### Minimum Requirements
- **Operating System**: Windows 10/11, Linux (Ubuntu 20.04+), macOS 10.15+
- **QGIS Version**: 3.36.2 or higher
- **Python**: 3.9+ (included with QGIS)
- **RAM**: 8GB
- **Storage**: 2GB free space (for models and dependencies)

### Recommended Requirements
- **RAM**: 16GB or more
- **GPU**: NVIDIA GPU with CUDA support
- **CUDA**: 11.7 or higher
- **Storage**: SSD with 10GB+ free space

### Software Dependencies

#### Required External Tools
- **exiftool**: GPS metadata extraction
  - Download: https://exiftool.org/
  - Verify installation: `exiftool -ver`

#### Python Packages
The following packages will be installed:
- PyTorch ≥2.0.0
- torchvision ≥0.15.0
- opencv-python ≥4.8.0
- numpy ≥1.24.0
- Pillow ≥10.0.0

---

## Pre-Installation Steps

### Step 1: Install QGIS

Download and install QGIS 3.36.2 or higher from https://qgis.org/

#### Windows
1. Download QGIS standalone installer
2. Run installer with admin privileges
3. Follow installation wizard

#### Linux (Ubuntu/Debian)
```bash
sudo apt-get update
sudo apt-get install qgis qgis-plugin-grass
```

#### macOS
```bash
brew install qgis
```

### Step 2: Install exiftool

#### Windows
1. Download from https://exiftool.org/
2. Extract exiftool(-k).exe
3. Rename to exiftool.exe
4. Add to system PATH:
   ```
   Control Panel → System → Advanced → Environment Variables
   Add exiftool directory to Path
   ```

#### Linux
```bash
sudo apt-get install libimage-exiftool-perl
```

#### macOS
```bash
brew install exiftool
```

**Verify Installation**:
```bash
exiftool -ver
# Should output: 12.xx (or higher)
```

### Step 3: Prepare QGIS Python Environment

#### Windows: Open OSGeo4W Shell
1. Start Menu → QGIS 3.36.2 → OSGeo4W Shell
2. This opens a shell with QGIS Python environment

#### Linux/macOS: Use system terminal
```bash
# Python is available as python3 in QGIS environment
```

---

## Installation Methods

### Method 1: QGIS Plugin Repository (Future)

*Note: Plugin is not yet published to official repository*

1. Open QGIS
2. Go to **Plugins → Manage and Install Plugins**
3. Search for "QGIS YOLOX"
4. Click **Install Plugin**
5. Dependencies will be installed automatically

### Method 2: Manual Installation (Current)

#### Step A: Download Plugin

Option 1: Clone from Git
```bash
cd %TEMP%
git clone https://github.com/yourusername/qgis-yolox.git
```

Option 2: Download ZIP
1. Download ZIP file from releases page
2. Extract to temporary folder

#### Step B: Copy to QGIS Plugins Directory

**Windows**:
```bash
# Copy plugin folder to QGIS plugins directory
xcopy /E /I c:\00_DEV\QGIS_YOLOX "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox"
```

**Linux**:
```bash
cp -r /path/to/QGIS_YOLOX ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/qgis_yolox
```

**macOS**:
```bash
cp -r /path/to/QGIS_YOLOX ~/Library/Application\ Support/QGIS/QGIS3/profiles/default/python/plugins/qgis_yolox
```

#### Step C: Install Python Dependencies

**From OSGeo4W Shell (Windows)**:
```bash
cd "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox"
python3 -m pip install -r requirements.txt
```

**Linux/macOS**:
```bash
cd ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/qgis_yolox
python3 -m pip install -r requirements.txt
```

**GPU Support (CUDA)**:
```bash
# For GPU acceleration, install PyTorch with CUDA
pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu118
```

#### Step D: Download YOLOX Weights

Create models directory and download weights:

```bash
cd "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox"
mkdir resources\models

# Download yolox-s (recommended)
curl -L -o resources\models\yolox_s.pth https://github.com/Megvii-BaseDetection/YOLOX/releases/download/0.1.1rc0/yolox_s.pth
```

Available models:
- **yolox_nano.pth**: Smallest, fastest (0.91M parameters)
- **yolox_tiny.pth**: Very fast (5.06M parameters)
- **yolox_s.pth**: **Recommended** balanced (9.0M parameters)
- **yolox_m.pth**: More accurate (25.3M parameters)
- **yolox_l.pth**: High accuracy (54.2M parameters)

### Method 3: Developer Installation

For development and testing:

```bash
# Clone repository
git clone https://github.com/yourusername/qgis-yolox.git
cd qgis-yolox

# Create symbolic link to QGIS plugins directory (Windows - run as admin)
mklink /D "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox" "%CD%"

# Linux/macOS
ln -s "$(pwd)" ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/qgis_yolox

# Install dependencies
pip install -r requirements.txt
```

---

## Post-Installation Configuration

### Step 1: Enable Plugin in QGIS

1. Start QGIS
2. Go to **Plugins → Manage and Install Plugins**
3. Click **Installed** tab
4. Find **QGIS YOLOX**
5. Check the checkbox to enable

### Step 2: Verify Plugin Loaded

Check for:
- Toolbar icon (YOLOX icon)
- Menu entry: **Plugins → QGIS YOLOX**
- Processing Toolbox: **YOLOX Object Detection** group

### Step 3: Configure Settings

1. Click Settings icon or go to **Plugins → QGIS YOLOX → Settings**
2. Configure:
   - **Model Path**: Point to downloaded yolox_s.pth
   - **Device**: Select CUDA (if GPU available) or CPU
   - **Confidence Threshold**: 0.5 (default)
   - **Frame Interval**: 30 (default - process 1 frame/second at 30 FPS)

### Step 4: Test Installation

#### Quick Test from Python Console

Open QGIS Python Console (**Plugins → Python Console**):

```python
# Test imports
from qgis_yolox.models.detection_model import DetectionModel
from qgis_yolox.utils import yolox_utils

# Test detection model
model = DetectionModel()
print(f"COCO classes: {len(model.class_names)}")  # Should print: 80

# Test YOLOX utils
classes = yolox_utils.get_coco_class_names()
print(f"First class: {classes[0]}")  # Should print: person

print("✓ Plugin installed successfully!")
```

---

## Verification

### Verify Processing Provider

1. Open **Processing → Toolbox** (Ctrl+Alt+T)
2. Look for **YOLOX Object Detection** group
3. Should contain:
   - Detect Objects in Video
   - Batch Process Videos

### Verify GPU Acceleration (Optional)

From Python Console:
```python
import torch

print(f"CUDA available: {torch.cuda.is_available()}")
if torch.cuda.is_available():
    print(f"GPU: {torch.cuda.get_device_name(0)}")
    print(f"CUDA version: {torch.version.cuda}")
else:
    print("Running on CPU mode")
```

### Run Full Integration Tests

From OSGeo4W Shell:
```bash
cd "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox"
python tests\test_plugin_integration.py
```

Expected output:
```
============================================================
QGIS YOLOX Plugin - Integration Tests
============================================================
Testing imports...
  ✓ Utils imports successful
  ...
Total: 7/7 tests passed (100.0%)
============================================================
```

---

## Troubleshooting

### Issue 1: Plugin Not Appearing in QGIS

**Symptoms**: Plugin not visible in Plugins menu or Manager

**Solutions**:

1. **Check plugin directory path**:
   ```bash
   # Windows - should exist
   dir "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox"

   # Linux
   ls ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/qgis_yolox
   ```

2. **Check metadata.txt**:
   - Must be in plugin root directory
   - Must contain all required fields (name, qgisMinimumVersion, etc.)

3. **Check __init__.py**:
   - Must contain `classFactory(iface)` function

4. **Check QGIS Python Console for errors**:
   - Go to **Plugins → Python Console**
   - Look for red error messages

5. **Enable debugging**:
   ```python
   # In Python Console
   import qgis.utils
   qgis.utils.showWarning = print  # Show all warnings
   ```

### Issue 2: Import Errors (ModuleNotFoundError)

**Symptoms**: "ModuleNotFoundError: No module named 'torch'"

**Solutions**:

1. **Ensure dependencies installed in QGIS Python**:
   ```bash
   # From OSGeo4W Shell (Windows)
   python3 -m pip list | findstr torch

   # Linux/macOS
   python3 -m pip list | grep torch
   ```

2. **Reinstall dependencies**:
   ```bash
   cd "%APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\qgis_yolox"
   python3 -m pip install -r requirements.txt --force-reinstall
   ```

3. **Check Python version**:
   ```python
   # In QGIS Python Console
   import sys
   print(sys.version)  # Should be 3.9+
   ```

### Issue 3: exiftool Not Found

**Symptoms**: "Error: exiftool executable not found"

**Solutions**:

1. **Verify exiftool installation**:
   ```bash
   exiftool -ver
   ```

2. **Add exiftool to PATH** (Windows):
   - System Properties → Advanced → Environment Variables
   - Edit Path variable
   - Add exiftool directory
   - Restart QGIS

3. **Specify full path in code** (workaround):
   - Edit `utils/video_utils.py`
   - Change exiftool command to use full path

### Issue 4: GPU Not Detected

**Symptoms**: "CUDA not available" despite having NVIDIA GPU

**Solutions**:

1. **Check NVIDIA drivers**:
   ```bash
   nvidia-smi
   ```

2. **Install CUDA Toolkit**:
   - Download from: https://developer.nvidia.com/cuda-downloads
   - Version must match PyTorch CUDA version

3. **Install PyTorch with CUDA**:
   ```bash
   pip3 uninstall torch torchvision
   pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu118
   ```

4. **Verify in Python Console**:
   ```python
   import torch
   print(torch.cuda.is_available())
   print(torch.version.cuda)
   ```

### Issue 5: Processing Algorithms Not Appearing

**Symptoms**: No "YOLOX Object Detection" in Processing Toolbox

**Solutions**:

1. **Check metadata.txt has**:
   ```ini
   hasProcessingProvider=yes
   ```

2. **Restart QGIS** after editing metadata.txt

3. **Manually refresh Processing**:
   - Processing → Options → Providers
   - Uncheck/recheck "YOLOX Object Detection"

4. **Check provider registration**:
   ```python
   # In Python Console
   from qgis.core import QgsApplication
   providers = QgsApplication.processingRegistry().providers()
   yolox = [p for p in providers if p.id() == 'yolox']
   print(f"YOLOX provider found: {len(yolox) > 0}")
   ```

### Issue 6: "No GPS data found in video"

**Symptoms**: Plugin reports no GPS data despite video having GPS

**Solutions**:

1. **Verify video has GPS metadata**:
   ```bash
   exiftool -ee video.mp4 | findstr GPS
   ```

2. **Check supported formats**:
   - DJI drones: Camera:GPSLatitude
   - GoPro: Track1:GPSLatitude
   - Generic: GPS:GPSLatitude

3. **Try different video format**:
   - Some formats store GPS differently
   - Convert to MP4 or MOV if needed

### Issue 7: Out of Memory During Processing

**Symptoms**: "CUDA out of memory" or system freeze

**Solutions**:

1. **Increase frame interval**:
   - Use 60 instead of 30 (process fewer frames)

2. **Use smaller YOLOX model**:
   - Switch from yolox-s to yolox-nano or yolox-tiny

3. **Switch to CPU**:
   - Slower but uses less GPU memory
   - Set device='cpu' in settings

4. **Process smaller video segments**:
   - Split large videos into chunks
   - Process separately

---

## Next Steps

After successful installation:

1. **Read User Guide**: See [usage.md](usage.md) for workflow tutorials
2. **Review API Documentation**: See [api.md](api.md) for programming reference
3. **Run Sample Workflow**: Try Processing Toolbox algorithms
4. **Configure for Your Needs**: Adjust model, thresholds, intervals

---

## Getting Help

- **Documentation**: Check `docs/` directory
- **GitHub Issues**: Report bugs and request features
- **QGIS Community**: https://gis.stackexchange.com/ (tag: qgis-plugin)
- **Email Support**: contact@qgis-yolox.org

---

**Installation Guide Version**: 1.0.0
**Last Updated**: 2025-12-28
**Tested on**: QGIS 3.36.2, Windows 11, Linux (Ubuntu 22.04)
