# QGIS YOLOX Plugin - Testing Guide

## Overview

This document describes how to run tests for the QGIS YOLOX plugin.

## Test Environment

Tests must be run in the QGIS Python environment because they depend on QGIS libraries (PyQt5, qgis.core, etc.).

## Running Tests

### Method 1: Using OSGeo4W Shell (Recommended)

1. Open **OSGeo4W Shell** from your QGIS installation
   - Windows: Start Menu → QGIS 3.36.2 → OSGeo4W Shell

2. Navigate to the plugin directory:
   ```bash
   cd c:\00_DEV\QGIS_YOLOX
   ```

3. Run the integration tests:
   ```bash
   python tests\test_plugin_integration.py
   ```

### Method 2: Using Batch Script

1. Set the QGIS_PYTHON_PATH environment variable:
   ```batch
   set QGIS_PYTHON_PATH=C:\Program Files\QGIS 3.36.2\bin\python-qgis.bat
   ```

2. Run the batch script:
   ```batch
   run_tests.bat
   ```

### Method 3: From QGIS Python Console

1. Open QGIS
2. Open Python Console (Plugins → Python Console)
3. Run:
   ```python
   import sys
   sys.path.append(r'c:\00_DEV\QGIS_YOLOX')
   exec(open(r'c:\00_DEV\QGIS_YOLOX\tests\test_plugin_integration.py').read())
   ```

## Test Coverage

The integration tests cover:

1. **Import Tests**: Verify all modules can be imported
2. **Model Instantiation**: Test VideoModel and DetectionModel creation
3. **DetectionModel Operations**: CRUD operations, filtering, statistics
4. **Coordinate Utilities**: GPS interpolation, distance calculation
5. **YOLOX Utilities**: Image preprocessing, NMS, IoU computation
6. **Config Utilities**: Configuration management
7. **Processing Algorithms**: Algorithm parameter definitions

## Expected Output

When all tests pass, you should see:

```
============================================================
QGIS YOLOX Plugin - Integration Tests
============================================================

Testing imports...
  ✓ Utils imports successful
  ✓ Model imports successful
  ✓ Controller imports successful
  ✓ Processing provider imports successful

Testing model instantiation...
  ✓ VideoModel instantiation successful
  ✓ DetectionModel instantiation successful

Testing DetectionModel operations...
  ✓ Add detection successful
  ✓ Get detections successful
  ✓ Filter by confidence successful
  ✓ Get statistics successful
  ✓ Clear detections successful

Testing coordinate utilities...
  ✓ GPS interpolation successful
  ✓ Distance calculation successful (XXXXX.XXm)

Testing YOLOX utilities...
  ✓ Get COCO class names successful
  ✓ Image preprocessing successful
  ✓ NMS successful (kept X/3 boxes)
  ✓ IoU computation successful (IoU=X.XXX)

Testing config utilities...
  ✓ Get default config successful

Testing Processing algorithms...
  ✓ VideoDetectionAlgorithm instantiation successful
  ✓ BatchProcessingAlgorithm instantiation successful

============================================================
TEST SUMMARY
============================================================
Import Test................................. ✓ PASS
Model Instantiation........................ ✓ PASS
DetectionModel Operations.................. ✓ PASS
Coordinate Utils........................... ✓ PASS
YOLOX Utils................................ ✓ PASS
Config Utils............................... ✓ PASS
Processing Algorithms...................... ✓ PASS
============================================================
Total: 7/7 tests passed (100.0%)
============================================================
```

## Troubleshooting

### Import Errors

If you get import errors for QGIS modules:
- Ensure you're running in QGIS Python environment (not system Python)
- Check QGIS version is 3.36.2 or higher
- Verify PYTHONPATH includes QGIS libraries

### Missing Dependencies

If tests fail due to missing dependencies:
- Install required packages: `pip install -r requirements.txt`
- Note: Some dependencies (torch, opencv) may need to be installed in QGIS Python environment

### YOLOX Model Not Found

The YOLOX utilities use placeholder implementations. Full YOLOX integration requires:
1. Installing YOLOX package
2. Downloading pre-trained weights
3. See `utils/yolox_utils.py` for integration notes

## Unit Tests

Individual unit tests for specific modules can be found in:
- `test_video_model.py` - Video processing tests
- `test_detection.py` - Detection model tests
- `test_geopackage.py` - GeoPackage export tests
- `test_coordinate_utils.py` - Coordinate transformation tests

## Continuous Integration

For CI/CD pipelines, use:
```bash
python tests/test_plugin_integration.py && echo "Tests passed" || exit 1
```

## Writing New Tests

When adding new tests:
1. Follow the existing test structure
2. Use descriptive test function names (test_<feature>)
3. Include print statements for progress tracking
4. Return True/False for test success
5. Add to `run_all_tests()` results list
