# QGIS YOLOX Plugin

A QGIS plugin for GPS-synchronized video object detection using YOLOX deep learning model, with GeoPackage export capabilities.

## Overview

QGIS YOLOX plugin enables you to:
- Process GPS-synchronized videos (from drones, action cameras, etc.)
- Detect objects and facilities using YOLOX deep learning model
- Export detection results as GeoPackage files
- Automatically add results to QGIS map canvas
- Support for 80 COCO dataset classes (vehicles, people, buildings, etc.)

## Features

### Core Functionality
- **GPS Video Processing**: Extract and process videos with embedded GPS metadata
- **YOLOX Object Detection**: State-of-the-art object detection using YOLOX models
- **GeoPackage Export**: Save detection results in standard GIS format
- **QGIS Integration**: Seamless integration with QGIS Processing framework
- **Multiple Object Classes**: Detect road facilities, buildings, vehicles, and more

### Supported Data

#### Video Formats
- MP4, AVI, MOV, and other common formats
- GPS metadata embedded in video (DJI drones, GoPro, etc.)

#### Detection Classes
- Road facilities (traffic signs, traffic lights, etc.)
- Buildings and structures
- Vehicles and moving objects
- 80 COCO dataset classes

## Requirements

### Software Requirements
- QGIS 3.36.2 or higher
- Python 3.9 or higher

### Python Dependencies
```
torch>=2.0.0
torchvision>=0.15.0
opencv-python>=4.8.0
numpy>=1.24.0
Pillow>=10.0.0
```

## Installation

### Method 1: QGIS Plugin Manager (Coming Soon)
1. Open QGIS
2. Go to `Plugins` > `Manage and Install Plugins`
3. Search for "QGIS YOLOX"
4. Click `Install Plugin`

### Method 2: Manual Installation
1. Download the plugin ZIP file
2. Extract to QGIS plugins directory:
   - Windows: `C:\Users\<USER>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins`
   - Linux: `~/.local/share/QGIS/QGIS3/profiles/default/python/plugins`
   - macOS: `~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins`
3. Install Python dependencies:
   ```bash
   pip install torch torchvision opencv-python numpy Pillow
   ```
4. Restart QGIS
5. Enable the plugin in `Plugins` > `Manage and Install Plugins`

## Usage

### Basic Workflow

1. **Launch Plugin**
   - Click the QGIS YOLOX toolbar button or
   - Go to `Plugins` > `QGIS YOLOX`

2. **Load Video**
   - Click "Load Video" button
   - Select a video file with GPS metadata

3. **Configure Settings**
   - Click "Settings" to configure:
     - YOLOX model (yolox-s, yolox-m, etc.)
     - Confidence threshold (default: 0.5)
     - Frame interval (default: 30 frames)
     - Device (CUDA/CPU)

4. **Process Video**
   - Click "Process" to start detection
   - Monitor progress bar

5. **Export Results**
   - Click "Export to GeoPackage"
   - Select output location
   - Results automatically added to QGIS map

### Using Processing Toolbox

You can also use QGIS Processing algorithms:

1. Open Processing Toolbox (`Processing` > `Toolbox`)
2. Find `QGIS YOLOX` provider
3. Run algorithms:
   - **Video Detection**: Process single video
   - **Batch Processing**: Process multiple videos

## Project Structure

```
qgis_yolox/
├── models/                  # MVC - Data models
├── views/                   # MVC - User interface
├── controllers/             # MVC - Business logic
├── utils/                   # Utility functions
├── processing_provider/     # QGIS Processing integration
├── resources/               # Icons and resources
├── i18n/                    # Translations
├── tests/                   # Unit tests
└── docs/                    # Documentation
```

## Configuration

### YOLOX Models

The plugin supports multiple YOLOX model sizes:

| Model | Parameters | Input Size | mAP | Speed |
|-------|-----------|------------|-----|-------|
| YOLOX-Nano | 0.91M | 416x416 | 25.8 | Fastest |
| YOLOX-S | 9.0M | 640x640 | 40.5 | **Recommended** |
| YOLOX-M | 25.3M | 640x640 | 46.9 | Slower |
| YOLOX-L | 54.2M | 640x640 | 49.7 | Slow |

### Settings

Access settings via the Settings dialog:
- **Model Path**: Path to YOLOX weights file
- **Confidence Threshold**: Minimum detection confidence (0-1)
- **Frame Interval**: Process every N frames
- **Device**: CUDA (GPU) or CPU
- **Output CRS**: Coordinate reference system for output

## GeoPackage Output

Detection results are saved with the following attributes:

| Field | Type | Description |
|-------|------|-------------|
| id | Integer | Unique identifier |
| frame_idx | Integer | Frame number |
| timestamp | Real | Video timestamp (seconds) |
| class_id | Integer | COCO class ID |
| class_name | String | Object class name |
| confidence | Real | Detection confidence (0-1) |
| bbox_x | Real | Bounding box X |
| bbox_y | Real | Bounding box Y |
| bbox_width | Real | Bounding box width |
| bbox_height | Real | Bounding box height |
| geometry | Point | GPS location (WGS84) |

## Performance Tips

- **GPU Acceleration**: Use CUDA for faster processing
- **Frame Interval**: Increase interval for faster processing (e.g., 30 = process 1 frame every second at 30 FPS)
- **Model Size**: Use YOLOX-S for balanced speed/accuracy
- **Video Resolution**: Lower resolution videos process faster

## Troubleshooting

### Common Issues

**Issue: Plugin doesn't load**
- Check QGIS version (3.36.2+)
- Verify Python dependencies are installed
- Check QGIS Python console for errors

**Issue: No GPU acceleration**
- Install CUDA-enabled PyTorch
- Check GPU drivers
- Verify CUDA availability in settings

**Issue: GPS metadata not found**
- Verify video has GPS metadata (use `exiftool video.mp4`)
- Check video format compatibility

## Development

### Building from Source

```bash
git clone https://github.com/yourusername/qgis-yolox.git
cd qgis-yolox
pip install -r requirements.txt
```

### Running Tests

```bash
python -m pytest tests/
```

### Contributing

Contributions are welcome! Please:
1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Submit a pull request

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

- **YOLOX**: [Megvii-BaseDetection/YOLOX](https://github.com/Megvii-BaseDetection/YOLOX)
- **QGIS**: [QGIS Project](https://qgis.org)

## Support

- **Issues**: [GitHub Issues](https://github.com/yourusername/qgis-yolox/issues)
- **Documentation**: [docs/](docs/)
- **Email**: contact@qgis-yolox.org

## Roadmap

### Version 1.1
- Custom YOLOX model support
- Additional video formats
- Real-time preview during processing

### Version 2.0
- 3D object detection
- Semantic segmentation
- Cloud processing integration

---

**Version**: 1.0.0
**Author**: QGIS YOLOX Development Team
**Last Updated**: 2025-12-28
