# -*- coding: utf-8 -*-
"""
QGIS YOLOX Plugin - Utils Package

This package contains utility functions for video processing,
YOLOX inference, GeoPackage creation, and coordinate transformations.
"""

from .video_utils import (
    extract_gps_from_video,
    parse_gps_string,
    extract_frames,
    get_video_info
)

from .yolox_utils import (
    load_yolox_model,
    download_pretrained_weights,
    preprocess_image,
    postprocess_detections,
    visualize_detections
)

from .geopackage_utils import (
    create_geopackage,
    add_detection_fields,
    add_detection_feature,
    save_layer
)

from .coordinate_utils import (
    wgs84_to_project_crs,
    interpolate_gps_position,
    calculate_camera_footprint
)

from .config_utils import (
    load_config,
    save_config,
    get_default_config
)

__all__ = [
    # video_utils
    'extract_gps_from_video',
    'parse_gps_string',
    'extract_frames',
    'get_video_info',
    # yolox_utils
    'load_yolox_model',
    'download_pretrained_weights',
    'preprocess_image',
    'postprocess_detections',
    'visualize_detections',
    # geopackage_utils
    'create_geopackage',
    'add_detection_fields',
    'add_detection_feature',
    'save_layer',
    # coordinate_utils
    'wgs84_to_project_crs',
    'interpolate_gps_position',
    'calculate_camera_footprint',
    # config_utils
    'load_config',
    'save_config',
    'get_default_config'
]
