# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QGISSPT
                                 A QGIS plugin
 Calculate Land Surface Temperature (LST)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-03-12
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Muhammad Rahmahalim
        email                : muhammad.rahmahalim@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QUrl
from qgis.PyQt.QtGui import QIcon, QDesktopServices
from qgis.PyQt.QtWidgets import QAction


# Tambah
from qgis.core import QgsRasterLayer
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry
from PyQt5.QtWidgets import QLineEdit, QRadioButton, QFileDialog, QMessageBox, QDialog
from qgis.gui import QgsFileWidget, QgsFilterLineEdit
from pathlib import Path
import os
from .AtTransmittance import AtTransmittance
from .Equation import Equation
from .DataSatellit import DataSatellit
from .RegCoefficient import RegCoefficient

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .QGIS_SPT_dialog import QGISSPTDialog
import os.path


class QGISSPT:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # tambah
        self.attrans = AtTransmittance()
        self.equation = Equation()
        self.datasatellit = DataSatellit()
        self.regcoefficient = RegCoefficient()

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'QGISSPT_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Plugin QGIS SPT')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('QGISSPT', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/QGIS_SPT/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Plugin QGIS SPT'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Plugin QGIS SPT'),
                action)
            self.iface.removeToolBarIcon(action)

# ==================== OTHER ======================
    # fungsi menampilkan pop-up error
    def popError(self, logo, name, description):
        self.logo = logo
        self.name = name
        self.description = description
        if self.logo == "Warning":
            msg = QMessageBox()
            msg.setText("[" + self.name + "] " + self.description)
            msg.setWindowTitle("Error : " + self.name)
            msg.setIcon(QMessageBox.Warning)
            msg.exec()
        if self.logo == "Critical":
            msg = QMessageBox()
            msg.setText("[" + self.name + "] " + self.description)
            msg.setWindowTitle("Error : " + self.name)
            msg.setIcon(QMessageBox.Critical)
            msg.exec()

    # fungsi konversi data suhu
    def outputTemp(self):
        self.value = self.dlg.cb_outputtemp.currentText()

        if self.value == "Celcius":
            TEMP = "+0"
            return TEMP
        if self.value == "Kelvin":
            TEMP = "+273.15"
            return TEMP
        if self.value == "Fahrenheit":
            TEMP = "* 9/5 + 32"
            return TEMP

    # fungsi cek value string LineEdit (return float & string)
    def checkString(self, value):
        le = QLineEdit()
        self.value = value
        le.setText(self.value)
        if le.text().isnumeric():
            return float(le.text())
        elif le.text().replace('.', '', 1).isnumeric():
            return float(le.text())
        else:
            return le.text()

    # fungsi cek semua input
    def checkInput(self):
        file_bred = self.dlg.fw_bred.filePath()
        file_bnir = self.dlg.fw_bnir.filePath()
        file_btir1 = self.dlg.fw_btir1.filePath()
        file_btir2 = self.dlg.fw_btir2.filePath()
        dir_output = self.dlg.fw_output.filePath()

        val_ndvis = self.checkString(self.dlg.le_ndvis.text())
        val_ndviv = self.checkString(self.dlg.le_ndviv.text())
        val_tir1emissivitys = self.checkString(self.dlg.le_tir1emissivitys.text())
        val_tir1emissivityv = self.checkString(self.dlg.le_tir1emissivityv.text())
        val_tir2emissivitys = self.checkString(self.dlg.le_tir2emissivitys.text())
        val_tir2emissivityv = self.checkString(self.dlg.le_tir2emissivityv.text())
        val_watervapor = self.checkString(self.dlg.le_watervapor.text())
        val_geometrical = self.checkString(self.dlg.le_geometrical.text())

        value_cb_datasatellit = self.dlg.cb_datasatellit.currentText()
        value_cb_outputtemp = self.dlg.cb_outputtemp.currentText()
        value_cb_rangetemp = self.dlg.cb_rangetemp.currentText()

        L_TIR1_K1, L_TIR1_K2, L_TIR1_RMULT, L_TIR1_RADD, L_TIR2_K1, L_TIR2_K2, L_TIR2_RMULT, L_TIR2_RADD = self.datasatellit.landsat8()

        if value_cb_datasatellit != "- select data satellit -":
            if value_cb_outputtemp != "- select output temp. -":
                if value_cb_rangetemp != "- select range temp. -":
                    if isinstance(val_watervapor, float):
                        if val_watervapor <= 3.0 and val_watervapor >= 0.5:
                            # tes fw red
                            if not file_bred:
                                self.popError("Warning", "Band Red", "has no value.\nplease insert the directory.")
                            elif not os.path.exists(Path(file_bred).parent):
                                self.popError("Critical", "Band Red", "directory doesn't exist.\nplease insert the correct directory.")
                            elif not os.path.exists(file_bred):
                                self.popError("Critical", "Band Red", "file doesn't exist.\nplease insert the correct file name.")
                            elif Path(str(file_bred)).suffix != '.tif' and Path(str(file_bred)).suffix != '.TIF':
                                self.popError("Critical", "Band Red", "error with extention.\nplease insert only with .tif/.TIF extention.")
                            elif os.path.exists(Path(file_bred).parent):
                                # tes fw bnir
                                if not file_bnir:
                                    self.popError("Warning", "Band NIR", "has no value.")
                                elif not os.path.exists(Path(file_bnir).parent):
                                    self.popError("Critical", "Band NIR", "directory doesn't exist.")
                                elif not os.path.exists(file_bnir):
                                    self.popError("Critical", "Band NIR", "File doesn't exist.")
                                elif Path(str(file_bnir)).suffix != '.tif' and Path(str(file_bnir)).suffix != '.TIF':
                                    self.popError("Critical", "Band NIR", "harus tif")
                                elif os.path.exists(Path(file_bnir).parent):
                                    # tes fw btir1
                                    if not file_btir1:
                                        self.popError("Warning", "Band TIR-1", "has no value.")
                                    elif not os.path.exists(Path(file_btir1).parent):
                                        self.popError("Critical", "Band TIR-1", "directory doesn't exist.")
                                    elif not os.path.exists(file_btir1):
                                        self.popError("Critical", "Band TIR-1", "File doesn't exist.")
                                    elif Path(str(file_btir1)).suffix != '.tif' and Path(str(file_btir1)).suffix != '.TIF':
                                        self.popError("Critical", "Band TIR-1", "harus tif")
                                    elif os.path.exists(Path(file_btir1).parent):
                                        # tes fw btir2
                                        if not file_btir2:
                                            self.popError("Warning", "Band TIR-2", "has no value.")
                                        elif not os.path.exists(Path(file_btir2).parent):
                                            self.popError("Critical", "Band TIR-2", "directory doesn't exist.")
                                        elif not os.path.exists(file_btir2):
                                            self.popError("Critical", "Band TIR-2", "File doesn't exist.")
                                        elif Path(str(file_btir2)).suffix != '.tif' and Path(str(file_btir2)).suffix != '.TIF':
                                            self.popError("Critical", "Band TIR-2", "harus tif")
                                        elif os.path.exists(Path(file_btir2).parent):
                                            if isinstance(val_ndvis, float):
                                                if val_ndvis <= 1.0 and val_ndvis >= 0.0:
                                                    if isinstance(val_ndviv, float):
                                                        if val_ndviv <= 1.0 and val_ndviv >= 0.0:
                                                            if isinstance(val_tir1emissivitys, float):
                                                                if val_tir1emissivitys <= 1.0 and val_tir1emissivitys >= 0.0:
                                                                    if isinstance(val_tir1emissivityv, float):
                                                                        if val_tir1emissivityv <= 1.0 and val_tir1emissivityv >= 0.0:
                                                                            if isinstance(val_tir2emissivitys, float):
                                                                                if val_tir2emissivitys <= 1.0 and val_tir2emissivitys >= 0.0:
                                                                                    if isinstance(val_tir2emissivityv, float):
                                                                                        if val_tir2emissivityv <= 1.0 and val_tir2emissivityv >= 0.0:
                                                                                            if isinstance(val_geometrical, float):
                                                                                                if val_geometrical <= 1.0 and val_geometrical >= 0.0:
                                                                                                    # test fw save output
                                                                                                    if not dir_output:
                                                                                                        self.popError("Warning", "Save Output", "has no value.")
                                                                                                    elif not os.path.exists(Path(dir_output).parent):
                                                                                                        self.popError("Critical", "Save Output", "directory doesn't exist.")
                                                                                                    elif Path(str(dir_output)).suffix != '.tif' and Path(str(dir_output)).suffix != '.TIF':
                                                                                                        self.popError("Critical", "Save Output", "harus tif")
                                                                                                    elif os.path.exists(Path(dir_output).parent):

                                                                                                        self.dlg.lb_datasatellit.setText(": " + str(value_cb_datasatellit))
                                                                                                        self.dlg.lb_outputtemp.setText(": " + str(value_cb_outputtemp))
                                                                                                        self.dlg.lb_rangetemp.setText(": " + str(value_cb_rangetemp))
                                                                                                        self.dlg.lb_watervapor.setText(": " + str(val_watervapor))
                                                                                                        self.dlg.lb_bred.setText(": " + Path(file_bred).name)
                                                                                                        self.dlg.lb_bnir.setText(": " + Path(file_bnir).name)
                                                                                                        self.dlg.lb_btir1.setText(": " + Path(file_btir1).name)
                                                                                                        self.dlg.lb_btir2.setText(": " + Path(file_btir2).name)

                                                                                                        self.dlg.lb_attransmit.setText(": " + self.dlg.cb_attransmit.currentText())
                                                                                                        self.dlg.lb_ndvis.setText(": " + str(val_ndvis))
                                                                                                        self.dlg.lb_ndviv.setText(": " + str(val_ndviv))
                                                                                                        self.dlg.lb_tir1emissivitys.setText(": " + str(val_tir1emissivitys))
                                                                                                        self.dlg.lb_tir1emissivityv.setText(": " + str(val_tir1emissivityv))
                                                                                                        self.dlg.lb_tir2emissivitys.setText(": " + str(val_tir2emissivitys))
                                                                                                        self.dlg.lb_tir2emissivityv.setText(": " + str(val_tir2emissivityv))
                                                                                                        self.dlg.lb_geometrical.setText(": " + str(val_geometrical))
                                                                                                        self.dlg.lb_output.setText(": " + Path(dir_output).name)

                                                                                                        self.splitWindowQin()
                                                                                                else:
                                                                                                    self.popError("Warning", "Geometrical", "Value must be range 0.0 - 1.0")
                                                                                            else:
                                                                                                self.popError("Warning", "Geometrical", "Please enter the value; value must be number.")
                                                                                        else:
                                                                                            self.popError("Warning", "TIR-2 Emis. Veg.", "Value must be range 0.0 - 1.0")
                                                                                    else:
                                                                                        self.popError("Warning", "TIR-2 Emis. Veg.", "Please enter the value; value must be number.")
                                                                                else:
                                                                                    self.popError("Warning", "TIR-2 Emis. Soil", "Value must be range 0.0 - 1.0")
                                                                            else:
                                                                                self.popError("Warning", "TIR-2 Emis. Soil", "Please enter the value; value must be number.")
                                                                        else:
                                                                            self.popError("Warning", "TIR-1 Emis. Veg.", "Value must be range 0.0 - 1.0")
                                                                    else:
                                                                        self.popError("Warning", "TIR-1 Emis. Veg.", "Please enter the value; value must be number.")
                                                                else:
                                                                    self.popError("Warning", "TIR-1 Emis. Soil", "Value must be range 0.0 - 1.0")
                                                            else:
                                                                self.popError("Warning", "TIR-1 Emis. Soil", "Please enter the value; value must be number.")
                                                        else:
                                                            self.popError("Warning", "NDVI Veg.", "Value must be range 0.0 - 1.0")
                                                    else:
                                                        self.popError("Warning", "NDVI Veg.", "Please enter the value; value must be number.")
                                                else:
                                                    self.popError("Warning", "NDVI Soil", "Value must be range 0.0 - 1.0")
                                            else:
                                                self.popError("Warning", "NDVI Soil", "Please enter the value; value must be number.")
                        else:
                            self.popError("Warning", "Tot. Water Vapor", "Value must be range 0.5 - 3.0")
                    else:
                        self.popError("Warning", "Tot. Water Vapor", "Please enter the value; value must be number.")
                else:
                    self.popError("Warning", "Range Temp.", "Please select the value.")
            else:
                self.popError("Warning", "Output Temp.", "Please select the value.")
        else:
            self.popError("Warning", "Data Satellit", "Please select the value.")

# ==================== FUNGSI SPLIT WINDOW QIN ======================
    def splitWindowQin(self):
        dir_output = self.dlg.fw_output.filePath()
        path = os.path.join(str(Path(dir_output).parent), 'temp_folder', '')
        dir_bred = self.dlg.fw_bred.filePath()
        dir_bnir = self.dlg.fw_bnir.filePath()
        dir_btir1 = self.dlg.fw_btir1.filePath()
        dir_btir2 = self.dlg.fw_btir2.filePath()
        dir_toa_10 = path + '10 - TOA.tif'
        dir_toa_11 = path + '11 - TOA.tif'
        dir_bt_10 = path + '10 - BT.tif'
        dir_bt_11 = path + '11 - BT.tif'
        dir_ndvi = path + 'NDVI.tif'
        dir_pv = path + 'Pv.tif'
        dir_c_kecil_10 = path + '10 - c kecil.tif'
        dir_e_10 = path + '10 - e.tif'
        dir_C_besar_10 = path + '10 - C besar.tif'
        dir_D_10 = path + '10 - D.tif'
        dir_c_kecil_11 = path + '11 - c kecil.tif'
        dir_e_11 = path + '11 - e.tif'
        dir_C_besar_11 = path + '11 - C besar.tif'
        dir_D_11 = path + '11 - D.tif'
        dir_E0 = path + 'E0.tif'
        dir_E2 = path + 'E2.tif'
        dir_E1 = path + 'E1.tif'
        dir_A = path + 'A.tif'
        dir_A2 = path + 'A2.tif'
        dir_A1 = path + 'A1.tif'
        dir_A0 = path + 'A0.tif'

        val_ndvis = self.checkString(self.dlg.le_ndvis.text())
        val_ndviv = self.checkString(self.dlg.le_ndviv.text())
        val_tir1emissivitys = self.checkString(self.dlg.le_tir1emissivitys.text())
        val_tir1emissivityv = self.checkString(self.dlg.le_tir1emissivityv.text())
        val_tir2emissivitys = self.checkString(self.dlg.le_tir2emissivitys.text())
        val_tir2emissivityv = self.checkString(self.dlg.le_tir2emissivityv.text())
        val_watervapor = self.checkString(self.dlg.le_watervapor.text())
        val_geometrical = self.checkString(self.dlg.le_geometrical.text())

        val_attransmit1, val_attransmit2 = self.attrans.calc(self.dlg.cb_attransmit.currentText(), self.dlg.le_watervapor.text())
        L_TIR1_K1, L_TIR1_K2, L_TIR1_RMULT, L_TIR1_RADD, L_TIR2_K1, L_TIR2_K2, L_TIR2_RMULT, L_TIR2_RADD = self.datasatellit.landsat8()
        A10, B10, A11, B11 = self.regcoefficient.getData(self.dlg.cb_rangetemp.currentText())
        TEMP = self.outputTemp()

        finish = 0
        while finish < 2:
            finish += 0.0001
            self.dlg.progressBar.setValue(finish)
            self.dlg.lb_loading.setText("Status: Running")

        self.equation.makeTemp(dir_output)
        self.equation.calc_10_toa(dir_output, dir_btir1, 'yes', L_TIR1_RMULT, L_TIR1_RADD)
        self.equation.calc_11_toa(dir_output, dir_btir2, 'yes', L_TIR2_RMULT, L_TIR2_RADD)
        self.equation.calc_10_bt(dir_output, dir_toa_10, 'yes', L_TIR1_K1, L_TIR1_K2)
        self.equation.calc_11_bt(dir_output, dir_toa_11, 'yes', L_TIR2_K1, L_TIR2_K2)
        self.equation.calc_ndvi(dir_output, dir_bred, dir_bnir, 'yes')

        while finish < 30:
            finish += 0.0001
            self.dlg.progressBar.setValue(finish)

        self.equation.calc_pv(dir_output, dir_ndvi, 'yes', val_ndvis, val_ndviv)
        self.equation.calc_10_ckecil(dir_output, dir_pv, 'yes', val_tir1emissivitys, val_tir1emissivityv, val_geometrical)
        self.equation.calc_10_e(dir_output, dir_pv, dir_c_kecil_10, 'yes', val_tir1emissivitys, val_tir1emissivityv)
        self.equation.calc_10_cbesar(dir_output, dir_e_10, 'yes', val_attransmit1)
        self.equation.calc_10_d(dir_output, dir_e_10, 'yes', val_attransmit1)

        while finish < 70:
            finish += 0.0001
            self.dlg.progressBar.setValue(finish)

        self.equation.calc_11_ckecil(dir_output, dir_pv, 'yes', val_tir2emissivitys, val_tir2emissivityv, val_geometrical)
        self.equation.calc_11_e(dir_output, dir_pv, dir_c_kecil_11, 'yes', val_tir2emissivitys, val_tir2emissivityv)
        self.equation.calc_11_cbesar(dir_output, dir_e_11, 'yes', val_attransmit2)
        self.equation.calc_11_d(dir_output, dir_e_11, 'yes', val_attransmit2)
        self.equation.calc_e0(dir_output, dir_D_11, dir_C_besar_10, dir_D_10, dir_C_besar_11, 'yes')
        self.equation.calc_e2(dir_output, dir_D_10, dir_C_besar_11, dir_D_11, dir_E0, 'yes')
        self.equation.calc_e1(dir_output, dir_D_11, dir_C_besar_10, dir_D_10, dir_E0, 'yes')
        self.equation.calc_a(dir_output, dir_D_10, dir_E0, 'yes')
        self.equation.calc_a2(dir_output, dir_A, dir_E2, 'yes', B11)
        self.equation.calc_a1(dir_output, dir_A, dir_E1, 'yes', B10)
        self.equation.calc_a0(dir_output, dir_E1, dir_E2, 'yes', A10, A11)

        while finish < 100:
            finish += 0.0001
            self.dlg.progressBar.setValue(finish)
        self.dlg.lb_loading.setText("Status: Idle")

        self.equation.calc_lst(dir_output, dir_bt_10, dir_bt_11, dir_A2, dir_A1, dir_A0, 'no', TEMP)

    def showHelp(self):
        help_file = 'file:///%s/help/index.html' % self.plugin_dir

        QDesktopServices.openUrl(QUrl(help_file))

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = QGISSPTDialog()

            # =============== PUSH BUTTON ===============
            self.dlg.pb_ok.clicked.connect(self.checkInput)
            self.dlg.pb_close.clicked.connect(lambda: self.dlg.close())
            self.dlg.pb_help.clicked.connect(self.showHelp)

            # =============== FILE WIDGET ===============
            self.dlg.fw_output.setStorageMode(QgsFileWidget.SaveFile)
            self.dlg.fw_output.setFilter("GeoTIFF (*.tif *.TIF)")
            self.dlg.fw_bred.setFilter("GeoTIFF (*.tif *.TIF)")
            self.dlg.fw_bnir.setFilter("GeoTIFF (*.tif *.TIF)")
            self.dlg.fw_btir1.setFilter("GeoTIFF (*.tif *.TIF)")
            self.dlg.fw_btir2.setFilter("GeoTIFF (*.tif *.TIF)")

            self.dlg.le_ndvis.setText('0.2')
            self.dlg.le_tir1emissivitys.setText('0.964')
            self.dlg.le_tir1emissivityv.setText('0.984')
            self.dlg.le_tir2emissivitys.setText('0.970')
            self.dlg.le_tir2emissivityv.setText('0.980')
            self.dlg.le_geometrical.setText('0.5')

            self.dlg.le_ndviv.setText('0.5')
            self.dlg.le_watervapor.setText('')

            # self.dlg.le_watervapor.setText('2.0394400')
            # self.dlg.le_ndviv.setText('0.616047')
            # self.dlg.fw_bred.setFilePath("C:/Users/HALIM/Downloads/olah/CROP/BAND 4.tif")
            # self.dlg.fw_bnir.setFilePath("C/Users/HALIM/Downloads/olah/CROP/BAND 5.tif")
            # self.dlg.fw_btir1.setFilePath("C/Users/HALIM/Downloads/olah/CROP/BAND 10.tif")
            # self.dlg.fw_btir2.setFilePath("C/Users/HALIM/Downloads/olah/CROP/BAND 11.tif")
            # self.dlg.fw_output.setFilePath("C/Users/HALIM/Downloads/olah/CROP/SPT.tif")

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
