# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QRichDem
                                 A QGIS plugin
 Qgis wrappers for RichDem
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-09-22
        copyright            : (C) 2022 by Fee
        email                : freakyfee@proton.me
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

__author__ = "Fee"
__date__ = "2022-09-22"
__copyright__ = "(C) 2022 by Fee"


# TODO: make installing better:
# https://github.com/opengisch/QgisModelBaker/pull/644
# https://github.com/QGEP/qgepplugin/blob/master/qgepplugin/gui/qgepdatamodeldialog.py#L498-L536


def import_maybe_install_richdem():
    try:
        import richdem as rd  # noqa: F401
    except ImportError:
        import subprocess

        # import sys

        print("installing RichDem!")
        if subprocess.check_call(
            "python3 -m pip install richdem",
            shell=True
            # [sys.executable, "-m", "pip", "install", "richdem"]
        ):
            raise RuntimeError(
                "Could not install RichDem. For concrete instructions, see https://qgis-tuts-wu.readthedocs.io/en/latest/docs/land_degradation_development/introduction/installing.html"
            )
        import richdem as rd  # noqa: F401


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load QRichDem class from file QRichDem.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    import_maybe_install_richdem()
    from .qgis_richdem import QRichDemPlugin

    return QRichDemPlugin()
