/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.ResourceFileManager;

public class ReplicationFileMergerInitializer
implements RunnableTask {
    private static final String LOCK_FILE_NAME = "download.lock";
    private static final String CONFIG_FILE_NAME = "configuration.txt";
    private static final String CONFIG_RESOURCE = "impl/replicationFileMergerConfiguration.txt";
    private static final String DATA_DIRECTORY = "data";
    private File workingDirectory;

    public ReplicationFileMergerInitializer(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private void initializeDirectory() {
        ResourceFileManager resourceFileManager = new ResourceFileManager();
        File configFile = new File(this.workingDirectory, CONFIG_FILE_NAME);
        if (configFile.exists()) {
            throw new OsmosisRuntimeException("Config file " + configFile + " already exists.");
        }
        resourceFileManager.copyResourceToFile(this.getClass(), CONFIG_RESOURCE, configFile);
        File dataDirectory = new File(this.workingDirectory, DATA_DIRECTORY);
        if (dataDirectory.exists()) {
            throw new OsmosisRuntimeException("Data directory " + dataDirectory + " already exists.");
        }
        if (!dataDirectory.mkdir()) {
            throw new OsmosisRuntimeException("Unable to create data directory " + dataDirectory + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FileBasedLock fileLock = new FileBasedLock(new File(this.workingDirectory, LOCK_FILE_NAME));
        try {
            fileLock.lock();
            this.initializeDirectory();
            fileLock.unlock();
        }
        finally {
            fileLock.release();
        }
    }
}

