/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.io.File;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.ReplicationFileSequenceFormatter;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replication.common.ReplicationStore;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeReader;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeWriter;

public class FileReplicationStore
implements ReplicationStore {
    private static final String STATE_FILE = "state.txt";
    private PropertiesPersister currentStatePersister;
    private ReplicationFileSequenceFormatter sequenceFormatter;
    private boolean saveCurrentState;

    public FileReplicationStore(File storeDirectory, boolean saveCurrentState) {
        this.currentStatePersister = new PropertiesPersister(new File(storeDirectory, STATE_FILE));
        this.sequenceFormatter = new ReplicationFileSequenceFormatter(storeDirectory);
        this.saveCurrentState = saveCurrentState;
    }

    @Override
    public ReplicationState getCurrentState() {
        ReplicationState state = new ReplicationState();
        state.load(this.currentStatePersister.loadMap());
        return state;
    }

    @Override
    public ReplicationState getState(long sequence) {
        File stateFile = this.sequenceFormatter.getFormattedName(sequence, ".state.txt");
        return new ReplicationState(new PropertiesPersister(stateFile).loadMap());
    }

    @Override
    public XmlChangeReader getData(long sequence) {
        File changeFile = this.sequenceFormatter.getFormattedName(sequence, ".osc.gz");
        return new XmlChangeReader(changeFile, false, CompressionMethod.GZip);
    }

    @Override
    public void saveState(ReplicationState state) {
        File stateFile = this.sequenceFormatter.getFormattedName(state.getSequenceNumber(), ".state.txt");
        new PropertiesPersister(stateFile).store(state.store());
        if (this.saveCurrentState) {
            this.currentStatePersister.store(state.store());
        }
    }

    @Override
    public XmlChangeWriter saveData(long sequence) {
        File changeFile = this.sequenceFormatter.getFormattedName(sequence, ".osc.gz");
        return new XmlChangeWriter(changeFile, CompressionMethod.GZip);
    }
}

