/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.IntegerLongIndexElement;

public class WayTileAreaIndexReader
implements Releasable {
    private int[] masks = new int[]{-1, -16, -256, -65536, -16777216, 0};
    private List<IndexStoreReader<Integer, IntegerLongIndexElement>> indexReaders;

    public WayTileAreaIndexReader(int[] masks, List<IndexStoreReader<Integer, IntegerLongIndexElement>> indexReaders) {
        this.masks = masks;
        this.indexReaders = indexReaders;
    }

    public Iterator<Long> getRange(Integer minimumTile, Integer maximumTile) {
        ArrayList<Iterator> ranges = new ArrayList<Iterator>(this.masks.length);
        for (int i = 0; i < this.masks.length; ++i) {
            int mask = this.masks[i];
            int beginKey = mask & minimumTile;
            int endKey = mask & maximumTile;
            IndexStoreReader<Integer, IntegerLongIndexElement> indexReader = this.indexReaders.get(i);
            ranges.add(indexReader.getRange((Object)beginKey, (Object)endKey));
        }
        return new ResultIterator(ranges.iterator());
    }

    public void release() {
        for (IndexStoreReader<Integer, IntegerLongIndexElement> indexReader : this.indexReaders) {
            indexReader.release();
        }
    }

    private static class ResultIterator
    implements Iterator<Long> {
        private Iterator<Iterator<IntegerLongIndexElement>> sources;
        private Iterator<IntegerLongIndexElement> currentSource;
        private boolean currentSourceAvailable;

        public ResultIterator(Iterator<Iterator<IntegerLongIndexElement>> sources) {
            this.sources = sources;
            this.currentSourceAvailable = false;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (!this.currentSourceAvailable) {
                    if (this.sources.hasNext()) {
                        this.currentSource = this.sources.next();
                        this.currentSourceAvailable = true;
                    } else {
                        return false;
                    }
                }
                if (this.currentSource.hasNext()) {
                    return true;
                }
                this.currentSourceAvailable = false;
            }
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentSource.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

