/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistory;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainerFactory;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class EntityContainerReader<T extends Entity>
implements ReleasableIterator<EntityContainer> {
    private ReleasableIterator<EntityHistory<T>> source;
    private EntityContainerFactory<T> containerFactory;
    private EntityContainer nextValue;
    private boolean nextValueLoaded;

    public EntityContainerReader(ReleasableIterator<EntityHistory<T>> source, EntityContainerFactory<T> containerFactory) {
        this.source = source;
        this.containerFactory = containerFactory;
    }

    public boolean hasNext() {
        while (!this.nextValueLoaded && this.source.hasNext()) {
            Entity entity = (Entity)((EntityHistory)this.source.next()).getEntity();
            this.nextValue = this.containerFactory.createContainer((Object)entity);
            this.nextValueLoaded = true;
        }
        return this.nextValueLoaded;
    }

    public EntityContainer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextValueLoaded = false;
        return this.nextValue;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void release() {
        this.source.release();
    }
}

