/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.openstreetmap.osmosis.apidb.common.DataSourceFactory;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.apidb.common.IdentityValueLoader;
import org.openstreetmap.osmosis.apidb.common.MysqlIdentityValueLoader2;
import org.openstreetmap.osmosis.apidb.common.PostgresqlIdentityValueLoader2;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabaseType;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseContext2 {
    private static final Logger LOG = Logger.getLogger(DatabaseContext.class.getName());
    private BasicDataSource dataSource;
    private PlatformTransactionManager txnManager;
    private TransactionTemplate txnTemplate;
    private JdbcTemplate jdbcTemplate;
    private DatabaseType dbType;
    private IdentityValueLoader identityValueLoader;

    public DatabaseContext2(DatabaseLoginCredentials loginCredentials) {
        this.dataSource = DataSourceFactory.createDataSource(loginCredentials);
        this.txnManager = new DataSourceTransactionManager((DataSource)this.dataSource);
        this.txnTemplate = new TransactionTemplate(this.txnManager);
        this.jdbcTemplate = new JdbcTemplate((DataSource)this.dataSource);
        this.dbType = loginCredentials.getDbType();
        this.setStatementFetchSizeForStreaming();
        switch (loginCredentials.getDbType()) {
            case POSTGRESQL: {
                this.identityValueLoader = new PostgresqlIdentityValueLoader2(this);
                break;
            }
            case MYSQL: {
                this.identityValueLoader = new MysqlIdentityValueLoader2(this);
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + loginCredentials.getDbType() + ".");
            }
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public <T> Object executeWithinTransaction(TransactionCallback<T> txnCallback) {
        return this.txnTemplate.execute(txnCallback);
    }

    public DatabaseType getDatabaseType() {
        return this.dbType;
    }

    private void setStatementFetchSizeForStreaming() {
        switch (this.dbType) {
            case POSTGRESQL: {
                this.jdbcTemplate.setFetchSize(10000);
                break;
            }
            case MYSQL: {
                this.jdbcTemplate.setFetchSize(Integer.MIN_VALUE);
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + this.dbType + ".");
            }
        }
    }

    public void truncateTables(List<String> tables) {
        switch (this.dbType) {
            case POSTGRESQL: {
                StringBuilder statementBuilder = new StringBuilder();
                for (String table : tables) {
                    if (statementBuilder.length() == 0) {
                        statementBuilder.append("TRUNCATE ");
                    } else {
                        statementBuilder.append(", ");
                    }
                    statementBuilder.append(table);
                }
                this.jdbcTemplate.update(statementBuilder.toString());
                break;
            }
            case MYSQL: {
                for (String table : tables) {
                    this.jdbcTemplate.update("TRUNCATE " + table);
                }
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + this.dbType + ".");
            }
        }
    }

    public void disableIndexes(List<String> tables) {
        switch (this.dbType) {
            case POSTGRESQL: {
                break;
            }
            case MYSQL: {
                for (String table : tables) {
                    this.jdbcTemplate.update("ALTER TABLE " + table + " DISABLE KEYS");
                }
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + this.dbType + ".");
            }
        }
    }

    public void enableIndexes(List<String> tables) {
        switch (this.dbType) {
            case POSTGRESQL: {
                break;
            }
            case MYSQL: {
                for (String table : tables) {
                    this.jdbcTemplate.update("ALTER TABLE " + table + " ENABLE KEYS");
                }
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + this.dbType + ".");
            }
        }
    }

    public void lockTables(List<String> tables) {
        switch (this.dbType) {
            case POSTGRESQL: {
                break;
            }
            case MYSQL: {
                StringBuilder statementBuilder = new StringBuilder();
                for (String table : tables) {
                    if (statementBuilder.length() == 0) {
                        statementBuilder.append("LOCK TABLES ");
                    } else {
                        statementBuilder.append(", ");
                    }
                    statementBuilder.append(table);
                    statementBuilder.append(" WRITE");
                }
                this.jdbcTemplate.update(statementBuilder.toString());
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + this.dbType + ".");
            }
        }
    }

    public void unlockTables(List<String> tables) {
        switch (this.dbType) {
            case POSTGRESQL: {
                break;
            }
            case MYSQL: {
                this.jdbcTemplate.update("UNLOCK TABLES");
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + this.dbType + ".");
            }
        }
    }

    public long getLastInsertId() {
        return this.identityValueLoader.getLastInsertId();
    }

    public long getLastSequenceId(String sequenceName) {
        return this.identityValueLoader.getLastSequenceId(sequenceName);
    }

    public void release() {
        this.identityValueLoader.release();
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            LOG.log(Level.WARNING, "Unable to cleanup the database connection pool.", e);
        }
    }

    public boolean doesColumnExist(String tableName, String columnName) {
        ResultSet resultSet = null;
        try {
            LOG.finest("Checking if column {" + columnName + "} in table {" + tableName + "} exists.");
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            resultSet = connection.getMetaData().getColumns(null, null, tableName, columnName);
            boolean result = resultSet.next();
            resultSet.close();
            resultSet = null;
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check for the existence of column " + tableName + "." + columnName + ".", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close column existence result set.", e);
                }
            }
        }
    }

    public boolean doesTableExist(String tableName) {
        ResultSet resultSet = null;
        try {
            LOG.finest("Checking if table {" + tableName + "} exists.");
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            resultSet = connection.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            boolean result = resultSet.next();
            resultSet.close();
            resultSet = null;
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check for the existence of table " + tableName + ".", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close table existence result set.", e);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

