/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.ReleasableStatementContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;

public class UserManager
implements Releasable {
    private static final Logger LOG = Logger.getLogger(UserManager.class.getName());
    private static final String SELECT_SQL_USER_EXISTS = "SELECT Count(id) AS userCount FROM users WHERE id = ?";
    private static final String INSERT_SQL_USER = "INSERT INTO users (id, email, pass_crypt, creation_time, display_name, data_public, description, home_lat, home_lon, home_zoom, nearby, pass_salt) VALUES (?, ?, '00000000000000000000000000000000', NOW(), ?, ?, ?, 0, 0, 3, 50, '00000000')";
    private static final String UPDATE_SQL_USER = "UPDATE users SET display_name = ? WHERE id = ?";
    private final DatabaseContext dbCtx;
    private final Set<Integer> updatedUsers;
    private final ReleasableStatementContainer statementContainer;
    private PreparedStatement statementInsert;
    private PreparedStatement statementExists;
    private PreparedStatement statementUpdate;

    public UserManager(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
        this.updatedUsers = new HashSet<Integer>();
        this.statementContainer = new ReleasableStatementContainer();
    }

    private boolean doesUserExistInDb(OsmUser user) {
        if (this.statementExists == null) {
            this.statementExists = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatementForStreaming(SELECT_SQL_USER_EXISTS));
        }
        ResultSet resultSet = null;
        try {
            int prmIndex = 1;
            this.statementExists.setInt(prmIndex++, user.getId());
            resultSet = this.statementExists.executeQuery();
            resultSet.next();
            boolean result = resultSet.getInt("userCount") != 0;
            resultSet.close();
            resultSet = null;
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check if user with id " + user.getId() + " exists in the database.", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close existing user result set.", e);
                }
            }
        }
    }

    private void insertUser(OsmUser user) {
        boolean dataPublic;
        String userName;
        if (this.statementInsert == null) {
            this.statementInsert = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_USER));
        }
        if (OsmUser.NONE.equals((Object)user)) {
            userName = "Osmosis Anonymous";
            dataPublic = false;
        } else {
            userName = user.getName();
            dataPublic = true;
        }
        try {
            int prmIndex = 1;
            this.statementInsert.setInt(prmIndex++, user.getId());
            this.statementInsert.setString(prmIndex++, "osmosis_user_" + user.getId() + "@example.com");
            this.statementInsert.setString(prmIndex++, userName);
            this.statementInsert.setBoolean(prmIndex++, dataPublic);
            this.statementInsert.setString(prmIndex++, userName);
            this.statementInsert.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to insert user with id " + user.getId() + " into the database.", (Throwable)e);
        }
    }

    private void updateUser(OsmUser user) {
        if (this.statementUpdate == null) {
            this.statementUpdate = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_USER));
        }
        try {
            String userName = OsmUser.NONE.equals((Object)user) ? "Osmosis Anonymous" : user.getName();
            int prmIndex = 1;
            this.statementUpdate.setString(prmIndex++, userName);
            this.statementUpdate.setInt(prmIndex++, user.getId());
            this.statementUpdate.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to update user with id " + user.getId() + " in the database.", (Throwable)e);
        }
    }

    public void addOrUpdateUser(OsmUser user) {
        if (!this.updatedUsers.contains(user.getId())) {
            if (this.doesUserExistInDb(user)) {
                this.updateUser(user);
            } else {
                this.insertUser(user);
            }
            this.updatedUsers.add(user.getId());
        }
    }

    public void release() {
        this.statementContainer.release();
    }
}

