/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.dataset.v0_6.impl.DatasetStoreFileManager;

public class TempFileDatasetStoreFileManager
implements DatasetStoreFileManager {
    private static Logger log = Logger.getLogger(TempFileDatasetStoreFileManager.class.getName());
    private List<File> allFiles = new ArrayList<File>();
    private File nodeObjectFile;
    private File nodeObjectOffsetIndexFile;
    private File nodeTileIndexFile;
    private File wayObjectFile;
    private File wayObjectOffsetIndexFile;
    private Map<Integer, File> wayTileIndexFileMap = new HashMap<Integer, File>();
    private File nodeWayIndexFile;
    private File relationObjectFile;
    private File relationObjectOffsetIndexFile;
    private File nodeRelationIndexFile;
    private File wayRelationIndexFile;
    private File relationRelationIndexFile;

    private File createTempFile(String prefix) {
        try {
            File file = File.createTempFile(prefix, null);
            this.allFiles.add(file);
            return file;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to create a new temporary file.", (Throwable)e);
        }
    }

    @Override
    public File getNodeObjectFile() {
        if (this.nodeObjectFile == null) {
            this.nodeObjectFile = this.createTempFile("dsno");
        }
        return this.nodeObjectFile;
    }

    @Override
    public File getNodeObjectOffsetIndexFile() {
        if (this.nodeObjectOffsetIndexFile == null) {
            this.nodeObjectOffsetIndexFile = this.createTempFile("dsnooi");
        }
        return this.nodeObjectOffsetIndexFile;
    }

    @Override
    public File getNodeTileIndexFile() {
        if (this.nodeTileIndexFile == null) {
            this.nodeTileIndexFile = this.createTempFile("dsnti");
        }
        return this.nodeTileIndexFile;
    }

    @Override
    public File getWayObjectFile() {
        if (this.wayObjectFile == null) {
            this.wayObjectFile = this.createTempFile("dswo");
        }
        return this.wayObjectFile;
    }

    @Override
    public File getWayObjectOffsetIndexFile() {
        if (this.wayObjectOffsetIndexFile == null) {
            this.wayObjectOffsetIndexFile = this.createTempFile("dswooi");
        }
        return this.wayObjectOffsetIndexFile;
    }

    @Override
    public File getWayTileIndexFile(int instance) {
        if (!this.wayTileIndexFileMap.containsKey(instance)) {
            this.wayTileIndexFileMap.put(instance, this.createTempFile("dswti"));
        }
        return this.wayTileIndexFileMap.get(instance);
    }

    @Override
    public File getNodeWayIndexFile() {
        if (this.nodeWayIndexFile == null) {
            this.nodeWayIndexFile = this.createTempFile("dsnwi");
        }
        return this.nodeWayIndexFile;
    }

    @Override
    public File getRelationObjectFile() {
        if (this.relationObjectFile == null) {
            this.relationObjectFile = this.createTempFile("dsro");
        }
        return this.relationObjectFile;
    }

    @Override
    public File getRelationObjectOffsetIndexFile() {
        if (this.relationObjectOffsetIndexFile == null) {
            this.relationObjectOffsetIndexFile = this.createTempFile("dsrooi");
        }
        return this.relationObjectOffsetIndexFile;
    }

    @Override
    public File getNodeRelationIndexFile() {
        if (this.nodeRelationIndexFile == null) {
            this.nodeRelationIndexFile = this.createTempFile("dsnri");
        }
        return this.nodeRelationIndexFile;
    }

    @Override
    public File getWayRelationIndexFile() {
        if (this.wayRelationIndexFile == null) {
            this.wayRelationIndexFile = this.createTempFile("dswri");
        }
        return this.wayRelationIndexFile;
    }

    @Override
    public File getRelationRelationIndexFile() {
        if (this.relationRelationIndexFile == null) {
            this.relationRelationIndexFile = this.createTempFile("dsrri");
        }
        return this.relationRelationIndexFile;
    }

    public void release() {
        for (File file : this.allFiles) {
            if (file.delete()) continue;
            log.warning("Unable to delete file " + file);
        }
    }
}

