/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.awt.geom.Rectangle2D;
import org.openstreetmap.osmosis.core.filter.common.BitSetIdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.store.UnsignedIntegerComparator;
import org.openstreetmap.osmosis.core.util.TileCalculator;

public class BoundingBoxContext {
    public final Rectangle2D boundingBox;
    public final int maximumTile;
    public final int minimumTile;
    public final IdTracker nodeIdTracker;
    public final IdTracker wayIdTracker;
    public final IdTracker relationIdTracker;
    public final IdTracker externalNodeIdTracker;

    public BoundingBoxContext(double left, double right, double top, double bottom) {
        int calculatedTile;
        TileCalculator tileCalculator = new TileCalculator();
        UnsignedIntegerComparator tileOrdering = new UnsignedIntegerComparator();
        this.boundingBox = new Rectangle2D.Double(left, bottom, right - left, top - bottom);
        int tmpMaximumTile = calculatedTile = (int)tileCalculator.calculateTile(top, left);
        int tmpMinimumTile = calculatedTile;
        calculatedTile = (int)tileCalculator.calculateTile(top, right);
        if (tileOrdering.compare(calculatedTile, tmpMinimumTile) < 0) {
            tmpMinimumTile = calculatedTile;
        }
        if (tileOrdering.compare(calculatedTile, tmpMaximumTile) > 0) {
            tmpMaximumTile = calculatedTile;
        }
        if (tileOrdering.compare(calculatedTile = (int)tileCalculator.calculateTile(bottom, left), tmpMinimumTile) < 0) {
            tmpMinimumTile = calculatedTile;
        }
        if (tileOrdering.compare(calculatedTile, tmpMaximumTile) > 0) {
            tmpMaximumTile = calculatedTile;
        }
        if (tileOrdering.compare(calculatedTile = (int)tileCalculator.calculateTile(bottom, right), tmpMinimumTile) < 0) {
            tmpMinimumTile = calculatedTile;
        }
        if (tileOrdering.compare(calculatedTile, tmpMaximumTile) > 0) {
            tmpMaximumTile = calculatedTile;
        }
        if (tmpMaximumTile == 0 && (right > -180.0 || top > -90.0)) {
            tmpMaximumTile = -1;
        }
        this.maximumTile = tmpMaximumTile;
        this.minimumTile = tmpMinimumTile;
        this.nodeIdTracker = new BitSetIdTracker();
        this.wayIdTracker = new BitSetIdTracker();
        this.relationIdTracker = new BitSetIdTracker();
        this.externalNodeIdTracker = new BitSetIdTracker();
    }
}

