/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.dataset.v0_6.impl.DatasetStoreFileManager;

public class PermanentFileDatasetStoreFileManager
implements DatasetStoreFileManager {
    private File directory;
    private File nodeObjectFile;
    private File nodeObjectOffsetIndexFile;
    private File nodeTileIndexFile;
    private File wayObjectFile;
    private File wayObjectOffsetIndexFile;
    private Map<Integer, File> wayTileIndexFileMap;
    private File nodeWayIndexFile;
    private File relationObjectFile;
    private File relationObjectOffsetIndexFile;
    private File nodeRelationIndexFile;
    private File wayRelationIndexFile;
    private File relationRelationIndexFile;

    public PermanentFileDatasetStoreFileManager(File directory) {
        this.directory = directory;
        this.wayTileIndexFileMap = new HashMap<Integer, File>();
    }

    private File createDataFile(String fileName) {
        return new File(this.directory, fileName);
    }

    @Override
    public File getNodeObjectFile() {
        if (this.nodeObjectFile == null) {
            this.nodeObjectFile = this.createDataFile("dsno");
        }
        return this.nodeObjectFile;
    }

    @Override
    public File getNodeObjectOffsetIndexFile() {
        if (this.nodeObjectOffsetIndexFile == null) {
            this.nodeObjectOffsetIndexFile = this.createDataFile("dsnooi");
        }
        return this.nodeObjectOffsetIndexFile;
    }

    @Override
    public File getNodeTileIndexFile() {
        if (this.nodeTileIndexFile == null) {
            this.nodeTileIndexFile = this.createDataFile("dsnti");
        }
        return this.nodeTileIndexFile;
    }

    @Override
    public File getWayObjectFile() {
        if (this.wayObjectFile == null) {
            this.wayObjectFile = this.createDataFile("dswo");
        }
        return this.wayObjectFile;
    }

    @Override
    public File getWayObjectOffsetIndexFile() {
        if (this.wayObjectOffsetIndexFile == null) {
            this.wayObjectOffsetIndexFile = this.createDataFile("dswooi");
        }
        return this.wayObjectOffsetIndexFile;
    }

    @Override
    public File getWayTileIndexFile(int instance) {
        if (!this.wayTileIndexFileMap.containsKey(instance)) {
            this.wayTileIndexFileMap.put(instance, this.createDataFile("dswti" + instance));
        }
        return this.wayTileIndexFileMap.get(instance);
    }

    @Override
    public File getNodeWayIndexFile() {
        if (this.nodeWayIndexFile == null) {
            this.nodeWayIndexFile = this.createDataFile("dsnwi");
        }
        return this.nodeWayIndexFile;
    }

    @Override
    public File getRelationObjectFile() {
        if (this.relationObjectFile == null) {
            this.relationObjectFile = this.createDataFile("dsro");
        }
        return this.relationObjectFile;
    }

    @Override
    public File getRelationObjectOffsetIndexFile() {
        if (this.relationObjectOffsetIndexFile == null) {
            this.relationObjectOffsetIndexFile = this.createDataFile("dsrooi");
        }
        return this.relationObjectOffsetIndexFile;
    }

    @Override
    public File getNodeRelationIndexFile() {
        if (this.nodeRelationIndexFile == null) {
            this.nodeRelationIndexFile = this.createDataFile("dsnri");
        }
        return this.nodeRelationIndexFile;
    }

    @Override
    public File getWayRelationIndexFile() {
        if (this.wayRelationIndexFile == null) {
            this.wayRelationIndexFile = this.createDataFile("dswri");
        }
        return this.wayRelationIndexFile;
    }

    @Override
    public File getRelationRelationIndexFile() {
        if (this.relationRelationIndexFile == null) {
            this.relationRelationIndexFile = this.createDataFile("dsrri");
        }
        return this.relationRelationIndexFile;
    }

    public void release() {
    }
}

