/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.util.Comparator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.Dataset;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.CompletableContainer;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.sort.v0_6.SortedEntityPipeValidator;
import org.openstreetmap.osmosis.core.store.ComparableComparator;
import org.openstreetmap.osmosis.core.store.IndexElement;
import org.openstreetmap.osmosis.core.store.IndexStore;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.IntegerLongIndexElement;
import org.openstreetmap.osmosis.core.store.LongLongIndexElement;
import org.openstreetmap.osmosis.core.store.NoSuchIndexElementException;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStore;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStoreReader;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.store.UnsignedIntegerComparator;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.util.TileCalculator;
import org.openstreetmap.osmosis.dataset.v0_6.impl.DatasetStoreFileManager;
import org.openstreetmap.osmosis.dataset.v0_6.impl.DatasetStoreReader;
import org.openstreetmap.osmosis.dataset.v0_6.impl.NodeStorageContainer;
import org.openstreetmap.osmosis.dataset.v0_6.impl.RelationStorageContainer;
import org.openstreetmap.osmosis.dataset.v0_6.impl.WayStorageContainer;
import org.openstreetmap.osmosis.dataset.v0_6.impl.WayTileAreaIndex;
import org.openstreetmap.osmosis.dataset.v0_6.impl.WayTileAreaIndexReader;

public class DatasetStore
implements Sink,
EntityProcessor,
Dataset {
    private static final Logger LOG = Logger.getLogger(DatasetStore.class.getName());
    private SortedEntityPipeValidator sortedPipeValidator;
    private TileCalculator tileCalculator;
    private UnsignedIntegerComparator uintComparator;
    private boolean enableWayTileIndex;
    private CompletableContainer storeContainer;
    private RandomAccessObjectStore<Node> nodeObjectStore;
    private IndexStore<Long, LongLongIndexElement> nodeObjectOffsetIndexWriter;
    private IndexStore<Integer, IntegerLongIndexElement> nodeTileIndexWriter;
    private RandomAccessObjectStore<Way> wayObjectStore;
    private IndexStore<Long, LongLongIndexElement> wayObjectOffsetIndexWriter;
    private WayTileAreaIndex wayTileIndexWriter;
    private IndexStore<Long, LongLongIndexElement> nodeWayIndexWriter;
    private RandomAccessObjectStore<Relation> relationObjectStore;
    private IndexStore<Long, LongLongIndexElement> relationObjectOffsetIndexWriter;
    private IndexStore<Long, LongLongIndexElement> nodeRelationIndexWriter;
    private IndexStore<Long, LongLongIndexElement> wayRelationIndexWriter;
    private IndexStore<Long, LongLongIndexElement> relationRelationIndexWriter;
    private RandomAccessObjectStoreReader<Node> nodeObjectReader;
    private IndexStoreReader<Long, LongLongIndexElement> nodeObjectOffsetIndexReader;

    public DatasetStore(DatasetStoreFileManager fileManager, boolean enableWayTileIndex) {
        this.enableWayTileIndex = enableWayTileIndex;
        this.storeContainer = new CompletableContainer();
        this.sortedPipeValidator = new SortedEntityPipeValidator();
        this.sortedPipeValidator.setSink(new Sink(){

            public void initialize(Map<String, Object> metaData) {
                throw new UnsupportedOperationException();
            }

            public void complete() {
                throw new UnsupportedOperationException();
            }

            public void process(EntityContainer entityContainer) {
                DatasetStore.this.processImpl(entityContainer);
            }

            public void release() {
                throw new UnsupportedOperationException();
            }
        });
        this.tileCalculator = new TileCalculator();
        this.uintComparator = new UnsignedIntegerComparator();
        this.nodeObjectStore = (RandomAccessObjectStore)this.storeContainer.add((Completable)new RandomAccessObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Node.class), fileManager.getNodeObjectFile()));
        this.nodeObjectOffsetIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getNodeObjectOffsetIndexFile()));
        this.nodeTileIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(IntegerLongIndexElement.class, (Comparator)this.uintComparator, fileManager.getNodeTileIndexFile()));
        this.wayObjectStore = (RandomAccessObjectStore)this.storeContainer.add((Completable)new RandomAccessObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Way.class), fileManager.getWayObjectFile()));
        this.wayObjectOffsetIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getWayObjectOffsetIndexFile()));
        this.wayTileIndexWriter = (WayTileAreaIndex)this.storeContainer.add((Completable)new WayTileAreaIndex(fileManager));
        this.nodeWayIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getNodeWayIndexFile()));
        this.relationObjectStore = (RandomAccessObjectStore)this.storeContainer.add((Completable)new RandomAccessObjectStore((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(Relation.class), fileManager.getRelationObjectFile()));
        this.relationObjectOffsetIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getRelationObjectOffsetIndexFile()));
        this.nodeRelationIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getNodeRelationIndexFile()));
        this.wayRelationIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getWayRelationIndexFile()));
        this.relationRelationIndexWriter = (IndexStore)this.storeContainer.add((Completable)new IndexStore(LongLongIndexElement.class, (Comparator)new ComparableComparator(), fileManager.getRelationRelationIndexFile()));
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(EntityContainer entityContainer) {
        this.sortedPipeValidator.process(entityContainer);
    }

    protected void processImpl(EntityContainer entityContainer) {
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer bound) {
    }

    public void process(NodeContainer nodeContainer) {
        Node node = nodeContainer.getEntity();
        long nodeId = node.getId();
        long objectOffset = this.nodeObjectStore.add((Storeable)node);
        this.nodeObjectOffsetIndexWriter.write((IndexElement)new LongLongIndexElement(nodeId, objectOffset));
        this.nodeTileIndexWriter.write((IndexElement)new IntegerLongIndexElement((int)this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude()), nodeId));
    }

    public void process(WayContainer wayContainer) {
        if (this.nodeObjectReader == null) {
            this.nodeObjectStore.complete();
            this.nodeObjectReader = this.nodeObjectStore.createReader();
        }
        if (this.nodeObjectOffsetIndexReader == null) {
            this.nodeObjectOffsetIndexWriter.complete();
            this.nodeObjectOffsetIndexReader = this.nodeObjectOffsetIndexWriter.createReader();
        }
        Way way = wayContainer.getEntity();
        long wayId = way.getId();
        long objectOffset = this.wayObjectStore.add((Storeable)way);
        this.wayObjectOffsetIndexWriter.write((IndexElement)new LongLongIndexElement(wayId, objectOffset));
        if (this.enableWayTileIndex) {
            boolean tilesFound = false;
            int minimumTile = 0;
            int maximumTile = 0;
            for (WayNode wayNode : way.getWayNodes()) {
                long nodeId = wayNode.getNodeId();
                try {
                    Node node = (Node)this.nodeObjectReader.get(((LongLongIndexElement)this.nodeObjectOffsetIndexReader.get((Object)nodeId)).getValue());
                    int tile = (int)this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude());
                    if (tilesFound) {
                        if (this.uintComparator.compare(Integer.valueOf(tile), Integer.valueOf(minimumTile)) < 0) {
                            minimumTile = tile;
                        }
                        if (this.uintComparator.compare(Integer.valueOf(maximumTile), Integer.valueOf(tile)) >= 0) continue;
                        maximumTile = tile;
                        continue;
                    }
                    minimumTile = tile;
                    maximumTile = tile;
                    tilesFound = true;
                }
                catch (NoSuchIndexElementException e) {
                    if (!LOG.isLoggable(Level.FINER)) continue;
                    LOG.finest("Ignoring referential integrity problem where way " + wayId + " refers to non-existent node " + nodeId + ".");
                }
            }
            if (tilesFound) {
                this.wayTileIndexWriter.write(wayId, minimumTile, maximumTile);
            }
        } else {
            for (WayNode wayNode : way.getWayNodes()) {
                long nodeId = wayNode.getNodeId();
                this.nodeWayIndexWriter.write((IndexElement)new LongLongIndexElement(nodeId, wayId));
            }
        }
    }

    public void process(RelationContainer relationContainer) {
        Relation relation = relationContainer.getEntity();
        long relationId = relation.getId();
        long objectOffset = this.relationObjectStore.add((Storeable)relation);
        this.relationObjectOffsetIndexWriter.write((IndexElement)new LongLongIndexElement(relationId, objectOffset));
        for (RelationMember member : relation.getMembers()) {
            EntityType memberType = member.getMemberType();
            if (memberType.equals((Object)EntityType.Node)) {
                this.nodeRelationIndexWriter.write((IndexElement)new LongLongIndexElement(member.getMemberId(), relationId));
                continue;
            }
            if (memberType.equals((Object)EntityType.Way)) {
                this.wayRelationIndexWriter.write((IndexElement)new LongLongIndexElement(member.getMemberId(), relationId));
                continue;
            }
            if (memberType.equals((Object)EntityType.Relation)) {
                this.relationRelationIndexWriter.write((IndexElement)new LongLongIndexElement(member.getMemberId(), relationId));
                continue;
            }
            throw new OsmosisRuntimeException("Member type " + memberType + " is not recognised.");
        }
    }

    public void complete() {
        this.storeContainer.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetContext createReader() {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            DatasetStoreReader reader = new DatasetStoreReader(new NodeStorageContainer((RandomAccessObjectStoreReader<Node>)((RandomAccessObjectStoreReader)releasableContainer.add((Releasable)this.nodeObjectStore.createReader())), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.nodeObjectOffsetIndexWriter.createReader())), (IndexStoreReader<Integer, IntegerLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.nodeTileIndexWriter.createReader())), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.nodeWayIndexWriter.createReader())), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.nodeRelationIndexWriter.createReader()))), new WayStorageContainer((RandomAccessObjectStoreReader<Way>)((RandomAccessObjectStoreReader)releasableContainer.add((Releasable)this.wayObjectStore.createReader())), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.wayObjectOffsetIndexWriter.createReader())), (WayTileAreaIndexReader)releasableContainer.add((Releasable)this.wayTileIndexWriter.createReader()), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.wayRelationIndexWriter.createReader()))), new RelationStorageContainer((RandomAccessObjectStoreReader<Relation>)((RandomAccessObjectStoreReader)releasableContainer.add((Releasable)this.relationObjectStore.createReader())), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.relationObjectOffsetIndexWriter.createReader())), (IndexStoreReader<Long, LongLongIndexElement>)((IndexStoreReader)releasableContainer.add((Releasable)this.relationRelationIndexWriter.createReader()))), this.enableWayTileIndex);
            releasableContainer.clear();
            DatasetStoreReader datasetStoreReader = reader;
            return datasetStoreReader;
        }
        finally {
            releasableContainer.release();
        }
    }

    public void release() {
        if (this.nodeObjectReader != null) {
            this.nodeObjectReader.release();
        }
        if (this.nodeObjectOffsetIndexReader != null) {
            this.nodeObjectOffsetIndexReader.release();
        }
        this.storeContainer.release();
    }
}

