/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.areafilter.v0_6;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import org.openstreetmap.osmosis.areafilter.common.PolygonFileReader;
import org.openstreetmap.osmosis.areafilter.v0_6.AreaFilter;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.filter.common.IdTrackerType;

public class PolygonFilter
extends AreaFilter {
    private File polygonFile;
    private Area area;

    public PolygonFilter(IdTrackerType idTrackerType, File polygonFile, boolean clipIncompleteEntities, boolean completeWays, boolean completeRelations, boolean cascadingRelations) {
        super(idTrackerType, clipIncompleteEntities, completeWays, completeRelations, cascadingRelations);
        this.polygonFile = polygonFile;
        this.area = null;
    }

    @Override
    public void process(BoundContainer boundContainer) {
        Bound newBound = null;
        if (this.area == null) {
            this.area = new PolygonFileReader(this.polygonFile).loadPolygon();
        }
        for (Bound b : boundContainer.getEntity().toSimpleBound()) {
            if (newBound == null) {
                newBound = this.simpleBoundIntersect(b);
                continue;
            }
            newBound = newBound.union(this.simpleBoundIntersect(b));
        }
        if (newBound != null) {
            super.process(new BoundContainer(newBound));
        }
    }

    private Bound simpleBoundIntersect(Bound bound) {
        Bound newBound = null;
        Area a2 = (Area)this.area.clone();
        if (bound.getLeft() > bound.getRight()) {
            return null;
        }
        double width = bound.getRight() - bound.getLeft();
        double height = bound.getTop() - bound.getBottom();
        a2.intersect(new Area(new Rectangle2D.Double(bound.getLeft(), bound.getBottom(), width, height)));
        if (!a2.isEmpty()) {
            Rectangle2D r = a2.getBounds2D();
            newBound = new Bound(r.getMaxX(), r.getMinX(), r.getMaxY(), r.getMinY(), bound.getOrigin());
        }
        return newBound;
    }

    @Override
    protected boolean isNodeWithinArea(Node node) {
        if (this.area == null) {
            this.area = new PolygonFileReader(this.polygonFile).loadPolygon();
        }
        double latitude = node.getLatitude();
        double longitude = node.getLongitude();
        return this.area.contains(longitude, latitude);
    }
}

