/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class ChangeSimplifierImpl
implements ChangeSinkChangeSource {
    private List<ChangeContainer> currentChanges = new ArrayList<ChangeContainer>();
    private ChangeSink changeSink;

    private void flushCurrentChanges() {
        ChangeContainer changeBegin = this.currentChanges.get(0);
        ChangeContainer changeEnd = this.currentChanges.get(this.currentChanges.size() - 1);
        ChangeAction actionBegin = changeBegin.getAction();
        ChangeAction actionEnd = changeEnd.getAction();
        ChangeAction actionResult = actionEnd.equals((Object)ChangeAction.Delete) ? ChangeAction.Delete : (actionBegin.equals((Object)ChangeAction.Create) ? ChangeAction.Create : ChangeAction.Modify);
        this.changeSink.process(new ChangeContainer(changeEnd.getEntityContainer(), actionResult));
        this.currentChanges.clear();
    }

    public void initialize(Map<String, Object> metaData) {
        this.changeSink.initialize(metaData);
    }

    public void process(ChangeContainer change) {
        long currentId;
        if (this.currentChanges.size() > 0 && (currentId = this.currentChanges.get(0).getEntityContainer().getEntity().getId()) != change.getEntityContainer().getEntity().getId()) {
            this.flushCurrentChanges();
        }
        this.currentChanges.add(change);
    }

    public void complete() {
        if (!this.currentChanges.isEmpty()) {
            this.flushCurrentChanges();
        }
        this.changeSink.complete();
    }

    public void release() {
        this.changeSink.release();
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }
}

