/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDataType;

public abstract class EntityMapper<T extends Entity> {
    public abstract String getEntityName();

    public abstract ActionDataType getEntityType();

    public abstract Class<T> getEntityClass();

    public String getSqlSelectCount(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT Count(e.*) AS count FROM " + this.getEntityName() + "s e");
        if (filterByEntityId) {
            resultSql.append(" WHERE e.id = ?");
        }
        return resultSql.toString();
    }

    protected abstract String[] getTypeSpecificFieldNames();

    public String getSqlSelect(boolean filterByEntityId, boolean orderByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT e.id, e.version, e.user_id, u.name AS user_name, e.tstamp, e.changeset_id");
        for (String fieldName : Arrays.asList(this.getTypeSpecificFieldNames())) {
            resultSql.append(", ").append(fieldName);
        }
        resultSql.append(" FROM ");
        resultSql.append(this.getEntityName());
        resultSql.append("s e");
        resultSql.append(" LEFT OUTER JOIN users u ON e.user_id = u.id");
        if (filterByEntityId) {
            resultSql.append(" WHERE e.id = ?");
        }
        if (orderByEntityId) {
            resultSql.append(" ORDER BY e.id");
        }
        return resultSql.toString();
    }

    public String getSqlInsert(int rowCount) {
        String[] typeSpecificFieldNames = this.getTypeSpecificFieldNames();
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO ").append(this.getEntityName()).append("s");
        resultSql.append("(id, version, user_id, tstamp, changeset_id");
        for (String fieldName : Arrays.asList(typeSpecificFieldNames)) {
            resultSql.append(", ").append(fieldName);
        }
        resultSql.append(") VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(?, ?, ?, ?, ?");
            for (int i = 0; i < typeSpecificFieldNames.length; ++i) {
                resultSql.append(", ?");
            }
            resultSql.append(")");
        }
        return resultSql.toString();
    }

    public String getSqlUpdate(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("UPDATE ").append(this.getEntityName()).append("s SET id = ?, version = ?, user_id = ?, tstamp = ?, changeset_id = ?");
        for (String fieldName : Arrays.asList(this.getTypeSpecificFieldNames())) {
            resultSql.append(", ").append(fieldName).append(" = ?");
        }
        if (filterByEntityId) {
            resultSql.append(" WHERE id = ?");
        }
        return resultSql.toString();
    }

    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM ").append(this.getEntityName()).append("s");
        if (filterByEntityId) {
            resultSql.append(" WHERE id = ?");
        }
        return resultSql.toString();
    }

    public abstract T parseRecord(ResultSet var1);

    protected OsmUser buildUser(ResultSet resultSet) {
        try {
            int userId = resultSet.getInt("user_id");
            OsmUser user = userId == OsmUser.NONE.getId() ? OsmUser.NONE : new OsmUser(userId, resultSet.getString("user_name"));
            return user;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a user from the current recordset row.", (Throwable)e);
        }
    }

    protected int populateCommonEntityParameters(PreparedStatement statement, int initialIndex, Entity entity) {
        int prmIndex = initialIndex;
        if (entity.getTimestamp() == null) {
            throw new OsmosisRuntimeException("Entity(" + entity.getType() + ") " + entity.getId() + " does not have a timestamp set.");
        }
        try {
            statement.setLong(prmIndex++, entity.getId());
            statement.setInt(prmIndex++, entity.getVersion());
            statement.setInt(prmIndex++, entity.getUser().getId());
            statement.setTimestamp(prmIndex++, new Timestamp(entity.getTimestamp().getTime()));
            statement.setLong(prmIndex++, entity.getChangesetId());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set a prepared statement parameter for entity(" + entity.getType() + ") " + entity.getId() + ".", (Throwable)e);
        }
        return prmIndex;
    }

    public abstract int populateEntityParameters(PreparedStatement var1, int var2, T var3);
}

