/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.ResultSet;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.common.BaseTableReader;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureMapper;

public class EntityFeatureTableReader<Tef extends Storeable, Tdb extends DbFeature<Tef>>
extends BaseTableReader<Tdb> {
    private EntityFeatureMapper<Tdb> entityFeatureBuilder;
    private String sql;

    public EntityFeatureTableReader(DatabaseContext dbCtx, EntityFeatureMapper<Tdb> entityFeatureBuilder) {
        super(dbCtx);
        this.entityFeatureBuilder = entityFeatureBuilder;
        this.sql = entityFeatureBuilder.getSqlSelect(false, true);
    }

    public EntityFeatureTableReader(DatabaseContext dbCtx, EntityFeatureMapper<Tdb> entityFeatureBuilder, String constraintTable) {
        super(dbCtx);
        this.entityFeatureBuilder = entityFeatureBuilder;
        this.sql = entityFeatureBuilder.getSqlSelect(false, false) + " INNER JOIN " + constraintTable + " c ON f." + entityFeatureBuilder.getParentEntityName() + "_id = c.id" + entityFeatureBuilder.getSqlDefaultOrderBy();
    }

    @Override
    protected ResultSet createResultSet(DatabaseContext queryDbCtx) {
        return queryDbCtx.executeQuery(this.sql);
    }

    @Override
    protected BaseTableReader.ReadResult<Tdb> createNextValue(ResultSet resultSet) {
        return new BaseTableReader.ReadResult<Tdb>(true, this.entityFeatureBuilder.buildEntity(resultSet));
    }
}

