/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;

public class DatabaseCapabilityChecker {
    private DatabaseContext dbCtx;
    private boolean initialized;
    private boolean isActionSupported;
    private boolean isWayBboxSupported;
    private boolean isWayLinestringSupported;

    public DatabaseCapabilityChecker(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
        this.initialized = false;
    }

    private void initialize() {
        if (!this.initialized) {
            this.isActionSupported = this.dbCtx.doesTableExist("actions");
            this.isWayBboxSupported = this.dbCtx.doesColumnExist("ways", "bbox");
            this.isWayLinestringSupported = this.dbCtx.doesColumnExist("ways", "linestring");
            this.initialized = true;
        }
    }

    public boolean isActionSupported() {
        this.initialize();
        return this.isActionSupported;
    }

    public boolean isWayBboxSupported() {
        this.initialize();
        return this.isWayBboxSupported;
    }

    public boolean isWayLinestringSupported() {
        this.initialize();
        return this.isWayLinestringSupported;
    }
}

