/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmElementProcessor;
import org.xml.sax.Attributes;

public class ChangeSourceElementProcessor
extends BaseElementProcessor {
    private static final String ELEMENT_NAME_CREATE = "create";
    private static final String ELEMENT_NAME_MODIFY = "modify";
    private static final String ELEMENT_NAME_DELETE = "delete";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private OsmElementProcessor createElementProcessor;
    private OsmElementProcessor modifyElementProcessor;
    private OsmElementProcessor deleteElementProcessor;

    public ChangeSourceElementProcessor(BaseElementProcessor parentProcessor, ChangeSink changeSink, boolean enableDateParsing) {
        super(parentProcessor, enableDateParsing);
        this.createElementProcessor = new OsmElementProcessor(this, new ChangeSinkAdapter(changeSink, ChangeAction.Create), enableDateParsing, false, true);
        this.modifyElementProcessor = new OsmElementProcessor(this, new ChangeSinkAdapter(changeSink, ChangeAction.Modify), enableDateParsing, false, true);
        this.deleteElementProcessor = new OsmElementProcessor(this, new ChangeSinkAdapter(changeSink, ChangeAction.Delete), enableDateParsing, false, false);
    }

    @Override
    public void begin(Attributes attributes) {
        String fileVersion = attributes.getValue(ATTRIBUTE_NAME_VERSION);
        if (!"0.6".equals(fileVersion)) {
            System.err.println("Warning, expected version 0.6 but received " + fileVersion + ".");
        }
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (ELEMENT_NAME_CREATE.equals(qName)) {
            return this.createElementProcessor;
        }
        if (ELEMENT_NAME_MODIFY.equals(qName)) {
            return this.modifyElementProcessor;
        }
        if (ELEMENT_NAME_DELETE.equals(qName)) {
            return this.deleteElementProcessor;
        }
        return super.getChild(uri, localName, qName);
    }

    @Override
    public void end() {
    }

    private static class ChangeSinkAdapter
    implements Sink {
        private ChangeSink changeSink;
        private ChangeAction action;

        public ChangeSinkAdapter(ChangeSink changeSink, ChangeAction action) {
            this.changeSink = changeSink;
            this.action = action;
        }

        public void initialize(Map<String, Object> metaData) {
            this.changeSink.initialize(metaData);
        }

        public void process(EntityContainer entityContainer) {
            this.changeSink.process(new ChangeContainer(entityContainer, this.action));
        }

        public void complete() {
            this.changeSink.complete();
        }

        public void release() {
            this.changeSink.release();
        }
    }
}

