/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.Comparator;
import java.util.HashMap;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityContainerComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.SortedDeltaChangePipeValidator;
import org.openstreetmap.osmosis.core.sort.v0_6.SortedEntityPipeValidator;
import org.openstreetmap.osmosis.core.store.DataPostbox;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.MultiSinkMultiChangeSinkRunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.set.v0_6.impl.DataPostboxChangeSink;
import org.openstreetmap.osmosis.set.v0_6.impl.DataPostboxSink;

public class ChangeApplier
implements MultiSinkMultiChangeSinkRunnableSource {
    private Sink sink;
    private DataPostbox<EntityContainer> basePostbox;
    private SortedEntityPipeValidator sortedEntityValidator;
    private DataPostbox<ChangeContainer> changePostbox;
    private SortedDeltaChangePipeValidator sortedChangeValidator;

    public ChangeApplier(int inputBufferCapacity) {
        this.basePostbox = new DataPostbox(inputBufferCapacity);
        this.sortedEntityValidator = new SortedEntityPipeValidator();
        this.sortedEntityValidator.setSink((Sink)new DataPostboxSink(this.basePostbox));
        this.changePostbox = new DataPostbox(inputBufferCapacity);
        this.sortedChangeValidator = new SortedDeltaChangePipeValidator();
        this.sortedChangeValidator.setChangeSink((ChangeSink)new DataPostboxChangeSink(this.changePostbox));
    }

    public Sink getSink(int instance) {
        if (instance != 0) {
            throw new OsmosisRuntimeException("Sink instance " + instance + " is not valid.");
        }
        return this.sortedEntityValidator;
    }

    public int getSinkCount() {
        return 1;
    }

    public ChangeSink getChangeSink(int instance) {
        if (instance != 0) {
            throw new OsmosisRuntimeException("Change sink instance " + instance + " is not valid.");
        }
        return this.sortedChangeValidator;
    }

    public int getChangeSinkCount() {
        return 1;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    private void processBaseOnlyEntity(EntityContainer entityContainer) {
        this.sink.process(entityContainer);
    }

    private void processChangeOnlyEntity(ChangeContainer changeContainer) {
        if (changeContainer.getAction().equals((Object)ChangeAction.Create) || changeContainer.getAction().equals((Object)ChangeAction.Modify)) {
            this.sink.process(changeContainer.getEntityContainer());
        }
    }

    private void processBothSourceEntity(EntityContainer entityContainer, ChangeContainer changeContainer) {
        if (changeContainer.getAction().equals((Object)ChangeAction.Create) || changeContainer.getAction().equals((Object)ChangeAction.Modify)) {
            this.sink.process(changeContainer.getEntityContainer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            EntityContainer base = null;
            ChangeContainer change = null;
            EntityContainerComparator comparator = new EntityContainerComparator((Comparator)new EntityByTypeThenIdComparator());
            HashMap metaData = new HashMap();
            metaData.putAll(this.basePostbox.outputInitialize());
            metaData.putAll(this.changePostbox.outputInitialize());
            this.sink.initialize(metaData);
            while ((base != null || this.basePostbox.hasNext()) && (change != null || this.changePostbox.hasNext())) {
                int comparisonResult;
                if (base == null) {
                    base = (EntityContainer)this.basePostbox.getNext();
                }
                if (change == null) {
                    change = (ChangeContainer)this.changePostbox.getNext();
                }
                if ((comparisonResult = comparator.compare(base, change.getEntityContainer())) < 0) {
                    this.processBaseOnlyEntity(base);
                    base = null;
                    continue;
                }
                if (comparisonResult > 0) {
                    this.processChangeOnlyEntity(change);
                    change = null;
                    continue;
                }
                this.processBothSourceEntity(base, change);
                base = null;
                change = null;
            }
            while (base != null || this.basePostbox.hasNext()) {
                if (base == null) {
                    base = (EntityContainer)this.basePostbox.getNext();
                }
                this.processBaseOnlyEntity(base);
                base = null;
            }
            while (change != null || this.changePostbox.hasNext()) {
                if (change == null) {
                    change = (ChangeContainer)this.changePostbox.getNext();
                }
                this.processChangeOnlyEntity(change);
                change = null;
            }
            this.sink.complete();
            this.basePostbox.outputComplete();
            this.changePostbox.outputComplete();
        }
        finally {
            this.sink.release();
            this.basePostbox.outputRelease();
            this.changePostbox.outputRelease();
        }
    }
}

