/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.store.DataPostbox;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.MultiChangeSinkRunnableChangeSource;
import org.openstreetmap.osmosis.set.v0_6.impl.DataPostboxChangeSink;

public class ChangeAppender
implements MultiChangeSinkRunnableChangeSource {
    private List<DataPostbox<ChangeContainer>> sources;
    private ChangeSink changeSink;

    public ChangeAppender(int sourceCount, int inputBufferCapacity) {
        this.sources = new ArrayList<DataPostbox<ChangeContainer>>(sourceCount);
        for (int i = 0; i < sourceCount; ++i) {
            this.sources.add((DataPostbox<ChangeContainer>)new DataPostbox(inputBufferCapacity));
        }
    }

    public ChangeSink getChangeSink(int instance) {
        if (instance < 0 || instance >= this.sources.size()) {
            throw new OsmosisRuntimeException("Sink instance " + instance + " is not valid.");
        }
        return new DataPostboxChangeSink(this.sources.get(instance));
    }

    public int getChangeSinkCount() {
        return this.sources.size();
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            HashMap metaData = new HashMap();
            for (DataPostbox<ChangeContainer> source : this.sources) {
                metaData.putAll(source.outputInitialize());
            }
            this.changeSink.initialize(metaData);
            for (DataPostbox<ChangeContainer> source : this.sources) {
                while (source.hasNext()) {
                    this.changeSink.process((ChangeContainer)source.getNext());
                }
            }
            this.changeSink.complete();
            for (DataPostbox<ChangeContainer> source : this.sources) {
                source.outputComplete();
            }
        }
        finally {
            this.changeSink.release();
            for (DataPostbox<ChangeContainer> source : this.sources) {
                source.outputRelease();
            }
        }
    }
}

