/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.store.BufferedRandomAccessFileInputStream;
import org.openstreetmap.osmosis.core.store.DataInputStoreReader;
import org.openstreetmap.osmosis.core.store.DataOutputStoreWriter;
import org.openstreetmap.osmosis.core.store.DynamicStoreClassRegister;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.ObjectWriter;
import org.openstreetmap.osmosis.core.store.OffsetTrackingOutputStream;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStoreReader;
import org.openstreetmap.osmosis.core.store.StorageStage;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.Storeable;

public class RandomAccessObjectStore<T extends Storeable>
implements Completable {
    private static final Logger LOG = Logger.getLogger(RandomAccessObjectStore.class.getName());
    private ObjectSerializationFactory serializationFactory;
    private StorageStage stage;
    private String tempFilePrefix;
    private File tempFile;
    private File storageFile;
    private OffsetTrackingOutputStream offsetTrackingStream;
    private StoreClassRegister storeClassRegister;
    private ObjectWriter objectWriter;

    public RandomAccessObjectStore(ObjectSerializationFactory serializationFactory, String tempFilePrefix) {
        this.serializationFactory = serializationFactory;
        this.tempFilePrefix = tempFilePrefix;
        this.storeClassRegister = new DynamicStoreClassRegister();
        this.stage = StorageStage.NotStarted;
    }

    public RandomAccessObjectStore(ObjectSerializationFactory serializationFactory, File storageFile) {
        this.serializationFactory = serializationFactory;
        this.storageFile = storageFile;
        this.storeClassRegister = new DynamicStoreClassRegister();
        this.stage = StorageStage.NotStarted;
    }

    private void initializeAddStage() {
        if (this.stage.compareTo(StorageStage.Add) > 0) {
            throw new OsmosisRuntimeException("Cannot add to storage in stage " + (Object)((Object)this.stage) + ".");
        }
        if (this.stage.compareTo(StorageStage.Add) < 0) {
            FileOutputStream fileStream = null;
            try {
                if (this.storageFile == null) {
                    this.storageFile = this.tempFile = File.createTempFile(this.tempFilePrefix, null);
                }
                fileStream = new FileOutputStream(this.storageFile);
                this.offsetTrackingStream = new OffsetTrackingOutputStream(new BufferedOutputStream(fileStream, 65536));
                fileStream = null;
                this.objectWriter = this.serializationFactory.createObjectWriter(new DataOutputStoreWriter(new DataOutputStream(this.offsetTrackingStream)), this.storeClassRegister);
                this.stage = StorageStage.Add;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to create object stream writing to file " + this.storageFile + ".", e);
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {
                        LOG.log(Level.WARNING, "Unable to close file stream.", e);
                    }
                }
            }
        }
    }

    public long add(T data) {
        this.initializeAddStage();
        long objectFileOffset = this.offsetTrackingStream.getByteCount();
        this.objectWriter.writeObject((Storeable)data);
        return objectFileOffset;
    }

    private void initializeReadingStage() {
        if (this.stage.equals((Object)StorageStage.Reading)) {
            return;
        }
        if (this.stage.equals((Object)StorageStage.Add)) {
            throw new OsmosisRuntimeException("Cannot begin reading in " + (Object)((Object)StorageStage.Add) + " stage, must call complete first.");
        }
        if (this.stage.compareTo(StorageStage.Reading) < 0) {
            this.stage = StorageStage.Reading;
        }
        if (this.stage.compareTo(StorageStage.Reading) > 0) {
            throw new OsmosisRuntimeException("Cannot read from storage once we've reached stage " + (Object)((Object)this.stage) + ".");
        }
    }

    public RandomAccessObjectStoreReader<T> createReader() {
        this.initializeReadingStage();
        try {
            BufferedRandomAccessFileInputStream randomFileReader = new BufferedRandomAccessFileInputStream(this.storageFile);
            return new RandomAccessObjectStoreReader(randomFileReader, this.serializationFactory.createObjectReader(new DataInputStoreReader(new DataInputStream(randomFileReader)), this.storeClassRegister));
        }
        catch (FileNotFoundException e) {
            throw new OsmosisRuntimeException("Unable to create object stream reading from file " + this.storageFile + ".", e);
        }
    }

    @Override
    public void complete() {
        if (this.stage.compareTo(StorageStage.Reading) != 0) {
            this.initializeAddStage();
            try {
                this.offsetTrackingStream.close();
                this.offsetTrackingStream = null;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to close the file " + this.storageFile + ".");
            }
            this.stage = StorageStage.Reading;
        }
    }

    @Override
    public void release() {
        if (this.offsetTrackingStream != null) {
            try {
                this.offsetTrackingStream.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to close offset tracking output stream.", e);
            }
            this.offsetTrackingStream = null;
        }
        if (this.tempFile != null) {
            if (!this.tempFile.delete()) {
                LOG.warning("Unable to delete file " + this.tempFile);
            }
            this.tempFile = null;
        }
        this.stage = StorageStage.Released;
    }
}

