/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.util.ArrayList;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureTableReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationMemberMapper;

public class RelationReader
extends EntityReader<Relation> {
    private PeekableIterator<DbOrderedFeature<RelationMember>> relationMemberReader;

    public RelationReader(DatabaseContext dbCtx) {
        super(dbCtx, new RelationMapper());
        this.relationMemberReader = new PeekableIterator(new EntityFeatureTableReader(dbCtx, new RelationMemberMapper()));
    }

    public RelationReader(DatabaseContext dbCtx, String constraintTable) {
        super(dbCtx, new RelationMapper(), constraintTable);
        this.relationMemberReader = new PeekableIterator(new EntityFeatureTableReader(dbCtx, new RelationMemberMapper(), constraintTable));
    }

    @Override
    protected void populateEntityFeatures(Relation entity) {
        DbFeature wayNode;
        super.populateEntityFeatures(entity);
        long relationId = entity.getId();
        while (this.relationMemberReader.hasNext() && (wayNode = (DbFeature)this.relationMemberReader.peekNext()).getEntityId() < relationId) {
            this.relationMemberReader.next();
        }
        ArrayList<Object> relationMembers = new ArrayList<Object>();
        while (this.relationMemberReader.hasNext() && ((DbOrderedFeature)this.relationMemberReader.peekNext()).getEntityId() == relationId) {
            relationMembers.add(this.relationMemberReader.next());
        }
        for (DbFeature dbFeature : relationMembers) {
            entity.getMembers().add(dbFeature.getFeature());
        }
    }

    @Override
    public void release() {
        super.release();
        this.relationMemberReader.release();
    }
}

