/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.BaseElementProcessor;
import org.openstreetmap.osmosis.xml.common.ElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.BoundsElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.LegacyBoundElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.NodeElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.RelationElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.SourceElementProcessor;
import org.openstreetmap.osmosis.xml.v0_6.impl.WayElementProcessor;
import org.xml.sax.Attributes;

public class OsmElementProcessor
extends SourceElementProcessor {
    private static final Logger LOG = Logger.getLogger(OsmElementProcessor.class.getName());
    private static final String ELEMENT_NAME_BOUND_LEGACY = "bound";
    private static final String ELEMENT_NAME_BOUNDS = "bounds";
    private static final String ELEMENT_NAME_NODE = "node";
    private static final String ELEMENT_NAME_WAY = "way";
    private static final String ELEMENT_NAME_RELATION = "relation";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_GENERATOR = "generator";
    private NodeElementProcessor nodeElementProcessor;
    private WayElementProcessor wayElementProcessor;
    private RelationElementProcessor relationElementProcessor;
    private boolean foundBound = false;
    private boolean foundEntities = false;
    private boolean validateVersion;
    private String generator;

    public OsmElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing, boolean validateVersion) {
        this(parentProcessor, sink, enableDateParsing, validateVersion, true);
    }

    public OsmElementProcessor(BaseElementProcessor parentProcessor, Sink sink, boolean enableDateParsing, boolean validateVersion, boolean coordinatesRequired) {
        super(parentProcessor, sink, enableDateParsing);
        this.validateVersion = validateVersion;
        this.nodeElementProcessor = new NodeElementProcessor(this, this.getSink(), enableDateParsing, coordinatesRequired);
        this.wayElementProcessor = new WayElementProcessor(this, this.getSink(), enableDateParsing);
        this.relationElementProcessor = new RelationElementProcessor(this, this.getSink(), enableDateParsing);
    }

    @Override
    public void begin(Attributes attributes) {
        String fileVersion;
        if (this.validateVersion && !"0.6".equals(fileVersion = attributes.getValue(ATTRIBUTE_NAME_VERSION))) {
            LOG.warning("Expected version 0.6 but received " + fileVersion + ".");
        }
        this.generator = attributes.getValue(ATTRIBUTE_NAME_GENERATOR);
    }

    @Override
    public ElementProcessor getChild(String uri, String localName, String qName) {
        if (ELEMENT_NAME_BOUNDS.equals(qName) || ELEMENT_NAME_BOUND_LEGACY.equals(qName)) {
            if (this.foundEntities) {
                throw new OsmosisRuntimeException("Bound element must come before any entities.");
            }
            if (this.foundBound) {
                throw new OsmosisRuntimeException("Only one bound element allowed.");
            }
            this.foundBound = true;
            if (ELEMENT_NAME_BOUND_LEGACY.equals(qName)) {
                LOG.fine("Legacy <bound> element encountered.");
                return new LegacyBoundElementProcessor(this, this.getSink(), true);
            }
            return new BoundsElementProcessor(this, this.getSink(), true, this.generator);
        }
        if (ELEMENT_NAME_NODE.equals(qName)) {
            this.foundEntities = true;
            return this.nodeElementProcessor;
        }
        if (ELEMENT_NAME_WAY.equals(qName)) {
            this.foundEntities = true;
            return this.wayElementProcessor;
        }
        if (ELEMENT_NAME_RELATION.equals(qName)) {
            this.foundEntities = true;
            return this.relationElementProcessor;
        }
        return super.getChild(uri, localName, qName);
    }

    @Override
    public void end() {
    }
}

