/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.util.AtomicFileCreator;

public class PropertiesPersister {
    private static final Logger LOG = Logger.getLogger(PropertiesPersister.class.getName());
    private AtomicFileCreator atomicFileCreator;

    public PropertiesPersister(File propertiesFile) {
        this.atomicFileCreator = new AtomicFileCreator(propertiesFile);
    }

    public Properties load() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.atomicFileCreator.getFile());
            InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(fileInputStream), Charset.forName("UTF-8"));
            Properties properties = new Properties();
            properties.load(reader);
            fileInputStream.close();
            fileInputStream = null;
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read the properties from file " + this.atomicFileCreator.getFile() + ".", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to close properties file " + this.atomicFileCreator.getFile() + ".", e);
                }
            }
        }
    }

    public Map<String, String> loadMap() {
        return new HashMap<Object, Object>(this.load());
    }

    public void store(Properties properties) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.atomicFileCreator.getTmpFile());
            OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(fileOutputStream));
            properties.store(writer, null);
            ((Writer)writer).close();
            this.atomicFileCreator.renameTmpFileToCurrent();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write the properties to temporary file " + this.atomicFileCreator.getTmpFile() + ".", e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to close temporary state file " + this.atomicFileCreator.getTmpFile() + ".", e);
                }
            }
        }
    }

    public void store(Map<String, String> propertiesMap) {
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        this.store(properties);
    }

    public boolean exists() {
        return this.atomicFileCreator.exists();
    }
}

