/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.report.v0_6;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.filter.common.BitSetIdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class IntegrityReporter
implements Sink,
EntityProcessor {
    private static final Logger LOG = Logger.getLogger(IntegrityReporter.class.getName());
    private File file;
    private boolean initialized;
    private BufferedWriter writer;
    private IdTracker nodeBitSet;
    private IdTracker wayBitSet;

    public IntegrityReporter(File file) {
        this.file = file;
        this.initialized = false;
        this.nodeBitSet = new BitSetIdTracker();
        this.wayBitSet = new BitSetIdTracker();
    }

    private void write(String data) {
        try {
            this.writer.write(data);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", e);
        }
    }

    private void writeNewLine() {
        try {
            this.writer.newLine();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write data.", e);
        }
    }

    protected void initialize() {
        if (!this.initialized) {
            FileOutputStream outStream = null;
            try {
                outStream = new FileOutputStream(this.file);
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, "UTF-8"));
                outStream = null;
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to open file " + this.file + " for writing.", e);
            }
            finally {
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Unable to close output stream for file " + this.file + ".", e);
                    }
                    outStream = null;
                }
            }
            this.initialized = true;
            this.write("Entity Type, Entity Id, Referred Type, Referred Id");
            this.writeNewLine();
        }
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
    }

    @Override
    public void process(EntityContainer entityContainer) {
        entityContainer.process(this);
    }

    @Override
    public void process(BoundContainer bound) {
    }

    @Override
    public void process(NodeContainer node) {
        this.nodeBitSet.set(node.getEntity().getId());
    }

    @Override
    public void process(WayContainer wayContainer) {
        Way way = wayContainer.getEntity();
        this.wayBitSet.set(way.getId());
        for (WayNode wayNode : way.getWayNodes()) {
            if (this.nodeBitSet.get(wayNode.getNodeId())) continue;
            this.initialize();
            this.write("Way," + way.getId() + ",Node," + wayNode.getNodeId());
            this.writeNewLine();
        }
    }

    @Override
    public void process(RelationContainer relationContainer) {
        Relation relation = relationContainer.getEntity();
        for (RelationMember relationMember : relation.getMembers()) {
            EntityType memberType = relationMember.getMemberType();
            if (EntityType.Node.equals((Object)memberType)) {
                if (this.nodeBitSet.get(relationMember.getMemberId())) continue;
                this.initialize();
                this.write("Relation," + relation.getId() + ",Node," + relationMember.getMemberId());
                this.writeNewLine();
                continue;
            }
            if (!EntityType.Way.equals((Object)memberType) || this.wayBitSet.get(relationMember.getMemberId())) continue;
            this.initialize();
            this.write("Relation," + relation.getId() + ",Way," + relationMember.getMemberId());
            this.writeNewLine();
        }
    }

    @Override
    public void complete() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to complete writing to the file " + this.file + ".", e);
        }
        finally {
            this.initialized = false;
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        try {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Unable to close writer.", e);
            }
        }
        finally {
            this.initialized = false;
            this.writer = null;
        }
    }
}

