/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;

public class Bound
extends Entity
implements Comparable<Bound> {
    private static final double MIN_LATITUDE = -90.0;
    private static final double MAX_LATITUDE = 90.0;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MAX_LONGITUDE = 180.0;
    private double right;
    private double left;
    private double top;
    private double bottom;
    private String origin;

    public Bound(String origin) {
        this(180.0, -180.0, 90.0, -90.0, origin);
    }

    public Bound(double right, double left, double top, double bottom, String origin) {
        super(new CommonEntityData(0L, 0, new Date(), OsmUser.NONE, 0L));
        if (Double.compare(right, 181.0) > 0 || Double.compare(right, -181.0) < 0 || Double.compare(left, 181.0) > 0 || Double.compare(left, -181.0) < 0 || Double.compare(top, 91.0) > 0 || Double.compare(top, -91.0) < 0 || Double.compare(bottom, 91.0) > 0 || Double.compare(bottom, -91.0) < 0) {
            throw new IllegalArgumentException("Bound coordinates outside of valid range");
        }
        if (Double.compare(top, bottom) < 0) {
            throw new IllegalArgumentException("Bound top < bottom");
        }
        this.right = right;
        this.left = left;
        this.top = top;
        this.bottom = bottom;
        this.origin = origin;
    }

    public Bound(StoreReader sr, StoreClassRegister scr) {
        super(sr, scr);
        this.right = sr.readDouble();
        this.left = sr.readDouble();
        this.top = sr.readDouble();
        this.bottom = sr.readDouble();
        this.origin = sr.readString();
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        super.store(sw, scr);
        sw.writeDouble(this.right);
        sw.writeDouble(this.left);
        sw.writeDouble(this.top);
        sw.writeDouble(this.bottom);
        sw.writeString(this.origin);
    }

    @Override
    public EntityType getType() {
        return EntityType.Bound;
    }

    public double getRight() {
        return this.right;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Bound intersect(Bound intersectingBound) {
        boolean this180;
        double newRight = 0.0;
        double newLeft = 0.0;
        if (intersectingBound == null) {
            return null;
        }
        double newTop = Math.min(this.getTop(), intersectingBound.getTop());
        double newBottom = Math.max(this.getBottom(), intersectingBound.getBottom());
        if (Double.compare(newBottom, newTop) >= 0) {
            return null;
        }
        boolean intersect180 = Double.compare(intersectingBound.getLeft(), intersectingBound.getRight()) > 0;
        boolean bl = this180 = Double.compare(this.getLeft(), this.getRight()) > 0;
        if (intersect180 && this180 || !intersect180 && !this180) {
            newRight = Math.min(this.getRight(), intersectingBound.getRight());
            newLeft = Math.max(this.getLeft(), intersectingBound.getLeft());
            if (!intersect180 && !this180 && Double.compare(newLeft, newRight) >= 0) {
                return null;
            }
        } else {
            Bound b2;
            Bound b1;
            if (intersect180 && !this180) {
                b1 = this;
                b2 = intersectingBound;
            } else {
                b1 = intersectingBound;
                b2 = this;
            }
            if (Double.compare(b1.getRight(), b2.getLeft()) > 0 && Double.compare(b1.getLeft(), b2.getRight()) < 0) {
                Double diff1 = b1.getRight() - b1.getLeft();
                Double diff2 = b2.getRight() - -180.0 + 180.0 - b2.getLeft();
                if (Double.compare(diff1, diff2) <= 0) {
                    newRight = b1.getRight();
                    newLeft = b1.getLeft();
                } else {
                    newRight = b2.getRight();
                    newLeft = b2.getLeft();
                }
            } else if (Double.compare(b1.getRight(), b2.getLeft()) > 0) {
                newRight = b1.getRight();
                newLeft = b2.getLeft();
            } else if (Double.compare(b1.getLeft(), b2.getRight()) < 0) {
                newRight = b2.getRight();
                newLeft = b1.getLeft();
            }
        }
        if (Double.compare(newRight, newLeft) == 0) {
            return null;
        }
        String newOrigin = this.origin != "" ? this.origin : intersectingBound.origin;
        return new Bound(newRight, newLeft, newTop, newBottom, newOrigin);
    }

    public Bound union(Bound unionBound) {
        double newRight = 0.0;
        double newLeft = 0.0;
        if (unionBound == null) {
            return this;
        }
        double newTop = Math.max(this.getTop(), unionBound.getTop());
        double newBottom = Math.min(this.getBottom(), unionBound.getBottom());
        if (Double.compare(newBottom, newTop) >= 0) {
            return null;
        }
        if (Double.compare(this.getLeft(), -180.0) == 0 && Double.compare(this.getRight(), 180.0) == 0 || Double.compare(unionBound.getLeft(), -180.0) == 0 && Double.compare(unionBound.getRight(), 180.0) == 0) {
            newRight = 180.0;
            newLeft = -180.0;
        } else {
            boolean this180;
            boolean union180 = Double.compare(unionBound.getLeft(), unionBound.getRight()) > 0;
            boolean bl = this180 = Double.compare(this.getLeft(), this.getRight()) > 0;
            if (union180 && this180) {
                newRight = Math.max(this.getRight(), unionBound.getRight());
                newLeft = Math.min(this.getLeft(), unionBound.getLeft());
            } else if (!union180 && !this180) {
                double size2;
                double size1 = Math.max(this.getRight(), unionBound.getRight()) - Math.min(this.getLeft(), unionBound.getLeft());
                if (Double.compare(size1, size2 = Math.min(this.getRight(), unionBound.getRight()) - -180.0 + (180.0 - Math.max(this.getLeft(), unionBound.getLeft()))) <= 0) {
                    newRight = Math.max(this.getRight(), unionBound.getRight());
                    newLeft = Math.min(this.getLeft(), unionBound.getLeft());
                } else {
                    newRight = Math.min(this.getRight(), unionBound.getRight());
                    newLeft = Math.max(this.getLeft(), unionBound.getLeft());
                }
            } else {
                Bound b2;
                Bound b1;
                if (union180 && !this180) {
                    b1 = unionBound;
                    b2 = this;
                } else {
                    b1 = this;
                    b2 = unionBound;
                }
                if (Double.compare(b1.getRight(), b2.getLeft()) >= 0 && Double.compare(b1.getLeft(), b2.getRight()) <= 0) {
                    newLeft = -180.0;
                    newRight = 180.0;
                } else {
                    double size2;
                    double size1 = Math.max(b1.getRight(), b2.getRight()) - -180.0 + (180.0 - b1.getLeft());
                    if (Double.compare(size1, size2 = b1.getRight() - -180.0 + (180.0 - Math.min(b1.getLeft(), b2.getLeft()))) <= 0) {
                        newRight = Math.max(b1.getRight(), b2.getRight());
                        newLeft = b1.getLeft();
                    } else {
                        newRight = b1.getRight();
                        newLeft = Math.min(b1.getLeft(), b2.getLeft());
                    }
                }
            }
        }
        if (Double.compare(newRight, newLeft) == 0) {
            return null;
        }
        String newOrigin = this.getOrigin() != null && !this.getOrigin().equals("") ? this.getOrigin() : unionBound.getOrigin();
        return new Bound(newRight, newLeft, newTop, newBottom, newOrigin);
    }

    public Iterable<Bound> toSimpleBound() {
        LinkedList<Bound> c = new LinkedList<Bound>();
        if (Double.compare(this.getLeft(), this.getRight()) < 0) {
            c.add(this);
        } else {
            c.add(new Bound(180.0, this.getLeft(), this.getTop(), this.getBottom(), this.getOrigin()));
            c.add(new Bound(this.getRight(), -180.0, this.getTop(), this.getBottom(), this.getOrigin()));
        }
        return Collections.unmodifiableCollection(c);
    }

    @Override
    public int compareTo(Bound comparisonBound) {
        double areaT = 0.0;
        double areaC = 0.0;
        for (Bound b : this.toSimpleBound()) {
            areaT += (b.getRight() - b.getLeft()) * (b.getTop() - b.getBottom());
        }
        for (Bound b : comparisonBound.toSimpleBound()) {
            areaC += (b.getRight() - b.getLeft()) * (b.getTop() - b.getBottom());
        }
        int result = Double.compare(areaT, areaC);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getTop(), comparisonBound.getTop());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getBottom(), comparisonBound.getBottom());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getLeft(), comparisonBound.getLeft());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getRight(), comparisonBound.getRight());
        if (result != 0) {
            return result;
        }
        String myOrigin = this.getOrigin();
        String otherOrigin = comparisonBound.getOrigin();
        if (myOrigin == null) {
            if (otherOrigin == null) {
                return 0;
            }
            return -1;
        }
        if (otherOrigin == null) {
            return 1;
        }
        return myOrigin.compareTo(otherOrigin);
    }

    public boolean equals(Object o) {
        if (o instanceof Bound) {
            return this.compareTo((Bound)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    @Override
    public Bound getWriteableInstance() {
        return this;
    }

    public String toString() {
        return "Bound(top=" + this.getTop() + ", bottom=" + this.getBottom() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }
}

