/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.hstore.PGHStore;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDataType;
import org.springframework.jdbc.core.RowMapper;

public abstract class EntityMapper<T extends Entity> {
    public abstract String getEntityName();

    public abstract ActionDataType getEntityType();

    public abstract Class<T> getEntityClass();

    public abstract RowMapper<T> getRowMapper();

    public String getSqlSelectCount(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT Count(e.*) AS count FROM " + this.getEntityName() + "s e");
        if (filterByEntityId) {
            resultSql.append(" WHERE e.id = ?");
        }
        return resultSql.toString();
    }

    protected abstract String[] getTypeSpecificFieldNames();

    public String getSqlSelect(boolean filterByEntityId, boolean orderByEntityId) {
        return this.getSqlSelect("", filterByEntityId, orderByEntityId);
    }

    public String getSqlSelect(String tablePrefix, boolean filterByEntityId, boolean orderByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT e.id, e.version, e.user_id, u.name AS user_name, e.tstamp, e.changeset_id, e.tags");
        for (String fieldName : Arrays.asList(this.getTypeSpecificFieldNames())) {
            resultSql.append(", ").append(fieldName);
        }
        resultSql.append(" FROM ");
        resultSql.append(tablePrefix).append(this.getEntityName()).append("s e");
        resultSql.append(" LEFT OUTER JOIN users u ON e.user_id = u.id");
        if (filterByEntityId) {
            resultSql.append(" WHERE e.id = ?");
        }
        if (orderByEntityId) {
            resultSql.append(" ORDER BY e.id");
        }
        return resultSql.toString();
    }

    public String getSqlInsert(int rowCount) {
        String[] typeSpecificFieldNames = this.getTypeSpecificFieldNames();
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO ").append(this.getEntityName()).append("s");
        resultSql.append("(id, version, user_id, tstamp, changeset_id, tags");
        for (String fieldName : Arrays.asList(typeSpecificFieldNames)) {
            resultSql.append(", ").append(fieldName);
        }
        resultSql.append(") VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(:id, :version, :userId, :timestamp, :changesetId, :tags");
            for (int i = 0; i < typeSpecificFieldNames.length; ++i) {
                resultSql.append(", :").append(typeSpecificFieldNames[i]);
            }
            resultSql.append(")");
        }
        return resultSql.toString();
    }

    public String getSqlUpdate(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("UPDATE ").append(this.getEntityName()).append("s SET id = :id, version = :version, user_id = :userId, tstamp = :timestamp, changeset_id = :changesetId, tags = :tags");
        for (String fieldName : Arrays.asList(this.getTypeSpecificFieldNames())) {
            resultSql.append(", ").append(fieldName).append(" = :").append(fieldName);
        }
        if (filterByEntityId) {
            resultSql.append(" WHERE id = :id");
        }
        return resultSql.toString();
    }

    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM ").append(this.getEntityName()).append("s");
        if (filterByEntityId) {
            resultSql.append(" WHERE id = :id");
        }
        return resultSql.toString();
    }

    protected void populateCommonEntityParameters(Map<String, Object> args, Entity entity) {
        if (entity.getTimestamp() == null) {
            throw new OsmosisRuntimeException("Entity(" + entity.getType() + ") " + entity.getId() + " does not have a timestamp set.");
        }
        PGHStore tags = new PGHStore();
        for (Tag tag : entity.getTags()) {
            tags.put(tag.getKey(), tag.getValue());
        }
        args.put("id", entity.getId());
        args.put("version", entity.getVersion());
        args.put("userId", entity.getUser().getId());
        args.put("timestamp", new Timestamp(entity.getTimestamp().getTime()));
        args.put("changesetId", entity.getChangesetId());
        args.put("tags", tags);
    }

    public abstract void populateEntityParameters(Map<String, Object> var1, T var2);
}

