/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.SchemaVersionValidator;

public class PostgreSqlTruncator
implements RunnableTask {
    private static final Logger LOG = Logger.getLogger(PostgreSqlTruncator.class.getName());
    private static final String[] SQL_TABLE_NAMES = new String[]{"actions", "users", "nodes", "node_tags", "ways", "way_tags", "way_nodes", "relations", "relation_tags", "relation_members"};
    private DatabaseContext dbCtx;
    private SchemaVersionValidator schemaVersionValidator;

    public PostgreSqlTruncator(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences) {
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.schemaVersionValidator = new SchemaVersionValidator(this.dbCtx.getJdbcTemplate(), preferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.schemaVersionValidator.validateVersion(6);
            this.dbCtx.beginTransaction();
            LOG.fine("Truncating tables.");
            for (int i = 0; i < SQL_TABLE_NAMES.length; ++i) {
                if (this.dbCtx.doesTableExist(SQL_TABLE_NAMES[i])) {
                    LOG.finer("Truncating table " + SQL_TABLE_NAMES[i] + ".");
                    this.dbCtx.getJdbcTemplate().update("TRUNCATE " + SQL_TABLE_NAMES[i]);
                    continue;
                }
                LOG.finer("Skipping table " + SQL_TABLE_NAMES[i] + " which doesn't exist in the current schema.");
            }
            LOG.fine("Committing changes.");
            this.dbCtx.commitTransaction();
            LOG.fine("Vacuuming database.");
            this.dbCtx.getJdbcTemplate().update("VACUUM ANALYZE");
            LOG.fine("Complete.");
        }
        finally {
            this.dbCtx.release();
        }
    }
}

