/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6;

import java.io.File;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkManager;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.PostgreSqlDumpWriter;

public class PostgreSqlDumpWriterFactory
extends TaskManagerFactory {
    private static final String ARG_ENABLE_BBOX_BUILDER = "enableBboxBuilder";
    private static final String ARG_ENABLE_LINESTRING_BUILDER = "enableLinestringBuilder";
    private static final String ARG_KEEP_INVALID_WAYS = "keepInvalidWays";
    private static final String ARG_FILE_NAME = "directory";
    private static final String ARG_NODE_LOCATION_STORE_TYPE = "nodeLocationStoreType";
    private static final boolean DEFAULT_ENABLE_BBOX_BUILDER = false;
    private static final boolean DEFAULT_ENABLE_LINESTRING_BUILDER = false;
    private static final boolean DEFAULT_KEEP_INVALID_WAYS = true;
    private static final String DEFAULT_FILE_PREFIX = "pgimport";
    private static final String DEFAULT_NODE_LOCATION_STORE_TYPE = "CompactTempFile";

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        String filePrefixString = this.getStringArgument(taskConfig, ARG_FILE_NAME, DEFAULT_FILE_PREFIX);
        boolean enableBboxBuilder = this.getBooleanArgument(taskConfig, ARG_ENABLE_BBOX_BUILDER, false);
        boolean enableLinestringBuilder = this.getBooleanArgument(taskConfig, ARG_ENABLE_LINESTRING_BUILDER, false);
        boolean keepInvalidWays = this.getBooleanArgument(taskConfig, ARG_KEEP_INVALID_WAYS, true);
        NodeLocationStoreType storeType = Enum.valueOf(NodeLocationStoreType.class, this.getStringArgument(taskConfig, ARG_NODE_LOCATION_STORE_TYPE, DEFAULT_NODE_LOCATION_STORE_TYPE));
        File filePrefix = new File(filePrefixString);
        return new SinkManager(taskConfig.getId(), (Sink)new PostgreSqlDumpWriter(filePrefix, enableBboxBuilder, enableLinestringBuilder, storeType, keepInvalidWays), taskConfig.getPipeArgs());
    }
}

