/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;

public final class DataSourceManager
implements Releasable {
    private static final Logger LOG = Logger.getLogger(DataSourceManager.class.getName());
    private DataSource dataSource;
    private BasicDataSource localDataSource;
    private DatabaseLoginCredentials credentials;

    public DataSourceManager(DatabaseLoginCredentials credentials) {
        this.credentials = credentials;
    }

    private void createDataSource() {
        this.localDataSource = new BasicDataSource();
        this.localDataSource.setDriverClassName("org.postgresql.Driver");
        this.localDataSource.setUrl("jdbc:postgresql://" + this.credentials.getHost() + "/" + this.credentials.getDatabase());
        this.localDataSource.setUsername(this.credentials.getUser());
        this.localDataSource.setPassword(this.credentials.getPassword());
        this.dataSource = this.localDataSource;
    }

    private void loadDatasource() {
        InitialContext cxt;
        String jndiLocation = this.credentials.getDatasourceJndiLocation();
        try {
            cxt = new InitialContext();
        }
        catch (NamingException e) {
            throw new OsmosisRuntimeException("Unable to create an initial JNDI context.", (Throwable)e);
        }
        try {
            this.dataSource = (DataSource)cxt.lookup(jndiLocation);
        }
        catch (NamingException e) {
            throw new OsmosisRuntimeException("Unable to locate the datasource (" + jndiLocation + ")", (Throwable)e);
        }
    }

    private Connection createConnectionFromDriverManager() {
        try {
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                throw new OsmosisRuntimeException("Unable to find database driver.", (Throwable)e);
            }
            return DriverManager.getConnection("jdbc:postgresql://" + this.credentials.getHost() + "/" + this.credentials.getDatabase(), this.credentials.getUser(), this.credentials.getPassword());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to establish a new database connection.", (Throwable)e);
        }
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            String jndiLocation = this.credentials.getDatasourceJndiLocation();
            if (jndiLocation != null) {
                LOG.finer("Retrieving a data source from JNDI.");
                this.loadDatasource();
            } else {
                LOG.finer("Creating a new locally managed data source.");
                this.createDataSource();
            }
        }
        return this.dataSource;
    }

    public Connection getConnection() {
        Connection connection;
        String jndiLocation = this.credentials.getDatasourceJndiLocation();
        if (this.dataSource == null && jndiLocation != null) {
            LOG.finer("Retrieving a data source from JNDI.");
            this.loadDatasource();
        }
        if (this.dataSource == null) {
            LOG.finer("Creating a new database connection from DriverManager.");
            connection = this.createConnectionFromDriverManager();
        } else {
            try {
                connection = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to obtain a connection from the datasource.", (Throwable)e);
            }
        }
        return connection;
    }

    public void release() {
        if (this.localDataSource != null) {
            try {
                this.localDataSource.close();
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Unable to cleanup the database connection pool.", e);
            }
            this.localDataSource = null;
            this.dataSource = null;
        }
    }
}

