/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.ArrayList;
import java.util.Date;
import org.openstreetmap.osmosis.apidb.v0_6.impl.NodeDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.RelationDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ReplicationQueryPredicates;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ReplicationSource;
import org.openstreetmap.osmosis.apidb.v0_6.impl.WayDao;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.MultipleSourceIterator;
import org.springframework.jdbc.core.JdbcTemplate;

public class AllEntityDao
implements ReplicationSource {
    private NodeDao nodeDao;
    private WayDao wayDao;
    private RelationDao relationDao;

    public AllEntityDao(JdbcTemplate jdbcTemplate) {
        this.nodeDao = new NodeDao(jdbcTemplate);
        this.wayDao = new WayDao(jdbcTemplate);
        this.relationDao = new RelationDao(jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleasableIterator<ChangeContainer> getHistory(ReplicationQueryPredicates predicates) {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            ArrayList<Releasable> sources = new ArrayList<Releasable>();
            sources.add(releasableContainer.add(this.nodeDao.getHistory(predicates)));
            sources.add(releasableContainer.add(this.wayDao.getHistory(predicates)));
            sources.add(releasableContainer.add(this.relationDao.getHistory(predicates)));
            MultipleSourceIterator resultIterator = new MultipleSourceIterator(sources);
            releasableContainer.clear();
            MultipleSourceIterator multipleSourceIterator = resultIterator;
            return multipleSourceIterator;
        }
        finally {
            releasableContainer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableIterator<ChangeContainer> getHistory(Date intervalBegin, Date intervalEnd) {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            ArrayList<Releasable> sources = new ArrayList<Releasable>();
            sources.add(releasableContainer.add(this.nodeDao.getHistory(intervalBegin, intervalEnd)));
            sources.add(releasableContainer.add(this.wayDao.getHistory(intervalBegin, intervalEnd)));
            sources.add(releasableContainer.add(this.relationDao.getHistory(intervalBegin, intervalEnd)));
            MultipleSourceIterator resultIterator = new MultipleSourceIterator(sources);
            releasableContainer.clear();
            MultipleSourceIterator multipleSourceIterator = resultIterator;
            return multipleSourceIterator;
        }
        finally {
            releasableContainer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableIterator<ChangeContainer> getHistory() {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            ArrayList<Releasable> sources = new ArrayList<Releasable>();
            sources.add(releasableContainer.add(this.nodeDao.getHistory()));
            sources.add(releasableContainer.add(this.wayDao.getHistory()));
            sources.add(releasableContainer.add(this.relationDao.getHistory()));
            MultipleSourceIterator resultIterator = new MultipleSourceIterator(sources);
            releasableContainer.clear();
            MultipleSourceIterator multipleSourceIterator = resultIterator;
            return multipleSourceIterator;
        }
        finally {
            releasableContainer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableIterator<EntityContainer> getCurrent() {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            ArrayList<Releasable> sources = new ArrayList<Releasable>();
            sources.add(releasableContainer.add(this.nodeDao.getCurrent()));
            sources.add(releasableContainer.add(this.wayDao.getCurrent()));
            sources.add(releasableContainer.add(this.relationDao.getCurrent()));
            MultipleSourceIterator resultIterator = new MultipleSourceIterator(sources);
            releasableContainer.clear();
            MultipleSourceIterator multipleSourceIterator = resultIterator;
            return multipleSourceIterator;
        }
        finally {
            releasableContainer.release();
        }
    }
}

