/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.common;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.apidb.common.IdentityValueLoader;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.ReleasableStatementContainer;

public class PostgresqlIdentityValueLoader
implements IdentityValueLoader {
    private static final Logger LOG = Logger.getLogger(PostgresqlIdentityValueLoader.class.getName());
    private static final String SQL_SELECT_LAST_INSERT_ID = "SELECT lastval() AS lastInsertId";
    private static final String SQL_SELECT_LAST_SEQUENCE_ID = "SELECT currval(?) AS lastSequenceId";
    private DatabaseContext dbCtx;
    private ReleasableStatementContainer statementContainer;
    private PreparedStatement selectInsertIdStatement;
    private PreparedStatement selectSequenceIdStatement;

    public PostgresqlIdentityValueLoader(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
        this.statementContainer = new ReleasableStatementContainer();
    }

    @Override
    public long getLastInsertId() {
        if (this.selectInsertIdStatement == null) {
            this.selectInsertIdStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatementForStreaming(SQL_SELECT_LAST_INSERT_ID));
        }
        ResultSet lastInsertQuery = null;
        try {
            lastInsertQuery = this.selectInsertIdStatement.executeQuery();
            lastInsertQuery.next();
            long lastInsertId = lastInsertQuery.getLong("lastInsertId");
            lastInsertQuery.close();
            lastInsertQuery = null;
            long l = lastInsertId;
            return l;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to retrieve the id of the newly inserted record.", (Throwable)e);
        }
        finally {
            if (lastInsertQuery != null) {
                try {
                    lastInsertQuery.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close last insert query.", e);
                }
            }
        }
    }

    @Override
    public long getLastSequenceId(String sequenceName) {
        if (this.selectSequenceIdStatement == null) {
            this.selectSequenceIdStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatementForStreaming(SQL_SELECT_LAST_SEQUENCE_ID));
        }
        ResultSet lastSequenceQuery = null;
        try {
            this.selectSequenceIdStatement.setString(1, sequenceName);
            lastSequenceQuery = this.selectSequenceIdStatement.executeQuery();
            lastSequenceQuery.next();
            long lastSequenceId = lastSequenceQuery.getLong("lastSequenceId");
            lastSequenceQuery.close();
            lastSequenceQuery = null;
            long l = lastSequenceId;
            return l;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to retrieve the last sequence id.", (Throwable)e);
        }
        finally {
            if (lastSequenceQuery != null) {
                try {
                    lastSequenceQuery.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close last sequence query.", e);
                }
            }
        }
    }

    public void release() {
        this.statementContainer.release();
    }
}

