/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class ChangeTagSorter
implements ChangeSinkChangeSource {
    private ChangeSink changeSink;

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.changeSink.initialize(metaData);
    }

    @Override
    public void process(ChangeContainer changeContainer) {
        EntityContainer readOnlyContainer = changeContainer.getEntityContainer();
        EntityContainer writeableContainer = readOnlyContainer.getWriteableInstance();
        Entity entity = writeableContainer.getEntity();
        List<Tag> sortedTags = this.sortTags(entity.getTags());
        entity.getTags().clear();
        entity.getTags().addAll(sortedTags);
        this.changeSink.process(new ChangeContainer(writeableContainer, changeContainer.getAction()));
    }

    private List<Tag> sortTags(Collection<Tag> tagList) {
        ArrayList<Tag> sortedTagList = new ArrayList<Tag>(tagList);
        Collections.sort(sortedTagList);
        return sortedTagList;
    }

    @Override
    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    @Override
    public void complete() {
        this.changeSink.complete();
    }

    @Override
    public void release() {
        this.changeSink.release();
    }
}

