/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.bound.v0_6;

import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class BoundSetter
implements SinkSource {
    private Sink sink;
    private boolean boundProcessed;
    private Bound newBound;

    public BoundSetter(Bound newBound) {
        this.newBound = newBound;
        this.boundProcessed = false;
    }

    @Override
    public void initialize(Map<String, Object> metaTags) {
        this.sink.initialize(metaTags);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        if (this.boundProcessed) {
            this.sink.process(entityContainer);
        } else {
            this.processFirstEntity(entityContainer);
            this.boundProcessed = true;
        }
    }

    private void processFirstEntity(EntityContainer entityContainer) {
        if (entityContainer.getEntity().getType() == EntityType.Bound) {
            if (this.newBound == null) {
                return;
            }
            this.sink.process(new BoundContainer(this.newBound));
        } else {
            if (this.newBound != null) {
                this.sink.process(new BoundContainer(this.newBound));
            }
            this.sink.process(entityContainer);
        }
    }

    @Override
    public void complete() {
        this.sink.complete();
    }

    @Override
    public void release() {
        this.sink.release();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

