/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.sort.v0_6.SortedDuplicateEntityPipeValidator;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class FlattenFilter
extends SortedDuplicateEntityPipeValidator {
    private Sink sink;
    private Sink flattener = new Sink(){
        private EntityContainer previousContainer;

        public void initialize(Map<String, Object> metaData) {
            FlattenFilter.this.sink.initialize(metaData);
        }

        public void process(EntityContainer currentContainer) {
            if (this.previousContainer == null) {
                this.previousContainer = currentContainer;
                return;
            }
            Entity current = currentContainer.getEntity();
            Entity previous = this.previousContainer.getEntity();
            if (current.getId() != previous.getId() || !current.getType().equals((Object)previous.getType())) {
                FlattenFilter.this.sink.process(this.previousContainer);
                this.previousContainer = currentContainer;
                return;
            }
            if (current.getVersion() > previous.getVersion()) {
                this.previousContainer = currentContainer;
            }
        }

        public void complete() {
            if (this.previousContainer != null) {
                FlattenFilter.this.sink.process(this.previousContainer);
            }
            FlattenFilter.this.sink.complete();
        }

        public void release() {
            FlattenFilter.this.sink.release();
        }
    };

    public FlattenFilter() {
        super.setSink(this.flattener);
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

