/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.merge.common.ConflictResolutionMethod;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityContainerComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.SortedEntityPipeValidator;
import org.openstreetmap.osmosis.core.store.DataPostbox;
import org.openstreetmap.osmosis.core.task.v0_6.MultiSinkRunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.set.v0_6.BoundRemovedAction;
import org.openstreetmap.osmosis.set.v0_6.impl.DataPostboxSink;

public class EntityMerger
implements MultiSinkRunnableSource {
    private static final Logger LOG = Logger.getLogger(EntityMerger.class.getName());
    private Sink sink;
    private DataPostbox<EntityContainer> postbox0;
    private SortedEntityPipeValidator sortedEntityValidator0;
    private DataPostbox<EntityContainer> postbox1;
    private SortedEntityPipeValidator sortedEntityValidator1;
    private ConflictResolutionMethod conflictResolutionMethod;
    private BoundRemovedAction boundRemovedAction;

    public EntityMerger(ConflictResolutionMethod conflictResolutionMethod, int inputBufferCapacity, BoundRemovedAction boundRemovedAction) {
        this.conflictResolutionMethod = conflictResolutionMethod;
        this.postbox0 = new DataPostbox(inputBufferCapacity);
        this.sortedEntityValidator0 = new SortedEntityPipeValidator();
        this.sortedEntityValidator0.setSink((Sink)new DataPostboxSink(this.postbox0));
        this.postbox1 = new DataPostbox(inputBufferCapacity);
        this.sortedEntityValidator1 = new SortedEntityPipeValidator();
        this.sortedEntityValidator1.setSink((Sink)new DataPostboxSink(this.postbox1));
    }

    public Sink getSink(int instance) {
        switch (instance) {
            case 0: {
                return this.sortedEntityValidator0;
            }
            case 1: {
                return this.sortedEntityValidator1;
            }
        }
        throw new OsmosisRuntimeException("Sink instance " + instance + " is not valid.");
    }

    public int getSinkCount() {
        return 2;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            EntityContainer entityContainer0 = null;
            EntityContainer entityContainer1 = null;
            EntityContainerComparator comparator = new EntityContainerComparator((Comparator)new EntityByTypeThenIdComparator());
            this.postbox0.outputInitialize();
            this.postbox1.outputInitialize();
            this.sink.initialize(Collections.emptyMap());
            entityContainer0 = EntityMerger.nextOrNull(this.postbox0);
            entityContainer1 = EntityMerger.nextOrNull(this.postbox1);
            if (entityContainer0 != null && entityContainer1 != null) {
                Bound bound0 = null;
                Bound bound1 = null;
                if (entityContainer0.getEntity().getType() == EntityType.Bound) {
                    bound0 = (Bound)entityContainer0.getEntity();
                    entityContainer0 = EntityMerger.nextOrNull(this.postbox0);
                }
                if (entityContainer1.getEntity().getType() == EntityType.Bound) {
                    bound1 = (Bound)entityContainer1.getEntity();
                    entityContainer1 = EntityMerger.nextOrNull(this.postbox1);
                }
                if (bound0 != null && bound1 != null) {
                    this.sink.process((EntityContainer)new BoundContainer(bound0.union(bound1)));
                } else if (bound0 != null && bound1 == null || bound0 == null && bound1 != null) {
                    this.handleBoundRemoved(bound0 == null);
                }
            }
            while ((entityContainer0 != null || this.postbox0.hasNext()) && (entityContainer1 != null || this.postbox1.hasNext())) {
                long comparisonResult;
                if (entityContainer0 == null) {
                    entityContainer0 = (EntityContainer)this.postbox0.getNext();
                }
                if (entityContainer1 == null) {
                    entityContainer1 = (EntityContainer)this.postbox1.getNext();
                }
                if ((comparisonResult = (long)comparator.compare(entityContainer0, entityContainer1)) < 0L) {
                    this.sink.process(entityContainer0);
                    entityContainer0 = null;
                    continue;
                }
                if (comparisonResult > 0L) {
                    this.sink.process(entityContainer1);
                    entityContainer1 = null;
                    continue;
                }
                if (this.conflictResolutionMethod.equals((Object)ConflictResolutionMethod.Timestamp)) {
                    int timestampComparisonResult = entityContainer0.getEntity().getTimestamp().compareTo(entityContainer1.getEntity().getTimestamp());
                    if (timestampComparisonResult < 0) {
                        this.sink.process(entityContainer1);
                    } else if (timestampComparisonResult > 0) {
                        this.sink.process(entityContainer0);
                    } else {
                        this.sink.process(entityContainer1);
                    }
                } else if (this.conflictResolutionMethod.equals((Object)ConflictResolutionMethod.LatestSource)) {
                    this.sink.process(entityContainer1);
                } else if (this.conflictResolutionMethod.equals((Object)ConflictResolutionMethod.Version)) {
                    int version1;
                    int version0 = entityContainer0.getEntity().getVersion();
                    if (version0 < (version1 = entityContainer1.getEntity().getVersion())) {
                        this.sink.process(entityContainer1);
                    } else if (version0 > version1) {
                        this.sink.process(entityContainer0);
                    } else {
                        this.sink.process(entityContainer1);
                    }
                } else {
                    throw new OsmosisRuntimeException("Conflict resolution method " + this.conflictResolutionMethod + " is not recognized.");
                }
                entityContainer0 = null;
                entityContainer1 = null;
            }
            while (entityContainer0 != null || this.postbox0.hasNext()) {
                if (entityContainer0 == null) {
                    entityContainer0 = (EntityContainer)this.postbox0.getNext();
                }
                this.sink.process(entityContainer0);
                entityContainer0 = null;
            }
            while (entityContainer1 != null || this.postbox1.hasNext()) {
                if (entityContainer1 == null) {
                    entityContainer1 = (EntityContainer)this.postbox1.getNext();
                }
                this.sink.process(entityContainer1);
                entityContainer1 = null;
            }
            this.sink.complete();
            this.postbox0.outputComplete();
            this.postbox1.outputComplete();
        }
        finally {
            this.sink.release();
            this.postbox0.outputRelease();
            this.postbox1.outputRelease();
        }
    }

    private void handleBoundRemoved(boolean source0BoundMissing) {
        String otherSourceID;
        String missingSourceID;
        if (this.boundRemovedAction == BoundRemovedAction.Ignore) {
            return;
        }
        if (source0BoundMissing) {
            missingSourceID = "0";
            otherSourceID = "1";
        } else {
            missingSourceID = "1";
            otherSourceID = "0";
        }
        String message = String.format("Source %s of the merge task has an explicit bound set, but source %s has not. Therefore the explicit bound has been removed from the merged stream.", missingSourceID, otherSourceID);
        if (this.boundRemovedAction == BoundRemovedAction.Warn) {
            LOG.warning(message);
        } else if (this.boundRemovedAction == BoundRemovedAction.Fail) {
            throw new OsmosisRuntimeException(message);
        }
    }

    private static EntityContainer nextOrNull(DataPostbox<EntityContainer> postbox) {
        if (postbox.hasNext()) {
            return (EntityContainer)postbox.getNext();
        }
        return null;
    }
}

